/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.DeploymentInformationService;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.binding.vmodl.Binary;
import com.vmware.vim.sso.admin.DeploymentInformation;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;
import java.io.InputStream;

public class DeploymentInformationImpl
implements DeploymentInformation {
    private final DeploymentInformationService _vmomiService;

    public DeploymentInformationImpl(DeploymentInformationService vmomiService) {
        this._vmomiService = vmomiService;
    }

    public boolean isMultiSiteDeployment() throws SystemException, NotAuthenticatedException {
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return DeploymentInformationImpl.this._vmomiService.isMultiSiteDeployment();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public InputStream retrieveHaBackupConfigurationPackage() throws SystemException, NotAuthenticatedException {
        return (InputStream)new VmomiClientCommand<InputStream>(){

            @Override
            public InputStream actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((Binary)DeploymentInformationImpl.this._vmomiService.retrieveHaBackupConfigurationPackage());
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public InputStream retrieveReplicaConfigurationPackage() throws SystemException, UnsupportedOperationException, NotAuthenticatedException {
        return (InputStream)new VmomiClientCommand<InputStream>(){

            @Override
            public InputStream actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((Binary)DeploymentInformationImpl.this._vmomiService.retrieveReplicaConfigurationPackage());
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }
}

