/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.SystemManagementService;
import com.vmware.vim.binding.sso.admin.fault.ADDomainAccessDeniedFault;
import com.vmware.vim.binding.sso.admin.fault.ADDomainAlreadyJoinedFault;
import com.vmware.vim.binding.sso.admin.fault.ADDomainNotJoinedFault;
import com.vmware.vim.binding.sso.admin.fault.ADDomainUnknownDomainFault;
import com.vmware.vim.binding.sso.admin.fault.ADIDSAlreadyExistFault;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.sso.admin.ActiveDirectoryJoinInfo;
import com.vmware.vim.sso.admin.SystemManagement;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.ADDomainAccessDeniedException;
import com.vmware.vim.sso.admin.exception.ADDomainAlreadyJoinedException;
import com.vmware.vim.sso.admin.exception.ADDomainNotJoinedException;
import com.vmware.vim.sso.admin.exception.ADDomainUnknownDomainException;
import com.vmware.vim.sso.admin.exception.ADIDSAlreadyExistException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;

public class SystemManagementImpl
implements SystemManagement {
    private final SystemManagementService _service;

    public SystemManagementImpl(SystemManagementService service) {
        this._service = service;
    }

    public ActiveDirectoryJoinInfo getActiveDirectoryJoinStatus() throws NoPermissionException {
        return (ActiveDirectoryJoinInfo)new VmomiClientCommand<ActiveDirectoryJoinInfo>(){

            @Override
            public ActiveDirectoryJoinInfo actionCommand() throws NotAuthenticated {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.ActiveDirectoryJoinInfo)SystemManagementImpl.this._service.getActiveDirectoryJoinStatus());
            }
        }.executeEnsuringNoDomainError();
    }

    public void joinActiveDirectory(final String username, final String password, final String domain, final String orgUnit) throws ADDomainAccessDeniedException, ADDomainUnknownDomainException, ADDomainAlreadyJoinedException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)username, (String)"username");
        ValidateUtil.validateNotNull((Object)password, (String)"password");
        ValidateUtil.validateNotEmpty((Object)domain, (String)"domain");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws NotAuthenticated, NoPermission, ADDomainAccessDeniedFault, ADDomainUnknownDomainFault, ADDomainAlreadyJoinedFault {
                SystemManagementImpl.this._service.joinActiveDirectory(username, password, domain, orgUnit);
                return null;
            }
        }.executeEnsuringDomainErrorIs(ADDomainAccessDeniedException.class, ADDomainUnknownDomainException.class, ADDomainAlreadyJoinedException.class, NotAuthenticatedException.class);
    }

    public void leaveActiveDirectory(final String username, final String password) throws ADIDSAlreadyExistException, ADDomainAccessDeniedException, ADDomainUnknownDomainException, ADDomainNotJoinedException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)username, (String)"username");
        ValidateUtil.validateNotNull((Object)password, (String)"password");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws NotAuthenticated, NoPermission, ADIDSAlreadyExistFault, ADDomainAccessDeniedFault, ADDomainUnknownDomainFault, ADDomainNotJoinedFault {
                SystemManagementImpl.this._service.leaveActiveDirectory(username, password);
                return null;
            }
        }.executeEnsuringDomainErrorIs(ADIDSAlreadyExistException.class, ADDomainAccessDeniedException.class, ADDomainUnknownDomainException.class, ADDomainNotJoinedException.class, NotAuthenticatedException.class);
    }
}

