/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.chassisa;

import com.vmware.samples.chassisa.ObjectStore;
import com.vmware.samples.chassisa.model.Chassis;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.data.VimObjectReferenceService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@type(value="samples:ChassisA")
public class ChassisDataAdapter
implements DataProviderAdapter {
    public static final String CHASSIS_TYPE = "samples:ChassisA";
    private final VimObjectReferenceService _objectRefService;
    private final ObjectStore _objectStore;

    public ChassisDataAdapter(VimObjectReferenceService vimObjectReferenceService, ObjectStore objectStore) {
        this._objectRefService = vimObjectReferenceService;
        this._objectStore = objectStore;
    }

    public Response getData(RequestSpec requestSpec) {
        if (requestSpec == null) {
            throw new IllegalArgumentException("request must be non-null.");
        }
        Response response = requestSpec.querySpec;
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>(((QuerySpec[])response).length);
        for (QuerySpec querySpec : response) {
            ResultSet resultSet = this.processQuery(querySpec);
            arrayList.add(resultSet);
        }
        Response response2 = new Response();
        response2.resultSet = arrayList.toArray(new ResultSet[0]);
        return response2;
    }

    private ResultSet processQuery(QuerySpec querySpec) {
        ResultSet resultSet = new ResultSet();
        if (!this.validateQuerySpec(querySpec)) {
            return resultSet;
        }
        List<ResultItem> list = this.processConstraint(querySpec.resourceSpec.constraint, querySpec.resourceSpec.propertySpecs);
        resultSet.totalMatchedObjectCount = list != null ? list.size() : 0;
        resultSet.items = list.toArray(new ResultItem[0]);
        resultSet.queryName = querySpec.name;
        return resultSet;
    }

    private String[] convertPropertySpec(PropertySpec[] propertySpecArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (propertySpecArray != null) {
            for (PropertySpec propertySpec : propertySpecArray) {
                for (String string : propertySpec.propertyNames) {
                    hashSet.add(string);
                }
            }
        }
        return hashSet.toArray(new String[0]);
    }

    private List<ResultItem> processConstraint(Constraint constraint, PropertySpec[] propertySpecArray) {
        List<ResultItem> list = null;
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            list = this.processObjectIdentityConstraint(objectIdentityConstraint, propertySpecArray);
        } else if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            list = this.processCompositeConstraint(compositeConstraint, propertySpecArray);
        } else if (constraint instanceof PropertyConstraint) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            list = this.processPropertyConstraint(propertyConstraint, propertySpecArray);
        } else if (this.isSimpleConstraint(constraint)) {
            list = this.processSimpleConstraint(constraint, propertySpecArray);
        }
        return list;
    }

    private List<ResultItem> processCompositeConstraint(CompositeConstraint compositeConstraint, PropertySpec[] propertySpecArray) {
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        for (Constraint constraint : compositeConstraint.nestedConstraints) {
            List<ResultItem> list = this.processConstraint(constraint, propertySpecArray);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List<ResultItem> processSimpleConstraint(Constraint constraint, PropertySpec[] propertySpecArray) {
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        String[] stringArray = this.convertPropertySpec(propertySpecArray);
        Map<String, Chassis> map = this._objectStore.getObjects();
        for (String string : map.keySet()) {
            Chassis chassis;
            ResultItem resultItem = this.createChassisResultItem(string, chassis = map.get(string), stringArray);
            if (resultItem == null) continue;
            arrayList.add(resultItem);
        }
        return arrayList;
    }

    private List<ResultItem> processObjectIdentityConstraint(ObjectIdentityConstraint objectIdentityConstraint, PropertySpec[] propertySpecArray) {
        ResultItem resultItem;
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        String[] stringArray = this.convertPropertySpec(propertySpecArray);
        String string = this._objectRefService.getUid(objectIdentityConstraint.target);
        Chassis chassis = this._objectStore.getChassis(string);
        if (chassis != null && (resultItem = this.createChassisResultItem(string, chassis, stringArray)) != null) {
            arrayList.add(resultItem);
        }
        return arrayList;
    }

    private List<ResultItem> processPropertyConstraint(PropertyConstraint propertyConstraint, PropertySpec[] propertySpecArray) {
        assert (propertyConstraint.comparator == Comparator.EQUALS);
        String string = propertyConstraint.comparableValue.toString();
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        String[] stringArray = this.convertPropertySpec(propertySpecArray);
        Map<String, Chassis> map = this._objectStore.getObjects();
        for (String string2 : map.keySet()) {
            ResultItem resultItem;
            Chassis chassis = map.get(string2);
            if (!string.equals(chassis.getProperty(propertyConstraint.propertyName)) || (resultItem = this.createChassisResultItem(string2, chassis, stringArray)) == null) continue;
            arrayList.add(resultItem);
        }
        return arrayList;
    }

    private ResultItem createChassisResultItem(String string, Chassis chassis, String[] stringArray) {
        Object object;
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = object = chassis.getChassisReference();
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = chassis.getProperty(string2);
            if (string3 == null) continue;
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.resourceObject = object;
            propertyValue.propertyName = string2;
            propertyValue.value = string3;
            arrayList.add(propertyValue);
        }
        resultItem.properties = arrayList.toArray(new PropertyValue[0]);
        return resultItem;
    }

    private boolean validateQuerySpec(QuerySpec querySpec) {
        if (querySpec == null) {
            return false;
        }
        ResourceSpec resourceSpec = querySpec.resourceSpec;
        if (resourceSpec == null || resourceSpec.constraint == null) {
            return false;
        }
        return this.validateConstraint(resourceSpec.constraint);
    }

    private boolean validateConstraint(Constraint constraint) {
        if (constraint instanceof ObjectIdentityConstraint) {
            Object object = ((ObjectIdentityConstraint)constraint).target;
            return object != null && CHASSIS_TYPE.equals(this._objectRefService.getResourceObjectType(object));
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            for (Constraint constraint2 : compositeConstraint.nestedConstraints) {
                if (this.validateConstraint(constraint2)) continue;
                return false;
            }
            return true;
        }
        if (constraint instanceof PropertyConstraint) {
            return CHASSIS_TYPE.equals(constraint.targetType) && ((PropertyConstraint)constraint).comparator == Comparator.EQUALS;
        }
        if (this.isSimpleConstraint(constraint)) {
            return CHASSIS_TYPE.equals(constraint.targetType);
        }
        return false;
    }

    private boolean isSimpleConstraint(Object object) {
        return object.getClass().getSimpleName().equals(Constraint.class.getSimpleName());
    }
}

