/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.chassisa;

import com.vmware.samples.chassisa.ChassisService;
import com.vmware.samples.chassisa.ObjectStore;
import com.vmware.samples.chassisa.model.Chassis;
import com.vmware.samples.chassisa.model.ChassisInfo;
import com.vmware.vise.vim.data.VimObjectReferenceService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChassisServiceImpl
implements ChassisService {
    private static final Log _logger = LogFactory.getLog(ChassisServiceImpl.class);
    private final VimObjectReferenceService _objectRefService;
    private final ObjectStore _objectStore;

    public ChassisServiceImpl(VimObjectReferenceService vimObjectReferenceService, ObjectStore objectStore) {
        this._objectRefService = vimObjectReferenceService;
        this._objectStore = objectStore;
    }

    @Override
    public Object createChassis(ChassisInfo chassisInfo) {
        Chassis chassis = this._objectStore.createChassis(chassisInfo, true);
        if (chassis == null) {
            _logger.info((Object)("Chassis not created because this name is taken: " + chassisInfo.name));
            return null;
        }
        _logger.info((Object)("Chassis created: " + chassis.toString()));
        return chassis.getChassisReference();
    }

    @Override
    public boolean updateChassis(Object object, ChassisInfo chassisInfo) {
        String string = this._objectRefService.getUid(object);
        Chassis chassis = this._objectStore.getChassis(string);
        if (chassis == null) {
            _logger.info((Object)("Chassis not found during edit operation: " + string));
            return false;
        }
        return this._objectStore.updateChassis(string, chassisInfo, object);
    }

    @Override
    public boolean deleteChassis(Object object) {
        String string = this._objectRefService.getUid(object);
        Chassis chassis = this._objectStore.removeChassis(string);
        if (chassis == null) {
            _logger.info((Object)("Chassis not found during delete operation: " + string));
            return false;
        }
        return true;
    }
}

