/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.chassisa;

import com.vmware.samples.chassisa.model.Chassis;
import com.vmware.samples.chassisa.model.ChassisInfo;
import com.vmware.vise.vim.data.VimObjectReferenceService;
import java.util.HashMap;
import java.util.Map;

public class ObjectStore {
    private static final int CHASSIS_INITIAL_COUNT = 4;
    private static final String CHASSIS_TYPE = "samples:ChassisA";
    private final Map<String, Chassis> _objectMap = new HashMap<String, Chassis>(4);
    private static int _index = 0;
    private final VimObjectReferenceService _objectRefService;

    public ObjectStore(VimObjectReferenceService vimObjectReferenceService) {
        this._objectRefService = vimObjectReferenceService;
    }

    public void init() {
        for (int i = 0; i < 4; ++i) {
            String[] stringArray = new String[]{"Chassis " + (i + 1), "Server_Type " + i % 3, "20in x 30in x 17in"};
            this.createChassis(new ChassisInfo(stringArray), false);
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Chassis> getObjects() {
        Map<String, Chassis> map = this._objectMap;
        synchronized (map) {
            return new HashMap<String, Chassis>(this._objectMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Chassis getChassis(String string) {
        Map<String, Chassis> map = this._objectMap;
        synchronized (map) {
            return this._objectMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Chassis removeChassis(String string) {
        Map<String, Chassis> map = this._objectMap;
        synchronized (map) {
            return this._objectMap.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Chassis createChassis(ChassisInfo chassisInfo, boolean bl) {
        Map<String, Chassis> map = this._objectMap;
        synchronized (map) {
            if (bl && ObjectStore.mapContainsName(this._objectMap, chassisInfo.name)) {
                return null;
            }
            Object object = this._objectRefService.getReference(CHASSIS_TYPE, "chassis-" + _index++, null);
            Chassis chassis = new Chassis(chassisInfo, object);
            String string = this._objectRefService.getUid(object);
            this._objectMap.put(string, chassis);
            return chassis;
        }
    }

    private static boolean mapContainsName(Map<String, Chassis> map, String string) {
        for (String string2 : map.keySet()) {
            Chassis chassis = map.get(string2);
            if (!string.equals(chassis.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateChassis(String string, ChassisInfo chassisInfo, Object object) {
        Map<String, Chassis> map = this._objectMap;
        synchronized (map) {
            Chassis chassis = new Chassis(chassisInfo, object);
            Chassis chassis2 = this._objectMap.put(string, chassis);
            return chassis2 != null;
        }
    }
}

