/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.chassisa.mvc;

import com.vmware.samples.chassisa.mvc.QueryUtil;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/data"}, method={RequestMethod.GET})
public class DataAccessController {
    private static final String OBJECT_ID = "id";
    private final DataService _dataService;
    private final ObjectReferenceService _objectReferenceService;

    @Autowired
    public DataAccessController(DataService dataService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._dataService = dataService;
        this._objectReferenceService = objectReferenceService;
        QueryUtil.setObjectReferenceService(objectReferenceService);
    }

    @RequestMapping(value={"/properties/{objectId}"})
    @ResponseBody
    public Map<String, Object> getProperties(@PathVariable(value="objectId") String string, @RequestParam(value="properties", required=true) String string2) throws Exception {
        Object object = this.getDecodedReference(string);
        String string3 = this._objectReferenceService.getUid(object);
        String[] stringArray = string2.split(",");
        PropertyValue[] propertyValueArray = QueryUtil.getProperties(this._dataService, object, stringArray);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(OBJECT_ID, string3);
        for (PropertyValue propertyValue : propertyValueArray) {
            hashMap.put(propertyValue.propertyName, propertyValue.value);
        }
        return hashMap;
    }

    @RequestMapping(value={"/propertiesByRelation/{objectId}"})
    @ResponseBody
    public PropertyValue[] getPropertiesForRelatedObject(@PathVariable(value="objectId") String string, @RequestParam(value="relation", required=true) String string2, @RequestParam(value="targetType", required=true) String string3, @RequestParam(value="properties", required=true) String string4) throws Exception {
        Object object = this.getDecodedReference(string);
        String[] stringArray = string4.split(",");
        PropertyValue[] propertyValueArray = QueryUtil.getPropertiesForRelatedObjects(this._dataService, object, string2, string3, stringArray);
        return propertyValueArray;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Map<String, String> handleException(Exception exception, HttpServletResponse httpServletResponse) {
        httpServletResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("message", exception.getMessage());
        if (exception.getCause() != null) {
            hashMap.put("cause", exception.getCause().getMessage());
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        hashMap.put("stackTrace", stringWriter.toString());
        return hashMap;
    }

    private Object getDecodedReference(String string) throws Exception {
        Object object = this._objectReferenceService.getReference(string, true);
        if (object == null) {
            throw new Exception("Object not found with id: " + string);
        }
        return object;
    }
}

