/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.messaging.amf.vim;

import com.vmware.vim.binding.vim.Description;
import com.vmware.vim.binding.vim.ElementDescription;
import com.vmware.vim.binding.vim.TypeDescription;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.messaging.amf.DataObjectProxy;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;

public abstract class I18nFilterProxyBase
extends DataObjectProxy {
    public static final String CLASSNAME = "#cname";
    public static final String QNAME = "#qname";
    public static final String RES_DESC_LABEL = ".label";
    public static final String RES_DESC_SUMMARY = ".summary";
    public static final String RES_PKG_NAME = "vim.";
    public static final String GENERIC_STR_FORMAT = "%s%s%s";
    private static final long serialVersionUID = -113935172442883046L;

    public I18nFilterProxyBase() {
        this(null);
    }

    public I18nFilterProxyBase(Object object) {
        super(object);
    }

    protected void fillTypeDescription(String string, TypeDescription[] typeDescriptionArray) {
        if (typeDescriptionArray != null) {
            for (TypeDescription typeDescription : typeDescriptionArray) {
                if (typeDescription == null) continue;
                String string2 = string;
                String string3 = typeDescription.getKey().getName();
                string2 = string2.length() == 0 ? string3 : (!string2.endsWith(".") ? String.format("%s.%s", string2, string3) : string2.concat(string3));
                this.fillDescription(string2, (Description)typeDescription);
            }
        }
    }

    protected void fillElementDescription(String string, ElementDescription[] elementDescriptionArray) {
        if (elementDescriptionArray != null) {
            for (ElementDescription elementDescription : elementDescriptionArray) {
                if (elementDescription == null) continue;
                String string2 = string;
                String string3 = elementDescription.getKey();
                string2 = string2.length() == 0 ? string3 : (!string2.endsWith(".") ? String.format("%s.%s", string2, string3) : string2.concat(string3));
                this.fillDescription(string2, (Description)elementDescription);
            }
        }
    }

    protected void fillDescription(String string, Description description) {
        if (description == null) {
            return;
        }
        description.setLabel(this.getMessage(string.concat(RES_DESC_LABEL), description.getLabel()));
        description.setSummary(this.getMessage(string.concat(RES_DESC_SUMMARY), description.getSummary()));
    }

    protected String getMessage(String string, String string2) {
        return this.getMessage(string, null, string2);
    }

    protected String getMessage(String string, KeyAnyValue[] keyAnyValueArray, String string2) {
        String string3 = LocalizationUtil.getLocalizedMessage((String)string, (KeyAnyValue[])keyAnyValueArray);
        if (string3 == null || string3.equals(string)) {
            string3 = string2;
        }
        return string3;
    }

    public String getClassName(Object object, NameStyle nameStyle) {
        Class<?> clazz = object.getClass();
        String string = clazz.getSimpleName();
        if (nameStyle == NameStyle.QNAME) {
            string = clazz.getName();
        }
        string = string.replace("$", ".");
        return string;
    }

    static enum NameStyle {
        SIMPLE,
        QNAME;

    }
}

