/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.messaging.amf.vim;

import com.vmware.vapi.client.exception.ClientException;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.messaging.amf.BeanProxy;
import com.vmware.vise.vim.commons.MixedUtil;
import java.lang.reflect.InvocationTargetException;

public class VimExceptionProxy
extends BeanProxy {
    static final long serialVersionUID = -1L;

    public VimExceptionProxy() {
        this(null);
    }

    public VimExceptionProxy(Throwable throwable) {
        super((Object)throwable);
    }

    public Object getInstanceToSerialize(Object object) {
        if (object instanceof OperationResult) {
            this.preprocess((OperationResult)object);
        } else if (object instanceof ResultSet) {
            this.preprocess((ResultSet)object);
        }
        return super.getInstanceToSerialize(object);
    }

    private void preprocess(OperationResult operationResult) {
        operationResult.error = this.convertToVimException(operationResult.error);
    }

    private void preprocess(ResultSet resultSet) {
        resultSet.error = this.convertToVimException(resultSet.error);
    }

    private Exception convertToVimException(Exception exception) {
        Exception exception2 = VimExceptionProxy.unwrapInvocationTargetException(exception);
        if (exception2 instanceof DataException) {
            DataException dataException = (DataException)exception2;
            dataException.rootCause = MixedUtil.getVimException((Throwable)dataException.rootCause);
            return dataException;
        }
        if (exception2 instanceof CompositeException) {
            CompositeException compositeException = (CompositeException)exception2;
            Exception[] exceptionArray = compositeException.getExceptions();
            if (exceptionArray != null) {
                for (int i = 0; i < exceptionArray.length; ++i) {
                    exceptionArray[i] = MixedUtil.getVimException((Throwable)exceptionArray[i]);
                }
            }
            return compositeException;
        }
        Exception exception3 = MixedUtil.getVimException((Throwable)exception2);
        if (exception3 != exception2) {
            return exception3;
        }
        if (this.isCommunicationException(exception2)) {
            return VimExceptionProxy.toMethodFault(exception2);
        }
        return exception2;
    }

    private boolean isCommunicationException(Exception exception) {
        return exception instanceof ClientException || exception instanceof com.vmware.vim.vmomi.client.exception.ClientException || exception instanceof UnexpectedStatusCodeException;
    }

    private static MethodFault toMethodFault(Exception exception) {
        if (exception instanceof MethodFault) {
            assert (false) : "MethodFault passed in toMethodFault.";
            return (MethodFault)exception;
        }
        MethodFault methodFault = new MethodFault();
        methodFault.setMessage(exception.getMessage());
        methodFault.initCause((Throwable)exception);
        return methodFault;
    }

    private static Exception unwrapInvocationTargetException(Exception exception) {
        if (exception instanceof InvocationTargetException) {
            Throwable throwable = ((InvocationTargetException)exception).getTargetException();
            if (throwable instanceof Exception) {
                return (Exception)throwable;
            }
            return new Exception(throwable);
        }
        return exception;
    }
}

