/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.common.compositecommand.network;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.BaseCommand;
import com.vmware.vsphere.client.common.compositecommand.BaseCommandSpec;
import com.vmware.vsphere.client.common.compositecommand.CommandFactory;
import com.vmware.vsphere.client.common.compositecommand.DummyCommand;
import com.vmware.vsphere.client.common.compositecommand.DummyCommandSpec;
import com.vmware.vsphere.client.dvportgroup.DvPortgroupReconfigureCommand;
import com.vmware.vsphere.client.dvportgroup.DvPortgroupReconfigureCommandSpec;
import com.vmware.vsphere.client.dvs.commands.DvsAddNetworkResourcePoolCommand;
import com.vmware.vsphere.client.dvs.commands.DvsApplyProductSpecCommand;
import com.vmware.vsphere.client.dvs.commands.DvsChangeResMgmtCommand;
import com.vmware.vsphere.client.dvs.commands.DvsCreateCommand;
import com.vmware.vsphere.client.dvs.commands.DvsCreatePortgroupCommand;
import com.vmware.vsphere.client.dvs.commands.DvsReconfigureCommand;
import com.vmware.vsphere.client.dvs.commands.DvsReconfigurePortsCommand;
import com.vmware.vsphere.client.dvs.commands.DvsRemoveNetworkResourcePoolCommand;
import com.vmware.vsphere.client.dvs.commands.DvsUpdateNetworkResourcePoolCommand;
import com.vmware.vsphere.client.dvs.commands.FetchDvPortsCommand;
import com.vmware.vsphere.client.dvs.commands.resmgmt.DvPortgroupNrpUnassignCommand;
import com.vmware.vsphere.client.dvs.commands.resmgmt.ResControlUpgradeVersionCommand;
import com.vmware.vsphere.client.dvs.lacp.commands.LacpLegacyConfigRemoveCommand;
import com.vmware.vsphere.client.dvs.lacp.commands.LacpUpgradePhysicalNicReassignCommand;
import com.vmware.vsphere.client.dvs.lacp.commands.LacpUpgradeVersionCommand;
import com.vmware.vsphere.client.dvs.lacp.commands.LagCreateCommand;
import com.vmware.vsphere.client.dvs.lacp.specs.LacpLegacyConfigRemoveCommandSpec;
import com.vmware.vsphere.client.dvs.lacp.specs.LacpPhysicalNicReassignCommandSpec;
import com.vmware.vsphere.client.dvs.lacp.specs.LacpUpgradeVersionCommandSpec;
import com.vmware.vsphere.client.dvs.lacp.specs.LagCreateCommandSpec;
import com.vmware.vsphere.client.dvs.specs.DvsAddNetworkResourcePoolSpec;
import com.vmware.vsphere.client.dvs.specs.DvsApplyProductSpecCommandSpec;
import com.vmware.vsphere.client.dvs.specs.DvsChangeResMgmtCommandSpec;
import com.vmware.vsphere.client.dvs.specs.DvsCreateCommandSpec;
import com.vmware.vsphere.client.dvs.specs.DvsCreatePortgroupCommandSpec;
import com.vmware.vsphere.client.dvs.specs.DvsReconfigureCommandSpec;
import com.vmware.vsphere.client.dvs.specs.DvsReconfigurePortsCommandSpec;
import com.vmware.vsphere.client.dvs.specs.DvsRemoveNetworkResourcePoolSpec;
import com.vmware.vsphere.client.dvs.specs.DvsUpdateNetworkResourcePoolSpec;
import com.vmware.vsphere.client.dvs.specs.FetchDvPortsCommandSpec;
import com.vmware.vsphere.client.dvs.specs.resmgmt.DvPortgroupNrpUnassignCommandSpec;
import com.vmware.vsphere.client.dvs.specs.resmgmt.ResControlUpgradeVersionCommandSpec;
import com.vmware.vsphere.client.network.host.commands.AddVirtualNicCommand;
import com.vmware.vsphere.client.network.host.commands.NetSysUpdateNetConfigCommand;
import com.vmware.vsphere.client.network.host.commands.RemoveVirtualNicCommand;
import com.vmware.vsphere.client.network.host.commands.SetVirtualNicServiceCommand;
import com.vmware.vsphere.client.network.host.commands.SetVirtualNicVsanServiceCommand;
import com.vmware.vsphere.client.network.host.commands.UpdateVirtualNicCommand;
import com.vmware.vsphere.client.network.host.iscsi.commands.BindVnicCommand;
import com.vmware.vsphere.client.network.host.iscsi.commands.UnbindVnicCommand;
import com.vmware.vsphere.client.network.host.iscsi.specs.BindVnicCommandSpec;
import com.vmware.vsphere.client.network.host.iscsi.specs.UnbindVnicCommandSpec;
import com.vmware.vsphere.client.network.host.specs.AddVirtualNicCommandSpec;
import com.vmware.vsphere.client.network.host.specs.NetSysUpdateNetConfigCommandSpec;
import com.vmware.vsphere.client.network.host.specs.RemovePortgroupCommand;
import com.vmware.vsphere.client.network.host.specs.RemovePortgroupCommandSpec;
import com.vmware.vsphere.client.network.host.specs.RemoveVirtualNicCommandSpec;
import com.vmware.vsphere.client.network.host.specs.SetVirtualNicServiceCommandSpec;
import com.vmware.vsphere.client.network.host.specs.SetVirtualNicVsanServiceCommandSpec;
import com.vmware.vsphere.client.network.host.specs.UpdateVirtualNicCommandSpec;
import com.vmware.vsphere.client.network.vm.commands.VmReconfigureCommand;
import com.vmware.vsphere.client.network.vm.specs.VmReconfigureCommandSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetworkCommandFactory
extends CommandFactory {
    private static final Log _logger = LogFactory.getLog(NetworkCommandFactory.class);

    public BaseCommand createCommand(BaseCommandSpec commandSpec, BaseCommand parentCommand, DataService dataService) {
        try {
            if (commandSpec instanceof DummyCommandSpec) {
                return this.createConcreteCommand((DummyCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof DvsReconfigureCommandSpec) {
                return this.createConcreteCommand((DvsReconfigureCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof NetSysUpdateNetConfigCommandSpec) {
                return this.createConcreteCommand((NetSysUpdateNetConfigCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof DvsCreateCommandSpec) {
                return this.createConcreteCommand((DvsCreateCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof DvsApplyProductSpecCommandSpec) {
                return this.createConcreteCommand((DvsApplyProductSpecCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof DvsChangeResMgmtCommandSpec) {
                return this.createConcreteCommand((DvsChangeResMgmtCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof DvsCreatePortgroupCommandSpec) {
                return this.createConcreteCommand((DvsCreatePortgroupCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof VmReconfigureCommandSpec) {
                return this.createConcreteCommand((VmReconfigureCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof DvsAddNetworkResourcePoolSpec) {
                return this.createConcreteCommand((DvsAddNetworkResourcePoolSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof DvsUpdateNetworkResourcePoolSpec) {
                return this.createConcreteCommand((DvsUpdateNetworkResourcePoolSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof DvsRemoveNetworkResourcePoolSpec) {
                return this.createConcreteCommand((DvsRemoveNetworkResourcePoolSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof FetchDvPortsCommandSpec) {
                return this.createConcreteCommand((FetchDvPortsCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof DvPortgroupNrpUnassignCommandSpec) {
                return this.createConcreteCommand((DvPortgroupNrpUnassignCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof AddVirtualNicCommandSpec) {
                return this.createConcreteCommand((AddVirtualNicCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof UpdateVirtualNicCommandSpec) {
                return this.createConcreteCommand((UpdateVirtualNicCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof RemoveVirtualNicCommandSpec) {
                return this.createConcreteCommand((RemoveVirtualNicCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof RemovePortgroupCommandSpec) {
                return this.createConcreteCommand((RemovePortgroupCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof SetVirtualNicServiceCommandSpec) {
                return this.createConcreteCommand((SetVirtualNicServiceCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof SetVirtualNicVsanServiceCommandSpec) {
                return this.createConcreteCommand((SetVirtualNicVsanServiceCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof ResControlUpgradeVersionCommandSpec) {
                return this.createConcreteCommand((ResControlUpgradeVersionCommandSpec)commandSpec, parentCommand, dataService);
            }
            if (commandSpec instanceof LacpUpgradeVersionCommandSpec) {
                return this.createConcreteCommand((LacpUpgradeVersionCommandSpec)commandSpec, parentCommand, dataService);
            }
            if (commandSpec instanceof LacpLegacyConfigRemoveCommandSpec) {
                return this.createConcreteCommand((LacpLegacyConfigRemoveCommandSpec)commandSpec, parentCommand, dataService);
            }
            if (commandSpec instanceof LagCreateCommandSpec) {
                return this.createConcreteCommand((LagCreateCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof LacpPhysicalNicReassignCommandSpec) {
                return this.createConcreteCommand((LacpPhysicalNicReassignCommandSpec)commandSpec, parentCommand, dataService);
            }
            if (commandSpec instanceof DvPortgroupReconfigureCommandSpec) {
                return this.createConcreteCommand((DvPortgroupReconfigureCommandSpec)commandSpec, parentCommand, dataService);
            }
            if (commandSpec instanceof DvsReconfigurePortsCommandSpec) {
                return this.createConcreteCommand((DvsReconfigurePortsCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof BindVnicCommandSpec) {
                return this.createConcreteCommand((BindVnicCommandSpec)commandSpec, parentCommand, dataService);
            }
            if (commandSpec instanceof UnbindVnicCommandSpec) {
                return this.createConcreteCommand((UnbindVnicCommandSpec)commandSpec, parentCommand, dataService);
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
        }
        return null;
    }

    private BaseCommand createConcreteCommand(AddVirtualNicCommandSpec commandSpec, BaseCommand parentCommand) {
        this.resolveCommandSpec(commandSpec, parentCommand, null);
        return new AddVirtualNicCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(UpdateVirtualNicCommandSpec commandSpec, BaseCommand parentCommand) {
        this.resolveCommandSpec(commandSpec, parentCommand, null);
        return new UpdateVirtualNicCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(RemoveVirtualNicCommandSpec commandSpec, BaseCommand parentCommand) {
        this.resolveCommandSpec(commandSpec, parentCommand, null);
        return new RemoveVirtualNicCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(RemovePortgroupCommandSpec commandSpec, BaseCommand parentCommand) {
        this.resolveCommandSpec(commandSpec, parentCommand, null);
        return new RemovePortgroupCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(SetVirtualNicServiceCommandSpec commandSpec, BaseCommand parentCommand) {
        this.resolveCommandSpec(commandSpec, parentCommand, null);
        SetVirtualNicServiceCommand command = new SetVirtualNicServiceCommand(commandSpec);
        if (parentCommand instanceof AddVirtualNicCommand || parentCommand instanceof SetVirtualNicServiceCommand || parentCommand instanceof SetVirtualNicVsanServiceCommand) {
            command.setArguments(parentCommand.getResult());
        }
        return command;
    }

    private BaseCommand createConcreteCommand(SetVirtualNicVsanServiceCommandSpec commandSpec, BaseCommand parentCommand) {
        this.resolveCommandSpec(commandSpec, parentCommand, null);
        SetVirtualNicVsanServiceCommand command = new SetVirtualNicVsanServiceCommand(commandSpec);
        if (parentCommand instanceof AddVirtualNicCommand || parentCommand instanceof SetVirtualNicServiceCommand || parentCommand instanceof SetVirtualNicVsanServiceCommand) {
            command.setArguments(parentCommand.getResult());
        }
        return command;
    }

    private BaseCommand createConcreteCommand(DummyCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec((BaseCommandSpec)commandSpec, parentCommand, null);
        return new DummyCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(DvsReconfigureCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{DistributedVirtualSwitch.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName()});
        return new DvsReconfigureCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(NetSysUpdateNetConfigCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{NetworkSystem.class.getSimpleName()});
        NetSysUpdateNetConfigCommand command = new NetSysUpdateNetConfigCommand(commandSpec);
        command.setArguments(parentCommand.getResult());
        return command;
    }

    private BaseCommand createConcreteCommand(DvsCreateCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{Datacenter.class.getSimpleName(), Folder.class.getSimpleName()});
        if (Datacenter.class.getSimpleName().equals(commandSpec.mor.getType())) {
            Datacenter datacenter = (Datacenter)ManagedObjectUtil.getManagedObject((ManagedObjectReference)commandSpec.mor);
            commandSpec.mor = datacenter.getNetworkFolder();
        }
        return new DvsCreateCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(DvsChangeResMgmtCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{DistributedVirtualSwitch.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName()});
        return new DvsChangeResMgmtCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(DvsCreatePortgroupCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{DistributedVirtualSwitch.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName()});
        return new DvsCreatePortgroupCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(VmReconfigureCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{VirtualMachine.class.getSimpleName()});
        return new VmReconfigureCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(DvsAddNetworkResourcePoolSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{DistributedVirtualSwitch.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName()});
        return new DvsAddNetworkResourcePoolCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(DvsUpdateNetworkResourcePoolSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{DistributedVirtualSwitch.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName()});
        return new DvsUpdateNetworkResourcePoolCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(DvsRemoveNetworkResourcePoolSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{DistributedVirtualSwitch.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName()});
        return new DvsRemoveNetworkResourcePoolCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(FetchDvPortsCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{DistributedVirtualSwitch.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName()});
        return new FetchDvPortsCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(DvPortgroupNrpUnassignCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{DistributedVirtualPortgroup.class.getSimpleName()});
        return new DvPortgroupNrpUnassignCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(ResControlUpgradeVersionCommandSpec commandSpec, BaseCommand parentCommand, DataService dataService) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{DistributedVirtualSwitch.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName()});
        return new ResControlUpgradeVersionCommand(commandSpec, dataService);
    }

    private BaseCommand createConcreteCommand(LacpUpgradeVersionCommandSpec commandSpec, BaseCommand parentCommand, DataService dataService) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{DistributedVirtualSwitch.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName()});
        return new LacpUpgradeVersionCommand(commandSpec, dataService);
    }

    private BaseCommand createConcreteCommand(LacpLegacyConfigRemoveCommandSpec commandSpec, BaseCommand parentCommand, DataService dataService) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{VmwareDistributedVirtualSwitch.class.getSimpleName()});
        return new LacpLegacyConfigRemoveCommand(commandSpec, dataService);
    }

    private BaseCommand createConcreteCommand(LagCreateCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{VmwareDistributedVirtualSwitch.class.getSimpleName()});
        return new LagCreateCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(LacpPhysicalNicReassignCommandSpec commandSpec, BaseCommand parentCommand, DataService dataService) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{HostSystem.class.getSimpleName()});
        return new LacpUpgradePhysicalNicReassignCommand(commandSpec, dataService);
    }

    private BaseCommand createConcreteCommand(DvPortgroupReconfigureCommandSpec commandSpec, BaseCommand parentCommand, DataService dataService) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{DistributedVirtualPortgroup.class.getSimpleName()});
        return new DvPortgroupReconfigureCommand(commandSpec, dataService);
    }

    private BaseCommand createConcreteCommand(DvsReconfigurePortsCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{DistributedVirtualSwitch.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName()});
        return new DvsReconfigurePortsCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(DvsApplyProductSpecCommandSpec commandSpec, BaseCommand parentCommand) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{DistributedVirtualSwitch.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName()});
        return new DvsApplyProductSpecCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(BindVnicCommandSpec commandSpec, BaseCommand parentCommand, DataService dataService) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{HostSystem.class.getSimpleName()});
        return new BindVnicCommand(commandSpec, dataService);
    }

    private BaseCommand createConcreteCommand(UnbindVnicCommandSpec commandSpec, BaseCommand parentCommand, DataService dataService) throws Exception {
        this.resolveCommandSpec(commandSpec, parentCommand, new String[]{HostSystem.class.getSimpleName()});
        return new UnbindVnicCommand(commandSpec, dataService);
    }
}

