/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvportgroup.impl;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.NetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.fault.DvsOperationBulkFault;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vim.vApp.IpPool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.data.QueryDataUtil;
import com.vmware.vsphere.client.dvs.impl.DvsUtil;
import com.vmware.vsphere.client.ippool.util.IpPoolUtil;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvPortgroupPropertyProvider
implements PropertyProviderBean {
    private static final String KEY_PROPERTY = "config.key";
    private static final String DVS_PROPERTY = "config.distributedVirtualSwitch";
    private static Log _logger = LogFactory.getLog(DvPortgroupPropertyProvider.class);
    private final DataService _dataService;

    public DvPortgroupPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="DistributedVirtualPortgroup")
    public int getAvailablePorts(ManagedObjectReference dvPgRef) throws Exception {
        QueryUtil.PropertyValueMap resultMap = QueryDataUtil.getPropertiesValue((DataService)this._dataService, (Object[])new Object[]{dvPgRef}, (String[])new String[]{DVS_PROPERTY, KEY_PROPERTY});
        Object key = resultMap.getProperty((Object)dvPgRef, (String)KEY_PROPERTY).value;
        Object dvsRef = resultMap.getProperty((Object)dvPgRef, (String)DVS_PROPERTY).value;
        if (dvsRef == null) {
            return 0;
        }
        PortCriteria pc = new PortCriteria();
        pc.portgroupKey = new String[]{(String)key};
        pc.connected = false;
        pc.inside = true;
        String[] availablePortKeys = null;
        try {
            DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)((ManagedObjectReference)dvsRef));
            availablePortKeys = dvs.fetchPortKeys(pc);
        }
        catch (NoPermission np) {
            // empty catch block
        }
        if (availablePortKeys == null) {
            return 0;
        }
        return availablePortKeys.length;
    }

    @type(value="DistributedVirtualPortgroup")
    public VmwareDistributedVirtualSwitch.PvlanMapEntry[] getPvlanConfig(ManagedObjectReference dvPgRef) throws Exception {
        QueryUtil.PropertyValueMap resultMap = QueryDataUtil.getPropertiesValue((DataService)this._dataService, (Object[])new Object[]{dvPgRef}, (String[])new String[]{DVS_PROPERTY});
        Object dvsRef = resultMap.getProperty((Object)dvPgRef, (String)DVS_PROPERTY).value;
        if (dvsRef == null) {
            return null;
        }
        return DvsUtil.getPvlanConfig(this._dataService, (ManagedObjectReference)dvsRef);
    }

    @type(value="DistributedVirtualPortgroup")
    public DistributedVirtualPort[] getPorts(ManagedObjectReference dvPgRef) throws Exception {
        QueryUtil.PropertyValueMap resultMap = QueryDataUtil.getPropertiesValue((DataService)this._dataService, (Object[])new Object[]{dvPgRef}, (String[])new String[]{DVS_PROPERTY, KEY_PROPERTY});
        Object key = resultMap.getProperty((Object)dvPgRef, (String)KEY_PROPERTY).value;
        Object dvsRef = resultMap.getProperty((Object)dvPgRef, (String)DVS_PROPERTY).value;
        if (dvsRef == null) {
            return null;
        }
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)((ManagedObjectReference)dvsRef));
        PortCriteria pc = new PortCriteria();
        pc.inside = true;
        pc.portgroupKey = new String[]{(String)key};
        return dvs.fetchPorts(pc);
    }

    @type(value="DistributedVirtualPortgroup")
    public DistributedVirtualPort[] getRefreshedPorts(ManagedObjectReference dvPgRef, Object[] portKeys) throws Exception {
        QueryUtil.PropertyValueMap resultMap = QueryDataUtil.getPropertiesValue((DataService)this._dataService, (Object[])new Object[]{dvPgRef}, (String[])new String[]{DVS_PROPERTY, KEY_PROPERTY});
        Object key = resultMap.getProperty((Object)dvPgRef, (String)KEY_PROPERTY).value;
        Object dvsRef = resultMap.getProperty((Object)dvPgRef, (String)DVS_PROPERTY).value;
        if (dvsRef == null) {
            return null;
        }
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)((ManagedObjectReference)dvsRef));
        String[] keys = (String[])Arrays.copyOf(portKeys, portKeys.length, String[].class);
        PortCriteria pc = new PortCriteria();
        pc.connected = true;
        pc.inside = true;
        pc.portgroupKey = new String[]{(String)key};
        pc.portKey = keys;
        keys = dvs.fetchPortKeys(pc);
        try {
            dvs.refreshPortState(keys);
        }
        catch (DvsOperationBulkFault bulkFault) {
            _logger.info((Object)"Refreshing port state failed for some hosts", (Throwable)bulkFault);
        }
        pc.portKey = keys;
        return dvs.fetchPorts(pc);
    }

    @type(value="DistributedVirtualPortgroup")
    public DistributedVirtualSwitch.Capability getCapability(ManagedObjectReference dvPgRef) throws Exception {
        QueryUtil.PropertyValueMap resultMap = QueryDataUtil.getPropertiesValue((DataService)this._dataService, (Object[])new Object[]{dvPgRef}, (String[])new String[]{DVS_PROPERTY, KEY_PROPERTY});
        Object dvsRef = resultMap.getProperty((Object)dvPgRef, (String)DVS_PROPERTY).value;
        if (dvsRef == null) {
            return null;
        }
        DistributedVirtualSwitch sw = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)((ManagedObjectReference)dvsRef));
        return sw.getCapability();
    }

    @type(value="DistributedVirtualPortgroup")
    public NetworkResourcePool[] getNetworkResourcePool(ManagedObjectReference dvPgRef) throws Exception {
        QueryUtil.PropertyValueMap resultMap = QueryDataUtil.getPropertiesValue((DataService)this._dataService, (Object[])new Object[]{dvPgRef}, (String[])new String[]{DVS_PROPERTY});
        Object dvsRef = resultMap.getProperty((Object)dvPgRef, (String)DVS_PROPERTY).value;
        if (dvsRef == null) {
            return null;
        }
        DistributedVirtualSwitch sw = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)((ManagedObjectReference)dvsRef));
        return sw.getNetworkResourcePool();
    }

    @type(value="Network,DistributedVirtualPortgroup")
    public IpPool getIpPool(ManagedObjectReference moRef) throws Exception {
        if (moRef == null) {
            throw new IllegalArgumentException("The managed object reference cannot be null");
        }
        return IpPoolUtil.getIpPool((ManagedObjectReference)moRef, (DataService)this._dataService);
    }
}

