/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.impl;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.RuntimeInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.network.HealthCheckRuntimeInfo;
import com.vmware.vsphere.client.network.UplinkPortSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DvsHealthCheckUtil {
    public static Map<ManagedObjectReference, HealthCheckRuntimeInfo> getHealthInfoByHost(HostMember[] hostMembers) {
        if (hostMembers == null || hostMembers.length == 0) {
            return null;
        }
        HashMap<ManagedObjectReference, HealthCheckRuntimeInfo> runtimeInfoByHost = new HashMap<ManagedObjectReference, HealthCheckRuntimeInfo>();
        for (HostMember member : hostMembers) {
            if (member == null || member.config == null || member.config.host == null) continue;
            HealthCheckRuntimeInfo info = new HealthCheckRuntimeInfo();
            info.runtime = new HostMember.RuntimeInfo();
            info.runtime.status = member.status;
            info.runtime.statusDetail = member.statusDetail;
            info.runtime.host = member.config.host;
            runtimeInfoByHost.put(member.config.host, info);
        }
        return runtimeInfoByHost;
    }

    public static void updateHostRuntimeInfo(DataService dataService, Map<ManagedObjectReference, HealthCheckRuntimeInfo> healthInfoByHost) throws Exception {
        PropertyValue[] hostProperties;
        Set<ManagedObjectReference> hostSet = healthInfoByHost.keySet();
        for (PropertyValue pv : hostProperties = QueryUtil.getProperties((DataService)dataService, (Object[])hostSet.toArray(), (String[])new String[]{"name", "runtime"})) {
            HealthCheckRuntimeInfo info = healthInfoByHost.get(pv.resourceObject);
            if (info == null) continue;
            if ("name".equals(pv.propertyName)) {
                info.hostName = (String)pv.value;
                continue;
            }
            if (!"runtime".equals(pv.propertyName)) continue;
            info.hostRuntime = (RuntimeInfo)pv.value;
        }
    }

    public static void updateHealthCheckResults(DataService dataService, ManagedObjectReference dvsRef, Map<ManagedObjectReference, HealthCheckRuntimeInfo> healthInfoByHost) throws Exception {
        if (VcServiceUtil.isMNVc((String)dvsRef.getServerGuid())) {
            return;
        }
        HostMember.RuntimeInfo[] runtimeInfo = (HostMember.RuntimeInfo[])QueryUtil.getProperty((DataService)dataService, (Object)dvsRef, (String)"runtime.hostMemberRuntime");
        if (runtimeInfo == null) {
            return;
        }
        for (HostMember.RuntimeInfo hostMemberRuntime : runtimeInfo) {
            HealthCheckRuntimeInfo info;
            if (hostMemberRuntime.host == null || (info = healthInfoByHost.get(hostMemberRuntime.host)) == null) continue;
            info.runtime.healthCheckResult = hostMemberRuntime.healthCheckResult;
        }
    }

    public static void updateHealthCheckUplinksInfo(DistributedVirtualSwitch dvs, HostMember[] hostMembers, HealthCheckRuntimeInfo[] healthInfo) throws Exception {
        Map<String, String> pnicsByKey = DvsHealthCheckUtil.getPnicsByKey(hostMembers);
        if (!pnicsByKey.isEmpty()) {
            PortCriteria pc = new PortCriteria();
            pc.connected = true;
            pc.uplinkPort = true;
            pc.portKey = pnicsByKey.keySet().toArray(new String[pnicsByKey.size()]);
            HashMap uplinkSpecsByHost = new HashMap();
            for (DistributedVirtualPort distributedVirtualPort : dvs.fetchPorts(pc)) {
                UplinkPortSpec portSpec = new UplinkPortSpec();
                portSpec.uplinkPortKey = distributedVirtualPort.key;
                portSpec.uplinkPortName = distributedVirtualPort.config.name;
                String pnicDevice = null;
                if (distributedVirtualPort.connectee != null && !StringUtil.isNullOrEmpty((String)distributedVirtualPort.connectee.nicKey) && (pnicDevice = distributedVirtualPort.connectee.nicKey).equals(pnicsByKey.get(distributedVirtualPort.key))) {
                    portSpec.backingPhysicalNic = pnicsByKey.get(distributedVirtualPort.key);
                }
                if (StringUtil.isNullOrEmpty((String)portSpec.backingPhysicalNic)) continue;
                if (!uplinkSpecsByHost.containsKey(distributedVirtualPort.proxyHost)) {
                    uplinkSpecsByHost.put(distributedVirtualPort.proxyHost, new ArrayList());
                }
                ((Collection)uplinkSpecsByHost.get(distributedVirtualPort.proxyHost)).add(portSpec);
            }
            for (HealthCheckRuntimeInfo healthCheckRuntimeInfo : healthInfo) {
                Collection currentUplinks = (Collection)uplinkSpecsByHost.get(healthCheckRuntimeInfo.runtime.host);
                if (currentUplinks == null) continue;
                healthCheckRuntimeInfo.uplinks = currentUplinks.toArray(new UplinkPortSpec[currentUplinks.size()]);
            }
        }
    }

    public static Map<String, String> getPnicsByKey(HostMember[] hostMembers) {
        HashMap<String, String> pnicsByKey = new HashMap<String, String>();
        if (hostMembers == null) {
            return pnicsByKey;
        }
        for (HostMember member : hostMembers) {
            HostMember.PnicSpec[] backingPnics;
            if (member == null || member.config == null || !(member.config.backing instanceof HostMember.PnicBacking) || (backingPnics = ((HostMember.PnicBacking)member.config.backing).pnicSpec) == null) continue;
            for (HostMember.PnicSpec pnicSpec : backingPnics) {
                pnicsByKey.put(pnicSpec.uplinkPortKey, pnicSpec.pnicDevice);
            }
        }
        return pnicsByKey;
    }

    public static void removeStaleHealthCheckResults(HealthCheckRuntimeInfo[] healthInfo) {
        ArrayList<String> uplinkPortKeys = new ArrayList<String>();
        ArrayList healthCheckResults = new ArrayList();
        for (HealthCheckRuntimeInfo hostHealthInfo : healthInfo) {
            if (hostHealthInfo.runtime.healthCheckResult == null) continue;
            uplinkPortKeys.clear();
            if (hostHealthInfo.uplinks != null) {
                for (UplinkPortSpec uplinkSpec : hostHealthInfo.uplinks) {
                    uplinkPortKeys.add(uplinkSpec.uplinkPortKey);
                }
            }
            healthCheckResults.clear();
            ArrayUtil.append(healthCheckResults, (Object[])hostHealthInfo.runtime.healthCheckResult);
            Iterator iterator = healthCheckResults.iterator();
            while (iterator.hasNext()) {
                String uplinkKey;
                HostMember.HealthCheckResult result = (HostMember.HealthCheckResult)iterator.next();
                if (!(result instanceof HostMember.UplinkHealthCheckResult) || uplinkPortKeys.contains(uplinkKey = ((HostMember.UplinkHealthCheckResult)result).uplinkPortKey)) continue;
                iterator.remove();
            }
            hostHealthInfo.runtime.healthCheckResult = healthCheckResults.toArray(new HostMember.HealthCheckResult[healthCheckResults.size()]);
        }
    }

    public static void updateHealthCheckResultsSummary(HealthCheckRuntimeInfo[] healthInfo) {
        for (HealthCheckRuntimeInfo hostHealthInfo : healthInfo) {
            if (hostHealthInfo.runtime.healthCheckResult == null) continue;
            for (HostMember.HealthCheckResult result : hostHealthInfo.runtime.healthCheckResult) {
                if (result instanceof VmwareDistributedVirtualSwitch.VlanHealthCheckResult) {
                    VmwareDistributedVirtualSwitch.VlanHealthCheckResult vlanResult = (VmwareDistributedVirtualSwitch.VlanHealthCheckResult)result;
                    if (!ArrayUtil.isNullOrEmpty((Object[])vlanResult.untrunkedVlan)) {
                        vlanResult.summary = ManagedEntity.Status.yellow.toString();
                        continue;
                    }
                    if (ArrayUtil.isNullOrEmpty((Object[])vlanResult.trunkedVlan)) {
                        vlanResult.summary = ManagedEntity.Status.gray.toString();
                        continue;
                    }
                    vlanResult.summary = ManagedEntity.Status.green.toString();
                    continue;
                }
                if (result instanceof VmwareDistributedVirtualSwitch.MtuHealthCheckResult) {
                    VmwareDistributedVirtualSwitch.MtuHealthCheckResult mtuResult = (VmwareDistributedVirtualSwitch.MtuHealthCheckResult)result;
                    if (mtuResult.mtuMismatch || !ArrayUtil.isNullOrEmpty((Object[])mtuResult.vlanNotSupportSwitchMtu)) {
                        mtuResult.summary = ManagedEntity.Status.yellow.toString();
                        continue;
                    }
                    if (ArrayUtil.isNullOrEmpty((Object[])mtuResult.vlanSupportSwitchMtu)) {
                        mtuResult.summary = ManagedEntity.Status.gray.toString();
                        continue;
                    }
                    mtuResult.summary = ManagedEntity.Status.green.toString();
                    continue;
                }
                if (!(result instanceof VmwareDistributedVirtualSwitch.TeamingHealthCheckResult)) continue;
                VmwareDistributedVirtualSwitch.TeamingHealthCheckResult teamingResult = (VmwareDistributedVirtualSwitch.TeamingHealthCheckResult)result;
                teamingResult.summary = teamingResult.teamingStatus.equals(VmwareDistributedVirtualSwitch.TeamingMatchStatus.iphashMismatch.toString()) || teamingResult.teamingStatus.equals(VmwareDistributedVirtualSwitch.TeamingMatchStatus.nonIphashMismatch.toString()) ? ManagedEntity.Status.yellow.toString() : ManagedEntity.Status.green.toString();
            }
        }
    }
}

