/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.impl;

import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.network.vm.specs.VmVnicSpec;
import java.util.ArrayList;
import java.util.List;

public class VmUpdateResControlInfo {
    public final ManagedObjectReference vmRef;
    public final List<Integer> deviceKeys = new ArrayList<Integer>();
    public final List<VirtualEthernetCard> virtualEthernetCards = new ArrayList<VirtualEthernetCard>();
    public String changeVersion;
    public boolean isVmAvailable = false;
    public boolean isVmConnected = false;

    public VmUpdateResControlInfo(ManagedObjectReference virtualMachineRef) {
        this.vmRef = virtualMachineRef;
    }

    public VmVnicSpec toVmVnicSpec() {
        VmVnicSpec vmVnicSpec = new VmVnicSpec();
        vmVnicSpec.vmRef = this.vmRef;
        vmVnicSpec.changeVersion = this.changeVersion;
        vmVnicSpec.networkAdapters = this.virtualEthernetCards.toArray(new VirtualEthernetCard[this.virtualEthernetCards.size()]);
        vmVnicSpec.missingDeviceKeys = this.getMissingDevices();
        vmVnicSpec.deviceEditingAllowed = this.isVmAvailable && this.isVmConnected;
        return vmVnicSpec;
    }

    private Integer[] getMissingDevices() {
        ArrayList<Integer> missingDevices = new ArrayList<Integer>();
        for (Integer deviceKey : this.deviceKeys) {
            if (deviceKey == null) continue;
            boolean nicExists = false;
            for (VirtualEthernetCard nic : this.virtualEthernetCards) {
                if (deviceKey != nic.key) continue;
                nicExists = true;
                break;
            }
            if (nicExists) continue;
            missingDevices.add(deviceKey);
        }
        return missingDevices.toArray(new Integer[missingDevices.size()]);
    }
}

