/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.network.impl;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroupInfo;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchInfo;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchManager;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.event.DvsOutOfSyncHostArgument;
import com.vmware.vim.binding.vim.event.HostEventArgument;
import com.vmware.vim.binding.vim.event.OutOfSyncDvsHost;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PciPassthruInfo;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.SriovInfo;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.network.host.specs.IssueInfoProviderWrapperSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostNetworkPropertyProvider
implements PropertyProviderBean {
    private final DataService _dataService;
    private static Log _logger = LogFactory.getLog(HostNetworkPropertyProvider.class);
    private static final String HOST_SERVICE_DVPG_RELATION = "serviceDvpg";
    private static final String DVS_CONFIG_UUID = "config.uuid";
    private static final String CONFIG_NAME = "config.name";
    private static final String HOST_DVS_RELATION = "dvs";
    private static final String DVPG_DVS_REF = "config.distributedVirtualSwitch";
    private static final String DVPG_UPLINK_FLAG = "isUplinkPortgroup";
    private static final String DVPG_CONFIG_TYPE = "config.type";
    private static final String DVPG_CONFIG_KEY = "config.key";

    public HostNetworkPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="HostSystem")
    public PhysicalNic.NetworkHint[] getNetworkHints(ManagedObjectReference objRef) throws Exception {
        PhysicalNic.NetworkHint[] networkHints = new PhysicalNic.NetworkHint[]{};
        ManagedObjectReference networkSystemRef = this.getNetworkSystem(objRef);
        if (networkSystemRef != null) {
            NetworkSystem networkSystem = (NetworkSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)networkSystemRef);
            if (networkSystem != null) {
                networkHints = networkSystem.queryNetworkHint(null);
            }
        } else {
            _logger.warn((Object)"getNetworkHints(): networkSystemRef is null.");
        }
        return networkHints;
    }

    @type(value="HostSystem")
    public ManagedObjectReference getNetworkSystem(ManagedObjectReference hostSystemRef) throws Exception {
        ManagedObjectReference networkSystemRef = null;
        if (this.avoidUsingDataService(hostSystemRef.getServerGuid())) {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostSystemRef);
            networkSystemRef = host.getConfigManager().getNetworkSystem();
        } else {
            networkSystemRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostSystemRef, (String)"configManager.networkSystem");
        }
        return networkSystemRef;
    }

    @type(value="HostSystem")
    public ManagedObjectReference getIscsiManager(ManagedObjectReference hostSystemRef) throws Exception {
        ManagedObjectReference iscsiManagerRef = null;
        if (this.avoidUsingDataService(hostSystemRef.getServerGuid())) {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostSystemRef);
            iscsiManagerRef = host.getConfigManager().getIscsiManager();
        } else {
            iscsiManagerRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostSystemRef, (String)"configManager.iscsiManager");
        }
        return iscsiManagerRef;
    }

    @type(value="HostSystem")
    public ManagedObjectReference getVirtualNicManager(ManagedObjectReference hostSystemRef) throws Exception {
        ManagedObjectReference vnicManagerRef = null;
        if (this.avoidUsingDataService(hostSystemRef.getServerGuid())) {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostSystemRef);
            vnicManagerRef = host.getConfigManager().getVirtualNicManager();
        } else {
            vnicManagerRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostSystemRef, (String)"configManager.virtualNicManager");
        }
        return vnicManagerRef;
    }

    private boolean avoidUsingDataService(String serverGuid) {
        return VcServiceUtil.isMNVc((String)serverGuid);
    }

    @type(value="HostSystem")
    public String[] getUnclaimedPhysicalNicNames(ManagedObjectReference objRef) throws Exception {
        String property = "config.network";
        NetworkInfo networkInfo = (NetworkInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)objRef, (String)"config.network");
        VirtualSwitch[] vsList = networkInfo.getVswitch();
        HostProxySwitch[] hpsList = networkInfo.getProxySwitch();
        OpaqueSwitch[] ovsList = networkInfo.getOpaqueSwitch();
        PhysicalNic[] pnicList = networkInfo.getPnic();
        Map<String, PhysicalNic> pnicSearchMap = HostNetworkPropertyProvider.createPhysicalNicSearchMap(pnicList);
        if (vsList != null) {
            for (VirtualSwitch virtualSwitch : vsList) {
                if (virtualSwitch.pnic == null) continue;
                for (String nicKey : virtualSwitch.pnic) {
                    pnicSearchMap.remove(HostNetworkPropertyProvider.decodePhysicalNicKey(nicKey));
                }
            }
        }
        if (hpsList != null) {
            for (VirtualSwitch virtualSwitch : hpsList) {
                if (virtualSwitch.pnic == null) continue;
                for (String nicKey : virtualSwitch.pnic) {
                    pnicSearchMap.remove(HostNetworkPropertyProvider.decodePhysicalNicKey(nicKey));
                }
            }
        }
        if (ovsList != null) {
            for (VirtualSwitch virtualSwitch : ovsList) {
                if (virtualSwitch.pnic == null) continue;
                for (String nicKey : virtualSwitch.pnic) {
                    pnicSearchMap.remove(HostNetworkPropertyProvider.decodePhysicalNicKey(nicKey));
                }
            }
        }
        ArrayList<String> nicNames = new ArrayList<String>(pnicSearchMap.size());
        for (PhysicalNic pnic : pnicSearchMap.values()) {
            nicNames.add(pnic.device);
        }
        return nicNames.toArray(new String[nicNames.size()]);
    }

    @type(value="HostSystem")
    public VirtualSwitch getVirtualSwitch(ManagedObjectReference objRef, String switchKey) throws Exception {
        String property = "config.network.vswitch";
        VirtualSwitch[] vsList = (VirtualSwitch[])QueryUtil.getProperty((DataService)this._dataService, (Object)objRef, (String)"config.network.vswitch");
        if (vsList == null) {
            return null;
        }
        for (VirtualSwitch vs : vsList) {
            if (!vs.key.equals(switchKey)) continue;
            return vs;
        }
        return null;
    }

    @type(value="HostSystem")
    public SriovInfo[] getSriovInfo(ManagedObjectReference objRef) throws Exception {
        ArrayList<SriovInfo> sriovList = new ArrayList<SriovInfo>();
        String property = "config.pciPassthruInfo";
        PciPassthruInfo[] pciPassThroughList = (PciPassthruInfo[])QueryUtil.getProperty((DataService)this._dataService, (Object)objRef, (String)"config.pciPassthruInfo");
        if (pciPassThroughList == null) {
            return null;
        }
        for (PciPassthruInfo pci : pciPassThroughList) {
            if (!(pci instanceof SriovInfo)) continue;
            sriovList.add((SriovInfo)pci);
        }
        return sriovList.toArray(new SriovInfo[sriovList.size()]);
    }

    @type(value="HostSystem")
    public IssueInfoProviderWrapperSpec[] getOutOfSyncDvsHostConfigIssue(ManagedObjectReference hostRef, ManagedObjectReference dvsRef) throws Exception {
        Set<ManagedObjectReference> dvsRefs = Collections.singleton(dvsRef);
        Collection<IssueInfoProviderWrapperSpec> foundIssues = this.extractRelevantOutOfSyncDvsHostIssues(hostRef, dvsRefs);
        return foundIssues.toArray(new IssueInfoProviderWrapperSpec[foundIssues.size()]);
    }

    @type(value="HostSystem")
    public PhysicalNic getPhysicalNicByDeviceName(ManagedObjectReference hostRef, String deviceName) throws Exception {
        PhysicalNic[] nics = (PhysicalNic[])QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"config.network.pnic");
        if (nics != null) {
            for (PhysicalNic pnic : nics) {
                if (pnic == null || pnic.device == null || !pnic.device.equals(deviceName)) continue;
                return pnic;
            }
        }
        return null;
    }

    @type(value="HostSystem")
    public boolean getMultipleNetStackInstancesInUse(ManagedObjectReference hostRef) {
        return false;
    }

    @type(value="HostSystem")
    public DistributedVirtualSwitchManager.DvsConfigTarget getDvsServiceConfig(ManagedObjectReference contextRef) throws Exception {
        DistributedVirtualSwitchManager.DvsConfigTarget result = new DistributedVirtualSwitchManager.DvsConfigTarget();
        result.distributedVirtualSwitch = this.extractDistributedVirtualSwitchesyHost(contextRef);
        result.distributedVirtualPortgroup = this.extractDistributedVirtualPortgroupsByHost(contextRef, result.distributedVirtualSwitch);
        return result;
    }

    private DistributedVirtualSwitchInfo[] extractDistributedVirtualSwitchesyHost(ManagedObjectReference hostRef) throws Exception {
        ResultSet dvSwitches = QueryUtil.getData((DataService)this._dataService, (QuerySpec)QueryUtil.buildQuerySpec((Constraint)QueryUtil.createConstraintForRelationship((Object)hostRef, (String)HOST_DVS_RELATION, (String)DistributedVirtualSwitch.class.getSimpleName()), (String[])new String[]{CONFIG_NAME, DVS_CONFIG_UUID}));
        DistributedVirtualSwitchInfo[] result = new DistributedVirtualSwitchInfo[dvSwitches.items.length];
        for (int i = 0; i < dvSwitches.items.length; ++i) {
            result[i] = new DistributedVirtualSwitchInfo();
            result[i].distributedVirtualSwitch = (ManagedObjectReference)dvSwitches.items[i].resourceObject;
            for (PropertyValue pv : dvSwitches.items[i].properties) {
                if (CONFIG_NAME.equals(pv.propertyName)) {
                    result[i].switchName = (String)pv.value;
                    continue;
                }
                if (!DVS_CONFIG_UUID.equals(pv.propertyName)) continue;
                result[i].switchUuid = (String)pv.value;
            }
        }
        return result;
    }

    private DistributedVirtualPortgroupInfo[] extractDistributedVirtualPortgroupsByHost(ManagedObjectReference hostRef, DistributedVirtualSwitchInfo[] switches) throws Exception {
        ResultSet portgroups = QueryUtil.getData((DataService)this._dataService, (QuerySpec)QueryUtil.buildQuerySpec((Constraint)QueryUtil.createConstraintForRelationship((Object)hostRef, (String)HOST_SERVICE_DVPG_RELATION, (String)DistributedVirtualPortgroup.class.getSimpleName()), (String[])new String[]{DVPG_CONFIG_KEY, CONFIG_NAME, DVPG_CONFIG_TYPE, DVPG_UPLINK_FLAG, DVPG_DVS_REF}));
        DistributedVirtualPortgroupInfo[] result = new DistributedVirtualPortgroupInfo[portgroups.items.length];
        for (int i = 0; i < portgroups.items.length; ++i) {
            result[i] = new DistributedVirtualPortgroupInfo();
            result[i].portgroup = (ManagedObjectReference)portgroups.items[i].resourceObject;
            block1: for (PropertyValue pv : portgroups.items[i].properties) {
                if (DVPG_CONFIG_KEY.equals(pv.propertyName)) {
                    result[i].portgroupKey = (String)pv.value;
                    continue;
                }
                if (CONFIG_NAME.equals(pv.propertyName)) {
                    result[i].portgroupName = (String)pv.value;
                    continue;
                }
                if (DVPG_CONFIG_TYPE.equals(pv.propertyName)) {
                    result[i].portgroupType = (String)pv.value;
                    continue;
                }
                if (DVPG_UPLINK_FLAG.equals(pv.propertyName)) {
                    result[i].uplinkPortgroup = (Boolean)pv.value;
                    continue;
                }
                if (!DVPG_DVS_REF.equals(pv.propertyName)) continue;
                ManagedObjectReference dvs = (ManagedObjectReference)pv.value;
                for (DistributedVirtualSwitchInfo dvsInfo : switches) {
                    if (!dvs.equals((Object)dvsInfo.distributedVirtualSwitch)) continue;
                    result[i].switchName = dvsInfo.switchName;
                    result[i].switchUuid = dvsInfo.switchUuid;
                    continue block1;
                }
            }
        }
        return result;
    }

    private Collection<IssueInfoProviderWrapperSpec> extractRelevantOutOfSyncDvsHostIssues(ManagedObjectReference hostRef, Collection<ManagedObjectReference> dvsRefs) throws Exception {
        ArrayList<IssueInfoProviderWrapperSpec> foundIssues = new ArrayList<IssueInfoProviderWrapperSpec>();
        for (ManagedObjectReference switchRef : dvsRefs) {
            ResultSet rs = this.getSingleProperty("info.entity", "ConfigIssue", switchRef, "info");
            if (rs == null || rs.items == null) continue;
            for (ResultItem item : rs.items) {
                IssueInfoProviderWrapperSpec issue = this.processConfigIssue(hostRef, (IssueInfo)item.properties[0].value, item.resourceObject);
                if (issue == null) continue;
                foundIssues.add(issue);
            }
        }
        return foundIssues;
    }

    private IssueInfoProviderWrapperSpec processConfigIssue(ManagedObjectReference hostRef, IssueInfo issue, Object issueURI) throws Exception {
        if (issue.details != null && issue.details instanceof OutOfSyncDvsHost) {
            OutOfSyncDvsHost outOfSync = (OutOfSyncDvsHost)issue.details;
            DvsOutOfSyncHostArgument related = null;
            for (DvsOutOfSyncHostArgument current : outOfSync.hostOutOfSync) {
                HostEventArgument hostEventArg = current.outOfSyncHost;
                if (!hostEventArg.host.equals((Object)hostRef)) continue;
                related = current;
                break;
            }
            if (related != null) {
                outOfSync.hostOutOfSync = new DvsOutOfSyncHostArgument[]{related};
                IssueInfoProviderWrapperSpec spec = new IssueInfoProviderWrapperSpec();
                spec.issueInfo = issue;
                spec.issueProvider = issueURI;
                return spec;
            }
        }
        return null;
    }

    private ResultSet getSingleProperty(String comparedProperty, String targetType, Object comparableValue, String requestedProperty) throws Exception {
        return QueryUtil.getData((DataService)this._dataService, (QuerySpec)QueryUtil.buildQuerySpec((Constraint)QueryUtil.createPropertyConstraint((String)targetType, (String)comparedProperty, (Comparator)Comparator.EQUALS, (Object)comparableValue), (String[])new String[]{requestedProperty}));
    }

    @type(value="HostSystem")
    public DistributedVirtualPortgroupInfo[] getAvailableUplinkPortGroupsForHps(ManagedObjectReference host, String dvsUuid) throws Exception {
        Constraint constraint = HostNetworkPropertyProvider.createHpsUplinkPortgroupConstraint(host, dvsUuid);
        String[] props = new String[]{"key", "name"};
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])props);
        ResultSet results = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        if (results.items == null) {
            _logger.error((Object)"getAvailableUplinkPortGroupsForHps(): results.items is null.");
            assert (false);
            return new DistributedVirtualPortgroupInfo[0];
        }
        DistributedVirtualPortgroupInfo[] pgInfos = new DistributedVirtualPortgroupInfo[results.items.length];
        for (int i = 0; i < results.items.length; ++i) {
            ResultItem ri = results.items[i];
            DistributedVirtualPortgroupInfo pgInfo = new DistributedVirtualPortgroupInfo();
            pgInfo.portgroup = (ManagedObjectReference)ri.resourceObject;
            pgInfo.switchUuid = dvsUuid;
            pgInfo.uplinkPortgroup = true;
            if (ri.properties != null) {
                for (PropertyValue pv : ri.properties) {
                    String value;
                    String string = value = pv.value == null ? null : pv.value.toString();
                    if ("key".equals(pv.propertyName)) {
                        pgInfo.portgroupKey = value;
                        continue;
                    }
                    if (!"name".equals(pv.propertyName)) continue;
                    pgInfo.portgroupName = value;
                }
            }
            pgInfos[i] = pgInfo;
        }
        return pgInfos;
    }

    private static Constraint createHpsUplinkPortgroupConstraint(ManagedObjectReference host, String dvsUuid) {
        ObjectIdentityConstraint hostConstraint = QueryUtil.createObjectIdentityConstraint((Object)host);
        Constraint vmwareDvsConstraint = HostNetworkPropertyProvider.createHpsUplinkPortgroupConstraintForDvsType(dvsUuid, (Constraint)hostConstraint, VmwareDistributedVirtualSwitch.class);
        Constraint genericDvsConstraint = HostNetworkPropertyProvider.createHpsUplinkPortgroupConstraintForDvsType(dvsUuid, (Constraint)hostConstraint, DistributedVirtualSwitch.class);
        CompositeConstraint pgConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{vmwareDvsConstraint, genericDvsConstraint}, (Conjoiner)Conjoiner.OR);
        return pgConstraint;
    }

    private static Constraint createHpsUplinkPortgroupConstraintForDvsType(String dvsUuid, Constraint hostConstraint, Class<?> dvsType) {
        RelationalConstraint hpsConstraint = QueryUtil.createRelationalConstraint((String)HOST_DVS_RELATION, (Constraint)hostConstraint, (Boolean)true, (String)dvsType.getSimpleName());
        PropertyConstraint uuidConstraint = QueryUtil.createPropertyConstraint((String)dvsType.getSimpleName(), (String)"uuid", (Comparator)Comparator.EQUALS, (Object)dvsUuid);
        Constraint[] nestedConstraints = new Constraint[]{hpsConstraint, uuidConstraint};
        CompositeConstraint dvsConstraint = QueryUtil.createCompositeConstraint((Constraint[])nestedConstraints, (Conjoiner)Conjoiner.AND);
        dvsConstraint.targetType = dvsType.getSimpleName();
        RelationalConstraint pgConstraint = QueryUtil.createRelationalConstraint((String)"uplinkPortgroup", (Constraint)dvsConstraint, (Boolean)true, (String)DistributedVirtualPortgroup.class.getSimpleName());
        return pgConstraint;
    }

    private static String decodePhysicalNicKey(String key) throws Exception {
        return key;
    }

    private static Map<String, PhysicalNic> createPhysicalNicSearchMap(PhysicalNic[] list) {
        HashMap<String, PhysicalNic> map = new HashMap<String, PhysicalNic>();
        for (PhysicalNic nic : list) {
            map.put(nic.key, nic);
        }
        return map;
    }
}

