/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.switchdiagram.impl;

import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroupInfo;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchInfo;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchManager;
import com.vmware.vim.binding.vim.dvs.PortConnectee;
import com.vmware.vim.binding.vim.dvs.PortConnection;
import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vim.dvs.ProductSpec;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.PciDevice;
import com.vmware.vim.binding.vim.host.PciPassthruInfo;
import com.vmware.vim.binding.vim.host.SriovInfo;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualNicManagerInfo;
import com.vmware.vim.binding.vim.vm.FaultToleranceConfigInfo;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.dvs.impl.DvsPropertyProvider;
import com.vmware.vsphere.client.dvs.specs.switchdiagram.SwitchDiagramDvsSpec;
import com.vmware.vsphere.client.dvs.specs.switchdiagram.SwitchDiagramFilterSpec;
import com.vmware.vsphere.client.dvs.specs.switchdiagram.SwitchDiagramHostSpec;
import com.vmware.vsphere.client.dvs.specs.switchdiagram.SwitchDiagramPortgroupSpec;
import com.vmware.vsphere.client.dvs.specs.switchdiagram.SwitchDiagramSpec;
import com.vmware.vsphere.client.dvs.specs.switchdiagram.SwitchDiagramVmSpec;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwitchDiagramPropertyProvider
implements PropertyProviderBean {
    private static final String PORTGROUP_RELATION = "portgroup";
    private static final String VM_DVPORTGROUP_RELATION = "dvPortGroup";
    private static final String HOST_RELATION = "host";
    private static final String DVS_CONFIG_PROPERTY = "config";
    private static final String DVS_CAPABILITY_PROPERTY = "capability";
    private static final String DVS_RES_CONTROL_VERSION_PROPERTY = "networkResourceManagementVersion";
    private static final String DVS_LACP_API_VERSION_PROPERTY = "config[@type='VMwareDVSConfigInfo'].lacpApiVersion";
    private static final String DVS_PRODUCT_INFO_PROPERTY = "summary.productInfo";
    private static final String DVS_UPLINK_PORTGROUP_PROPERTY = "config.uplinkPortgroup";
    private static final String DVS_PORTGROUPS_COUNT_PROPERTY = "portgroup._length";
    private static final String DVS_HOSTS_COUNT_PROPERTY = "config.host._length";
    private static final String DVS_VMS_COUNT_PROPERTY = "summary.vm._length";
    private static final String DVS_UUID_PROPERTY = "uuid";
    private static final String DVS_STANDALONE_PORT_COUNT_PROPERTY = "config.numStandalonePorts";
    private static final String[] SWITCH_DIAGRAM_DVS_PROPERTIES = new String[]{"config", "capability", "networkResourceManagementVersion", "config[@type='VMwareDVSConfigInfo'].lacpApiVersion", "summary.productInfo", "config.uplinkPortgroup", "portgroup._length", "config.host._length", "summary.vm._length", "uuid", "config.numStandalonePorts"};
    private static final String HOST_NAME_PROPERTY = "name";
    private static final String HOST_NETWORK_PROPERTY = "config.network";
    private static final String HOST_VM_PROPERTY = "vm";
    private static final String HOST_PCI_DEVICE = "hardware.pciDevice";
    private static final String HOST_PCI_PASSTHRU_INFO = "config.pciPassthruInfo";
    private static final String HOST_VNIC_MANAGER_INFO = "config.virtualNicManagerInfo";
    private static final String HOST_CONFIG_PRODUCT = "config.product";
    private static final String HOST_IPV6_SUPPORTED = "config.capabilities.ipV6Supported";
    private static final String HOST_SUPPORTS_VLAN = "config.capabilities.supportsVlan";
    private static final String[] SWITCH_DIAGRAM_HOST_PROPERTIES = new String[]{"name", "config.network", "config.virtualNicManagerInfo", "config.pciPassthruInfo", "config.product", "config.capabilities.ipV6Supported", "config.capabilities.supportsVlan"};
    private static final String PORTGROUP_KEY_PROPERTY = "key";
    private static final String PORTGROUP_NAME_PROPERTY = "config.name";
    private static final String PORTGROUP_TYPE_PROPERTY = "config.type";
    private static final String PORTGROUP_NUM_PORTS_PROPERTY = "config.numPorts";
    private static final String PORTGROUP_VLAN_PROPERTY = "config.defaultPortConfig[@type='VMwareDVSPortSetting'].vlan";
    private static final String PORTGROUP_UPLINK_ORDER_PROPERTY = "config.defaultPortConfig[@type='VMwareDVSPortSetting'].uplinkTeamingPolicy.uplinkPortOrder";
    private static final String PORTGROUP_VM_PROPERTY = "vm";
    private static final String[] SWITCH_DIAGRAM_PORTGROUP_PROPERTIES = new String[]{"key", "config.name", "config.type", "config.numPorts", "config.defaultPortConfig[@type='VMwareDVSPortSetting'].vlan", "config.defaultPortConfig[@type='VMwareDVSPortSetting'].uplinkTeamingPolicy.uplinkPortOrder"};
    private static final String VM_NAME_PROPERTY = "name";
    private static final String VM_HOST_PROPERTY = "summary.runtime.host";
    private static final String VM_DEVICE_PROPERTY = "virtualEthernetDistributedBacking";
    private static final String VM_POWER_STATE_PROPERTY = "runtime.powerState";
    private static final String VM_FT_INFO_PROPERTY = "config.ftInfo";
    private static final String VM_CONNECTION_STATE_PROPERTY = "runtime.connectionState";
    private static final String[] SWITCH_DIAGRAM_VM_PROPERTIES = new String[]{"name", "summary.runtime.host", "virtualEthernetDistributedBacking", "runtime.powerState", "config.ftInfo", "runtime.connectionState"};
    private static final String SWITCH_DIAGRAM_DVS_PROPERTIES_QUERY_SPEC = "dvsPropertiesQuerySpec";
    private static final String SWITCH_DIAGRAM_HOST_PROPERTIES_QUERY_SPEC = "hostPropertiesQuerySpec";
    private static final String SWITCH_DIAGRAM_PORTGROUP_PROPERTIES_QUERY_SPEC = "portgroupPropertiesQuerySpec";
    private static final String SWITCH_DIAGRAM_UPLINK_PORTGROUP_PROPERTIES_QUERY_SPEC = "uplinkPortgroupPropertiesQuerySpec";
    private static final String SWITCH_DIAGRAM_VM_PROPERTIES_QUERY_SPEC = "vmPropertiesQuerySpec";
    private static final String SWITCH_DIAGRAM_PG_VM_COUNTS_QUERY_SPEC = "ns-switchdiagram-pgvmcounts-";
    private static final String SWITCH_DIAGRAM_PG_VM_PROPS_QUERY_SPEC = "ns-switchdiagram-pgvmprops-";
    private static final String SWITCH_DIAGRAM_SA_VM_COUNTS_QUERY_SPEC = "ns-switchdiagram-savmcounts-";
    private static final String SWITCH_DIAGRAM_SA_VM_PROPS_QUERY_SPEC = "ns-switchdiagram-savmprops-";
    private static Log _logger = LogFactory.getLog(SwitchDiagramPropertyProvider.class);
    private DataService _dataService;
    private DvsPropertyProvider _dvsPropertyProvider;

    public SwitchDiagramPropertyProvider(DataService dataService, DvsPropertyProvider dvsPropertyProvider) {
        this._dataService = dataService;
        this._dvsPropertyProvider = dvsPropertyProvider;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public SwitchDiagramSpec getSwitchDiagramSpec(ManagedObjectReference dvsRef, SwitchDiagramFilterSpec switchDiagramFilterSpec) throws Exception {
        long startTimeMs = System.currentTimeMillis();
        SwitchDiagramSpec resultSpec = !ArrayUtil.isNullOrEmpty((Object[])switchDiagramFilterSpec.portKeys) ? this.getPortFilteredSwitchDiagramSpec(dvsRef, switchDiagramFilterSpec) : (switchDiagramFilterSpec != null && switchDiagramFilterSpec.vms != null ? this.getVmFilteredSwitchDiagramSpec(dvsRef, switchDiagramFilterSpec) : this.getHostPortgroupFilteredSwitchDiagramSpec(dvsRef, switchDiagramFilterSpec));
        if (_logger.isDebugEnabled()) {
            long stopTimeMs = System.currentTimeMillis();
            long durationMs = stopTimeMs - startTimeMs;
            this.logPerformanceData(resultSpec, durationMs);
        }
        return resultSpec;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public SwitchDiagramSpec getPortgroupVmsOnDemandDiagramSpec(ManagedObjectReference dvsRef, SwitchDiagramFilterSpec switchDiagramFilterSpec) throws Exception {
        if (switchDiagramFilterSpec == null) {
            throw new IllegalArgumentException("Required switchDiagramFilterSpec not provided.");
        }
        this.validateFilterSpec(switchDiagramFilterSpec, true);
        return this.getSwitchDiagramSpec(dvsRef, switchDiagramFilterSpec);
    }

    private void logPerformanceData(SwitchDiagramSpec resultSpec, long durationMs) {
        double durationS = (double)durationMs / 1000.0;
        String messageFormat = "Retrieved in %.3fs (H %d PG %d VM %d p %d)";
        try {
            int vmCount;
            int hostCount = resultSpec.dvsSpec.hosts == null ? 0 : resultSpec.dvsSpec.hosts.length;
            int pgCount = resultSpec.dvsSpec.portgroups == null ? 0 : resultSpec.dvsSpec.portgroups.length;
            int n = vmCount = resultSpec.dvsSpec.vms == null ? 0 : resultSpec.dvsSpec.vms.length;
            if (resultSpec.dvsSpec.portgroups != null) {
                for (SwitchDiagramPortgroupSpec pgSpec : resultSpec.dvsSpec.portgroups) {
                    if (pgSpec == null) continue;
                    vmCount += pgSpec.vmsCount;
                }
            }
            int nonUplinkPortCount = resultSpec.nonUplinkPorts == null ? 0 : resultSpec.nonUplinkPorts.length;
            int uplinkPortCount = resultSpec.uplinkPorts == null ? 0 : resultSpec.uplinkPorts.length;
            int portCount = nonUplinkPortCount + uplinkPortCount;
            _logger.debug((Object)String.format("Retrieved in %.3fs (H %d PG %d VM %d p %d)", durationS, hostCount, pgCount, vmCount += resultSpec.dvsSpec.standaloneVmsCount, portCount));
        }
        catch (RuntimeException ex) {
            _logger.error((Object)"Could not write performance data.", (Throwable)ex);
        }
    }

    public SwitchDiagramSpec getHostPortgroupFilteredSwitchDiagramSpec(ManagedObjectReference dvsRef, SwitchDiagramFilterSpec switchDiagramFilterSpec) throws Exception {
        QuerySpec[] dhpQuerySpec = this.getDPHQuerySpec(dvsRef, switchDiagramFilterSpec);
        Response dphResponse = null;
        if (dhpQuerySpec.length > 0) {
            RequestSpec requestSpec = new RequestSpec();
            requestSpec.querySpec = dhpQuerySpec;
            dphResponse = this._dataService.getData(requestSpec);
        }
        int standalonePortsCount = this.getRetrievedStandalonePortsCount(dphResponse);
        ManagedObjectReference[] retrievedHostRefs = this.getRetrievedHostRefs(dphResponse);
        ManagedObjectReference[] retrievedPortgroupRefs = this.getRetrievedPortgroupRefs(dphResponse);
        ManagedObjectReference[] filteredHostRefs = this.getFilteredHostRefs(retrievedHostRefs, switchDiagramFilterSpec);
        ManagedObjectReference[] filteredPortgroupRefsForVMCounting = this.getFilteredPortgroupRefsForVMCounting(retrievedPortgroupRefs, switchDiagramFilterSpec);
        ManagedObjectReference[] filteredPortgroupRefsForVMLoading = this.getFilteredPortgroupRefsForVMLoading(retrievedPortgroupRefs, switchDiagramFilterSpec);
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
        DistributedVirtualPort[] uplinkPorts = null;
        Object[] vnicPorts = null;
        Object[] standalonePorts = null;
        ManagedObjectReference[] standaloneVmRefs = null;
        if (!switchDiagramFilterSpec.includeOnlyVmsData) {
            uplinkPorts = this.fetchUplinkPorts(dvs);
            String[] appPortgroupKeys = this.getPortgroupKeys(dphResponse.resultSet, null);
            String[] portKeys = this.getVnicPortKeys(dphResponse.resultSet, appPortgroupKeys);
            vnicPorts = this.fetchPortsByKey(dvs, portKeys);
        }
        String[] vmLoadingPortgroupKeys = this.getPortgroupKeys(dphResponse.resultSet, filteredPortgroupRefsForVMLoading);
        Object[] nonUplinkPorts = this.fetchConnectedNonUplinkPorts(dvs, vmLoadingPortgroupKeys);
        if (standalonePortsCount > 0 || switchDiagramFilterSpec.includeOnlyVmsData && switchDiagramFilterSpec.includeStandaloneVmsData) {
            standalonePorts = this.fetchStandalonePorts(dvs);
            standaloneVmRefs = this.getPortConnectedEntityRefs((DistributedVirtualPort[])standalonePorts, VirtualMachine.class);
        }
        HashMap<String, ManagedObjectReference> queryNameToPortgroupMap = new HashMap<String, ManagedObjectReference>();
        QuerySpec[] vmQuerySpec = this.getVmsCountAndDataQuerySpec(filteredHostRefs, filteredPortgroupRefsForVMCounting, filteredPortgroupRefsForVMLoading, standaloneVmRefs, switchDiagramFilterSpec, queryNameToPortgroupMap);
        RequestSpec vmRequestSpec = new RequestSpec();
        vmRequestSpec.querySpec = vmQuerySpec;
        Response vmResponse = this._dataService.getData(vmRequestSpec);
        Object[] portgroupPorts = switchDiagramFilterSpec.includeOnlyVmsData ? nonUplinkPorts : (DistributedVirtualPort[])ArrayUtils.addAll((Object[])nonUplinkPorts, (Object[])vnicPorts);
        if (switchDiagramFilterSpec.includeStandaloneVmsData) {
            portgroupPorts = (DistributedVirtualPort[])ArrayUtils.addAll((Object[])portgroupPorts, (Object[])standalonePorts);
        }
        SwitchDiagramSpec resultSpec = this.createSwitchDiagramSpec(dvsRef, dphResponse.resultSet, vmResponse.resultSet, (DistributedVirtualPort[])portgroupPorts, uplinkPorts, queryNameToPortgroupMap, switchDiagramFilterSpec);
        return resultSpec;
    }

    private SwitchDiagramSpec getPortFilteredSwitchDiagramSpec(ManagedObjectReference dvsRef, SwitchDiagramFilterSpec switchDiagramFilterSpec) throws Exception {
        this.validateFilterSpec(switchDiagramFilterSpec, false);
        SwitchDiagramSpec resultSpec = null;
        Boolean isUplinkPort = false;
        PortCriteria pc = new PortCriteria();
        pc.portKey = switchDiagramFilterSpec.portKeys;
        pc.uplinkPort = false;
        Object[] ports = this._dvsPropertyProvider.getPorts(dvsRef, pc);
        if (ports == null) {
            pc.uplinkPort = true;
            ports = this._dvsPropertyProvider.getPorts(dvsRef, pc);
            if (!ArrayUtil.isNullOrEmpty((Object[])ports)) {
                isUplinkPort = true;
            }
        }
        Object dvPort = null;
        if (ports != null && ports.length == 1 && ports[0] != null) {
            dvPort = ports[0];
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])switchDiagramFilterSpec.hosts) && dvPort != null && ((DistributedVirtualPort)dvPort).proxyHost != null && !ManagedObjectUtil.areEqual((ManagedObjectReference)((DistributedVirtualPort)dvPort).proxyHost, (ManagedObjectReference)switchDiagramFilterSpec.hosts[0]).booleanValue()) {
            dvPort = null;
        }
        ManagedObjectReference hostRef = null;
        ManagedObjectReference vmRef = null;
        if (dvPort != null) {
            hostRef = ((DistributedVirtualPort)dvPort).proxyHost;
            if (((DistributedVirtualPort)dvPort).connectee != null && ((DistributedVirtualPort)dvPort).connectee.type.equals(PortConnectee.ConnecteeType.vmVnic.toString())) {
                vmRef = ((DistributedVirtualPort)dvPort).connectee.connectedEntity;
            }
        }
        ArrayList<QuerySpec> querySpecs = new ArrayList<QuerySpec>();
        QuerySpec dvsPropertiesQuerySpec = this.getDvsPropertiesQuerySpec(dvsRef);
        querySpecs.add(dvsPropertiesQuerySpec);
        if (hostRef != null) {
            QuerySpec hostPropertiesQuerySpec = QueryUtil.buildQuerySpec((Object)hostRef, (String[])SWITCH_DIAGRAM_HOST_PROPERTIES);
            hostPropertiesQuerySpec.name = SWITCH_DIAGRAM_HOST_PROPERTIES_QUERY_SPEC;
            querySpecs.add(hostPropertiesQuerySpec);
        }
        if (vmRef != null) {
            QuerySpec vmPropertiesQuerySpec = QueryUtil.buildQuerySpec((Object)vmRef, (String[])SWITCH_DIAGRAM_VM_PROPERTIES);
            vmPropertiesQuerySpec.name = SWITCH_DIAGRAM_VM_PROPERTIES_QUERY_SPEC;
            querySpecs.add(vmPropertiesQuerySpec);
        }
        if (dvPort != null && !isUplinkPort.booleanValue() && ((DistributedVirtualPort)dvPort).portgroupKey != null) {
            QuerySpec nonUplinkPortgroupPropertiesQuerySpec = this.getPortgroupByKeyQuerySpec(dvsRef, ((DistributedVirtualPort)dvPort).portgroupKey);
            querySpecs.add(nonUplinkPortgroupPropertiesQuerySpec);
        }
        QuerySpec uplinkPortgroupPropertiesQuerySpec = this.getUplinkPortgroupPropertiesQuerySpec(dvsRef);
        querySpecs.add(uplinkPortgroupPropertiesQuerySpec);
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecs.toArray(new QuerySpec[querySpecs.size()]);
        Response response = this._dataService.getData(requestSpec);
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
        DistributedVirtualPort[] uplinkPorts = this.fetchUplinkPorts(dvs);
        resultSpec = this.createSwitchDiagramSpec(dvsRef, response.resultSet, null, (DistributedVirtualPort[])ports, uplinkPorts, null, switchDiagramFilterSpec);
        if (!isUplinkPort.booleanValue() && hostRef == null && vmRef == null) {
            resultSpec.uplinkPorts = uplinkPorts;
        }
        return resultSpec;
    }

    private QuerySpec getPortgroupByKeyQuerySpec(ManagedObjectReference dvsRef, String key) {
        Constraint dvsPortgroupsConstraint = QueryUtil.createConstraintForRelationship((Object)dvsRef, (String)PORTGROUP_RELATION, (String)DistributedVirtualPortgroup.class.getSimpleName());
        PropertyConstraint portgroupkeyConstraint = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)PORTGROUP_KEY_PROPERTY, (Comparator)Comparator.EQUALS, (Object)key);
        Constraint compositeConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{dvsPortgroupsConstraint, portgroupkeyConstraint}, (Conjoiner)Conjoiner.AND);
        QuerySpec resultSpec = QueryUtil.buildQuerySpec((Constraint)compositeConstraint, (String[])SWITCH_DIAGRAM_PORTGROUP_PROPERTIES);
        resultSpec.name = SWITCH_DIAGRAM_PORTGROUP_PROPERTIES_QUERY_SPEC;
        return resultSpec;
    }

    private SwitchDiagramSpec getVmFilteredSwitchDiagramSpec(ManagedObjectReference dvsRef, SwitchDiagramFilterSpec switchDiagramFilterSpec) throws Exception {
        this.validateFilterSpec(switchDiagramFilterSpec, false);
        ArrayList<QuerySpec> querySpecs = new ArrayList<QuerySpec>();
        QuerySpec dvsPropertiesQuerySpec = this.getDvsPropertiesQuerySpec(dvsRef);
        querySpecs.add(dvsPropertiesQuerySpec);
        QuerySpec hostPropertiesQuerySpec = this.getHostProperertiesQuerySpec(dvsRef, switchDiagramFilterSpec);
        querySpecs.add(hostPropertiesQuerySpec);
        QuerySpec nonUplinkPortgroupsQuerySpec = this.getNonUplinkPortgroupsQuerySpec(dvsRef, switchDiagramFilterSpec);
        querySpecs.add(nonUplinkPortgroupsQuerySpec);
        QuerySpec uplinkPortgroupPropertiesQuerySPec = this.getUplinkPortgroupPropertiesQuerySpec(dvsRef);
        querySpecs.add(uplinkPortgroupPropertiesQuerySPec);
        QuerySpec vmPropertiesQuerySpec = this.createVmPropertiesQuerySpec(switchDiagramFilterSpec);
        vmPropertiesQuerySpec.name = SWITCH_DIAGRAM_VM_PROPERTIES_QUERY_SPEC;
        querySpecs.add(vmPropertiesQuerySpec);
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecs.toArray(new QuerySpec[querySpecs.size()]);
        Response response = this._dataService.getData(requestSpec);
        Object[] portKeys = this.getVmPortKeys(response.resultSet);
        DistributedVirtualPort[] nonUplinkPorts = !ArrayUtil.isNullOrEmpty((Object[])portKeys) ? this._dvsPropertyProvider.getPortsByKey(dvsRef, portKeys) : null;
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
        DistributedVirtualPort[] uplinkPorts = this.fetchUplinkPorts(dvs);
        SwitchDiagramSpec resultSpec = this.createSwitchDiagramSpec(dvsRef, response.resultSet, null, nonUplinkPorts, uplinkPorts, null, switchDiagramFilterSpec);
        return resultSpec;
    }

    private QuerySpec createVmPropertiesQuerySpec(SwitchDiagramFilterSpec switchDiagramFilterSpec) {
        QuerySpec resultSpec = null;
        if (ArrayUtil.isNullOrEmpty((Object[])switchDiagramFilterSpec.vms)) {
            return resultSpec;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])switchDiagramFilterSpec.hosts)) {
            resultSpec = QueryUtil.buildQuerySpec((Object[])switchDiagramFilterSpec.vms, (String[])SWITCH_DIAGRAM_VM_PROPERTIES);
        } else {
            CompositeConstraint cc = new CompositeConstraint();
            cc.conjoiner = Conjoiner.OR;
            cc.targetType = VirtualMachine.class.getSimpleName();
            Constraint[] vmConstraints = new Constraint[switchDiagramFilterSpec.vms.length];
            for (int i = 0; i < switchDiagramFilterSpec.vms.length; ++i) {
                ObjectIdentityConstraint oic = new ObjectIdentityConstraint();
                oic.target = switchDiagramFilterSpec.vms[i];
                oic.targetType = VirtualMachine.class.getSimpleName();
                vmConstraints[i] = oic;
            }
            cc.nestedConstraints = vmConstraints;
            ObjectIdentityConstraint hostConstraint = new ObjectIdentityConstraint();
            hostConstraint.target = switchDiagramFilterSpec.hosts[0];
            hostConstraint.targetType = QueryUtil.getReferenceType((Object)hostConstraint.target);
            RelationalConstraint rc = new RelationalConstraint();
            rc.constraintOnRelatedObject = hostConstraint;
            rc.targetType = VirtualMachine.class.getSimpleName();
            rc.relation = "vm";
            rc.hasInverseRelation = true;
            CompositeConstraint finalConstraint = new CompositeConstraint();
            finalConstraint.conjoiner = Conjoiner.AND;
            finalConstraint.targetType = VirtualMachine.class.getSimpleName();
            Constraint[] constraints = new Constraint[]{cc, rc};
            finalConstraint.nestedConstraints = constraints;
            resultSpec = QueryUtil.buildQuerySpec((Constraint)finalConstraint, (String[])SWITCH_DIAGRAM_VM_PROPERTIES);
        }
        return resultSpec;
    }

    private QuerySpec getNonUplinkPortgroupsQuerySpec(ManagedObjectReference dvsRef, SwitchDiagramFilterSpec switchDiagramFilterSpec) {
        QuerySpec portgroupPropertiesQuerySpec = null;
        if (switchDiagramFilterSpec.vms != null) {
            Constraint[] nestedConstraints = new Constraint[switchDiagramFilterSpec.vms.length];
            for (int i = 0; i < switchDiagramFilterSpec.vms.length; ++i) {
                ManagedObjectReference vmRef = switchDiagramFilterSpec.vms[i];
                nestedConstraints[i] = QueryUtil.createConstraintForRelationship((Object)vmRef, (String)VM_DVPORTGROUP_RELATION, (String)DistributedVirtualPortgroup.class.getSimpleName());
            }
            Constraint vmNetworksConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])nestedConstraints, (Conjoiner)Conjoiner.OR);
            Constraint dvsPortgroupsConstraint = QueryUtil.createConstraintForRelationship((Object)dvsRef, (String)PORTGROUP_RELATION, (String)DistributedVirtualPortgroup.class.getSimpleName());
            Constraint compositeConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{vmNetworksConstraint, dvsPortgroupsConstraint}, (Conjoiner)Conjoiner.AND);
            portgroupPropertiesQuerySpec = QueryUtil.buildQuerySpec((Constraint)compositeConstraint, (String[])SWITCH_DIAGRAM_PORTGROUP_PROPERTIES);
        } else if (switchDiagramFilterSpec.numberOfPortGroups > 0) {
            Constraint nonUplinkPortgroupConstraint = null;
            if (switchDiagramFilterSpec.includeOnlyNonEmptyPortgroups && !ArrayUtil.isNullOrEmpty((Object[])switchDiagramFilterSpec.hosts)) {
                nonUplinkPortgroupConstraint = this.createNonEmptyNonUplinkPortGroupsConstraint(dvsRef, switchDiagramFilterSpec.hosts);
            } else {
                Constraint[] nestedConstraints = new Constraint[]{QueryUtil.createConstraintForRelationship((Object)dvsRef, (String)PORTGROUP_RELATION, (String)DistributedVirtualPortgroup.class.getSimpleName()), QueryUtil.createConstraintForRelationship((Object)dvsRef, (String)DVS_UPLINK_PORTGROUP_PROPERTY, (String)DistributedVirtualPortgroup.class.getSimpleName())};
                nonUplinkPortgroupConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])nestedConstraints, (Conjoiner)Conjoiner.EXCEPT);
            }
            portgroupPropertiesQuerySpec = switchDiagramFilterSpec.includeOnlyVmsData ? QueryUtil.buildQuerySpec((Constraint)nonUplinkPortgroupConstraint, (String[])new String[]{PORTGROUP_KEY_PROPERTY}) : QueryUtil.buildQuerySpec((Constraint)nonUplinkPortgroupConstraint, (String[])SWITCH_DIAGRAM_PORTGROUP_PROPERTIES);
            portgroupPropertiesQuerySpec.resultSpec = new ResultSpec();
            portgroupPropertiesQuerySpec.resultSpec.maxResultCount = switchDiagramFilterSpec.numberOfPortGroups;
            portgroupPropertiesQuerySpec.resultSpec.offset = 0;
            OrderingCriteria hostsOrderingCriteria = new OrderingCriteria();
            hostsOrderingCriteria.orderingProperties = new OrderingPropertySpec[1];
            hostsOrderingCriteria.orderingProperties[0] = new OrderingPropertySpec();
            hostsOrderingCriteria.orderingProperties[0].propertyNames = new String[]{"name"};
            hostsOrderingCriteria.orderingProperties[0].orderingType = SortType.ASCENDING;
            portgroupPropertiesQuerySpec.resultSpec.order = hostsOrderingCriteria;
        } else if (!ArrayUtil.isNullOrEmpty((Object[])switchDiagramFilterSpec.portGroups)) {
            portgroupPropertiesQuerySpec = switchDiagramFilterSpec.includeOnlyVmsData ? QueryUtil.buildQuerySpec((Object[])switchDiagramFilterSpec.portGroups, (String[])new String[]{PORTGROUP_KEY_PROPERTY}) : QueryUtil.buildQuerySpec((Object[])switchDiagramFilterSpec.portGroups, (String[])SWITCH_DIAGRAM_PORTGROUP_PROPERTIES);
        } else {
            _logger.error((Object)"getNonUplinkPortgroupsQuerySpec: Invalid switch diagram filter spec.");
            return null;
        }
        if (portgroupPropertiesQuerySpec != null) {
            portgroupPropertiesQuerySpec.name = SWITCH_DIAGRAM_PORTGROUP_PROPERTIES_QUERY_SPEC;
        }
        return portgroupPropertiesQuerySpec;
    }

    private QuerySpec getHostProperertiesQuerySpec(ManagedObjectReference dvsRef, SwitchDiagramFilterSpec switchDiagramFilterSpec) {
        QuerySpec hostPropertiesQuerySpec = null;
        if (switchDiagramFilterSpec.vms != null) {
            Constraint[] vmConstraints = new Constraint[switchDiagramFilterSpec.vms.length];
            for (int i = 0; i < switchDiagramFilterSpec.vms.length; ++i) {
                ManagedObjectReference vmRef = switchDiagramFilterSpec.vms[i];
                ObjectIdentityConstraint vmConstraint = QueryUtil.createObjectIdentityConstraint((Object)vmRef);
                vmConstraints[i] = vmConstraint;
            }
            Constraint compositeVmConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])vmConstraints, (Conjoiner)Conjoiner.OR);
            compositeVmConstraint.targetType = VirtualMachine.class.getSimpleName();
            RelationalConstraint compositeConstraint = QueryUtil.createRelationalConstraint((String)HOST_RELATION, (Constraint)compositeVmConstraint, (Boolean)true, (String)HostSystem.class.getSimpleName());
            hostPropertiesQuerySpec = QueryUtil.buildQuerySpec((Constraint)compositeConstraint, (String[])SWITCH_DIAGRAM_HOST_PROPERTIES);
        } else if (switchDiagramFilterSpec.numberOfHosts > 0) {
            Constraint hostConstraint = QueryUtil.createConstraintForRelationship((Object)dvsRef, (String)HOST_RELATION, (String)HostSystem.class.getSimpleName());
            hostPropertiesQuerySpec = switchDiagramFilterSpec.includeOnlyVmsData ? QueryUtil.buildQuerySpec((Constraint)hostConstraint, (String[])new String[0]) : QueryUtil.buildQuerySpec((Constraint)hostConstraint, (String[])SWITCH_DIAGRAM_HOST_PROPERTIES);
            hostPropertiesQuerySpec.resultSpec = new ResultSpec();
            hostPropertiesQuerySpec.resultSpec.maxResultCount = switchDiagramFilterSpec.numberOfHosts;
            hostPropertiesQuerySpec.resultSpec.offset = 0;
            OrderingCriteria hostsOrderingCriteria = new OrderingCriteria();
            hostsOrderingCriteria.orderingProperties = new OrderingPropertySpec[1];
            hostsOrderingCriteria.orderingProperties[0] = new OrderingPropertySpec();
            hostsOrderingCriteria.orderingProperties[0].propertyNames = new String[]{"name"};
            hostsOrderingCriteria.orderingProperties[0].orderingType = SortType.ASCENDING;
            hostPropertiesQuerySpec.resultSpec.order = hostsOrderingCriteria;
        } else if (!ArrayUtil.isNullOrEmpty((Object[])switchDiagramFilterSpec.hosts)) {
            hostPropertiesQuerySpec = switchDiagramFilterSpec.includeOnlyVmsData ? null : QueryUtil.buildQuerySpec((Object[])switchDiagramFilterSpec.hosts, (String[])SWITCH_DIAGRAM_HOST_PROPERTIES);
        } else {
            _logger.error((Object)"getHostProperertiesQuerySpec: Invalid switch diagram filter spec.");
            return null;
        }
        if (hostPropertiesQuerySpec != null) {
            hostPropertiesQuerySpec.name = SWITCH_DIAGRAM_HOST_PROPERTIES_QUERY_SPEC;
        }
        return hostPropertiesQuerySpec;
    }

    private QuerySpec getUplinkPortgroupPropertiesQuerySpec(ManagedObjectReference dvsRef) {
        Constraint uplinkPortgroupConstraint = QueryUtil.createConstraintForRelationship((Object)dvsRef, (String)DVS_UPLINK_PORTGROUP_PROPERTY, (String)DistributedVirtualPortgroup.class.getSimpleName());
        QuerySpec uplinkPortgroupPropertiesQuerySpec = QueryUtil.buildQuerySpec((Constraint)uplinkPortgroupConstraint, (String[])SWITCH_DIAGRAM_PORTGROUP_PROPERTIES);
        uplinkPortgroupPropertiesQuerySpec.name = SWITCH_DIAGRAM_UPLINK_PORTGROUP_PROPERTIES_QUERY_SPEC;
        return uplinkPortgroupPropertiesQuerySpec;
    }

    private QuerySpec getDvsPropertiesQuerySpec(ManagedObjectReference dvsRef) {
        return this.getDvsPropertiesQuerySpec(dvsRef, null);
    }

    private QuerySpec getDvsPropertiesQuerySpec(ManagedObjectReference dvsRef, SwitchDiagramFilterSpec switchDiagramFilterSpec) {
        QuerySpec dvsPropertiesQuerySpec = switchDiagramFilterSpec == null || !switchDiagramFilterSpec.includeOnlyVmsData ? QueryUtil.buildQuerySpec((Object)dvsRef, (String[])SWITCH_DIAGRAM_DVS_PROPERTIES) : QueryUtil.buildQuerySpec((Object)dvsRef, (String[])new String[]{DVS_UUID_PROPERTY});
        dvsPropertiesQuerySpec.name = SWITCH_DIAGRAM_DVS_PROPERTIES_QUERY_SPEC;
        return dvsPropertiesQuerySpec;
    }

    private ResultSet findResultByQueryName(ResultSet[] resultSets, String queryName) {
        if (resultSets != null) {
            for (ResultSet rs : resultSets) {
                if (rs == null || rs.queryName == null || !rs.queryName.equals(queryName)) continue;
                return rs;
            }
        }
        return null;
    }

    private String[] getPortgroupKeys(ResultSet[] resultSets, ManagedObjectReference[] portgroupFilterRef) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<ManagedObjectReference> portgroupFilterRefSet = new HashSet<ManagedObjectReference>();
        if (portgroupFilterRef != null) {
            portgroupFilterRefSet.addAll(Arrays.asList(portgroupFilterRef));
        }
        for (ResultSet rs : resultSets) {
            if (!rs.queryName.equals(SWITCH_DIAGRAM_PORTGROUP_PROPERTIES_QUERY_SPEC) || ArrayUtil.isNullOrEmpty((Object[])rs.items)) continue;
            for (ResultItem ri : rs.items) {
                if (ri == null || ArrayUtil.isNullOrEmpty((Object[])ri.properties) || portgroupFilterRef != null && !portgroupFilterRefSet.contains(ri.resourceObject)) continue;
                for (PropertyValue pv : ri.properties) {
                    if (!Util.checkPropertyValueNameType(pv, PORTGROUP_KEY_PROPERTY, String.class)) continue;
                    result.add((String)pv.value);
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] getVmPortKeys(ResultSet[] resultSets) {
        HashSet<String> portKeys = new HashSet<String>();
        String dvsUuid = this.getDvsUuid(resultSets);
        for (ResultSet rs : resultSets) {
            if (!rs.queryName.equals(SWITCH_DIAGRAM_VM_PROPERTIES_QUERY_SPEC) || ArrayUtil.isNullOrEmpty((Object[])rs.items)) continue;
            for (ResultItem ri : rs.items) {
                if (ri.properties == null) continue;
                for (PropertyValue pv : ri.properties) {
                    if (!Util.checkPropertyValueNameType(pv, VM_DEVICE_PROPERTY, VirtualDevice[].class)) continue;
                    VirtualDevice[] virtualDeviceArray = (VirtualDevice[])pv.value;
                    pv.value = this.getEthernetCards(virtualDeviceArray, dvsUuid);
                    for (VirtualDevice vd : (VirtualDevice[])pv.value) {
                        if (!(vd instanceof VirtualEthernetCard)) continue;
                        VirtualEthernetCard vec = (VirtualEthernetCard)vd;
                        if (vec.backing == null || !(vec.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo)) continue;
                        VirtualEthernetCard.DistributedVirtualPortBackingInfo dvpbi = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)vec.backing;
                        if (dvpbi.port == null || dvpbi.port.portKey == null || dvpbi.port.switchUuid == null || !dvpbi.port.switchUuid.equals(dvsUuid)) continue;
                        portKeys.add(dvpbi.port.portKey);
                    }
                }
            }
            break;
        }
        return portKeys.toArray(new String[portKeys.size()]);
    }

    private String[] getVnicPortKeys(ResultSet[] resultSets, String[] portgroupKeysFilter) {
        HashSet<String> portKeySet = new HashSet<String>();
        String dvsUuid = this.getDvsUuid(resultSets);
        if (StringUtil.isNullOrEmpty((String)dvsUuid)) {
            return null;
        }
        HashSet<String> portgroupKeyFilterSet = new HashSet<String>();
        if (portgroupKeysFilter != null) {
            portgroupKeyFilterSet.addAll(Arrays.asList(portgroupKeysFilter));
        }
        for (ResultSet rs : resultSets) {
            if (!rs.queryName.equals(SWITCH_DIAGRAM_HOST_PROPERTIES_QUERY_SPEC) || ArrayUtil.isNullOrEmpty((Object[])rs.items)) continue;
            for (ResultItem ri : rs.items) {
                if (ri == null || ri.properties == null) continue;
                for (PropertyValue pv : ri.properties) {
                    VirtualNic[] vnics;
                    NetworkInfo networkInfo;
                    if (!Util.checkPropertyValueNameType(pv, HOST_NETWORK_PROPERTY, NetworkInfo.class) || (networkInfo = (NetworkInfo)pv.value) == null || (vnics = (VirtualNic[])ArrayUtils.addAll((Object[])networkInfo.vnic, (Object[])networkInfo.consoleVnic)) == null) continue;
                    for (VirtualNic vnic : vnics) {
                        if (vnic.spec == null || vnic.spec.distributedVirtualPort == null) continue;
                        PortConnection portConnection = vnic.spec.distributedVirtualPort;
                        if (!dvsUuid.equals(portConnection.switchUuid) || !portgroupKeyFilterSet.contains(portConnection.portgroupKey)) continue;
                        portKeySet.add(portConnection.portKey);
                    }
                }
            }
        }
        return portKeySet.toArray(new String[portKeySet.size()]);
    }

    private String getDvsUuid(ResultSet[] resultSets) {
        for (ResultSet rs : resultSets) {
            if (!rs.queryName.equals(SWITCH_DIAGRAM_DVS_PROPERTIES_QUERY_SPEC) || ArrayUtil.isNullOrEmpty((Object[])rs.items)) continue;
            for (ResultItem ri : rs.items) {
                if (ri.properties == null) continue;
                for (PropertyValue pv : ri.properties) {
                    if (!Util.checkPropertyValueNameType(pv, DVS_UUID_PROPERTY, String.class)) continue;
                    return (String)pv.value;
                }
            }
            break;
        }
        return null;
    }

    private DistributedVirtualPort[] fetchConnectedNonUplinkPorts(DistributedVirtualSwitch dvs, String[] portgroupKeys) {
        if (ArrayUtils.isEmpty((Object[])portgroupKeys)) {
            return new DistributedVirtualPort[0];
        }
        PortCriteria pc = new PortCriteria();
        pc.connected = true;
        pc.inside = true;
        pc.portgroupKey = portgroupKeys;
        pc.uplinkPort = false;
        DistributedVirtualPort[] ports = null;
        try {
            ports = dvs.fetchPorts(pc);
        }
        catch (Exception e) {
            _logger.error((Object)("Fetching non-uplink connected ports failed: " + e.getMessage()));
        }
        return ports;
    }

    private DistributedVirtualPort[] fetchUplinkPorts(DistributedVirtualSwitch dvs) {
        PortCriteria pc = new PortCriteria();
        pc.uplinkPort = true;
        DistributedVirtualPort[] ports = null;
        try {
            ports = dvs.fetchPorts(pc);
        }
        catch (Exception e) {
            _logger.error((Object)("Fetching uplink ports failed: " + e.getMessage()));
        }
        return ports;
    }

    private DistributedVirtualPort[] fetchStandalonePorts(DistributedVirtualSwitch dvs) {
        PortCriteria pc = new PortCriteria();
        pc.inside = false;
        pc.uplinkPort = false;
        DistributedVirtualPort[] ports = null;
        try {
            ports = dvs.fetchPorts(pc);
        }
        catch (Exception e) {
            _logger.error((Object)("Fetching standalone ports failed: " + e.getMessage()));
        }
        return ports;
    }

    private DistributedVirtualPort[] fetchPortsByKey(DistributedVirtualSwitch dvs, String[] portKeys) {
        if (ArrayUtil.isNullOrEmpty((Object[])portKeys)) {
            return null;
        }
        PortCriteria pc = new PortCriteria();
        pc.portKey = portKeys;
        pc.connected = true;
        DistributedVirtualPort[] ports = null;
        try {
            ports = dvs.fetchPorts(pc);
        }
        catch (Exception e) {
            _logger.error((Object)("Fetching ports by port keys failed: " + e.getMessage()));
        }
        return ports;
    }

    private SwitchDiagramSpec createSwitchDiagramSpec(ManagedObjectReference dvsRef, ResultSet[] dvsProperties, ResultSet[] vmProperties, DistributedVirtualPort[] nonUplinkPorts, DistributedVirtualPort[] uplinkPorts, Map<String, ManagedObjectReference> countingQueryNameToPortgroupMap, SwitchDiagramFilterSpec switchDiagramFilterSpec) {
        SwitchDiagramSpec resultSpec = new SwitchDiagramSpec();
        resultSpec.dvsSpec = new SwitchDiagramDvsSpec();
        resultSpec.dvsSpec.provider = dvsRef;
        Set<ManagedObjectReference> hostSet = null;
        String dvsUuid = this.getDvsUuid(dvsProperties);
        for (ResultSet rs : dvsProperties) {
            if (SWITCH_DIAGRAM_DVS_PROPERTIES_QUERY_SPEC.equals(rs.queryName)) {
                this.populateDvsProperties(resultSpec.dvsSpec, rs);
                continue;
            }
            if (SWITCH_DIAGRAM_HOST_PROPERTIES_QUERY_SPEC.equals(rs.queryName)) {
                hostSet = this.populateHostProperties(resultSpec.dvsSpec, rs);
                continue;
            }
            if (SWITCH_DIAGRAM_PORTGROUP_PROPERTIES_QUERY_SPEC.equals(rs.queryName)) {
                this.populatePortgroupProperties(resultSpec.dvsSpec, rs, false);
                continue;
            }
            if (SWITCH_DIAGRAM_UPLINK_PORTGROUP_PROPERTIES_QUERY_SPEC.equals(rs.queryName)) {
                this.populatePortgroupProperties(resultSpec.dvsSpec, rs, true);
                continue;
            }
            if (!SWITCH_DIAGRAM_VM_PROPERTIES_QUERY_SPEC.equals(rs.queryName)) continue;
            this.populateVmProperties(resultSpec.dvsSpec, rs, dvsUuid);
        }
        if (hostSet == null && switchDiagramFilterSpec.includeOnlyVmsData && !ArrayUtil.isNullOrEmpty((Object[])switchDiagramFilterSpec.hosts)) {
            hostSet = new HashSet<ManagedObjectReference>(Arrays.asList(switchDiagramFilterSpec.hosts));
        }
        this.populateDvsConfigTarget(resultSpec.dvsSpec);
        this.populateUplinkPorts(resultSpec, uplinkPorts, hostSet);
        this.populateNonUplinkPorts(resultSpec, nonUplinkPorts, hostSet);
        this.populateVmProperties(resultSpec.dvsSpec, vmProperties, dvsUuid);
        this.populateVmCounts(resultSpec.dvsSpec, vmProperties, countingQueryNameToPortgroupMap);
        resultSpec.includesOnlyVmsData = switchDiagramFilterSpec.includeOnlyVmsData;
        return resultSpec;
    }

    private void populateDvsConfigTarget(SwitchDiagramDvsSpec dvsSpec) {
        if (dvsSpec == null || dvsSpec.hosts == null) {
            return;
        }
        DistributedVirtualSwitchManager.DvsConfigTarget dvsConfigTarget = new DistributedVirtualSwitchManager.DvsConfigTarget();
        String dvsName = dvsSpec.config == null ? null : dvsSpec.config.name;
        String dvsUuid = dvsSpec.config == null ? null : dvsSpec.config.uuid;
        dvsConfigTarget.distributedVirtualSwitch = new DistributedVirtualSwitchInfo[]{new DistributedVirtualSwitchInfo(dvsName, dvsUuid, dvsSpec.provider, null)};
        if (dvsSpec.portgroups != null) {
            dvsConfigTarget.distributedVirtualPortgroup = new DistributedVirtualPortgroupInfo[dvsSpec.portgroups.length];
            for (int i = 0; i < dvsSpec.portgroups.length; ++i) {
                DistributedVirtualPortgroupInfo pgInfo;
                SwitchDiagramPortgroupSpec pgSpec = dvsSpec.portgroups[i];
                String pgName = StringUtil.isNullOrEmpty((String)pgSpec.name) ? null : pgSpec.name;
                String pgType = StringUtil.isNullOrEmpty((String)pgSpec.type) ? null : pgSpec.type;
                dvsConfigTarget.distributedVirtualPortgroup[i] = pgInfo = new DistributedVirtualPortgroupInfo(dvsName, dvsUuid, pgName, pgSpec.key, pgType, false, pgSpec.provider, null);
            }
        }
        for (SwitchDiagramHostSpec spec : dvsSpec.hosts) {
            spec.dvsConfigTarget = dvsConfigTarget;
        }
    }

    private Constraint createNonEmptyNonUplinkPortGroupsConstraint(ManagedObjectReference dvsRef, ManagedObjectReference[] hosts) {
        if (dvsRef == null || hosts == null) {
            return null;
        }
        ObjectIdentityConstraint[] hostConstraints = new ObjectIdentityConstraint[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            ManagedObjectReference hostRef = hosts[i];
            ObjectIdentityConstraint hostOic = new ObjectIdentityConstraint();
            hostOic.target = hostRef;
            hostOic.targetType = HostSystem.class.getSimpleName();
            hostConstraints[i] = hostOic;
        }
        CompositeConstraint hostsConstraint = QueryUtil.createCompositeConstraint((Constraint[])hostConstraints, (Conjoiner)Conjoiner.OR);
        hostsConstraint.targetType = HostSystem.class.getSimpleName();
        RelationalConstraint hostVmsConstraint = QueryUtil.createRelationalConstraint((String)"vm", (Constraint)hostsConstraint, (Boolean)true, (String)VirtualMachine.class.getSimpleName());
        RelationalConstraint vmPortGroupsConstraint = QueryUtil.createRelationalConstraint((String)VM_DVPORTGROUP_RELATION, (Constraint)hostVmsConstraint, (Boolean)true, (String)DistributedVirtualPortgroup.class.getSimpleName());
        ObjectIdentityConstraint dvsOic = new ObjectIdentityConstraint();
        dvsOic.target = dvsRef;
        RelationalConstraint dvsPortGroups = QueryUtil.createRelationalConstraint((String)PORTGROUP_RELATION, (Constraint)dvsOic, (Boolean)true, (String)DistributedVirtualPortgroup.class.getSimpleName());
        RelationalConstraint hostServicePortGroups = QueryUtil.createRelationalConstraint((String)"serviceDvpg", (Constraint)hostsConstraint, (Boolean)true, (String)DistributedVirtualPortgroup.class.getSimpleName());
        CompositeConstraint nonEmptyPgsConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{hostServicePortGroups, vmPortGroupsConstraint}, (Conjoiner)Conjoiner.OR);
        CompositeConstraint nonEmptyPgsInDvsConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{nonEmptyPgsConstraint, dvsPortGroups}, (Conjoiner)Conjoiner.AND);
        return nonEmptyPgsInDvsConstraint;
    }

    private void populateUplinkPorts(SwitchDiagramSpec switchDiagramSpec, DistributedVirtualPort[] uplinkPorts, Set<ManagedObjectReference> hostSet) {
        if (uplinkPorts == null || hostSet == null) {
            return;
        }
        ArrayList<DistributedVirtualPort> resultPorts = new ArrayList<DistributedVirtualPort>();
        for (DistributedVirtualPort dvPort : uplinkPorts) {
            if (!hostSet.contains(dvPort.proxyHost)) continue;
            resultPorts.add(dvPort);
        }
        switchDiagramSpec.uplinkPorts = resultPorts.toArray(new DistributedVirtualPort[resultPorts.size()]);
    }

    private void populateNonUplinkPorts(SwitchDiagramSpec switchDiagramSpec, DistributedVirtualPort[] nonUplinkPorts, Set<ManagedObjectReference> hostSet) {
        if (nonUplinkPorts == null || hostSet == null) {
            return;
        }
        ArrayList<DistributedVirtualPort> resultPorts = new ArrayList<DistributedVirtualPort>();
        for (DistributedVirtualPort dvPort : nonUplinkPorts) {
            if (!hostSet.contains(dvPort.proxyHost)) continue;
            resultPorts.add(dvPort);
        }
        switchDiagramSpec.nonUplinkPorts = resultPorts.toArray(new DistributedVirtualPort[resultPorts.size()]);
    }

    private void populateVmProperties(SwitchDiagramDvsSpec dvsSpec, ResultSet[] vmProperties, String dvsUuid) {
        if (vmProperties == null) {
            return;
        }
        HashMap<ManagedObjectReference, SwitchDiagramVmSpec> vmSpecsMap = new HashMap<ManagedObjectReference, SwitchDiagramVmSpec>();
        for (ResultSet result : vmProperties) {
            for (ResultItem item : result.items) {
                for (PropertyValue pv : item.properties) {
                    ManagedObjectReference vmRef = (ManagedObjectReference)pv.resourceObject;
                    SwitchDiagramVmSpec vmSpec = (SwitchDiagramVmSpec)((Object)vmSpecsMap.get(vmRef));
                    if (vmSpec == null) {
                        vmSpec = new SwitchDiagramVmSpec();
                        vmSpec.provider = vmRef;
                        vmSpecsMap.put(vmRef, vmSpec);
                    }
                    this.populateVmProperty(vmSpec, pv, dvsUuid);
                }
            }
        }
        Collection values = vmSpecsMap.values();
        dvsSpec.vms = values.toArray(new SwitchDiagramVmSpec[values.size()]);
    }

    private void populateVmProperty(SwitchDiagramVmSpec vmSpec, PropertyValue pv, String dvsUuid) {
        if (Util.checkPropertyValueNameType(pv, "name", String.class)) {
            vmSpec.name = (String)pv.value;
        } else if (Util.checkPropertyValueNameType(pv, VM_DEVICE_PROPERTY, VirtualDevice[].class)) {
            vmSpec.devices = this.getEthernetCards((VirtualDevice[])pv.value, dvsUuid);
        } else if (Util.checkPropertyValueNameType(pv, VM_CONNECTION_STATE_PROPERTY, VirtualMachine.ConnectionState.class)) {
            vmSpec.connectionState = (VirtualMachine.ConnectionState)pv.value;
        } else if (Util.checkPropertyValueNameType(pv, VM_FT_INFO_PROPERTY, FaultToleranceConfigInfo.class)) {
            vmSpec.ftInfo = (FaultToleranceConfigInfo)pv.value;
        } else if (Util.checkPropertyValueNameType(pv, VM_POWER_STATE_PROPERTY, VirtualMachine.PowerState.class)) {
            vmSpec.powerState = (VirtualMachine.PowerState)pv.value;
        } else if (Util.checkPropertyValueNameType(pv, VM_HOST_PROPERTY, ManagedObjectReference.class)) {
            vmSpec.host = (ManagedObjectReference)pv.value;
        }
    }

    private void populateVmProperties(SwitchDiagramDvsSpec dvsSpec, ResultSet resultSet, String dvsUuid) {
        if (resultSet == null) {
            return;
        }
        ArrayList<SwitchDiagramVmSpec> vmSpecs = new ArrayList<SwitchDiagramVmSpec>();
        if (!ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
            for (ResultItem ri : resultSet.items) {
                if (ri == null || ri.resourceObject == null || !(ri.resourceObject instanceof ManagedObjectReference)) continue;
                SwitchDiagramVmSpec vmSpec = new SwitchDiagramVmSpec();
                vmSpec.provider = (ManagedObjectReference)ri.resourceObject;
                vmSpecs.add(vmSpec);
                if (ArrayUtil.isNullOrEmpty((Object[])ri.properties)) continue;
                for (PropertyValue pv : ri.properties) {
                    this.populateVmProperty(vmSpec, pv, dvsUuid);
                }
            }
        }
        dvsSpec.vms = vmSpecs.toArray(new SwitchDiagramVmSpec[vmSpecs.size()]);
    }

    private void populateVmCounts(SwitchDiagramDvsSpec dvsSpec, ResultSet[] vmProperties, Map<String, ManagedObjectReference> queryNameToPortgroupMap) {
        if (vmProperties == null || queryNameToPortgroupMap == null) {
            return;
        }
        HashMap<ManagedObjectReference, Integer> portgroupVmsCountMap = new HashMap<ManagedObjectReference, Integer>();
        int standaloneVmsCount = 0;
        for (ResultSet resultSet : vmProperties) {
            if (resultSet.queryName == null) continue;
            if (resultSet.queryName.contains(SWITCH_DIAGRAM_PG_VM_COUNTS_QUERY_SPEC)) {
                ManagedObjectReference portGroup = queryNameToPortgroupMap.get(resultSet.queryName);
                portgroupVmsCountMap.put(portGroup, resultSet.totalMatchedObjectCount);
                continue;
            }
            if (!resultSet.queryName.contains(SWITCH_DIAGRAM_SA_VM_COUNTS_QUERY_SPEC)) continue;
            standaloneVmsCount += resultSet.totalMatchedObjectCount.intValue();
        }
        if (dvsSpec.portgroups != null) {
            for (SwitchDiagramPortgroupSpec switchDiagramPortgroupSpec : dvsSpec.portgroups) {
                if (!portgroupVmsCountMap.containsKey(switchDiagramPortgroupSpec.provider)) continue;
                switchDiagramPortgroupSpec.vmsCount = (Integer)portgroupVmsCountMap.get(switchDiagramPortgroupSpec.provider);
            }
        }
        dvsSpec.standaloneVmsCount = standaloneVmsCount;
    }

    private VirtualDevice[] getEthernetCards(VirtualDevice[] virtualDeviceArray, String dvsUuid) {
        ArrayList<VirtualDevice> virtualEthernetCards = new ArrayList<VirtualDevice>();
        if (virtualDeviceArray != null) {
            for (VirtualDevice vd : virtualDeviceArray) {
                if (!(vd instanceof VirtualEthernetCard)) continue;
                VirtualEthernetCard vec = (VirtualEthernetCard)vd;
                if (!(vec.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo)) continue;
                VirtualEthernetCard.DistributedVirtualPortBackingInfo dvpbi = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)vec.backing;
                if (dvpbi.port == null || dvpbi.port.switchUuid == null || !dvpbi.port.switchUuid.equals(dvsUuid)) continue;
                virtualEthernetCards.add(vd);
            }
        }
        return (VirtualDevice[])virtualEthernetCards.toArray(new VirtualEthernetCard[virtualEthernetCards.size()]);
    }

    private void populatePortgroupProperties(SwitchDiagramDvsSpec dvsSpec, ResultSet portgroupProperties, Boolean isUplink) {
        ArrayList<SwitchDiagramPortgroupSpec> portgroupSpecList = new ArrayList<SwitchDiagramPortgroupSpec>();
        if (portgroupProperties != null && !ArrayUtil.isNullOrEmpty((Object[])portgroupProperties.items)) {
            for (int i = 0; i < portgroupProperties.items.length; ++i) {
                ResultItem ri = portgroupProperties.items[i];
                if (ri == null || ri.properties == null || ri.properties.length <= 1 || !(ri.resourceObject instanceof ManagedObjectReference)) continue;
                SwitchDiagramPortgroupSpec spgSpec = new SwitchDiagramPortgroupSpec();
                portgroupSpecList.add(spgSpec);
                spgSpec.provider = (ManagedObjectReference)ri.resourceObject;
                for (PropertyValue pv : ri.properties) {
                    if (Util.checkPropertyValueNameType(pv, PORTGROUP_NAME_PROPERTY, String.class)) {
                        spgSpec.name = (String)pv.value;
                        continue;
                    }
                    if (Util.checkPropertyValueNameType(pv, PORTGROUP_KEY_PROPERTY, String.class)) {
                        spgSpec.key = (String)pv.value;
                        continue;
                    }
                    if (Util.checkPropertyValueNameType(pv, PORTGROUP_TYPE_PROPERTY, String.class)) {
                        spgSpec.type = (String)pv.value;
                        continue;
                    }
                    if (Util.checkPropertyValueNameType(pv, PORTGROUP_NUM_PORTS_PROPERTY, Integer.class)) {
                        spgSpec.numPorts = (Integer)pv.value;
                        continue;
                    }
                    if (Util.checkPropertyValueNameType(pv, PORTGROUP_VLAN_PROPERTY, VmwareDistributedVirtualSwitch.VlanSpec.class)) {
                        spgSpec.vlan = (VmwareDistributedVirtualSwitch.VlanSpec)pv.value;
                        continue;
                    }
                    if (Util.checkPropertyValueNameType(pv, PORTGROUP_UPLINK_ORDER_PROPERTY, VmwareDistributedVirtualSwitch.UplinkPortOrderPolicy.class)) {
                        spgSpec.uplinkPortOrder = (VmwareDistributedVirtualSwitch.UplinkPortOrderPolicy)pv.value;
                        continue;
                    }
                    _logger.warn((Object)("Unexpected property returned: " + pv.propertyName));
                }
            }
        }
        SwitchDiagramPortgroupSpec[] portgroupSpecs = portgroupSpecList.toArray(new SwitchDiagramPortgroupSpec[portgroupSpecList.size()]);
        if (isUplink.booleanValue()) {
            dvsSpec.uplinkPortgroups = portgroupSpecs;
        } else {
            dvsSpec.portgroups = portgroupSpecs;
        }
    }

    private Set<ManagedObjectReference> populateHostProperties(SwitchDiagramDvsSpec dvsSpec, ResultSet hostProperties) {
        HashSet<ManagedObjectReference> hostSet = new HashSet<ManagedObjectReference>();
        ArrayList<SwitchDiagramHostSpec> hostSpecList = new ArrayList<SwitchDiagramHostSpec>();
        if (hostProperties != null && !ArrayUtil.isNullOrEmpty((Object[])hostProperties.items)) {
            for (int i = 0; i < hostProperties.items.length; ++i) {
                ResultItem ri = hostProperties.items[i];
                if (ri == null) continue;
                ManagedObjectReference hostRef = null;
                if (ri.resourceObject == null || !(ri.resourceObject instanceof ManagedObjectReference)) continue;
                hostRef = (ManagedObjectReference)ri.resourceObject;
                hostSet.add(hostRef);
                if (ArrayUtil.isNullOrEmpty((Object[])ri.properties)) continue;
                SwitchDiagramHostSpec switchDiagramHostSpec = new SwitchDiagramHostSpec();
                hostSpecList.add(switchDiagramHostSpec);
                switchDiagramHostSpec.provider = hostRef;
                for (PropertyValue pv : ri.properties) {
                    if (Util.checkPropertyValueNameType(pv, "name", String.class)) {
                        switchDiagramHostSpec.name = (String)pv.value;
                        continue;
                    }
                    if (Util.checkPropertyValueNameType(pv, HOST_NETWORK_PROPERTY, NetworkInfo.class)) {
                        switchDiagramHostSpec.network = (NetworkInfo)pv.value;
                        continue;
                    }
                    if (Util.checkPropertyValueNameType(pv, HOST_IPV6_SUPPORTED, Boolean.class)) {
                        switchDiagramHostSpec.ipV6Supported = (Boolean)pv.value;
                        continue;
                    }
                    if (Util.checkPropertyValueNameType(pv, HOST_PCI_DEVICE, PciDevice[].class)) {
                        switchDiagramHostSpec.pciDevice = (PciDevice[])pv.value;
                        continue;
                    }
                    if (Util.checkPropertyValueNameType(pv, HOST_PCI_PASSTHRU_INFO, PciPassthruInfo[].class)) {
                        switchDiagramHostSpec.sriov = this.filterSriovInfo((PciPassthruInfo[])pv.value);
                        continue;
                    }
                    if (Util.checkPropertyValueNameType(pv, HOST_VNIC_MANAGER_INFO, VirtualNicManagerInfo.class)) {
                        switchDiagramHostSpec.vnicManagerInfo = (VirtualNicManagerInfo)pv.value;
                        continue;
                    }
                    if (Util.checkPropertyValueNameType(pv, HOST_CONFIG_PRODUCT, AboutInfo.class)) {
                        switchDiagramHostSpec.product = (AboutInfo)pv.value;
                        continue;
                    }
                    if (!Util.checkPropertyValueNameType(pv, HOST_SUPPORTS_VLAN, Boolean.class)) continue;
                    switchDiagramHostSpec.supportsVlan = (Boolean)pv.value;
                }
            }
        }
        dvsSpec.hosts = hostSpecList.toArray(new SwitchDiagramHostSpec[hostSpecList.size()]);
        return hostSet;
    }

    private void populateDvsProperties(SwitchDiagramDvsSpec dvsSpec, ResultSet dvsPropertiesResultSet) {
        ResultItem ri;
        if (dvsPropertiesResultSet != null && !ArrayUtil.isNullOrEmpty((Object[])dvsPropertiesResultSet.items) && (ri = dvsPropertiesResultSet.items[0]) != null && !ArrayUtil.isNullOrEmpty((Object[])ri.properties)) {
            for (PropertyValue pv : ri.properties) {
                if (Util.checkPropertyValueNameType(pv, DVS_CONFIG_PROPERTY, DistributedVirtualSwitch.ConfigInfo.class)) {
                    dvsSpec.config = (DistributedVirtualSwitch.ConfigInfo)pv.value;
                    continue;
                }
                if (Util.checkPropertyValueNameType(pv, DVS_CAPABILITY_PROPERTY, DistributedVirtualSwitch.Capability.class)) {
                    dvsSpec.capability = (DistributedVirtualSwitch.Capability)pv.value;
                    continue;
                }
                if (Util.checkPropertyValueNameType(pv, DVS_RES_CONTROL_VERSION_PROPERTY, Integer.class)) {
                    dvsSpec.networkResourceManagementVersion = (Integer)pv.value;
                    continue;
                }
                if (Util.checkPropertyValueNameType(pv, DVS_LACP_API_VERSION_PROPERTY, String.class)) {
                    dvsSpec.lacpApiVersion = (String)pv.value;
                    continue;
                }
                if (Util.checkPropertyValueNameType(pv, DVS_PRODUCT_INFO_PROPERTY, ProductSpec.class)) {
                    dvsSpec.productInfo = (ProductSpec)pv.value;
                    continue;
                }
                if (Util.checkPropertyValueNameType(pv, DVS_PORTGROUPS_COUNT_PROPERTY, Integer.class)) {
                    dvsSpec.totalNumberOfPortgroups = (Integer)pv.value;
                    continue;
                }
                if (Util.checkPropertyValueNameType(pv, DVS_HOSTS_COUNT_PROPERTY, Integer.class)) {
                    dvsSpec.totalNumberOfHosts = (Integer)pv.value;
                    continue;
                }
                if (!Util.checkPropertyValueNameType(pv, DVS_VMS_COUNT_PROPERTY, Integer.class)) continue;
                dvsSpec.totalNumberOfVms = (Integer)pv.value;
            }
            if (dvsSpec.config != null && dvsSpec.config.uplinkPortgroup != null) {
                dvsSpec.totalNumberOfPortgroups -= dvsSpec.config.uplinkPortgroup.length;
            }
        }
    }

    private SriovInfo[] filterSriovInfo(PciPassthruInfo[] pciPassthruList) {
        ArrayList<SriovInfo> sriovList = new ArrayList<SriovInfo>();
        if (pciPassthruList == null) {
            return null;
        }
        for (PciPassthruInfo pci : pciPassthruList) {
            if (!(pci instanceof SriovInfo)) continue;
            sriovList.add((SriovInfo)pci);
        }
        return sriovList.toArray(new SriovInfo[sriovList.size()]);
    }

    private ManagedObjectReference[] getFilteredHostRefs(ManagedObjectReference[] retrievedPortgroupRefs, SwitchDiagramFilterSpec switchDiagramFilterSpec) {
        if (ArrayUtil.isNullOrEmpty((Object[])switchDiagramFilterSpec.hosts)) {
            return retrievedPortgroupRefs;
        }
        return switchDiagramFilterSpec.hosts;
    }

    private ManagedObjectReference[] getFilteredPortgroupRefsForVMCounting(ManagedObjectReference[] retrievedPortgroupRefs, SwitchDiagramFilterSpec switchDiagramFilterSpec) {
        return this.getFilteredPortgroupRefs(retrievedPortgroupRefs, switchDiagramFilterSpec, false);
    }

    private ManagedObjectReference[] getFilteredPortgroupRefsForVMLoading(ManagedObjectReference[] retrievedPortgroupRefs, SwitchDiagramFilterSpec switchDiagramFilterSpec) {
        return this.getFilteredPortgroupRefs(retrievedPortgroupRefs, switchDiagramFilterSpec, true);
    }

    private ManagedObjectReference[] getFilteredPortgroupRefs(ManagedObjectReference[] retrievedPortgroupRefs, SwitchDiagramFilterSpec switchDiagramFilterSpec, boolean forLoading) {
        HashSet<ManagedObjectReference> portgroupForVMLoadingRefSet = new HashSet<ManagedObjectReference>();
        if (!ArrayUtil.isNullOrEmpty((Object[])switchDiagramFilterSpec.portgroupsForVmLoading)) {
            portgroupForVMLoadingRefSet.addAll(Arrays.asList(switchDiagramFilterSpec.portgroupsForVmLoading));
        }
        ManagedObjectReference[] availPortgroupRefs = !ArrayUtil.isNullOrEmpty((Object[])switchDiagramFilterSpec.portGroups) ? switchDiagramFilterSpec.portGroups : retrievedPortgroupRefs;
        ArrayList<ManagedObjectReference> filteredPortgroupRefList = new ArrayList<ManagedObjectReference>();
        for (ManagedObjectReference availPortgroupRef : availPortgroupRefs) {
            boolean includePortgroup;
            boolean bl = includePortgroup = !(forLoading ^ portgroupForVMLoadingRefSet.contains(availPortgroupRef));
            if (!includePortgroup) continue;
            filteredPortgroupRefList.add(availPortgroupRef);
        }
        return filteredPortgroupRefList.toArray(new ManagedObjectReference[filteredPortgroupRefList.size()]);
    }

    private ManagedObjectReference[] getRetrievedPortgroupRefs(Response response) {
        if (response == null || response.resultSet == null) {
            return null;
        }
        ArrayList<ManagedObjectReference> refList = new ArrayList<ManagedObjectReference>();
        for (ResultSet rs : response.resultSet) {
            if (!SWITCH_DIAGRAM_PORTGROUP_PROPERTIES_QUERY_SPEC.equals(rs.queryName) || rs == null || ArrayUtil.isNullOrEmpty((Object[])rs.items)) continue;
            for (int i = 0; i < rs.items.length; ++i) {
                ResultItem ri = rs.items[i];
                if (ri == null || !(ri.resourceObject instanceof ManagedObjectReference)) continue;
                refList.add((ManagedObjectReference)ri.resourceObject);
            }
        }
        return refList.toArray(new ManagedObjectReference[refList.size()]);
    }

    private ManagedObjectReference[] getRetrievedHostRefs(Response response) {
        if (response == null || response.resultSet == null) {
            return null;
        }
        ArrayList<ManagedObjectReference> refList = new ArrayList<ManagedObjectReference>();
        for (ResultSet rs : response.resultSet) {
            if (!SWITCH_DIAGRAM_HOST_PROPERTIES_QUERY_SPEC.equals(rs.queryName) || rs == null || ArrayUtil.isNullOrEmpty((Object[])rs.items)) continue;
            for (int i = 0; i < rs.items.length; ++i) {
                ResultItem ri = rs.items[i];
                if (ri == null || !(ri.resourceObject instanceof ManagedObjectReference)) continue;
                refList.add((ManagedObjectReference)ri.resourceObject);
            }
        }
        return refList.toArray(new ManagedObjectReference[refList.size()]);
    }

    private QuerySpec[] getDPHQuerySpec(ManagedObjectReference dvsRef, SwitchDiagramFilterSpec switchDiagramFilterSpec) {
        QuerySpec nonUplinkPortgroupsQuerySpec;
        if (dvsRef == null) {
            throw new IllegalArgumentException("Required dvsRef parameter not provided");
        }
        if (switchDiagramFilterSpec == null) {
            throw new IllegalArgumentException("Required switchDiagramFilterSpec parameter not provided");
        }
        ArrayList<QuerySpec> dphQuerySpecs = new ArrayList<QuerySpec>();
        QuerySpec dvsPropertiesQuerySpec = this.getDvsPropertiesQuerySpec(dvsRef, switchDiagramFilterSpec);
        dphQuerySpecs.add(dvsPropertiesQuerySpec);
        QuerySpec hostPropertiesQuerySpec = this.getHostProperertiesQuerySpec(dvsRef, switchDiagramFilterSpec);
        if (hostPropertiesQuerySpec != null) {
            dphQuerySpecs.add(hostPropertiesQuerySpec);
        }
        if ((nonUplinkPortgroupsQuerySpec = this.getNonUplinkPortgroupsQuerySpec(dvsRef, switchDiagramFilterSpec)) != null) {
            dphQuerySpecs.add(nonUplinkPortgroupsQuerySpec);
        }
        if (!switchDiagramFilterSpec.includeOnlyVmsData) {
            QuerySpec uplinkPortgroupPropertiesQuerySPec = this.getUplinkPortgroupPropertiesQuerySpec(dvsRef);
            dphQuerySpecs.add(uplinkPortgroupPropertiesQuerySPec);
        }
        return dphQuerySpecs.toArray(new QuerySpec[dphQuerySpecs.size()]);
    }

    private QuerySpec[] getVmsCountAndDataQuerySpec(ManagedObjectReference[] hostRefs, ManagedObjectReference[] portgroupVMCountingRefs, ManagedObjectReference[] portgroupVMLoading, ManagedObjectReference[] standaloneVmRefs, SwitchDiagramFilterSpec switchDiagramFilterSpec, Map<String, ManagedObjectReference> queryNameToPortgroupMap) {
        if (hostRefs == null) {
            throw new IllegalArgumentException("Required hostRefs parameter is not provided.");
        }
        if (hostRefs.length > 70) {
            _logger.warn((Object)String.format("More (%d) than the recommended maximum of %d nested host identity constraints is provided. This may have adverse performance impact.", hostRefs.length, 70));
        }
        if (portgroupVMCountingRefs == null && portgroupVMLoading == null) {
            throw new IllegalArgumentException("Both portgroupVMCountingRefs and portgroupVMLoading parameters are not provided.At least one of them is required.");
        }
        if (portgroupVMCountingRefs != null && portgroupVMCountingRefs.length > 70) {
            _logger.warn((Object)String.format("More (%d) than the recommended maximum of %d nested portgroup identity constraints is provided. This may have adverse performance impact.", portgroupVMCountingRefs.length, 70));
        }
        if (portgroupVMLoading != null && portgroupVMLoading.length > 70) {
            _logger.warn((Object)String.format("More (%d) than the recommended maximum of %d nested portgroup identity constraints is provided. This may have adverse performance impact.", portgroupVMLoading.length, 70));
        }
        if (switchDiagramFilterSpec == null) {
            throw new IllegalArgumentException("Required switchDiagramFilterSpec parameter not provided");
        }
        if (queryNameToPortgroupMap == null) {
            throw new IllegalArgumentException("Required queryNameToPortgroupMap parameter not provided");
        }
        ArrayList<QuerySpec> querySpecList = new ArrayList<QuerySpec>();
        int queryId = 0;
        int i = 0;
        ObjectIdentityConstraint[] hostConstraint = new ObjectIdentityConstraint[hostRefs.length];
        for (ManagedObjectReference hostMor : hostRefs) {
            hostConstraint[i++] = QueryUtil.createObjectIdentityConstraint((Object)hostMor);
        }
        CompositeConstraint hostsConstraint = QueryUtil.createCompositeConstraint((Constraint[])hostConstraint, (Conjoiner)Conjoiner.OR);
        RelationalConstraint hostsVmsConstraint = QueryUtil.createRelationalConstraint((String)"vm", (Constraint)hostsConstraint, (Boolean)true, (String)VirtualMachine.class.getSimpleName());
        if (!switchDiagramFilterSpec.includeOnlyVmsData && !ArrayUtil.isNullOrEmpty((Object[])portgroupVMCountingRefs)) {
            for (ManagedObjectReference portgroupMor : portgroupVMCountingRefs) {
                ObjectIdentityConstraint portgroupConstraint = QueryUtil.createObjectIdentityConstraint((Object)portgroupMor);
                RelationalConstraint portgroupVmsConstraint = QueryUtil.createRelationalConstraint((String)"vm", (Constraint)portgroupConstraint, (Boolean)true, (String)VirtualMachine.class.getSimpleName());
                CompositeConstraint vmsIntersectionConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{portgroupVmsConstraint, hostsVmsConstraint}, (Conjoiner)Conjoiner.AND);
                vmsIntersectionConstraint.targetType = VirtualMachine.class.getSimpleName();
                QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)vmsIntersectionConstraint, (String[])new String[0]);
                querySpec.resultSpec = new ResultSpec();
                querySpec.resultSpec.maxResultCount = 0;
                querySpec.name = SWITCH_DIAGRAM_PG_VM_COUNTS_QUERY_SPEC + queryId++;
                querySpecList.add(querySpec);
                queryNameToPortgroupMap.put(querySpec.name, portgroupMor);
            }
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])portgroupVMLoading)) {
            ObjectIdentityConstraint[] portgroupConstraint = new ObjectIdentityConstraint[portgroupVMLoading.length];
            i = 0;
            for (ManagedObjectReference portgroupMor : portgroupVMLoading) {
                portgroupConstraint[i++] = QueryUtil.createObjectIdentityConstraint((Object)portgroupMor);
            }
            CompositeConstraint portgroupsConstraint = QueryUtil.createCompositeConstraint((Constraint[])portgroupConstraint, (Conjoiner)Conjoiner.OR);
            RelationalConstraint portgroupVmsConstraint = QueryUtil.createRelationalConstraint((String)"vm", (Constraint)portgroupsConstraint, (Boolean)true, (String)VirtualMachine.class.getSimpleName());
            CompositeConstraint vmsIntersectionConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{portgroupVmsConstraint, hostsVmsConstraint}, (Conjoiner)Conjoiner.AND);
            vmsIntersectionConstraint.targetType = VirtualMachine.class.getSimpleName();
            QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)vmsIntersectionConstraint, (String[])SWITCH_DIAGRAM_VM_PROPERTIES);
            querySpec.name = SWITCH_DIAGRAM_PG_VM_PROPS_QUERY_SPEC + queryId++;
            querySpecList.add(querySpec);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])standaloneVmRefs)) {
            int currentRefPos = 0;
            boolean hasChunk = true;
            while (hasChunk) {
                QuerySpec querySpec;
                int chunkSize = standaloneVmRefs.length - currentRefPos;
                if (chunkSize > 70) {
                    chunkSize = 70;
                } else {
                    hasChunk = false;
                }
                ObjectIdentityConstraint[] standaloneVmConstraint = new ObjectIdentityConstraint[chunkSize];
                int j = 0;
                while (j < chunkSize) {
                    standaloneVmConstraint[j] = QueryUtil.createObjectIdentityConstraint((Object)standaloneVmRefs[currentRefPos]);
                    ++j;
                    ++currentRefPos;
                }
                CompositeConstraint standaloneVmsConstraint = QueryUtil.createCompositeConstraint((Constraint[])standaloneVmConstraint, (Conjoiner)Conjoiner.OR);
                CompositeConstraint standaloneVmsIntersectionConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{standaloneVmsConstraint, hostsVmsConstraint}, (Conjoiner)Conjoiner.AND);
                standaloneVmsIntersectionConstraint.targetType = VirtualMachine.class.getSimpleName();
                if (!switchDiagramFilterSpec.includeStandaloneVmsData) {
                    querySpec = QueryUtil.buildQuerySpec((Constraint)standaloneVmsIntersectionConstraint, (String[])new String[0]);
                    querySpec.name = SWITCH_DIAGRAM_SA_VM_COUNTS_QUERY_SPEC + queryId++;
                    querySpecList.add(querySpec);
                    continue;
                }
                querySpec = QueryUtil.buildQuerySpec((Constraint)standaloneVmsIntersectionConstraint, (String[])SWITCH_DIAGRAM_VM_PROPERTIES);
                querySpec.name = SWITCH_DIAGRAM_SA_VM_PROPS_QUERY_SPEC + queryId++;
                querySpecList.add(querySpec);
            }
        }
        return querySpecList.toArray(new QuerySpec[querySpecList.size()]);
    }

    private void validateFilterSpec(SwitchDiagramFilterSpec switchDiagramFilterSpec, boolean onDemandVMLoading) {
        if (onDemandVMLoading) {
            if (!switchDiagramFilterSpec.includeOnlyVmsData || ArrayUtil.isNullOrEmpty((Object[])switchDiagramFilterSpec.portgroupsForVmLoading) && !switchDiagramFilterSpec.includeStandaloneVmsData) {
                _logger.warn((Object)"Invalid diagram filter specification. The specified parameters does not provide proper configuration for on-demand loading.");
            }
        } else if (!ArrayUtil.isNullOrEmpty((Object[])switchDiagramFilterSpec.portgroupsForVmLoading) || switchDiagramFilterSpec.includeOnlyVmsData) {
            _logger.warn((Object)"Invalid diagram filter specification. The specified parameters for VM on-demand loading are only applicable for port groups and hosts based filters. They will be ignored");
        }
    }

    private int getRetrievedStandalonePortsCount(Response response) {
        Integer standalonePortCount;
        ResultSet dvsProps = this.findResultByQueryName(response.resultSet, SWITCH_DIAGRAM_DVS_PROPERTIES_QUERY_SPEC);
        if (dvsProps != null && dvsProps.items != null && dvsProps.items.length == 1 && (standalonePortCount = (Integer)Util.getPropertyValue(dvsProps.items[0], DVS_STANDALONE_PORT_COUNT_PROPERTY)) != null) {
            return standalonePortCount;
        }
        return 0;
    }

    private ManagedObjectReference[] getPortConnectedEntityRefs(DistributedVirtualPort[] ports, Class<?> managedObjectType) {
        if (ports != null) {
            ArrayList<ManagedObjectReference> refsList = new ArrayList<ManagedObjectReference>(ports.length);
            for (DistributedVirtualPort port : ports) {
                if (port == null || port.connectee == null || port.connectee.connectedEntity == null) continue;
                if (managedObjectType != null) {
                    if (!managedObjectType.getSimpleName().equals(port.connectee.connectedEntity.getType())) continue;
                    refsList.add(port.connectee.connectedEntity);
                    continue;
                }
                refsList.add(port.connectee.connectedEntity);
            }
            return refsList.toArray(new ManagedObjectReference[refsList.size()]);
        }
        return null;
    }
}

