/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.messaging.amf.vim;

import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.AuthorizationDescription;
import com.vmware.vim.binding.vim.AuthorizationManager;
import com.vmware.vim.binding.vim.Description;
import com.vmware.vim.binding.vim.DiagnosticManager;
import com.vmware.vim.binding.vim.EVCMode;
import com.vmware.vim.binding.vim.ElementDescription;
import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.HistoricalInterval;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.LicenseManager;
import com.vmware.vim.binding.vim.PerformanceDescription;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.TaskDescription;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.alarm.AlarmDescription;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.cluster.DrsRecommendation;
import com.vmware.vim.binding.vim.cluster.Recommendation;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vim.binding.vim.host.HardwareStatusInfo;
import com.vmware.vim.binding.vim.host.NumericSensorInfo;
import com.vmware.vim.binding.vim.host.Ruleset;
import com.vmware.vim.binding.vim.host.Service;
import com.vmware.vim.binding.vim.host.SystemIdentificationInfo;
import com.vmware.vim.binding.vim.option.ChoiceOption;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskDescription;
import com.vmware.vim.binding.vim.vm.ConfigInfo;
import com.vmware.vim.binding.vim.vm.ConfigOption;
import com.vmware.vim.binding.vim.vm.ConfigOptionDescriptor;
import com.vmware.vim.binding.vim.vm.GuestInfo;
import com.vmware.vim.binding.vim.vm.GuestOsDescriptor;
import com.vmware.vim.binding.vim.vm.Message;
import com.vmware.vim.binding.vim.vm.QuestionInfo;
import com.vmware.vim.binding.vim.vm.Summary;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.messaging.amf.vim.I18nFilterProxyBase;
import com.vmware.vise.messaging.util.VmodlHelper;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import flex.messaging.io.BeanProxy;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18nFilterProxy
extends I18nFilterProxyBase {
    private static final String LM_FEATURE = "feature";
    private static final String LM_ADDON = "addon";
    private static final String LICENSE_INFO_PREFIX = "LicenseManager.LicenseInfo";
    private static final String RES_EVENT_NAME = "event.";
    private static final String RES_EVENTAUX_NAME = "eventaux.";
    private static final String RES_EVENT_CATEGORY = ".category";
    private static final String RES_EVENT_DESCRIPTION = ".description";
    private static final String RES_EVENT_LONGDESCRIPTION = ".longDescription";
    private static final String RES_EVENT_FULL = ".fullFormat";
    private static final String RES_EVENT_ONVM = ".formatOnVm";
    private static final String RES_EVENT_ONHOST = ".formatOnHost";
    private static final String RES_EVENT_ONCRES = ".formatOnComputeResource";
    private static final String RES_EVENT_ONDC = ".formatOnDatacenter";
    private static final String RES_EXTEVENT_NAME = "vim.event.ExtendedEvent";
    private static final String RES_EVENTEX_NAME = "vim.event.EventEx";
    private static final String RES_ABOUT_SHORTNAME = ".name";
    private static final String RES_ABOUT_FULLNAME = ".fullName";
    private static final String RES_ABOUT_VENDOR = ".vendor";
    private static final String RES_ABOUT_VERSION = ".localeVersion";
    private static final String RES_ABOUT_BUILD = ".localeBuild";
    private static final String RES_STASK_FREQ = ".frequency";
    private static final String RES_PERF_COUNTER = "counter.";
    private static final String RES_PERF_GROUP = "group.";
    private static final String RES_PERF_UNIT = "unit.";
    private static final String RES_PERF_HIST = "history.";
    private static final String RES_EXT = "extension.";
    private static final String RES_EXT_CLIENT = ".client.";
    private static final String RES_EXT_SERVER = ".server.";
    private static final String RES_DRS_RECCO = "reason.";
    private static final String RES_HOST_SERVICE = "ServiceInfo.";
    private static final String RES_HOST_FIREWALL = "FirewallInfo.";
    private static final String RES_VM_DEVICE = "device.";
    private static final String RES_VM_DEVICE_INFO_LABEL = "deviceInfo.label";
    private static final String RES_VM_QUESTION = "question";
    private static final String RES_VM_DEVGROUP = ".group";
    private static final String RES_VM_GUESTOS = "guestos.";
    private static final String RES_ANSWER_NAME = "Answer.";
    private static final String RES_BUTTON_NAME = "button.";
    private static final String RES_EVC_MODE = "Mode.";
    private static final String RES_ALARM_NAME = "alarm.";
    private static final String RES_AUTH_PRIV = "privilege.";
    private static final String RES_AUTH_ROLE = "role.";
    private static final String RES_LOC_MSG = "locmsg.";
    public static final String LF = "\n";
    static final long serialVersionUID = 8953762772682815676L;
    static Map<String, Method> methodMap = new HashMap<String, Method>();
    private static final Log _logger;

    public I18nFilterProxy() {
        this(null);
    }

    public I18nFilterProxy(Object object) {
        super(object);
    }

    public Object getInstanceToSerialize(Object object) {
        if (object == null) {
            return object;
        }
        Method method = this.getMethod(object);
        if (method == null) {
            return object;
        }
        try {
            method.invoke((Object)this, object);
        }
        catch (Exception exception) {
            Class<?> clazz = object.getClass();
            _logger.error((Object)("Failed to invoke process(" + clazz.getSimpleName() + ")"), (Throwable)exception);
        }
        return object;
    }

    public static Class<?>[] getSupportedTypes() {
        return new Class[]{AboutInfo.class, DiagnosticManager.LogDescriptor.class, ScheduledTaskDescription.class, PerformanceManager.CounterInfo.class, HistoricalInterval.class, Extension.class, SystemIdentificationInfo.class, NumericSensorInfo.class, HardwareStatusInfo.HardwareElementInfo.class, VirtualDevice.class, QuestionInfo.class, EventDescription.class, Recommendation.class, DrsRecommendation.class, ConfigInfo.class, GuestInfo.class, Summary.ConfigSummary.class, Summary.GuestSummary.class, GuestOsDescriptor.class, LicenseManager.DiagnosticInfo.class, LicenseManager.LicenseInfo.class, ConfigOptionDescriptor.class, ConfigOption.class, EVCMode.class, LicenseManager.FeatureInfo.class, AlarmDescription.class, AlarmInfo.class, TaskDescription.class, TaskInfo.class, AuthorizationManager.Role.class, AuthorizationDescription.class, EventDescription.EventArgDesc.class, PerformanceDescription.class, Message.class, Service.class, Ruleset.class};
    }

    private Method getMethod(Object object) {
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        Method method = methodMap.get(string);
        if (method != null) {
            return method;
        }
        if (this.defaultInstance instanceof Class) {
            Class clazz2 = (Class)this.defaultInstance;
            string = clazz2.getName();
            method = methodMap.get(string);
        }
        if (method != null) {
            return method;
        }
        _logger.info((Object)("Failed to find process method for " + clazz.getName()));
        return null;
    }

    private static void loadMethodMap() {
        Class<?>[] classArray;
        for (Class<?> clazz : classArray = I18nFilterProxy.getSupportedTypes()) {
            try {
                Method method = I18nFilterProxy.class.getDeclaredMethod("process", clazz);
                method.setAccessible(true);
                methodMap.put(clazz.getName(), method);
            }
            catch (Exception exception) {
                _logger.warn((Object)("Failed to locate process method for type " + clazz));
            }
        }
    }

    private void stuffFullGuestName(Object object) {
        BeanProxy.BeanProperty beanProperty = this.getBeanProperty(object, "guestId");
        String string = (String)this.getBeanValue(object, beanProperty);
        if (string == null || string.length() == 0) {
            return;
        }
        beanProperty = this.getBeanProperty(object, "guestFullName");
        String string2 = (String)this.getBeanValue(object, beanProperty);
        if ((string.equals("otherGuest") || string.equals("otherGuest64")) && string2 != null) {
            return;
        }
        String string3 = this.getMessage(String.format("guestos.%s%s", string, ".label"), null);
        if (string3 != null) {
            try {
                beanProperty.set(object, (Object)string3);
            }
            catch (Exception exception) {
                _logger.error((Object)("Failed to invoke setGuestFullName on data object " + object));
            }
        }
    }

    private void process(AboutInfo aboutInfo) {
        String string = String.format("%s.%s", this.getClassName(aboutInfo, I18nFilterProxyBase.NameStyle.SIMPLE), aboutInfo.getProductLineId());
        aboutInfo.setName(this.getMessage(string.concat(RES_ABOUT_SHORTNAME), aboutInfo.getName()));
        aboutInfo.setVendor(this.getMessage(string.concat(RES_ABOUT_VENDOR), aboutInfo.getVendor()));
        aboutInfo.setLocaleVersion(this.getMessage(string.concat(RES_ABOUT_VERSION), aboutInfo.getLocaleVersion()));
        aboutInfo.setLocaleBuild(this.getMessage(string.concat(RES_ABOUT_BUILD), aboutInfo.getLocaleBuild()));
        KeyAnyValue[] keyAnyValueArray = new KeyAnyValue[]{VmodlHelper.newKeyValue((String)"name", (Object)aboutInfo.getName()), VmodlHelper.newKeyValue((String)"version", (Object)aboutInfo.getVersion()), VmodlHelper.newKeyValue((String)"build", (Object)aboutInfo.getBuild())};
        String string2 = LocalizationUtil.getLocalizedMessage((String)string.concat(RES_ABOUT_FULLNAME), (KeyAnyValue[])keyAnyValueArray);
        if (string2 != null) {
            aboutInfo.setFullName(string2);
        }
    }

    private void process(DiagnosticManager.LogDescriptor logDescriptor) {
        Description description = logDescriptor.getInfo();
        String string = String.format("%s.%s", this.getClassName(logDescriptor, I18nFilterProxyBase.NameStyle.SIMPLE), logDescriptor.getCreator());
        this.fillDescription(string, description);
    }

    private void process(ScheduledTaskDescription scheduledTaskDescription) {
        ScheduledTaskDescription.SchedulerDetail[] schedulerDetailArray = scheduledTaskDescription.getSchedulerInfo();
        if (schedulerDetailArray != null) {
            for (ScheduledTaskDescription.SchedulerDetail schedulerDetail : schedulerDetailArray) {
                String string = schedulerDetail.getKey().getName();
                this.fillDescription(string, (Description)schedulerDetail);
                schedulerDetail.setFrequency(this.getMessage(string.concat(RES_STASK_FREQ), schedulerDetail.getFrequency()));
            }
        }
        this.fillTypeDescription("", scheduledTaskDescription.getAction());
        this.fillElementDescription("TaskInfo.State", scheduledTaskDescription.getState());
        this.fillElementDescription("scheduler.MonthlyByWeekdayTaskScheduler.DayOfWeek", scheduledTaskDescription.getDayOfWeek());
        this.fillElementDescription("scheduler.MonthlyByWeekdayTaskScheduler.WeekOfMonth", scheduledTaskDescription.getWeekOfMonth());
    }

    private void process(PerformanceManager.CounterInfo counterInfo) {
        ElementDescription elementDescription = counterInfo.getGroupInfo();
        ElementDescription elementDescription2 = counterInfo.getNameInfo();
        ElementDescription elementDescription3 = counterInfo.getUnitInfo();
        if (elementDescription == null || elementDescription2 == null || elementDescription3 == null) {
            return;
        }
        String string = String.format("%s%s.%s", RES_PERF_COUNTER, elementDescription.getKey(), elementDescription2.getKey());
        this.fillDescription(string, (Description)elementDescription2);
        string = RES_PERF_UNIT.concat(elementDescription3.getKey());
        this.fillDescription(string, (Description)elementDescription3);
        string = RES_PERF_GROUP.concat(elementDescription.getKey());
        this.fillDescription(string, (Description)elementDescription);
    }

    private void process(HistoricalInterval historicalInterval) {
        String string = historicalInterval.getName();
        if (string.indexOf(RES_PERF_HIST) == 0) {
            historicalInterval.setName(this.getMessage(String.format("%s%s", string, ".label"), string));
        }
    }

    private void process(Extension extension) {
        Extension.ClientInfo[] clientInfoArray;
        Description description = extension.getDescription();
        String string = extension.getKey();
        this.fillDescription(string, description);
        Extension.ClientInfo[] clientInfoArray2 = extension.getClient();
        if (clientInfoArray2 != null) {
            clientInfoArray = clientInfoArray2;
            int n = clientInfoArray.length;
            for (int i = 0; i < n; ++i) {
                Extension.ClientInfo clientInfo = clientInfoArray[i];
                description = clientInfo.getDescription();
                Object object = String.format("%s%s%s", string, RES_EXT_CLIENT, clientInfo.getType());
                this.fillDescription((String)object, description);
            }
        }
        if ((clientInfoArray = extension.getServer()) != null) {
            for (Object object : clientInfoArray) {
                description = object.getDescription();
                String string2 = String.format("%s%s%s", string, RES_EXT_SERVER, object.getType());
                this.fillDescription(string2, description);
            }
        }
    }

    private void process(SystemIdentificationInfo systemIdentificationInfo) {
        this.fillElementDescription("host.SystemIdentificationInfo.IdentifierType", new ElementDescription[]{systemIdentificationInfo.getIdentifierType()});
    }

    private void process(NumericSensorInfo numericSensorInfo) {
        this.fillElementDescription("host.NumericSensorInfo.HealthState", new ElementDescription[]{numericSensorInfo.getHealthState()});
    }

    private void process(HardwareStatusInfo.HardwareElementInfo hardwareElementInfo) {
        this.fillElementDescription("host.HardwareStatusInfo.HardwareElementInfo.Status", new ElementDescription[]{hardwareElementInfo.getStatus()});
    }

    private void process(Recommendation recommendation) {
        String string = String.format("%s%s%s", RES_DRS_RECCO, recommendation.getReason(), ".summary");
        recommendation.setReasonText(this.getMessage(string, recommendation.getReason()));
    }

    private void process(DrsRecommendation drsRecommendation) {
        String string = String.format("%s%s%s", RES_DRS_RECCO, drsRecommendation.getReason(), ".summary");
        drsRecommendation.setReasonText(this.getMessage(string, drsRecommendation.getReason()));
    }

    private void process(Ruleset ruleset) {
        String string = String.format("%s%s%s", RES_HOST_FIREWALL, ruleset.getKey(), ".label");
        ruleset.setLabel(this.getMessage(string, ruleset.getKey()));
    }

    private void process(GuestOsDescriptor guestOsDescriptor) {
        String string = String.format("%s%s%s", RES_VM_GUESTOS, guestOsDescriptor.getId(), ".label");
        guestOsDescriptor.setFullName(this.getMessage(string, guestOsDescriptor.getFullName()));
    }

    private void process(LicenseManager.DiagnosticInfo diagnosticInfo) {
        String string = this.getClassName(diagnosticInfo, I18nFilterProxyBase.NameStyle.SIMPLE);
        string = string.concat(".summary");
        diagnosticInfo.setOpFailureMessage(this.getMessage(string, diagnosticInfo.getOpFailureMessage()));
    }

    private void process(LicenseManager.LicenseInfo licenseInfo) {
        KeyAnyValue[] keyAnyValueArray = licenseInfo.getProperties();
        if (keyAnyValueArray != null) {
            for (KeyAnyValue keyAnyValue : keyAnyValueArray) {
                BeanProxy.BeanProperty beanProperty;
                String string;
                Object object;
                String string2 = keyAnyValue.getKey();
                if (!LM_FEATURE.equals(string2) && !LM_ADDON.equals(string2) || (object = keyAnyValue.getValue()) == null || (string = (String)this.getBeanValue(object, beanProperty = this.getBeanProperty(object, "key"))) == null) continue;
                String string3 = string.replaceAll(":", ".");
                String string4 = this.getMessage(String.format("%s.%s%s", LICENSE_INFO_PREFIX, string3, ".label"), string);
                KeyValue keyValue = new KeyValue();
                keyValue.setKey(string);
                keyValue.setValue(string4);
                keyAnyValue.setValue((Object)keyValue);
            }
        }
    }

    private void process(QuestionInfo questionInfo) {
        questionInfo.setText(this.getMessageText(questionInfo.getMessage(), questionInfo.getText()));
        ChoiceOption choiceOption = questionInfo.getChoice();
        if (choiceOption == null) {
            return;
        }
        ElementDescription[] elementDescriptionArray = choiceOption.getChoiceInfo();
        if (elementDescriptionArray != null) {
            for (ElementDescription elementDescription : elementDescriptionArray) {
                String string = null;
                string = !elementDescription.getLabel().startsWith(RES_BUTTON_NAME) ? RES_ANSWER_NAME.concat(elementDescription.getLabel()) : elementDescription.getLabel();
                elementDescription.setSummary(this.getMessage(string, elementDescription.getSummary()));
            }
        }
    }

    private void process(ConfigOptionDescriptor configOptionDescriptor) {
        String string = String.format("%s.%s%s", this.getClassName(configOptionDescriptor, I18nFilterProxyBase.NameStyle.SIMPLE), configOptionDescriptor.getKey(), ".summary");
        configOptionDescriptor.setDescription(this.getMessage(string, configOptionDescriptor.getDescription()));
    }

    private void process(ConfigOption configOption) {
        String string = configOption.getVersion();
        String string2 = String.format("%s.%s%s", this.getClassName(configOption, I18nFilterProxyBase.NameStyle.SIMPLE), string, ".summary");
        configOption.setDescription(this.getMessage(string2, configOption.getDescription()));
    }

    private void process(EVCMode eVCMode) {
        String string = RES_EVC_MODE.concat(eVCMode.getKey());
        eVCMode.setLabel(this.getMessage(string.concat(".label"), eVCMode.getLabel()));
        eVCMode.setSummary(this.getMessage(string.concat(".summary"), eVCMode.getSummary()));
    }

    private void process(LicenseManager.FeatureInfo featureInfo) {
        String string = this.getClassName(featureInfo, I18nFilterProxyBase.NameStyle.SIMPLE);
        featureInfo.setFeatureName(this.getMessage(string.concat(".label"), new KeyAnyValue[]{VmodlHelper.newKeyValue((String)"key", (Object)featureInfo.getKey())}, featureInfo.getFeatureName()));
        string = featureInfo.getExpiresOn() == null ? string.concat(".summary") : string.concat(".Expiration").concat(".summary");
        featureInfo.setFeatureDescription(this.getMessage(string, featureInfo.getFeatureDescription()));
    }

    private void process(AlarmDescription alarmDescription) {
        this.fillTypeDescription("", alarmDescription.getExpr());
        this.fillElementDescription("alarm.StateAlarmExpression.StateOperator", alarmDescription.getStateOperator());
        this.fillElementDescription("alarm.MetricAlarmExpression.MetricOperator", alarmDescription.getMetricOperator());
        this.fillElementDescription("HostSystem.ConnectionState", alarmDescription.getHostSystemConnectionState());
        this.fillElementDescription("HostSystem.PowerState", alarmDescription.getHostSystemPowerState());
        this.fillElementDescription("VirtualMachine.PowerState", alarmDescription.getVirtualMachinePowerState());
        this.fillElementDescription("VirtualMachine.GuestHeartbeatStatus", alarmDescription.getVirtualMachineGuestHeartbeatStatus());
        this.fillElementDescription("Datastore.Accessible", alarmDescription.getDatastoreConnectionState());
        this.fillElementDescription("ManagedEntity.Status", alarmDescription.getEntityStatus());
        this.fillTypeDescription("", alarmDescription.getAction());
    }

    private void process(AlarmInfo alarmInfo) {
        String string = alarmInfo.getName();
        if (string.indexOf(RES_ALARM_NAME) == 0) {
            alarmInfo.setName(this.getMessage(string.concat(".label"), string));
            alarmInfo.setDescription(this.getMessage(string.concat(".summary"), alarmInfo.getDescription()));
        }
    }

    private void process(TaskDescription taskDescription) {
        this.fillElementDescription("", taskDescription.getMethodInfo());
        this.fillElementDescription("TaskInfo.State", taskDescription.getState());
        this.fillTypeDescription("", taskDescription.getReason());
    }

    private void process(TaskInfo taskInfo) {
        int n;
        String string = taskInfo.getDescriptionId();
        if (string == null || string.length() == 0) {
            if (taskInfo.getName() != null) {
                string = taskInfo.getName().getName();
            }
            if (string == null || string.length() == 0) {
                string = "NoTaskName";
            }
        }
        n = (n = string.indexOf("vim.")) != -1 ? n + 4 : 0;
        taskInfo.setDescriptionId(string.substring(n));
    }

    private void process(AuthorizationManager.Role role) {
        this.fillDescription(RES_AUTH_ROLE.concat(role.getName()), role.getInfo());
    }

    private void process(AuthorizationDescription authorizationDescription) {
        this.fillElementDescription(RES_AUTH_PRIV, authorizationDescription.getPrivilege());
        this.fillElementDescription(RES_AUTH_PRIV, authorizationDescription.getPrivilegeGroup());
    }

    private void process(EventDescription.EventArgDesc eventArgDesc) {
        ElementDescription elementDescription = eventArgDesc.getDescription();
        if (elementDescription != null) {
            this.fillElementDescription(RES_EVENT_NAME, new ElementDescription[]{elementDescription});
        }
    }

    private void process(EventDescription eventDescription) {
        Object object;
        String string;
        EventDescription.EventDetail[] eventDetailArray;
        this.fillElementDescription("event.EventDescription.EventCategory", eventDescription.getCategory());
        EventDescription.EventDetail[] eventDetailArray2 = eventDescription.getEventInfo();
        if (eventDetailArray2 != null) {
            eventDetailArray = eventDetailArray2;
            int n = eventDetailArray.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                Object object2;
                EventDescription.EventDetail eventDetail = eventDetailArray[i];
                String string3 = eventDetail.getKey().getName();
                if (RES_EXTEVENT_NAME.equals(string3) || RES_EVENTEX_NAME.equals(string3)) {
                    string = eventDetail.getFullFormat();
                    object = RES_EVENT_NAME.concat(string);
                    object2 = ((String)object).concat(RES_EVENT_CATEGORY);
                    eventDetail.setCategory(this.getMessage((String)object2, eventDetail.getCategory()));
                    object2 = ((String)object).concat(RES_EVENT_DESCRIPTION);
                    eventDetail.setDescription(this.getMessage((String)object2, string));
                    object2 = ((String)object).concat(RES_EVENT_FULL);
                    string2 = this.getMessage((String)object2, (String)object2);
                    eventDetail.setFullFormat(String.format("%s|%s", string, string2));
                    eventDetail.setFormatOnDatacenter(this.getMessage(((String)object).concat(RES_EVENT_ONDC), string2));
                    eventDetail.setFormatOnComputeResource(this.getMessage(((String)object).concat(RES_EVENT_ONCRES), string2));
                    eventDetail.setFormatOnHost(this.getMessage(((String)object).concat(RES_EVENT_ONHOST), string2));
                    eventDetail.setFormatOnVm(this.getMessage(((String)object).concat(RES_EVENT_ONVM), string2));
                    object2 = String.format("%s%s%s", RES_EVENTAUX_NAME, string, RES_EVENT_LONGDESCRIPTION);
                    eventDetail.setLongDescription(this.getMessage((String)object2, eventDetail.getLongDescription()));
                    continue;
                }
                if (string3.length() <= "vim.".length() || !"vim.".equals(string3.substring(0, "vim.".length()))) continue;
                string = string3.substring("vim.".length());
                object = string.concat(RES_EVENT_CATEGORY);
                eventDetail.setCategory(this.getMessage((String)object, (String)object));
                object = string.concat(RES_EVENT_DESCRIPTION);
                eventDetail.setDescription(this.getMessage((String)object, string3));
                object = string.concat(RES_EVENT_FULL);
                object2 = this.getMessage((String)object, (String)object);
                eventDetail.setFullFormat((String)object2);
                eventDetail.setFormatOnDatacenter(this.getMessage(string.concat(RES_EVENT_ONDC), (String)object2));
                eventDetail.setFormatOnComputeResource(this.getMessage(string.concat(RES_EVENT_ONCRES), (String)object2));
                eventDetail.setFormatOnHost(this.getMessage(string.concat(RES_EVENT_ONHOST), (String)object2));
                eventDetail.setFormatOnVm(this.getMessage(string.concat(RES_EVENT_ONVM), (String)object2));
                string2 = string.substring(RES_EVENT_NAME.length());
                object = String.format("%s%s%s", RES_EVENTAUX_NAME, string2, RES_EVENT_LONGDESCRIPTION);
                eventDetail.setLongDescription(this.getMessage((String)object, eventDetail.getLongDescription()));
            }
        }
        if ((eventDetailArray = eventDescription.getEnumeratedTypes()) != null) {
            for (EventDescription.EventDetail eventDetail : eventDetailArray) {
                string = this.getClassName(eventDetail.getKey());
                object = eventDetail.getTags();
                if (object == null) continue;
                for (Object object3 : object) {
                    this.fillDescription(string, (Description)object3);
                }
            }
        }
    }

    private void process(PerformanceDescription performanceDescription) {
        this.fillElementDescription("PerformanceManager.CounterInfo.RollupType", performanceDescription.getCounterType());
        this.fillElementDescription("PerformanceManager.CounterInfo.StatsType", performanceDescription.getStatsType());
    }

    private void process(Message message) {
        String string = message.getId();
        KeyAnyValue[] keyAnyValueArray = null;
        Object[] objectArray = message.getArgument();
        if (objectArray != null) {
            keyAnyValueArray = new KeyAnyValue[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = this.getMessage(RES_LOC_MSG + objectArray[i], (String)objectArray[i]);
                keyAnyValueArray[i] = VmodlHelper.newKeyValue((String)String.valueOf(i + 1), (Object)string2);
            }
        }
        message.setText(this.getMessage(string, keyAnyValueArray, message.getText()));
    }

    private void process(Service service) {
        String string = String.format("%s%s%s", RES_HOST_SERVICE, service.getKey(), ".label");
        service.setLabel(this.getMessage(string, service.getKey()));
    }

    private void process(VirtualDevice virtualDevice) {
        if (virtualDevice.getDeviceInfo() != null) {
            Description description = virtualDevice.getDeviceInfo();
            String string = RES_VM_DEVICE + virtualDevice.getClass().getSimpleName();
            KeyAnyValue keyAnyValue = VmodlHelper.newKeyValue((String)RES_VM_DEVICE_INFO_LABEL, (Object)this.getVmDeviceOrderNumber(description));
            KeyAnyValue[] keyAnyValueArray = new KeyAnyValue[]{keyAnyValue};
            String string2 = this.getMessage(string.concat(".label"), keyAnyValueArray, description.getLabel());
            description.setLabel(string2);
            VirtualDevice.BackingInfo backingInfo = virtualDevice.getBacking();
            if (backingInfo != null) {
                string = String.format("%s.%s", string, this.getClassName(backingInfo, I18nFilterProxyBase.NameStyle.QNAME));
            }
            String string3 = this.getMessage(string.concat(".summary"), keyAnyValueArray, description.getSummary());
            description.setSummary(string3.trim());
        }
    }

    private String getVmDeviceOrderNumber(Description description) {
        String string = description.getLabel();
        String string2 = "";
        if (!StringUtil.isNullOrEmpty((String)string) && !StringUtil.isNullOrEmpty((String)(string2 = this.getVmDeviceOrderNumber(string)))) {
            return string2;
        }
        String string3 = description.getSummary();
        if (!StringUtil.isNullOrEmpty((String)string3) && !StringUtil.isNullOrEmpty((String)(string2 = this.getVmDeviceOrderNumber(string3)))) {
            return string2;
        }
        _logger.warn((Object)("Device order number not found: " + description.getLabel()));
        return "";
    }

    private String getVmDeviceOrderNumber(String string) {
        int n;
        if (StringUtil.isNullOrEmpty((String)string)) {
            return null;
        }
        int n2 = (string = string.trim()).length();
        if (n2 == 0) {
            return null;
        }
        boolean bl = false;
        for (n = n2 - 1; n > 0 && this.isNumber(string.charAt(n)); --n) {
            bl = true;
        }
        if (bl) {
            return string.substring(n + 1);
        }
        return null;
    }

    private boolean isNumber(char c) {
        try {
            Integer.parseInt(Character.toString(c));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void process(ConfigInfo configInfo) {
        this.stuffFullGuestName(configInfo);
    }

    private void process(GuestInfo guestInfo) {
        this.stuffFullGuestName(guestInfo);
    }

    private void process(Summary.ConfigSummary configSummary) {
        this.stuffFullGuestName(configSummary);
    }

    private void process(Summary.GuestSummary guestSummary) {
        this.stuffFullGuestName(guestSummary);
    }

    private String getMessageText(Message[] messageArray, String string) {
        if (messageArray == null || messageArray.length == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Message message : messageArray) {
            String string2 = message.getId();
            KeyAnyValue[] keyAnyValueArray = null;
            if (message.getArgument() != null) {
                Object[] objectArray = message.getArgument();
                keyAnyValueArray = new KeyAnyValue[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    keyAnyValueArray[i] = VmodlHelper.newKeyValue((String)String.valueOf(i + 1), (Object)objectArray[i]);
                }
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(LF);
            }
            stringBuffer.append(this.getMessage(string2, keyAnyValueArray, message.getText()));
        }
        return stringBuffer.toString();
    }

    static {
        I18nFilterProxy.loadMethodMap();
        _logger = LogFactory.getLog(I18nFilterProxy.class);
    }
}

