/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.messaging.amf.vim;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.messaging.amf.BeanProxy;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.xml.NamespaceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedObjectReferenceProxy
extends BeanProxy {
    private static final Log _logger = LogFactory.getLog(ManagedObjectReferenceProxy.class);
    static final long serialVersionUID = -8596192524207625521L;
    static final String PROPERTY_TYPE = "type";
    static final String PROPERTY_VERSION = "version";
    private final ThreadLocal<LinkedVcGroupRegistry> linkedVcGroupRegistry = new ThreadLocal();

    public ManagedObjectReferenceProxy() {
        this(null);
    }

    public ManagedObjectReferenceProxy(Object object) {
        super(object);
    }

    public List getPropertyNames(Object object) {
        List list = super.getPropertyNames(object);
        if (object instanceof ManagedObjectReference && !list.contains(PROPERTY_VERSION)) {
            list.add(PROPERTY_VERSION);
        }
        return list;
    }

    public Object getValue(Object object, String string) {
        if (!(object instanceof ManagedObjectReference)) {
            return super.getValue(object, string);
        }
        if (PROPERTY_TYPE.equals(string)) {
            String string2 = QueryUtil.getReferenceType((Object)object);
            return string2;
        }
        if (PROPERTY_VERSION.equals(string)) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
            return this.getVcVersion(managedObjectReference);
        }
        return super.getValue(object, string);
    }

    private String getVcVersion(ManagedObjectReference managedObjectReference) {
        try {
            Object object;
            String string = managedObjectReference.getServerGuid();
            if (string == null) {
                return null;
            }
            VcService vcService = null;
            LinkedVcGroupRegistry linkedVcGroupRegistry = this.linkedVcGroupRegistry.get();
            if (linkedVcGroupRegistry != null && (object = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string)) != null) {
                vcService = object.getVcService(string);
            }
            if (vcService == null) {
                vcService = ManagedObjectReferenceProxy.getStartupVcService(string);
            }
            if (vcService == null) {
                return null;
            }
            object = vcService.getServiceInstanceContent().about.version;
            return object;
        }
        catch (Exception exception) {
            _logger.warn((Object)String.format("Cannot get the VC version, MOR = %s", managedObjectReference), (Throwable)ExceptionUtil.limitStackTrace((Exception)exception));
            return null;
        }
    }

    public void setValue(Object object, String string, Object object2) {
        if (object instanceof ManagedObjectReference && PROPERTY_TYPE.equals(string)) {
            String string2 = object2.toString();
            String string3 = NamespaceUtil.getUnqualifiedTypeName((String)string2);
            super.setValue(object, string, (Object)string3);
            return;
        }
        super.setValue(object, string, object2);
    }

    public void setLinkedVcGroupRegistry(LinkedVcGroupRegistry linkedVcGroupRegistry) {
        this.linkedVcGroupRegistry.set(linkedVcGroupRegistry);
    }

    public void removeLinkedVcGroupRegistry() {
        this.linkedVcGroupRegistry.remove();
    }

    private static VcService getStartupVcService(String string) {
        LinkedVcGroup[] linkedVcGroupArray;
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (linkedVcGroupRegistry == null) {
            return null;
        }
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray = linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups()) {
            VcService vcService = linkedVcGroup.getVcService(string);
            if (vcService == null) continue;
            return vcService;
        }
        return null;
    }
}

