/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.common.vapi.localization;

import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VapiLocalizationUtil {
    public static String getLocalizedMessage(LocalizableMessage localizableMessage) {
        String string = LocalizationUtil.getLocalizedMessage(localizableMessage.getId(), VapiLocalizationUtil.positionalArgsToKeyAnyValues(localizableMessage.getArgs()));
        if (!VapiLocalizationUtil.isLocalizedSuccesfully(string, localizableMessage).booleanValue()) {
            string = localizableMessage.getDefaultMessage();
        }
        return string;
    }

    public static List<String> getLocalizedMessages(List<LocalizableMessage> list) {
        int n = list.size();
        String[] stringArray = new String[n];
        KeyAnyValue[][] keyAnyValueArrayArray = new KeyAnyValue[n][];
        LocalizableMessage localizableMessage = null;
        for (int i = 0; i < n; ++i) {
            localizableMessage = list.get(i);
            if (localizableMessage == null) continue;
            stringArray[i] = localizableMessage.getId();
            keyAnyValueArrayArray[i] = VapiLocalizationUtil.positionalArgsToKeyAnyValues(localizableMessage.getArgs());
        }
        Map<String, String> map = LocalizationUtil.getLocalizedMessage(stringArray, keyAnyValueArrayArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (LocalizableMessage localizableMessage2 : list) {
            if (localizableMessage2 == null) continue;
            String string = map.get(localizableMessage2.getId());
            if (!VapiLocalizationUtil.isLocalizedSuccesfully(string, localizableMessage2).booleanValue()) {
                string = localizableMessage2.getDefaultMessage();
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private static Boolean isLocalizedSuccesfully(String string, LocalizableMessage localizableMessage) {
        return string != null && !string.equals(localizableMessage.getId());
    }

    private static KeyAnyValue[] positionalArgsToKeyAnyValues(List<String> list) {
        if (CollectionUtil.isNullOrEmpty(list)) {
            return new KeyAnyValue[0];
        }
        KeyAnyValueImpl[] keyAnyValueImplArray = new KeyAnyValueImpl[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            keyAnyValueImplArray[i] = new KeyAnyValueImpl();
            keyAnyValueImplArray[i].setKey(String.valueOf(i));
            keyAnyValueImplArray[i].setValue((Object)list.get(i));
        }
        return keyAnyValueImplArray;
    }
}

