/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.cache;

import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.session.SessionUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

public class BoundedSessionCache
implements UserSessionListener {
    private final int _maxSessions;
    private final Map<String, Queue<HttpSession>> _sessionQueueByDataId = new HashMap<String, Queue<HttpSession>>();

    public BoundedSessionCache(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The value of 'maxSessions' argument should be positive.");
        }
        this._maxSessions = n;
    }

    public synchronized void setData(String string, Object object) {
        SessionUtil.setData((String)string, (Object)object);
        HttpSession httpSession = SessionUtil.getHttpSession();
        Queue<HttpSession> queue = this._sessionQueueByDataId.get(string);
        if (queue == null) {
            queue = new LinkedList<HttpSession>();
            this._sessionQueueByDataId.put(string, queue);
        }
        this.removeSessionFromQueue(queue, httpSession);
        queue.add(httpSession);
        this.evictOldSessionData(string, queue);
    }

    public synchronized <T> T getData(String string) {
        HttpSession httpSession = SessionUtil.getHttpSession();
        Queue<HttpSession> queue = this._sessionQueueByDataId.get(string);
        if (queue != null && this.removeSessionFromQueue(queue, httpSession)) {
            queue.add(httpSession);
        }
        Object object = SessionUtil.getData((String)string);
        return (T)object;
    }

    public synchronized Object removeData(String string) {
        Object object = SessionUtil.removeData((String)string);
        HttpSession httpSession = SessionUtil.getHttpSession();
        Queue<HttpSession> queue = this._sessionQueueByDataId.get(string);
        if (queue != null) {
            this.removeSessionFromQueue(queue, httpSession);
            if (queue.isEmpty()) {
                this._sessionQueueByDataId.remove(string);
            }
        }
        return object;
    }

    public synchronized Object getSyncObject(String string) {
        return SessionUtil.getSyncObject((String)string, (HttpSession)SessionUtil.getHttpSession());
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    public synchronized void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        HttpSession httpSession = httpSessionEvent.getSession();
        Iterator<Map.Entry<String, Queue<HttpSession>>> iterator = this._sessionQueueByDataId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Queue<HttpSession>> entry = iterator.next();
            Queue<HttpSession> queue = entry.getValue();
            this.removeSessionFromQueue(queue, httpSession);
            if (!queue.isEmpty()) continue;
            iterator.remove();
        }
    }

    private void evictOldSessionData(String string, Queue<HttpSession> queue) {
        if (queue.size() > this._maxSessions) {
            HttpSession httpSession = queue.remove();
            if (queue.isEmpty()) {
                this._sessionQueueByDataId.remove(string);
            }
            SessionUtil.removeData((String)string, (HttpSession)httpSession);
        }
    }

    private boolean removeSessionFromQueue(Queue<HttpSession> queue, HttpSession httpSession) {
        boolean bl = false;
        String string = httpSession.getId();
        Iterator iterator = queue.iterator();
        if (string != null) {
            while (iterator.hasNext()) {
                HttpSession httpSession2 = (HttpSession)iterator.next();
                if (!string.equals(httpSession2.getId())) continue;
                iterator.remove();
                bl = true;
                break;
            }
        } else {
            while (iterator.hasNext()) {
                HttpSession httpSession3 = (HttpSession)iterator.next();
                if (httpSession3.getId() != null) continue;
                iterator.remove();
                bl = true;
                break;
            }
        }
        return bl;
    }
}

