/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.i18n;

import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.i18n.CatalogEntry;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageResolver {
    private static final String KEY_VALUE_ARRAY_TYPE = "com.vmware.vim.binding.vim.KeyValue[]";
    private static final Log _logger = LogFactory.getLog(MessageResolver.class);
    private Map<String, CatalogEntry> _catalogDictionary = null;
    private final Locale _locale;
    private static final String DEFAULT_SEPARATOR = ",";
    private static final String MSG_FORMAT = ".msg";

    public MessageResolver(Map<String, CatalogEntry> map, Locale locale) {
        this._catalogDictionary = map;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this._locale = locale;
    }

    public String getLocalizedMessage(String string, KeyAnyValue[] keyAnyValueArray) {
        if (string == null) {
            return null;
        }
        CatalogEntry catalogEntry = this._catalogDictionary == null ? null : this._catalogDictionary.get(string);
        return catalogEntry == null ? null : this.resolve(string, catalogEntry.getValue(), keyAnyValueArray);
    }

    private String resolve(String string, String string2, KeyAnyValue[] keyAnyValueArray) {
        boolean bl = false;
        if (string2 == null) {
            return null;
        }
        if (keyAnyValueArray == null) {
            return string2;
        }
        String string3 = string2;
        int n = string2.indexOf(123);
        if (n == -1) {
            n = string2.indexOf(91);
            bl = n != -1;
        }
        int n2 = bl ? string2.indexOf(93) : string2.indexOf(125);
        while (n != -1 && n2 != -1 && n < n2 && keyAnyValueArray.length > 0) {
            String string4 = string2.substring(n + 1, n2);
            String string5 = this.valueForVariable(string4, keyAnyValueArray);
            if (string5 == null) {
                _logger.error((Object)("Null value for variable " + string4 + " in key " + string));
            } else {
                String string6 = bl ? "[" + string4 + "]" : "{" + string4 + "}";
                string3 = string3.replace(string6, string5);
            }
            string2 = string2.substring(n2 + 1);
            if (bl) {
                n = string2.indexOf(91);
                n2 = string2.indexOf(93);
                continue;
            }
            n = string2.indexOf(123);
            n2 = string2.indexOf(125);
        }
        return string3;
    }

    private String valueForVariable(String string, KeyAnyValue[] keyAnyValueArray) {
        int n = string.indexOf(64);
        if (n == -1) {
            return this.valueFromArgsAsString(string, keyAnyValueArray);
        }
        String string2 = string.substring(0, n - 1);
        String string3 = this.valueFromArgsAsString(string2, keyAnyValueArray);
        if (string3 == null) {
            return null;
        }
        String string4 = string.substring(n + 1);
        String string5 = String.format("%1$s.%2$s.label", string4, string3);
        int n2 = string5.indexOf(".");
        String string6 = string5.substring(n2 + 1);
        return this.getLocalizedMessage(string6, keyAnyValueArray);
    }

    private String valueFromArgsAsString(String string, KeyAnyValue[] keyAnyValueArray) {
        String[] stringArray;
        if (keyAnyValueArray == null) {
            return null;
        }
        ValueResult valueResult = this.valueFromArgs(string, keyAnyValueArray);
        if (valueResult.isFound()) {
            String string2 = MessageResolver.valueToString(valueResult.getValue());
            try {
                Integer.parseInt(string);
                String string3 = LocalizationUtil.getLocalizedMessage(string2, null);
                if (string3 != null) {
                    return string3;
                }
                return string2;
            }
            catch (NumberFormatException numberFormatException) {
                return string2;
            }
        }
        if (string.endsWith(MSG_FORMAT)) {
            string = string.substring(0, string.indexOf(MSG_FORMAT));
            return this.valueFromArgsAsString(string, keyAnyValueArray);
        }
        if (string.indexOf(44) > 0 && (stringArray = string.split(DEFAULT_SEPARATOR)).length <= 3) {
            KeyAnyValue keyAnyValue;
            Object object;
            block15: {
                object = null;
                try {
                    int n = Integer.parseInt(stringArray[0]);
                    if (n >= 0 && n <= keyAnyValueArray.length) {
                        keyAnyValue = keyAnyValueArray[n];
                        object = keyAnyValue != null ? keyAnyValue.getValue() : null;
                    } else {
                        _logger.error((Object)("Invalid argument index (" + n + ") in property '" + string + "'. Maximum allowed: " + (keyAnyValueArray.length - 1) + " (0-based)."));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    valueResult = this.valueFromArgs(stringArray[0], keyAnyValueArray);
                    if (valueResult == null || !valueResult.isFound()) break block15;
                    object = valueResult.getValue();
                }
            }
            if (object != null) {
                try {
                    String string4 = stringArray.length >= 2 ? stringArray[1] : null;
                    keyAnyValue = stringArray.length >= 3 ? stringArray[2] : null;
                    FormatSpec formatSpec = FormatSpec.fromFormatSpecString(string4);
                    if (formatSpec == null) {
                        throw new ParseException("Invalid format spec: " + string4);
                    }
                    String string5 = formatSpec.formatValue(object, (String)keyAnyValue, this._locale);
                    return string5;
                }
                catch (ParseException parseException) {
                    _logger.error((Object)("Invalid message argument: " + string + "."), (Throwable)parseException);
                }
            }
        }
        return string;
    }

    private ValueResult valueFromArgs(String string, KeyAnyValue[] keyAnyValueArray) {
        if (keyAnyValueArray == null) {
            return ValueResult.NOT_FOUND;
        }
        String[] stringArray = string.split("\\.");
        for (KeyAnyValue keyAnyValue : keyAnyValueArray) {
            String string2;
            if (keyAnyValue == null || !(string2 = keyAnyValue.getKey()).equals(string) && stringArray.length <= 1 || !string2.equals(stringArray[0]) && !string2.equals(string)) continue;
            KeyAnyValue[] keyAnyValueArray2 = keyAnyValue.getValue();
            if (keyAnyValue.getValue() != null && KEY_VALUE_ARRAY_TYPE.equals(keyAnyValue.getValue().getClass().getCanonicalName())) {
                keyAnyValueArray2 = this.vimKeyValuesToKeyAnyValues(keyAnyValue.getValue());
            }
            if (keyAnyValueArray2 instanceof KeyAnyValue[]) {
                return this.valueFromArgs(stringArray[1], keyAnyValueArray2);
            }
            return new ValueResult(true, keyAnyValueArray2);
        }
        return ValueResult.NOT_FOUND;
    }

    private KeyAnyValue[] vimKeyValuesToKeyAnyValues(Object object) {
        try {
            Object[] objectArray = (Object[])object;
            Class<?> clazz = objectArray.getClass().getComponentType();
            Field field = clazz.getField("key");
            Field field2 = clazz.getField("value");
            KeyAnyValue[] keyAnyValueArray = new KeyAnyValue[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                KeyAnyValueImpl keyAnyValueImpl = new KeyAnyValueImpl();
                keyAnyValueImpl.setKey((String)field.get(objectArray[i]));
                keyAnyValueImpl.setValue(field2.get(objectArray[i]));
                keyAnyValueArray[i] = keyAnyValueImpl;
            }
            return keyAnyValueArray;
        }
        catch (Exception exception) {
            _logger.error((Object)("Could not transform object to KeyAnyValue[]. Data: " + object), (Throwable)exception);
            return null;
        }
    }

    private static String valueToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof List) {
            return MessageResolver.joinList((List)object, DEFAULT_SEPARATOR);
        }
        if (object instanceof String[]) {
            return MessageResolver.joinList(Arrays.asList((String[])object), DEFAULT_SEPARATOR);
        }
        return object.toString();
    }

    private static String joinList(List<?> list, String string) {
        if (list == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(string);
            }
            if (list.get(i) == null) continue;
            stringBuilder.append(list.get(i).toString());
        }
        return stringBuilder.toString();
    }

    static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParseException(String string) {
            super(string);
        }
    }

    private static class ValueResult {
        private static final ValueResult NOT_FOUND = new ValueResult(false, null);
        private final boolean _found;
        private final Object _value;

        private ValueResult(boolean bl, Object object) {
            this._found = bl;
            this._value = object;
        }

        private boolean isFound() {
            return this._found;
        }

        private Object getValue() {
            return this._value;
        }
    }

    static enum FormatSpec {
        CHARACTER("C"){

            @Override
            public String formatValue(Object object, String string, Locale locale) {
                return MessageResolver.valueToString(object);
            }
        }
        ,
        INTEGER("I"){

            @Override
            public String formatValue(Object object, String string, Locale locale) throws ParseException {
                if (object == null) {
                    return null;
                }
                long l = this.toLong(object);
                if (FormatSpec.SUBFORMAT_SPEC_SHORT.equalsIgnoreCase(string)) {
                    return String.valueOf(l);
                }
                if (FormatSpec.SUBFORMAT_SPEC_LONG.equalsIgnoreCase(string)) {
                    NumberFormat numberFormat = NumberFormat.getIntegerInstance(locale);
                    DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
                    decimalFormat.setGroupingUsed(true);
                    return decimalFormat.format(l);
                }
                if (FormatSpec.SUBFORMAT_SPEC_MEDIUM.equalsIgnoreCase(string)) {
                    return String.valueOf(l / 100L) + "%";
                }
                if (FormatSpec.SUBFORMAT_SPEC_HEX.equalsIgnoreCase(string)) {
                    return "0x" + this.toHexString(l);
                }
                throw new ParseException("Invalid sub-format spec: " + string);
            }
        }
        ,
        FLOATING("F"){

            @Override
            public String formatValue(Object object, String string, Locale locale) throws ParseException {
                BigDecimal bigDecimal;
                if (object == null) {
                    return null;
                }
                if (object instanceof BigDecimal) {
                    bigDecimal = (BigDecimal)object;
                } else if (object instanceof BigInteger) {
                    bigDecimal = new BigDecimal((BigInteger)object);
                } else if (object instanceof Double) {
                    bigDecimal = new BigDecimal(((Double)object).toString());
                } else if (object instanceof Number) {
                    bigDecimal = new BigDecimal(((Number)object).longValue());
                } else if (object instanceof String) {
                    try {
                        bigDecimal = new BigDecimal((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("The string is not a number: " + object);
                    }
                } else {
                    throw new ParseException("The value is not a number: " + object);
                }
                if (FormatSpec.SUBFORMAT_SPEC_SHORT.equalsIgnoreCase(string)) {
                    return bigDecimal.toPlainString();
                }
                if (FormatSpec.SUBFORMAT_SPEC_LONG.equalsIgnoreCase(string)) {
                    NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
                    DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
                    decimalFormat.setGroupingUsed(true);
                    return decimalFormat.format(bigDecimal);
                }
                if (FormatSpec.SUBFORMAT_SPEC_MEDIUM.equalsIgnoreCase(string)) {
                    return String.valueOf(bigDecimal.divide(HUNDRED)) + "%";
                }
                throw new ParseException("Invalid sub-format spec: " + string);
            }
        }
        ,
        DATE("D"){

            @Override
            public String formatValue(Object object, String string, Locale locale) throws ParseException {
                return this.formatCalendar(object, string, locale, true);
            }
        }
        ,
        TIME("T"){

            @Override
            public String formatValue(Object object, String string, Locale locale) throws ParseException {
                return this.formatCalendar(object, string, locale, false);
            }
        }
        ,
        HEX("x"){

            @Override
            public String formatValue(Object object, String string, Locale locale) throws ParseException {
                if (object == null) {
                    return null;
                }
                long l = this.toLong(object);
                return "0x" + this.toHexString(l);
            }
        };

        static final String SUBFORMAT_SPEC_SHORT = "s";
        static final String SUBFORMAT_SPEC_MEDIUM = "m";
        static final String SUBFORMAT_SPEC_LONG = "l";
        static final String SUBFORMAT_SPEC_HEX = "x";
        private static final BigDecimal HUNDRED;
        private final String _specString;

        private FormatSpec(String string2) {
            this._specString = string2;
        }

        public String getFormatSpecString() {
            return this._specString;
        }

        public static FormatSpec fromFormatSpecString(String string) {
            if (StringUtil.isNullOrEmpty((String)string)) {
                return null;
            }
            for (FormatSpec formatSpec : FormatSpec.values()) {
                if (!formatSpec._specString.equalsIgnoreCase(string)) continue;
                return formatSpec;
            }
            return null;
        }

        protected String formatCalendar(Object object, String string, Locale locale, boolean bl) throws ParseException {
            int n;
            if (object == null) {
                return null;
            }
            Date date = null;
            if (object instanceof Calendar) {
                date = ((Calendar)object).getTime();
            } else if (object instanceof Date) {
                date = (Date)object;
            }
            if (date == null) {
                throw new ParseException("The value is not a date: " + object);
            }
            if (SUBFORMAT_SPEC_SHORT.equalsIgnoreCase(string)) {
                n = 3;
            } else if (SUBFORMAT_SPEC_LONG.equalsIgnoreCase(string)) {
                n = 1;
            } else if (SUBFORMAT_SPEC_MEDIUM.equalsIgnoreCase(string)) {
                n = 2;
            } else {
                throw new ParseException("Invalid sub-format spec: " + string);
            }
            DateFormat dateFormat = bl ? DateFormat.getDateInstance(n, locale) : DateFormat.getTimeInstance(n, locale);
            String string2 = dateFormat.format(date);
            return string2;
        }

        protected long toLong(Object object) throws ParseException {
            long l;
            if (object instanceof Number) {
                l = ((Number)object).longValue();
            } else if (object instanceof String) {
                try {
                    l = Long.parseLong((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("The string is not an integer number: " + object);
                }
            } else {
                throw new ParseException("The value is not an integer number: " + object);
            }
            return l;
        }

        protected String toHexString(long l) {
            String string = Long.toHexString(l);
            if (l >= -128L && l <= 127L) {
                string = string.substring(Math.max(string.length() - 2, 0));
            } else if (l >= -32768L && l <= 32767L) {
                string = string.substring(Math.max(string.length() - 4, 0));
            } else if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                string = string.substring(Math.max(string.length() - 8, 0));
            }
            string = string.toUpperCase(Locale.ENGLISH);
            return string;
        }

        public abstract String formatValue(Object var1, String var2, Locale var3) throws ParseException;

        static {
            HUNDRED = new BigDecimal(100);
        }
    }
}

