/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.ssl;

import com.vmware.vise.vim.commons.ssl.KeystoreService;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeystoreUtil {
    public static final String LOCAL_KEYSTORE_FILE = "keystore.jks.path";
    public static final String LOCAL_KEYSTORE_PASSWORD = "keystore.jks.password";
    public static final String VECS_KEYSTORE_TYPE = "VKS2";
    public static final String TRUSTED_ROOTS = "TRUSTED_ROOTS";
    public static final String VECS_LOAD_STORE_PARAM_TYPE = "com.vmware.provider.VecsLoadStoreParameter";
    private static final Log _logger = LogFactory.getLog(KeystoreUtil.class);
    static KeystoreService keyStoreService;

    public static KeyStore getKeyStore() {
        if (keyStoreService == null) {
            return null;
        }
        return keyStoreService.getKeyStore();
    }

    public static String getKeyStorePassword() {
        if (keyStoreService == null) {
            return null;
        }
        return keyStoreService.getKeyStorePassword();
    }

    public static X509Certificate[] getSslTrustCertificates() {
        if (keyStoreService == null) {
            return null;
        }
        return keyStoreService.getSslTrustCertificates();
    }

    public static String getInfoAboutKeyStore(KeyStore keyStore) {
        if (keyStore == null) {
            return null;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder(1000);
            stringBuilder.append(keyStore.getClass().getName()).append('(').append(Integer.toHexString(System.identityHashCode(keyStore))).append(')').append('\n');
            Enumeration<String> enumeration = keyStore.aliases();
            stringBuilder.append("Certificates in the keystore:\n");
            int n = 1;
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!keyStore.isCertificateEntry(string)) continue;
                if (n > 1) {
                    stringBuilder.append("\n\n");
                }
                stringBuilder.append("<<<").append(n).append(",alias=").append(string).append(">>>\n");
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                stringBuilder.append(x509Certificate);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            if (_logger.isDebugEnabled()) {
                _logger.error((Object)"Failed to extract info about the keystore", (Throwable)exception);
            } else {
                _logger.error((Object)("Failed to extract info about the keystore: " + exception.getMessage()));
            }
            return "?";
        }
    }
}

