/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.ssl;

import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vise.util.StringUtil;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class SslThumbprintVerifier
implements ThumbprintVerifier {
    private static final Log _logger = LogFactory.getLog(SslThumbprintVerifier.class);
    private volatile String[] _thumbprints;
    private final boolean _ignoreSslErrors;

    public SslThumbprintVerifier() {
        this._ignoreSslErrors = false;
    }

    public SslThumbprintVerifier(boolean bl) {
        this._ignoreSslErrors = bl;
    }

    public String getThumbprint() {
        String[] stringArray = this._thumbprints;
        if (stringArray == null || stringArray.length != 1) {
            return null;
        }
        return stringArray[0];
    }

    public void setThumbprint(String string) {
        this._thumbprints = new String[]{string};
    }

    public String[] getThumbprints() {
        String[] stringArray = this._thumbprints;
        if (stringArray == null) {
            return null;
        }
        stringArray = Arrays.copyOf(stringArray, stringArray.length);
        return stringArray;
    }

    public void setThumbprints(String[] stringArray) {
        this._thumbprints = stringArray == null || stringArray.length == 0 ? null : Arrays.copyOf(stringArray, stringArray.length);
    }

    public void clearThumbprints() {
        this._thumbprints = null;
    }

    public ThumbprintVerifier.Result verify(String string) {
        _logger.debug((Object)("Verifying the ssl certificate: " + string));
        if (this._ignoreSslErrors) {
            return ThumbprintVerifier.Result.MATCH;
        }
        String[] stringArray = this._thumbprints;
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (StringUtil.isNullOrEmpty((String)string2) || !string2.equalsIgnoreCase(string)) continue;
                return ThumbprintVerifier.Result.MATCH;
            }
        }
        return ThumbprintVerifier.Result.MISMATCH;
    }

    public void onSuccess(X509Certificate[] x509CertificateArray, String string, ThumbprintVerifier.Result result, boolean bl, boolean bl2) throws SSLException {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return;
        }
        _logger.debug((Object)("Ssl certificate is verified successfully: " + string));
    }
}

