/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.tanuki;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.tanukisoftware.wrapper.WrapperSimpleApp;

public final class TanukiWrapperEx
extends WrapperSimpleApp {
    private static final String VECS_KEYSTORE_TYPE = "VKS";
    private static final String MACHINE_SSL_CERT = "MACHINE_SSL_CERT";
    private static final String VECS_LOAD_STORE_PARAM_TYPE = "com.vmware.provider.VecsLoadStoreParameter";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String CLIENT_APP_DATA_FOLDER = System.getenv("VMWARE_CFG_DIR") + FILE_SEPARATOR + "vsphere-client";
    private static final String DEST_KEYSTORE_NAME = "keystore.jks";
    private static final String PASSWORD = UUID.randomUUID().toString();
    private static final String VIRGO_DIR = "org.eclipse.virgo.kernel.home";
    private static final String CONFIG_DIR = System.getProperty("org.eclipse.virgo.kernel.home") + System.getProperty("file.separator") + "configuration";
    private static final AtomicBoolean _INITIALIZED = new AtomicBoolean(false);

    private TanukiWrapperEx(String[] stringArray) {
        super(stringArray);
    }

    public static void main(String[] stringArray) {
        new TanukiWrapperEx(stringArray);
    }

    public void run() {
        TanukiWrapperEx.runCustomAction();
        super.run();
    }

    private static void runCustomAction() {
        boolean bl = _INITIALIZED.compareAndSet(false, true);
        if (!bl) {
            return;
        }
        TanukiWrapperEx.loadKeystore();
    }

    private static void loadKeystore() {
        KeyStore keyStore = TanukiWrapperEx.loadVecsMachineStore();
        File file = new File(CLIENT_APP_DATA_FOLDER, DEST_KEYSTORE_NAME);
        if (file.exists()) {
            boolean bl = file.delete();
            if (!bl) {
                throw new RuntimeException("The old JKS keystore file could not be deleted.");
            }
            System.out.println("Deleted the old JKS file.");
        }
        TanukiWrapperEx.writeKeystoreToFile(keyStore, file);
        TanukiWrapperEx.updateTomcatConfig(file);
    }

    private static KeyStore loadVecsMachineStore() {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(VECS_KEYSTORE_TYPE);
            Class<?> clazz = Class.forName(VECS_LOAD_STORE_PARAM_TYPE);
            KeyStore.LoadStoreParameter loadStoreParameter = (KeyStore.LoadStoreParameter)clazz.getConstructor(String.class).newInstance(MACHINE_SSL_CERT);
            keyStore.load(loadStoreParameter);
            System.out.println("VKS keystore loaded");
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to load Vecs machine store", exception);
        }
        return keyStore;
    }

    private static void writeKeystoreToFile(KeyStore keyStore, File file) {
        KeyStore keyStore2 = null;
        FileOutputStream fileOutputStream = null;
        try {
            keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore2.load(null, PASSWORD.toCharArray());
            TanukiWrapperEx.populateJksKeystore(keyStore, keyStore2);
            fileOutputStream = new FileOutputStream(file);
            keyStore2.store(fileOutputStream, PASSWORD.toCharArray());
            System.out.println("JKS keystore written to file system successfully.");
        }
        catch (Exception exception) {
            throw new RuntimeException("Error when writing to the jks-based keystore - " + file.getPath(), exception);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void populateJksKeystore(KeyStore keyStore, KeyStore keyStore2) {
        try {
            System.out.println("JKS keystore processing aliases...");
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Certificate[] certificateArray = keyStore.getCertificateChain(string);
                Key key = keyStore.getKey(string, null);
                keyStore2.setKeyEntry(string, key, PASSWORD.toCharArray(), certificateArray);
                if (certificateArray == null) continue;
                System.out.println(String.format("JKS keystore alias = %s, certificate count = %d", string, certificateArray.length));
            }
            System.out.println("JKS keystore populated successfully.");
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to copy certificate/key from vecs keystore to jks-based keystore.", exception);
        }
    }

    private static void updateTomcatConfig(File file) {
        try {
            File file2 = new File(CONFIG_DIR, "tomcat-server.xml");
            String string = TanukiWrapperEx.readTextFile(file2);
            String string2 = "keystorePass=\".+?\"";
            String string3 = "keystorePass=\"" + PASSWORD + "\"";
            String string4 = string.replaceFirst(string2, string3);
            String string5 = file.getPath().replace("\\", "/");
            string2 = "keystoreFile=\".+?\"";
            string3 = "keystoreFile=\"" + string5 + "\"";
            string4 = string4.replaceFirst(string2, string3);
            TanukiWrapperEx.writeFile(string4.getBytes(), file2);
            System.out.println("Tomcat config file populated successfully.");
        }
        catch (Exception exception) {
            throw new RuntimeException("Error when updating the tomcat-server.xml file.", exception);
        }
    }

    private static String readTextFile(File file) throws IOException {
        byte[] byArray = TanukiWrapperEx.readFile(file);
        return new String(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file.getPath(), false);
        try {
            fileOutputStream.write(byArray);
        }
        finally {
            fileOutputStream.flush();
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            long l = file.length();
            if (l > Integer.MAX_VALUE) {
                throw new IOException("File too big.");
            }
            byte[] byArray = new byte[(int)l];
            fileInputStream.read(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }
}

