/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class Util {
    private static final String RESOURCE_BUNDLE_NAME = "TaggingService";
    private static final String MANAGED_ENTITY_TYPE = "ManagedEntity";
    private static final String TAG_CATEGORY_PROP = "category";
    private static final String TAG_CATEGORY_TYPE = "inventoryservice:InventoryServiceCategory";
    private static final String TAG_CATEGORY_MULTIPLE_CARDINALITY_PROP = "multipleCardinality";
    private static final String TAG_CATEGORY_CHILD_TAGS_PROP = "childTags";
    private static final String TAG_TYPE = "inventoryservice:InventoryServiceTag";
    private static final String TAG_PROP = "inventoryservice:tag";
    public static final String GLOBAL_SERVER_ID = "GLOBAL";

    public static String getLocalizedString(String string) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (ClassLoader)Util.class.getClassLoader());
    }

    public static String getLocalizedString(String string, String[] stringArray) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (String[])stringArray, (ClassLoader)Util.class.getClassLoader());
    }

    public static void checkValidQuerySpec(QuerySpec querySpec, Class<?>[] classArray) {
        if (querySpec == null) {
            throw new IllegalArgumentException("spec");
        }
        if (querySpec.resourceSpec == null) {
            throw new IllegalArgumentException("spec.resourceSpec");
        }
        boolean bl = false;
        for (Class<?> clazz : classArray) {
            if (!clazz.isInstance(querySpec.resourceSpec.constraint)) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("spec.resourceSpec.constraint");
        }
    }

    public static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?>[] classArray) {
        LinkedList<PropertyDescriptor> linkedList = new LinkedList<PropertyDescriptor>();
        for (Class<?> clazz : classArray) {
            for (Field field : clazz.getFields()) {
                String string = String.format("${%s}", field.getName());
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor();
                propertyDescriptor.name = field.getName();
                propertyDescriptor.title = string;
                propertyDescriptor.description = string;
                propertyDescriptor.isOptional = true;
                propertyDescriptor.providerName = clazz.getName();
                propertyDescriptor.valueTypeName = field.getType().getName();
                linkedList.add(propertyDescriptor);
            }
        }
        return linkedList.toArray(new PropertyDescriptor[linkedList.size()]);
    }

    public static String[] getPropertyNames(Class<?> clazz) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Field field : clazz.getFields()) {
            linkedList.add(field.getName());
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static TypeDescriptor[] getTypeDescriptors(String[] stringArray) {
        LinkedList<TypeDescriptor> linkedList = new LinkedList<TypeDescriptor>();
        for (String string : stringArray) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("userSearchable", "true");
            String string2 = String.format("${%s}", string);
            TypeDescriptor typeDescriptor = new TypeDescriptor();
            typeDescriptor.title = string2;
            typeDescriptor.description = string2;
            typeDescriptor.name = string;
            typeDescriptor.tags = hashMap;
            linkedList.add(typeDescriptor);
        }
        return linkedList.toArray(new TypeDescriptor[linkedList.size()]);
    }

    public static VcService getVcServiceByUuid(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Util.getLocalizedString("error.invalidVcUuid", new String[]{string}));
        }
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup linkedVcGroup = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string);
        for (VcService vcService : linkedVcGroup.getVcServices()) {
            ServiceEndpointEx[] serviceEndpointExArray;
            if (vcService.getServiceGuid().equals(string)) {
                return vcService;
            }
            for (ServiceEndpointEx serviceEndpointEx : serviceEndpointExArray = vcService.getServiceEndPoints()) {
                if (!serviceEndpointEx.getInstanceUuid().equals(string) || serviceEndpointEx.getServiceEndpointType() != ServiceEndpointType.IS) continue;
                return vcService;
            }
        }
        throw new IllegalArgumentException(Util.getLocalizedString("error.invalidVcUuid", new String[]{string}));
    }

    public static URI toURI(Object object) throws URISyntaxException {
        return new URI(QueryUtil.getReferenceUid((Object)object));
    }

    public static Object[] filterAssignedObjects(DataService dataService, ManagedObjectReference managedObjectReference, Object[] objectArray) throws Exception {
        ResultItem[] resultItemArray;
        Object object;
        if (objectArray == null || objectArray.length == 0) {
            return new Object[0];
        }
        Constraint[] constraintArray = new Constraint[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            constraintArray[i] = QueryUtil.createObjectIdentityConstraint((Object)object);
        }
        CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])constraintArray, (Conjoiner)Conjoiner.OR);
        object = QueryUtil.createRelationalConstraint((String)TAG_PROP, (Constraint)QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{QueryUtil.createObjectIdentityConstraint((Object)managedObjectReference), QueryUtil.createRelationalConstraint((String)TAG_CATEGORY_PROP, (Constraint)QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{QueryUtil.createPropertyConstraint((String)TAG_CATEGORY_TYPE, (String)TAG_CATEGORY_MULTIPLE_CARDINALITY_PROP, (Comparator)Comparator.EQUALS, (Object)false), QueryUtil.createRelationalConstraint((String)TAG_CATEGORY_CHILD_TAGS_PROP, (Constraint)QueryUtil.createObjectIdentityConstraint((Object)managedObjectReference), (Boolean)false, (String)TAG_CATEGORY_TYPE)}, (Conjoiner)Conjoiner.AND), (Boolean)false, (String)TAG_TYPE)}, (Conjoiner)Conjoiner.OR), (Boolean)false, (String)MANAGED_ENTITY_TYPE);
        CompositeConstraint compositeConstraint2 = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{compositeConstraint, object}, (Conjoiner)Conjoiner.EXCEPT);
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)compositeConstraint2, (String[])new String[]{"name"});
        ResultSet resultSet = QueryUtil.getData((DataService)dataService, (QuerySpec)querySpec);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (resultSet != null && (resultItemArray = resultSet.items) != null && resultItemArray.length > 0 && resultItemArray[0] != null) {
            for (ResultItem resultItem : resultItemArray) {
                arrayList.add(resultItem.resourceObject);
            }
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    public static String formatLogMessage(String string, String string2, Object ... objectArray) {
        String string3 = String.format(string2, objectArray);
        String string4 = String.format("[Server: %1$s] %2$s", string, string3);
        return string4;
    }

    public static boolean isServiceUnavailable(Throwable throwable) {
        return throwable instanceof UnexpectedStatusCodeException && ((UnexpectedStatusCodeException)throwable).getStatusCode() == 503;
    }
}

