/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging.impl;

import com.vmware.vim.binding.dataservice.tagging.Category;
import com.vmware.vim.binding.dataservice.tagging.CategoryInfo;
import com.vmware.vim.binding.dataservice.tagging.Tag;
import com.vmware.vim.binding.dataservice.tagging.TagInfo;
import com.vmware.vim.binding.dataservice.tagging.TagManager;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.query.client.Client;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vsphere.client.tagging.TagService;
import java.net.URI;
import java.util.concurrent.ExecutionException;

public class TagServiceImpl
implements TagService {
    private final Client _queryClient;

    TagServiceImpl(Client client) {
        this._queryClient = client;
    }

    @Override
    public ManagedObjectReference createTag(ManagedObjectReference managedObjectReference, TagInfo tagInfo) throws InterruptedException, ExecutionException {
        Category category = this.createStub(Category.class, managedObjectReference);
        BlockingFuture blockingFuture = new BlockingFuture();
        category.createTag(tagInfo, (Future)blockingFuture);
        return (ManagedObjectReference)blockingFuture.get();
    }

    @Override
    public ManagedObjectReference createCategory(CategoryInfo categoryInfo) throws InterruptedException, ExecutionException {
        BlockingFuture blockingFuture = new BlockingFuture();
        this._queryClient.getTagManager().createCategory(categoryInfo, (Future)blockingFuture);
        return (ManagedObjectReference)blockingFuture.get();
    }

    @Override
    public void updateCategory(ManagedObjectReference managedObjectReference, CategoryInfo categoryInfo) throws InterruptedException, ExecutionException {
        Category category = this.createStub(Category.class, managedObjectReference);
        BlockingFuture blockingFuture = new BlockingFuture();
        category.updateInfo(categoryInfo, (Future)blockingFuture);
        blockingFuture.get();
    }

    @Override
    public TagManager.AttachTagsResult[] attachTags(ManagedObjectReference[] managedObjectReferenceArray, URI[] uRIArray) throws InterruptedException, ExecutionException {
        BlockingFuture blockingFuture = new BlockingFuture();
        this._queryClient.getTagManager().bulkAttachTags(uRIArray, managedObjectReferenceArray, (Future)blockingFuture);
        TagManager.AttachTagsResult[] attachTagsResultArray = (TagManager.AttachTagsResult[])blockingFuture.get();
        return attachTagsResultArray;
    }

    @Override
    public TagManager.DetachTagsResult[] detachTags(ManagedObjectReference[] managedObjectReferenceArray, URI[] uRIArray) throws InterruptedException, ExecutionException {
        BlockingFuture blockingFuture = new BlockingFuture();
        this._queryClient.getTagManager().bulkDetachTags(uRIArray, managedObjectReferenceArray, (Future)blockingFuture);
        TagManager.DetachTagsResult[] detachTagsResultArray = (TagManager.DetachTagsResult[])blockingFuture.get();
        return detachTagsResultArray;
    }

    @Override
    public void updateTag(ManagedObjectReference managedObjectReference, TagInfo tagInfo) throws InterruptedException, ExecutionException {
        Tag tag = this.createStub(Tag.class, managedObjectReference);
        BlockingFuture blockingFuture = new BlockingFuture();
        tag.updateInfo(tagInfo, (Future)blockingFuture);
        blockingFuture.get();
    }

    @Override
    public void deleteTag(ManagedObjectReference managedObjectReference) throws InterruptedException, ExecutionException {
        Tag tag = this.createStub(Tag.class, managedObjectReference);
        BlockingFuture blockingFuture = new BlockingFuture();
        tag.delete((Future)blockingFuture);
        blockingFuture.get();
    }

    @Override
    public void deleteCategory(ManagedObjectReference managedObjectReference) throws InterruptedException, ExecutionException {
        Category category = this.createStub(Category.class, managedObjectReference);
        BlockingFuture blockingFuture = new BlockingFuture();
        category.delete((Future)blockingFuture);
        blockingFuture.get();
    }

    private <T extends ManagedObject> T createStub(Class<T> clazz, ManagedObjectReference managedObjectReference) {
        ManagedObject managedObject = this._queryClient.getVmomiClient().createStub(clazz, managedObjectReference);
        return (T)managedObject;
    }
}

