/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging.impl;

import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vim.query.client.Client;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.tagging.QueryClientManager;
import com.vmware.vsphere.client.tagging.TagService;
import com.vmware.vsphere.client.tagging.TagServiceLocator;
import com.vmware.vsphere.client.tagging.Util;
import com.vmware.vsphere.client.tagging.exception.AuthenticationException;
import com.vmware.vsphere.client.tagging.exception.HostConnectException;
import com.vmware.vsphere.client.tagging.impl.TagServiceImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TagServiceLocatorImpl
implements TagServiceLocator,
UserSessionListener {
    private static final Log _logger = LogFactory.getLog(TagServiceLocatorImpl.class);
    private static final String QUERY_CLIENT_PER_VC_SERVICE_MAP = "TaggingServiceLocator.queryClientPerVcMap";
    private final QueryClientManager _clientManager;
    private final ComponentManagerService _componentManagerService;
    private volatile String _serverGuidForTagging;

    public TagServiceLocatorImpl(QueryClientManager queryClientManager, ComponentManagerService componentManagerService) {
        this._clientManager = queryClientManager;
        this._componentManagerService = componentManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public TagService getTagService(String string) throws Exception {
        LinkedVcGroup linkedVcGroup;
        block7: {
            LinkedVcGroup[] linkedVcGroupArray;
            Object object;
            if (string == null || "GLOBAL".equals(string)) {
                object = this._serverGuidForTagging;
                if (object == null) {
                    linkedVcGroupArray = this;
                    // MONITORENTER : this
                    object = this._serverGuidForTagging;
                    if (object == null) {
                        object = super.chooseVcForTaggingOperations();
                        this._serverGuidForTagging = object;
                    }
                    // MONITOREXIT : linkedVcGroupArray
                }
                string = object;
            }
            if (string != null) return this.getTagServiceInternal(string);
            object = VimSessionUtil.getLinkedVcGroupRegistry();
            linkedVcGroupArray = object.getUtils().getStartupLinkedVcGroups();
            string = linkedVcGroupArray[0].getStartUpVcService().getServiceGuid();
            if (linkedVcGroupArray.length <= 1) return this.getTagServiceInternal(string);
            LinkedVcGroup[] linkedVcGroupArray2 = linkedVcGroupArray;
            int n = linkedVcGroupArray2.length;
            int n2 = 0;
            while (n2 < n) {
                linkedVcGroup = linkedVcGroupArray2[n2];
                VcService vcService = linkedVcGroup.getStartUpVcService();
                if (!VcServiceUtil.is2014VcOrLaterByVersion((String)vcService.getServiceVersion())) {
                    ++n2;
                    continue;
                }
                break block7;
            }
            return this.getTagServiceInternal(string);
        }
        string = linkedVcGroup.getStartUpVcService().getServiceGuid();
        return this.getTagServiceInternal(string);
    }

    private TagService getTagServiceInternal(String string) throws Exception {
        Object object;
        LinkedVcGroupRegistry linkedVcGroupRegistry;
        VcService vcService = Util.getVcServiceByUuid(string);
        if (vcService == null) {
            linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
            object = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string);
            Collection collection = object.getVcServices();
            if (collection.isEmpty()) {
                VcService vcService2 = object.getStartUpVcService();
                String string2 = vcService2 != null ? vcService2.getServiceUrl() : "???";
                throw new IllegalStateException(LinkedVcGroup.class.getSimpleName() + " " + string2 + " doesn't contain " + "any active VC services. Check the log to find out the reason.");
            }
            vcService = (VcService)collection.iterator().next();
        }
        linkedVcGroupRegistry = this.getClient(vcService);
        object = new TagServiceImpl((Client)linkedVcGroupRegistry);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Client getClient(VcService vcService) throws AuthenticationException, HostConnectException {
        Client client = null;
        Map map = (Map)SessionUtil.getData((String)QUERY_CLIENT_PER_VC_SERVICE_MAP, null, (boolean)true);
        if (map == null) {
            _logger.error((Object)"Something went wrong with the user session. The queryClientPerVcService map is null");
            throw new IllegalStateException("The tagging service client could not be retrievedbecause queryClientPerVcMap is null.");
        }
        HttpSession httpSession = SessionUtil.getHttpSession();
        CountDownLatch countDownLatch = SessionUtil.getSessionMonitor((HttpSession)httpSession);
        synchronized (countDownLatch) {
            if (map.containsKey(vcService)) {
                client = (Client)map.get(vcService);
            } else {
                client = this._clientManager.createClient(vcService);
                map.put(vcService, client);
            }
        }
        return client;
    }

    private String chooseVcForTaggingOperations() {
        String string = this._componentManagerService.getHostId();
        if (string == null) {
            return null;
        }
        ServiceTypeImpl serviceTypeImpl = new ServiceTypeImpl("com.vmware.cis", "vcenterserver");
        SearchCriteriaImpl searchCriteriaImpl = new SearchCriteriaImpl();
        searchCriteriaImpl.setServiceType((ServiceType)serviceTypeImpl);
        ServiceInfo[] serviceInfoArray = null;
        try {
            serviceInfoArray = this._componentManagerService.search((SearchCriteria)searchCriteriaImpl);
        }
        catch (ComponentManagerFault componentManagerFault) {
            _logger.error((Object)"Component manager search encountered an error", (Throwable)componentManagerFault);
            return null;
        }
        if (serviceInfoArray != null) {
            for (ServiceInfo serviceInfo : serviceInfoArray) {
                if (!string.equals(serviceInfo.getHostId())) continue;
                return serviceInfo.getServiceId();
            }
        }
        return null;
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        SessionUtil.setData((String)QUERY_CLIENT_PER_VC_SERVICE_MAP, new HashMap(), (HttpSession)httpSessionEvent.getSession());
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        Map map = (Map)SessionUtil.getData((String)QUERY_CLIENT_PER_VC_SERVICE_MAP, (HttpSession)httpSessionEvent.getSession(), (boolean)true);
        if (map == null) {
            _logger.error((Object)"Something went wrong with the user session. The queryClientPerVcService map is null");
            throw new IllegalStateException("The queryClientPerVcMap is null");
        }
        for (Map.Entry entry : map.entrySet()) {
            Client client = (Client)entry.getValue();
            VcService vcService = (VcService)entry.getKey();
            this._clientManager.closeClient(client, vcService);
        }
        SessionUtil.removeData((String)QUERY_CLIENT_PER_VC_SERVICE_MAP, (HttpSession)httpSessionEvent.getSession());
    }
}

