/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.query.util.ResultUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaggingPropertyProvider
implements PropertyProviderBean {
    private final DataService _dataService;
    private final QuerySpecBuilder _querySpecBuilder;
    private static final String ASSOCIABLE_WITH_ALL_ENTITY_TYPES = "associableWithAllEntityTypes";
    private static final String ASSOCIABLE_ENTITY_TYPE_NAME = "associableEntityTypeName";
    private static final String TAG_CATEGORY_PROP = "category";
    private static final String TAG_CATEGORY_TYPE = "inventoryservice:InventoryServiceCategory";
    private static final String TAG_CATEGORY_MULTIPLE_CARDINALITY_PROP = "multipleCardinality";
    private static final String TAG_CATEGORY_CHILD_TAGS_PROP = "childTags";
    private static final String TAG_CATEGORY_ENTITY_PROP = "entity";
    private static final String TAG_TYPE = "inventoryservice:InventoryServiceTag";
    private static final String HOSTSYSTEM = "HostSystem";

    public TaggingPropertyProvider(DataService dataService, QuerySpecBuilder querySpecBuilder) {
        this._dataService = dataService;
        this._querySpecBuilder = querySpecBuilder;
    }

    @type(value="Folder,Datacenter,HostSystem,ComputeResource,VirtualMachine,ClusterComputeResource,Datastore,DistributedVirtualPortgroup,DistributedVirtualSwitch,VmwareDistributedVirtualSwitch,ResourcePool,VirtualApp,StoragePod,Network,com.vmware.content.LibraryModel,com.vmware.content.library.ItemModel")
    public Object getAssignableTagsForTarget(ManagedObjectReference managedObjectReference) {
        CompositeConstraint compositeConstraint = this._querySpecBuilder.createCompositeConstraint(new Constraint[]{this.associableTagsConstraint(managedObjectReference), this.categoryForTagConstraint(managedObjectReference), this.cardinalityForTagsConstraint(managedObjectReference)}, Conjoiner.EXCEPT);
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec((Constraint)compositeConstraint, new String[]{"name", TAG_CATEGORY_PROP, "description"});
        CompositeConstraint compositeConstraint2 = this._querySpecBuilder.createCompositeConstraint(new Constraint[]{this.associableTagsConstraint(managedObjectReference), this.categoryForTagConstraint(managedObjectReference), this.cardinalityForTagsConstraint(managedObjectReference)}, Conjoiner.EXCEPT);
        RelationalConstraint relationalConstraint = this._querySpecBuilder.createRelationalConstraint(TAG_CATEGORY_PROP, (Constraint)compositeConstraint2, Boolean.valueOf(true), TAG_CATEGORY_TYPE);
        QuerySpec querySpec2 = this._querySpecBuilder.buildQuerySpec((Constraint)relationalConstraint, new String[]{"name"});
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec, querySpec2};
        Response response = this._dataService.getData(requestSpec);
        return this.formatAssociableTagsResultSet(response.resultSet[0], response.resultSet[1]);
    }

    @type(value="Folder,Datacenter,HostSystem,ComputeResource,VirtualMachine,ClusterComputeResource,Datastore,DistributedVirtualPortgroup,DistributedVirtualSwitch,VmwareDistributedVirtualSwitch,ResourcePool,VirtualApp,StoragePod,Network,com.vmware.content.LibraryModel,com.vmware.content.library.ItemModel")
    public List<Map<String, Object>> getAllTags(ManagedObjectReference managedObjectReference) {
        Constraint constraint = new Constraint();
        constraint.targetType = TAG_TYPE;
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(constraint, new String[]{"name", "description", "categoryName"});
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        return this.formatAllTagsResultSet(response.resultSet[0]);
    }

    private Constraint associableTagsConstraint(ManagedObjectReference managedObjectReference) {
        PropertyConstraint propertyConstraint = this._querySpecBuilder.createPropertyConstraint(TAG_CATEGORY_TYPE, ASSOCIABLE_WITH_ALL_ENTITY_TYPES, Comparator.EQUALS, (Object)true);
        PropertyConstraint propertyConstraint2 = this._querySpecBuilder.createPropertyConstraint(TAG_CATEGORY_TYPE, ASSOCIABLE_ENTITY_TYPE_NAME, Comparator.EQUALS, (Object)managedObjectReference.getType());
        CompositeConstraint compositeConstraint = this._querySpecBuilder.createCompositeConstraint(new Constraint[]{propertyConstraint, propertyConstraint2}, Conjoiner.OR);
        RelationalConstraint relationalConstraint = this._querySpecBuilder.createRelationalConstraint(TAG_CATEGORY_PROP, (Constraint)compositeConstraint, Boolean.valueOf(false), TAG_TYPE);
        return this._querySpecBuilder.createCompositeConstraint(new Constraint[]{relationalConstraint}, Conjoiner.AND);
    }

    private Constraint categoryForTagConstraint(ManagedObjectReference managedObjectReference) {
        ObjectIdentityConstraint objectIdentityConstraint = this._querySpecBuilder.createObjectIdentityConstraint((Object)managedObjectReference);
        return this._querySpecBuilder.createRelationalConstraint(TAG_CATEGORY_ENTITY_PROP, (Constraint)objectIdentityConstraint, Boolean.valueOf(false), TAG_TYPE);
    }

    private Constraint cardinalityForTagsConstraint(ManagedObjectReference managedObjectReference) {
        ObjectIdentityConstraint objectIdentityConstraint = this._querySpecBuilder.createObjectIdentityConstraint((Object)managedObjectReference);
        RelationalConstraint relationalConstraint = this._querySpecBuilder.createRelationalConstraint(TAG_CATEGORY_ENTITY_PROP, (Constraint)objectIdentityConstraint, Boolean.valueOf(false), TAG_TYPE);
        RelationalConstraint relationalConstraint2 = this._querySpecBuilder.createRelationalConstraint(TAG_CATEGORY_CHILD_TAGS_PROP, (Constraint)relationalConstraint, Boolean.valueOf(false), TAG_CATEGORY_TYPE);
        PropertyConstraint propertyConstraint = this._querySpecBuilder.createPropertyConstraint(TAG_CATEGORY_TYPE, TAG_CATEGORY_MULTIPLE_CARDINALITY_PROP, Comparator.EQUALS, (Object)false);
        CompositeConstraint compositeConstraint = this._querySpecBuilder.createCompositeConstraint(new Constraint[]{propertyConstraint, relationalConstraint2}, Conjoiner.AND);
        return this._querySpecBuilder.createRelationalConstraint(TAG_CATEGORY_PROP, (Constraint)compositeConstraint, Boolean.valueOf(false), TAG_TYPE);
    }

    private List<Map<String, Object>> formatAllTagsResultSet(ResultSet resultSet) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (ResultItem resultItem : resultSet.items) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", ResultUtil.getPropertyValue((ResultItem)resultItem, (String)"name").value.toString());
            hashMap.put("description", ResultUtil.getPropertyValue((ResultItem)resultItem, (String)"description").value.toString());
            hashMap.put("categoryName", ResultUtil.getPropertyValue((ResultItem)resultItem, (String)"categoryName").value.toString());
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private List<Map<String, Object>> formatAssociableTagsResultSet(ResultSet resultSet, ResultSet resultSet2) {
        ArrayList arrayList = null;
        if (resultSet != null && resultSet2 != null) {
            arrayList = new ArrayList();
            for (ResultItem resultItem : resultSet.items) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("name", ResultUtil.getPropertyValue((ResultItem)resultItem, (String)"name").value.toString());
                hashMap.put("description", ResultUtil.getPropertyValue((ResultItem)resultItem, (String)"description").value.toString());
                String string = this.findCategoryInCategoryList(resultSet2, ResultUtil.getPropertyValue((ResultItem)resultItem, (String)TAG_CATEGORY_PROP));
                hashMap.put("categoryName", string);
                hashMap.put("resourceObject", resultItem.resourceObject);
                arrayList.add(hashMap);
            }
        }
        return arrayList;
    }

    private String findCategoryInCategoryList(ResultSet resultSet, PropertyValue propertyValue) {
        for (ResultItem resultItem : resultSet.items) {
            if (!propertyValue.value.equals(resultItem.resourceObject)) continue;
            return ResultUtil.getPropertyValue((ResultItem)resultItem, (String)"name").value.toString();
        }
        return null;
    }
}

