/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.bind.ArrayTypeAdapter;
import com.google.gson.internal.bind.CollectionTypeAdapterFactory;
import com.google.gson.internal.bind.ObjectTypeAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.internal.bind.StringToValueMapTypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MiniGson {
    private final ThreadLocal<Map<TypeToken<?>, FutureTypeAdapter<?>>> calls = new ThreadLocal<Map<TypeToken<?>, FutureTypeAdapter<?>>>(){

        @Override
        protected Map<TypeToken<?>, FutureTypeAdapter<?>> initialValue() {
            return new HashMap();
        }
    };
    private final List<TypeAdapter.Factory> factories;

    private MiniGson(Builder builder) {
        ConstructorConstructor constructorConstructor = new ConstructorConstructor();
        ArrayList<TypeAdapter.Factory> factories = new ArrayList<TypeAdapter.Factory>();
        if (builder.addDefaultFactories) {
            factories.add(TypeAdapters.BOOLEAN_FACTORY);
            factories.add(TypeAdapters.INTEGER_FACTORY);
            factories.add(TypeAdapters.DOUBLE_FACTORY);
            factories.add(TypeAdapters.FLOAT_FACTORY);
            factories.add(TypeAdapters.LONG_FACTORY);
            factories.add(TypeAdapters.STRING_FACTORY);
        }
        factories.addAll(builder.factories);
        if (builder.addDefaultFactories) {
            factories.add(new CollectionTypeAdapterFactory(constructorConstructor));
            factories.add(new StringToValueMapTypeAdapterFactory(constructorConstructor));
            factories.add(ArrayTypeAdapter.FACTORY);
            factories.add(ObjectTypeAdapter.FACTORY);
            factories.add(new ReflectiveTypeAdapterFactory(constructorConstructor));
        }
        this.factories = Collections.unmodifiableList(factories);
    }

    public <T> TypeAdapter<T> getAdapter(TypeToken<T> type) {
        Map<TypeToken<?>, FutureTypeAdapter<?>> threadCalls = this.calls.get();
        FutureTypeAdapter<?> ongoingCall = threadCalls.get(type);
        if (ongoingCall != null) {
            return ongoingCall;
        }
        FutureTypeAdapter<T> call = new FutureTypeAdapter<T>();
        threadCalls.put(type, call);
        try {
            for (TypeAdapter.Factory factory : this.factories) {
                TypeAdapter<T> candidate = factory.create(this, type);
                if (candidate == null) continue;
                call.setDelegate(candidate);
                TypeAdapter<T> typeAdapter = candidate;
                return typeAdapter;
            }
            throw new IllegalArgumentException("This MiniGSON cannot handle " + type);
        }
        finally {
            threadCalls.remove(type);
        }
    }

    public <T> TypeAdapter<T> getNextAdapter(TypeAdapter.Factory skipPast, TypeToken<T> type) {
        boolean skipPastFound = false;
        for (TypeAdapter.Factory factory : this.factories) {
            if (!skipPastFound) {
                if (factory != skipPast) continue;
                skipPastFound = true;
                continue;
            }
            TypeAdapter<T> candidate = factory.create(this, type);
            if (candidate == null) continue;
            return candidate;
        }
        throw new IllegalArgumentException("This MiniGSON cannot serialize " + type);
    }

    public <T> TypeAdapter<T> getAdapter(Class<T> type) {
        return this.getAdapter(TypeToken.get(type));
    }

    public List<TypeAdapter.Factory> getFactories() {
        return this.factories;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        private final List<TypeAdapter.Factory> factories = new ArrayList<TypeAdapter.Factory>();
        boolean addDefaultFactories = true;

        public Builder factory(TypeAdapter.Factory factory) {
            this.factories.add(factory);
            return this;
        }

        public Builder withoutDefaultFactories() {
            this.addDefaultFactories = false;
            return this;
        }

        public <T> Builder typeAdapter(Class<T> type, TypeAdapter<T> typeAdapter) {
            this.factories.add(TypeAdapters.newFactory(type, typeAdapter));
            return this;
        }

        public <T> Builder typeAdapter(TypeToken<T> type, TypeAdapter<T> typeAdapter) {
            this.factories.add(TypeAdapters.newFactory(type, typeAdapter));
            return this;
        }

        public <T> Builder typeHierarchyAdapter(Class<T> type, TypeAdapter<T> typeAdapter) {
            this.factories.add(TypeAdapters.newTypeHierarchyFactory(type, typeAdapter));
            return this;
        }

        public MiniGson build() {
            return new MiniGson(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FutureTypeAdapter<T>
    extends TypeAdapter<T> {
        private TypeAdapter<T> delegate;

        FutureTypeAdapter() {
        }

        public void setDelegate(TypeAdapter<T> typeAdapter) {
            if (this.delegate != null) {
                throw new AssertionError();
            }
            this.delegate = typeAdapter;
        }

        @Override
        public T read(JsonReader reader) throws IOException {
            if (this.delegate == null) {
                throw new IllegalStateException();
            }
            return this.delegate.read(reader);
        }

        @Override
        public void write(JsonWriter writer, T value) throws IOException {
            if (this.delegate == null) {
                throw new IllegalStateException();
            }
            this.delegate.write(writer, value);
        }
    }
}

