/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm;

import com.vmware.cis.services.common.sso.SsoOverRestHelper;
import com.vmware.cis.services.common.sso.SsoOverRestRequest;
import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceEndPointData;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointDataImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointTypeImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceInfoImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.http.Request;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.common.Environment;
import com.vmware.vise.util.concurrent.BlockingUtil;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.net.ssl.SSLConfigurationProviderBuilder;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.cm.CatalogServiceProviderInfo;
import com.vmware.vise.vim.cm.CmLocalizationUtil;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.cm.LocalizedMessageDictionary;
import com.vmware.vise.vim.commons.i18n.CatalogManager;
import com.vmware.vise.vim.commons.i18n.CatalogManagerAcceptingLocales;
import com.vmware.vise.vim.commons.i18n.CatalogRetriever;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.internal.Config;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class CmCatalogManager
implements UserSessionListener,
CatalogManager,
CatalogRetriever,
CatalogManagerAcceptingLocales {
    private static final String FILE_FORMAT = ".zip";
    private static final String FILE_SEPARATOR = Environment.fileSeparator();
    private static final String CATALOG_FOLDER = Environment.clientAppDataFolder() + FILE_SEPARATOR + "cmCatalog" + FILE_SEPARATOR;
    private static final Log _logger = LogFactory.getLog(CmCatalogManager.class);
    private static final String RESOURCE_BUNDLE_ENDPOINT_TYPE = "com.vmware.cis.common.resourcebundle";
    private static final String RESOURCE_BUNDLE_BASENAME = "com.vmware.cis.common.resourcebundle.basename";
    private static final String RESOURCE_BUNDLE_BASENAME_DELIMITER = ":";
    private static final String RESOURCE_BUNDLE_VERSION = "com.vmware.cis.common.resourcebundle.version";
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static final int HEADER_CHUNK_SIZE = 1024;
    private static final KeyAnyValue[] EMPTY_KEY_ANY_VALUE_ARRAY = new KeyAnyValue[0];
    private static final KeyAnyValue[][] EMPTY_KEY_ANY_VALUE_ARRAYS = new KeyAnyValue[][]{new KeyAnyValue[0]};
    private final ComponentManagerService _cmService;
    private final SsoSolutionUser _ngcSolutionUser;
    private final KeystoreService _ksService;
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private final Set<String> _missingLocalizationKeys = new HashSet<String>();
    private static final ExecutorService EXECUTOR = ThreadPoolFactory.newQueingCachedThreadPool((int)100, (ThreadFactory)new WorkerThreadFactory("cm-catalog-manager-pool"), (long)5L, (TimeUnit)TimeUnit.MINUTES, (long)1L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CALLER_RUNS);
    private final LocalizedMessageDictionary _propertyDictionary;
    private final Object _lock = new Object();
    private final Lock _syncLock = new ReentrantLock();
    private final CopyOnWriteArraySet<Locale> _locales = new CopyOnWriteArraySet();
    private final ConcurrentMap<String, CatalogTask> _serviceProviderTaskById = new ConcurrentHashMap<String, CatalogTask>();

    @Deprecated
    public CmCatalogManager(ComponentManagerService componentManagerService, SsoSolutionUser ssoSolutionUser, LocalizedMessageDictionary localizedMessageDictionary, KeystoreService keystoreService) {
        this(componentManagerService, ssoSolutionUser, localizedMessageDictionary, keystoreService, CmCatalogManager.createLegacySSLConfigurationProvider());
    }

    public CmCatalogManager(ComponentManagerService componentManagerService, SsoSolutionUser ssoSolutionUser, LocalizedMessageDictionary localizedMessageDictionary, KeystoreService keystoreService, SSLConfigurationProvider sSLConfigurationProvider) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{componentManagerService, ssoSolutionUser, localizedMessageDictionary, sSLConfigurationProvider});
        this._cmService = componentManagerService;
        this._ngcSolutionUser = ssoSolutionUser;
        this._propertyDictionary = localizedMessageDictionary;
        this._ksService = keystoreService;
        this._sslConfigurationProvider = sSLConfigurationProvider;
        this._locales.add(DEFAULT_LOCALE);
        this._locales.add(Locale.getDefault());
    }

    @Deprecated
    public CmCatalogManager(ComponentManagerService componentManagerService, SsoSolutionUser ssoSolutionUser, KeystoreService keystoreService) {
        this(componentManagerService, ssoSolutionUser, new LocalizedMessageDictionary("Locale", DEFAULT_LOCALE), keystoreService, CmCatalogManager.createLegacySSLConfigurationProvider());
    }

    public CmCatalogManager(ComponentManagerService componentManagerService, SsoSolutionUser ssoSolutionUser, KeystoreService keystoreService, SSLConfigurationProvider sSLConfigurationProvider) {
        this(componentManagerService, ssoSolutionUser, new LocalizedMessageDictionary("Locale", DEFAULT_LOCALE), keystoreService, sSLConfigurationProvider);
    }

    private static SSLConfigurationProvider createLegacySSLConfigurationProvider() {
        return new SSLConfigurationProviderBuilder().build();
    }

    public void init() {
        LocalizationUtil.setCatalogManager((CatalogManager)this);
        this.doInitCatalogInfo(null, true);
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        SessionUtil.setData((String)"Locale", (Object)locale);
        String string = httpSessionEvent.getSession().getId();
        _logger.debug((Object)("CmCatalogManager init start " + string));
        this.doInitCatalogInfo(locale, false);
    }

    private Future<SyncWorkItems> doInitCatalogInfo(Locale locale, Boolean bl) {
        Callable<SyncWorkItems> callable = this.getInitTask(locale, bl);
        Future<SyncWorkItems> future = EXECUTOR.submit(callable);
        return future;
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        String string = httpSessionEvent.getSession().getId();
        _logger.debug((Object)("CmCatalogManager init complete " + string));
    }

    public String getLocalizedMessage(String string, KeyAnyValue[] keyAnyValueArray) {
        return this.getLocalizedMessage(string, keyAnyValueArray, 0);
    }

    public String getLocalizedMessage(String string, KeyAnyValue[] keyAnyValueArray, Locale locale) {
        return this.getLocalizedMessage(string, keyAnyValueArray, 0, locale);
    }

    public String getLocalizedMessage(String string, KeyAnyValue[] keyAnyValueArray, int n) {
        return this.getLocalizedMessage(string, keyAnyValueArray, n, null);
    }

    public String getLocalizedMessage(String string, KeyAnyValue[] keyAnyValueArray, int n, Locale locale) {
        KeyAnyValue[][] keyAnyValueArray2;
        if (string == null) {
            return null;
        }
        String[] stringArray = new String[]{string};
        if (keyAnyValueArray == null) {
            keyAnyValueArray2 = EMPTY_KEY_ANY_VALUE_ARRAYS;
        } else {
            KeyAnyValue[][] keyAnyValueArrayArray = new KeyAnyValue[1][];
            keyAnyValueArray2 = keyAnyValueArrayArray;
            keyAnyValueArrayArray[0] = keyAnyValueArray;
        }
        Map<String, String> map = this.getLocalizedMessage(stringArray, keyAnyValueArray2, n, locale);
        return map.get(string);
    }

    public Map<String, String> getLocalizedMessage(String[] stringArray, KeyAnyValue[][] keyAnyValueArray) {
        return this.getLocalizedMessage(stringArray, keyAnyValueArray, 0);
    }

    public Map<String, String> getLocalizedMessage(String[] stringArray, KeyAnyValue[][] keyAnyValueArray, Locale locale) {
        return this.getLocalizedMessage(stringArray, keyAnyValueArray, 0, locale);
    }

    public Map<String, String> getLocalizedMessage(String[] stringArray, KeyAnyValue[][] keyAnyValueArray, int n) {
        return this.getLocalizedMessage(stringArray, keyAnyValueArray, n, null);
    }

    public Map<String, String> getLocalizedMessage(String[] stringArray, KeyAnyValue[][] keyAnyValueArray, int n, Locale locale) {
        Map<String, String> map = this.getLocalizedMessageInternal(stringArray, keyAnyValueArray, locale);
        if (n == 0) {
            return map;
        }
        Map<String, KeyAnyValue[]> map2 = CmCatalogManager.getUnlocalizedKeys(map, stringArray, keyAnyValueArray);
        if (map2.isEmpty()) {
            return map;
        }
        Map<String, String> map3 = this.getMissingLocalizedMessage(map2, n, locale);
        map.putAll(map3);
        return map;
    }

    private Map<String, String> getLocalizedMessageInternal(String[] stringArray, KeyAnyValue[][] keyAnyValueArray, Locale locale) {
        Map<String, String> map = this._propertyDictionary.getLocalizedMessages(stringArray, keyAnyValueArray, locale);
        return map;
    }

    private static Map<String, KeyAnyValue[]> getUnlocalizedKeys(Map<String, String> map, String[] stringArray, KeyAnyValue[][] keyAnyValueArray) {
        HashMap<String, KeyAnyValue[]> hashMap = new HashMap<String, KeyAnyValue[]>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string != map.get(string)) continue;
            hashMap.put(string, keyAnyValueArray == null ? EMPTY_KEY_ANY_VALUE_ARRAY : keyAnyValueArray[i]);
        }
        return hashMap;
    }

    private Map<String, String> getMissingLocalizedMessage(Map<String, KeyAnyValue[]> map, int n, Locale locale) {
        Map<String, String> map2 = new HashMap<String, String>(map.size());
        ArrayList<String> arrayList = new ArrayList<String>(map.size());
        for (String object2 : map.keySet()) {
            if (this._missingLocalizationKeys.contains(object2)) continue;
            arrayList.add(object2);
        }
        if (arrayList.isEmpty()) {
            return map2;
        }
        _logger.warn((Object)String.format("Catalog sync will be triggered due to missing keys = %s", ObjectUtil.prettyPrint(arrayList)));
        this.sync(n < 0 ? Config.CM_CATALOG_MANAGER_SYNC_TIMEOUT : (long)n);
        Iterator<String> iterator = CmCatalogManager.toKeyAndEntryArrays(map);
        map2 = this.getLocalizedMessageInternal((String[])((Pair)iterator).first, (KeyAnyValue[][])((Pair)iterator).second, locale);
        Map<String, KeyAnyValue[]> map3 = CmCatalogManager.getUnlocalizedKeys(map2, (String[])((Pair)iterator).first, (KeyAnyValue[][])((Pair)iterator).second);
        if (!map3.isEmpty()) {
            _logger.warn((Object)String.format("After catalog sync, still missing key = %s", ObjectUtil.prettyPrint(map3.keySet())));
            this._missingLocalizationKeys.addAll(map3.keySet());
        }
        return map2;
    }

    private static Pair<String[], KeyAnyValue[][]> toKeyAndEntryArrays(Map<String, KeyAnyValue[]> map) {
        String[] stringArray = new String[map.size()];
        KeyAnyValue[][] keyAnyValueArrayArray = new KeyAnyValue[map.size()][];
        int n = 0;
        for (Map.Entry<String, KeyAnyValue[]> entry : map.entrySet()) {
            stringArray[n] = entry.getKey();
            keyAnyValueArrayArray[n++] = entry.getValue();
        }
        return new Pair((Object)stringArray, (Object)keyAnyValueArrayArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(long l) {
        if (this._syncLock.tryLock()) {
            try {
                _logger.info((Object)"Catalog sync operation, starting...");
                this.syncCatalogs(CmCatalogManager.getValidLocale(), l);
                _logger.info((Object)"Catalog sync operation, completed.");
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                _logger.warn((Object)String.format("Catalog sync operation cannot be completed within the specified timeout of %d ms, error = %s", l, exception.getMessage()));
            }
            finally {
                this._syncLock.unlock();
            }
        } else {
            _logger.info((Object)"Catalog sync operation, in progress, waiting for results...");
            this._syncLock.lock();
            this._syncLock.unlock();
            _logger.info((Object)"Catalog sync operation, in progress no more.");
        }
    }

    private void syncCatalogs(Locale locale, long l) throws InterruptedException, ExecutionException, TimeoutException {
        long l2 = System.currentTimeMillis();
        Future<SyncWorkItems> future = this.doInitCatalogInfo(locale, false);
        SyncWorkItems syncWorkItems = future.get(l, TimeUnit.MILLISECONDS);
        long l3 = CmCatalogManager.checkTimeout(l2, l);
        CmCatalogManager.waitTasks(syncWorkItems, l3);
    }

    private static long checkTimeout(long l, long l2) throws TimeoutException {
        long l3 = System.currentTimeMillis() - l;
        if (l3 > l2) {
            throw new TimeoutException(String.format("checkTimeout: Timeout value = %d, but time passed = %d", l2, l3));
        }
        return l2 - l3;
    }

    private static <V> void waitTasks(List<Future<?>> list, long l) throws TimeoutException, InterruptedException, ExecutionException {
        long l2 = System.currentTimeMillis();
        long l3 = l;
        for (Future<?> future : list) {
            future.get(l3, TimeUnit.MILLISECONDS);
            l3 = CmCatalogManager.checkTimeout(l2, l);
        }
    }

    private static Locale getValidLocale() {
        Locale locale = (Locale)SessionUtil.getData((String)"Locale");
        if (locale == null) {
            locale = Locale.US;
        }
        return locale;
    }

    public boolean addResourceBundle(Locale locale, CatalogRetriever.ResourceBundle[] resourceBundleArray) {
        HashMap<String, List<ServiceInfo>> hashMap = new HashMap<String, List<ServiceInfo>>();
        try {
            for (CatalogRetriever.ResourceBundle resourceBundle : (CatalogRetriever.ResourceBundle[])ArrayUtil.toSafe((Object[])resourceBundleArray, CatalogRetriever.ResourceBundle.class)) {
                Object object;
                if (this.isTaskAlreadyExisting(resourceBundle.resBundleUrl)) {
                    _logger.debug((Object)String.format("Bundle %s is being skipped, as it already was subject to processing", resourceBundle.resBundleUrl.toString()));
                    continue;
                }
                ServiceTypeImpl serviceTypeImpl = new ServiceTypeImpl();
                serviceTypeImpl.setProductId(resourceBundle.productId);
                serviceTypeImpl.setTypeId(resourceBundle.serviceId);
                ServiceInfoImpl serviceInfoImpl = new ServiceInfoImpl();
                serviceInfoImpl.setServiceType((ServiceType)serviceTypeImpl);
                serviceInfoImpl.setServiceVersion(resourceBundle.serviceVersion);
                ServiceEndPointTypeImpl serviceEndPointTypeImpl = new ServiceEndPointTypeImpl();
                serviceEndPointTypeImpl.setTypeId(RESOURCE_BUNDLE_ENDPOINT_TYPE);
                ServiceEndPointImpl serviceEndPointImpl = new ServiceEndPointImpl();
                serviceEndPointImpl.setEndPointType((ServiceEndPointType)serviceEndPointTypeImpl);
                serviceEndPointImpl.setUrl(resourceBundle.resBundleUrl);
                ServiceEndPointDataImpl serviceEndPointDataImpl = new ServiceEndPointDataImpl();
                serviceEndPointDataImpl.setKey(RESOURCE_BUNDLE_BASENAME);
                serviceEndPointDataImpl.setValue(resourceBundle.resBundleBaseName);
                if (resourceBundle.bundleVersion != null) {
                    object = new ServiceEndPointDataImpl();
                    serviceEndPointDataImpl.setKey(RESOURCE_BUNDLE_VERSION);
                    serviceEndPointDataImpl.setValue(resourceBundle.bundleVersion);
                    serviceEndPointImpl.setEndPointData(new ServiceEndPointData[]{serviceEndPointDataImpl, object});
                } else {
                    serviceEndPointImpl.setEndPointData(new ServiceEndPointData[]{serviceEndPointDataImpl});
                }
                serviceInfoImpl.setServiceEndPoints(new ServiceEndPoint[]{serviceEndPointImpl});
                object = serviceInfoImpl.getServiceType().getProductId() + "." + serviceInfoImpl.getServiceType().getTypeId();
                ArrayList<ServiceInfoImpl> arrayList = new ArrayList<ServiceInfoImpl>(1);
                arrayList.add(serviceInfoImpl);
                hashMap.put((String)object, arrayList);
            }
            this.processResourceBundles(locale != null ? locale : Locale.US, hashMap, 0L);
            return true;
        }
        catch (InterruptedException interruptedException) {
            _logger.error((Object)"Cannot process resource bundles", (Throwable)interruptedException);
            return false;
        }
    }

    private Map<String, List<ServiceInfo>> detectServiceProviders(long l) {
        ServiceInfo[] serviceInfoArray;
        HashMap<String, List<ServiceInfo>> hashMap = new HashMap<String, List<ServiceInfo>>();
        Callable<ServiceInfo[]> callable = new Callable<ServiceInfo[]>(){

            @Override
            public ServiceInfo[] call() throws ComponentManagerFault {
                return CmCatalogManager.getServiceInfo(CmCatalogManager.this._cmService);
            }
        };
        for (ServiceInfo serviceInfo : serviceInfoArray = CmCatalogManager.retryUntil("detectServiceProviders: getServiceInfo", callable, new ServiceInfo[0], l)) {
            String string = serviceInfo.getServiceType().getProductId() + "." + serviceInfo.getServiceType().getTypeId();
            ArrayList<ServiceInfo> arrayList = (ArrayList<ServiceInfo>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<ServiceInfo>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(serviceInfo);
        }
        return hashMap;
    }

    private static int extractResourceBundleVersion(ServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return -1;
        }
        ServiceEndPoint serviceEndPoint = CmCatalogManager.getResourceBundleEndpoint(serviceInfo);
        int n = CmCatalogManager.extractResourceBundleVersion(serviceEndPoint);
        return n;
    }

    private static int extractResourceBundleVersion(ServiceEndPoint serviceEndPoint) {
        ServiceEndPointData[] serviceEndPointDataArray;
        if (serviceEndPoint == null) {
            return -1;
        }
        for (ServiceEndPointData serviceEndPointData : serviceEndPointDataArray = serviceEndPoint.getEndPointData()) {
            Integer n;
            String string;
            if (serviceEndPointData == null || !RESOURCE_BUNDLE_VERSION.equals(serviceEndPointData.getKey()) || (string = serviceEndPointData.getValue()) == null || string.isEmpty()) continue;
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                _logger.warn((Object)("Invalid value for property com.vmware.cis.common.resourcebundle.version in service " + serviceEndPoint.getUrl() + ". As a result the value is now set to -1."));
                return -1;
            }
            return n;
        }
        return -1;
    }

    private Callable<SyncWorkItems> getInitTask(final Locale locale, final Boolean bl) {
        final SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext();
        Callable<SyncWorkItems> callable = new Callable<SyncWorkItems>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SyncWorkItems call() {
                SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                SyncWorkItems syncWorkItems = new SyncWorkItems();
                try {
                    long l = System.currentTimeMillis();
                    long l2 = bl != false ? Config.CM_CATALOG_MANAGER_BUNDLE_DOWNLOAD_RETRY_TIMEOUT : 0L;
                    Map map = CmCatalogManager.this.detectServiceProviders(l2);
                    long l3 = System.currentTimeMillis() - l;
                    _logger.info((Object)("detectServiceProviders took (ms):" + l3));
                    if (locale != null && CmCatalogManager.this._locales.contains(locale)) {
                        boolean bl2 = false;
                        for (Map.Entry entry : map.entrySet()) {
                            CatalogServiceProviderInfo catalogServiceProviderInfo;
                            CatalogTask catalogTask = (CatalogTask)CmCatalogManager.this._serviceProviderTaskById.get(entry.getKey());
                            if (catalogTask == null) {
                                bl2 = true;
                                break;
                            }
                            if (catalogTask.isDone() && (catalogServiceProviderInfo = CmCatalogManager.getServiceProviderInfo(catalogTask)) == null) {
                                bl2 = true;
                                break;
                            }
                            if (!CmCatalogManager.this.hasBetterServiceInfoCandidate((List)entry.getValue(), catalogTask)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            _logger.info((Object)"No new locales or service infos to download.");
                            SyncWorkItems syncWorkItems2 = syncWorkItems;
                            return syncWorkItems2;
                        }
                    }
                    l = System.currentTimeMillis();
                    syncWorkItems = CmCatalogManager.this.processResourceBundles(locale, map, l2);
                    l3 = System.currentTimeMillis() - l;
                    _logger.info((Object)("processResourceBundles took (ms):" + l3));
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    SessionUtil.setThreadContext(null);
                }
                return syncWorkItems;
            }
        };
        return callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncWorkItems processResourceBundles(Locale locale, Map<String, List<ServiceInfo>> map, long l) throws InterruptedException {
        Object object;
        HashMap<String, FutureTask<CatalogServiceProviderInfo>> hashMap = new HashMap<String, FutureTask<CatalogServiceProviderInfo>>();
        HashMap<String, FutureTask<CatalogServiceProviderInfo>> hashMap2 = new HashMap<String, FutureTask<CatalogServiceProviderInfo>>();
        HashSet<Locale> hashSet = new HashSet<Locale>();
        boolean bl = false;
        SyncWorkItems syncWorkItems = new SyncWorkItems();
        HttpClientManager httpClientManager = new HttpClientManager();
        Iterator<Object> iterator = this._lock;
        synchronized (iterator) {
            for (Map.Entry<String, List<ServiceInfo>> entry : map.entrySet()) {
                Object object2;
                String string = entry.getKey();
                List<ServiceInfo> list = entry.getValue();
                boolean bl2 = false;
                object = (CatalogTask)this._serviceProviderTaskById.get(string);
                if (object == null) {
                    bl2 = true;
                } else {
                    if (((FutureTask)object).isDone() && (object2 = CmCatalogManager.getServiceProviderInfo((Future<CatalogServiceProviderInfo>)object)) == null) {
                        bl2 = true;
                    }
                    if (!bl2 && this.hasBetterServiceInfoCandidate(list, (CatalogTask)object)) {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    object2 = this.getCatalogServiceProviderInfoTask(httpClientManager, list, string, l);
                    this._serviceProviderTaskById.put(string, (CatalogTask)object2);
                    hashMap2.put(string, (FutureTask<CatalogServiceProviderInfo>)object2);
                    continue;
                }
                hashMap.put(string, (FutureTask<CatalogServiceProviderInfo>)object);
            }
            hashSet.addAll(this._locales);
            if (locale != null) {
                bl = this._locales.add(locale);
            }
        }
        for (FutureTask futureTask : hashMap2.values()) {
            httpClientManager.acquirePermit();
            EXECUTOR.execute(futureTask);
            syncWorkItems.add(futureTask);
        }
        httpClientManager.canCloseClient();
        for (Map.Entry entry : hashMap2.entrySet()) {
            Future future = (Future)entry.getValue();
            for (Locale locale2 : hashSet) {
                String string = CmCatalogManager.getDirectoryName((String)entry.getKey());
                object = this.getLoadPropertiesTask(string, locale2, future);
                syncWorkItems.add(EXECUTOR.submit(object));
            }
        }
        if (bl) {
            syncWorkItems.addAll(this.loadProperties(locale, hashMap2));
            syncWorkItems.addAll(this.loadProperties(locale, hashMap));
        }
        return syncWorkItems;
    }

    private boolean hasBetterServiceInfoCandidate(List<ServiceInfo> list, CatalogTask catalogTask) {
        Version version;
        ServiceInfo serviceInfo = this.extractBestServiceInfo(list);
        Version version2 = this.extractServiceInfoVersion(serviceInfo);
        if (version2.compareTo(version = catalogTask.getServiceInfoVersion()) < 0) {
            return false;
        }
        if (version2.compareTo(version) > 0) {
            return true;
        }
        int n = CmCatalogManager.extractResourceBundleVersion(serviceInfo);
        return n > catalogTask.getResourceBundleVersion();
    }

    private List<Future<Void>> loadProperties(Locale locale, Map<String, FutureTask<CatalogServiceProviderInfo>> map) throws InterruptedException {
        ArrayList<Future<Void>> arrayList = new ArrayList<Future<Void>>();
        for (Map.Entry<String, FutureTask<CatalogServiceProviderInfo>> entry : map.entrySet()) {
            String string = CmCatalogManager.getDirectoryName(entry.getKey());
            Future future = entry.getValue();
            Callable<Void> callable = this.getLoadPropertiesTask(string, locale, future);
            arrayList.add(EXECUTOR.submit(callable));
        }
        return arrayList;
    }

    private Callable<Void> getLoadPropertiesTask(final String string, final Locale locale, final Future<CatalogServiceProviderInfo> future) {
        final SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext((boolean)true);
        Callable<Void> callable = new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                try {
                    long l = System.currentTimeMillis();
                    String string2 = string + CmCatalogManager.RESOURCE_BUNDLE_BASENAME_DELIMITER + locale.getCountry();
                    _logger.info((Object)("Loading properties for " + string2));
                    CatalogServiceProviderInfo catalogServiceProviderInfo = CmCatalogManager.getServiceProviderInfo(future);
                    long l2 = System.currentTimeMillis() - l;
                    _logger.info((Object)("Time waiting for csp info (ms) for " + string2 + ": " + l2));
                    l = System.currentTimeMillis();
                    try {
                        if (catalogServiceProviderInfo == null) {
                            _logger.info((Object)("Unable to get catalogServiceProviderInfo for " + string2));
                            Void void_ = null;
                            return void_;
                        }
                        List<String> list = catalogServiceProviderInfo.getResourceBundleBaseName();
                        CmCatalogManager.this._propertyDictionary.loadProperties(string, locale, list);
                    }
                    finally {
                        long l3 = System.currentTimeMillis() - l;
                        _logger.info((Object)("Time to load properties (ms)" + string2 + ": " + l3));
                    }
                    Void void_ = null;
                    return void_;
                }
                finally {
                    SessionUtil.setThreadContext(null);
                }
            }
        };
        return callable;
    }

    private static ServiceInfo[] getServiceInfo(ComponentManagerService componentManagerService) throws ComponentManagerFault {
        ServiceEndPointTypeImpl serviceEndPointTypeImpl = new ServiceEndPointTypeImpl();
        serviceEndPointTypeImpl.setTypeId(RESOURCE_BUNDLE_ENDPOINT_TYPE);
        SearchCriteriaImpl searchCriteriaImpl = new SearchCriteriaImpl();
        searchCriteriaImpl.setEndPointType((ServiceEndPointType)serviceEndPointTypeImpl);
        Object[] objectArray = componentManagerService.search((SearchCriteria)searchCriteriaImpl);
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            _logger.error((Object)"Could not find ServiceInfo with com.vmware.cis.common.resourcebundle");
            return new ServiceInfo[0];
        }
        return objectArray;
    }

    private CatalogTask getCatalogServiceProviderInfoTask(final HttpClientManager httpClientManager, final List<ServiceInfo> list, final String string, final long l) {
        final SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext((boolean)true);
        Callable<CatalogServiceProviderInfo> callable = new Callable<CatalogServiceProviderInfo>(){
            private String _stringRepresentation;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CatalogServiceProviderInfo call() throws Exception {
                SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                CatalogServiceProviderInfo catalogServiceProviderInfo = null;
                try {
                    CloseableHttpClient closeableHttpClient = httpClientManager.getClient();
                    catalogServiceProviderInfo = CmCatalogManager.this.initializeCatalogServiceProviderInfo((HttpClient)closeableHttpClient, list, string, l);
                }
                catch (Exception exception) {
                    _logger.error((Object)("Error while creating service provider: " + string), (Throwable)exception);
                }
                finally {
                    httpClientManager.releasePermit();
                    SessionUtil.setThreadContext(null);
                }
                return catalogServiceProviderInfo;
            }

            public String toString() {
                if (this._stringRepresentation != null) {
                    return this._stringRepresentation;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (ServiceEndPoint serviceEndPoint : ((ServiceInfo)list.get(0)).getServiceEndPoints()) {
                    if (!CmCatalogManager.RESOURCE_BUNDLE_ENDPOINT_TYPE.equals(serviceEndPoint.getEndPointType().getTypeId())) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(serviceEndPoint.getUrl());
                }
                this._stringRepresentation = "<" + string + " from URLs " + stringBuilder.toString() + ">";
                return this._stringRepresentation;
            }
        };
        ServiceInfo serviceInfo = this.extractBestServiceInfo(list);
        Version version = this.extractServiceInfoVersion(serviceInfo);
        int n = CmCatalogManager.extractResourceBundleVersion(serviceInfo);
        CatalogTask catalogTask = new CatalogTask(this.getResourceBundleUrl(list.get(0)), n, version, callable);
        return catalogTask;
    }

    private ServiceInfo extractBestServiceInfo(List<ServiceInfo> list) {
        if (list.size() == 0) {
            return null;
        }
        ServiceInfo serviceInfo = list.get(0);
        Version version = this.extractServiceInfoVersion(serviceInfo);
        int n = CmCatalogManager.extractResourceBundleVersion(serviceInfo);
        for (int i = 1; i < list.size(); ++i) {
            ServiceInfo serviceInfo2 = list.get(i);
            Version version2 = this.extractServiceInfoVersion(serviceInfo2);
            if (version2.compareTo(version) < 0) continue;
            if (version2.compareTo(version) > 0) {
                serviceInfo = serviceInfo2;
                version = version2;
                n = CmCatalogManager.extractResourceBundleVersion(serviceInfo2);
                continue;
            }
            int n2 = CmCatalogManager.extractResourceBundleVersion(serviceInfo2);
            if (n2 <= n) continue;
            n = n2;
            serviceInfo = serviceInfo2;
        }
        return serviceInfo;
    }

    private Version extractServiceInfoVersion(ServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return new Version(null);
        }
        return new Version(serviceInfo.getServiceVersion());
    }

    private CatalogServiceProviderInfo initializeCatalogServiceProviderInfo(final HttpClient httpClient, List<ServiceInfo> list, String string, long l) {
        Object object;
        Object object22;
        final CatalogServiceProviderInfo.Spec spec = new CatalogServiceProviderInfo.Spec();
        ServiceInfo serviceInfo = this.extractBestServiceInfo(list);
        Version version = this.extractServiceInfoVersion(serviceInfo);
        int n = CmCatalogManager.extractResourceBundleVersion(serviceInfo);
        for (Object object22 : list) {
            Version version2 = this.extractServiceInfoVersion((ServiceInfo)object22);
            if (version.compareTo(version2) > 0) continue;
            for (ServiceEndPoint serviceEndPoint : object = object22.getServiceEndPoints()) {
                int n2;
                if (!serviceEndPoint.getEndPointType().getTypeId().equals(RESOURCE_BUNDLE_ENDPOINT_TYPE) || (n2 = CmCatalogManager.extractResourceBundleVersion(serviceEndPoint)) < n) continue;
                spec.resourceURLs.add(new CatalogServiceProviderInfo.ResourceURL(serviceEndPoint.getUrl(), serviceEndPoint.getSslTrust()));
                if (spec.productId == null) {
                    spec.productId = object22.getServiceType().getProductId();
                }
                if (spec.typeId == null) {
                    spec.typeId = object22.getServiceType().getTypeId();
                }
                if (!spec.resourceBundleBaseNames.isEmpty()) continue;
                String string2 = null;
                ServiceEndPointData[] serviceEndPointDataArray = serviceEndPoint.getEndPointData();
                if (serviceEndPointDataArray == null) {
                    _logger.warn((Object)("Resource EndPointData not available for  " + serviceEndPoint.getUrl()));
                    continue;
                }
                for (ServiceEndPointData serviceEndPointData : serviceEndPointDataArray) {
                    if (!serviceEndPointData.getKey().equals(RESOURCE_BUNDLE_BASENAME)) continue;
                    string2 = serviceEndPointData.getValue();
                    break;
                }
                if (string2 == null || string2.isEmpty()) {
                    _logger.error((Object)("Resource Bundle base name not set for " + spec.productId));
                    continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, RESOURCE_BUNDLE_BASENAME_DELIMITER);
                while (stringTokenizer.hasMoreTokens()) {
                    spec.resourceBundleBaseNames.add(stringTokenizer.nextToken());
                }
            }
        }
        _logger.debug((Object)("Initiating download for service provider " + string));
        final String string3 = CmCatalogManager.getDirectoryName(string);
        object22 = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                CmCatalogManager.this.downloadResourceBundle(httpClient, string3, spec);
                return true;
            }
        };
        boolean bl = CmCatalogManager.retryUntil(String.format("downloadResourceBundle(%s from %s)", string, spec.resourceURLs.get((int)0).resourceURI), object22, false, l);
        if (!bl) {
            _logger.warn((Object)String.format("Failed to download %s from %s.", string3, spec.resourceURLs.get((int)0).resourceURI));
            return null;
        }
        object = new CatalogServiceProviderInfo(spec);
        return object;
    }

    private static String getDirectoryName(String string) {
        String string2 = CATALOG_FOLDER + string + FILE_FORMAT;
        return string2;
    }

    private static CatalogServiceProviderInfo getServiceProviderInfo(Future<CatalogServiceProviderInfo> future) {
        try {
            CatalogServiceProviderInfo catalogServiceProviderInfo = future.get();
            return catalogServiceProviderInfo;
        }
        catch (ExecutionException executionException) {
            _logger.error((Object)"Error while getting catalog service info", executionException.getCause());
        }
        catch (InterruptedException interruptedException) {
            _logger.info((Object)"Interrupted while waiting for CMCatalog download");
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private void downloadResourceBundle(HttpClient httpClient, String string, CatalogServiceProviderInfo.Spec spec) throws Exception {
        long l = System.currentTimeMillis();
        Exception exception = null;
        CatalogServiceProviderInfo.ResourceURL resourceURL = spec.resourceURLs.get(0);
        CatalogServiceProviderInfo.ResourceURL resourceURL2 = spec.getNextResourceUrl();
        URI uRI = resourceURL2.resourceURI;
        Object[] objectArray = resourceURL2.sslTrust;
        try {
            if (resourceURL != resourceURL2) {
                _logger.info((Object)("downloadResourceBundle: Trying " + resourceURL.resourceURI + " via alternative " + uRI));
            } else {
                _logger.info((Object)("downloadResourceBundle: Trying " + uRI));
            }
            this.executeDownload(httpClient, string, uRI);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (exception instanceof SSLHandshakeException && !ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            try {
                _logger.info((Object)("downloadResourceBundle: Failed to download resource bundle " + string + " from " + uRI + ". Retry using sslTrust."));
                this.executeDownload(string, uRI, (String[])objectArray);
                exception = null;
            }
            catch (Exception exception3) {
                exception = exception3;
            }
        }
        if (exception != null) {
            if (new File(string).exists()) {
                _logger.warn((Object)String.format("downloadResourceBundle: Download %s from %s failed, but previous local cache exists and will be used. Error message is: %s", string, uRI, exception.toString()));
                return;
            }
            throw exception;
        }
        long l2 = System.currentTimeMillis() - l;
        _logger.info((Object)("downloadResourceBundle: Took (ms) for the resource bundle " + string + "," + uRI + ": " + l2));
    }

    private void executeDownload(HttpClient httpClient, String string, URI uRI) throws Exception {
        HttpResponse httpResponse = CmLocalizationUtil.executeRequest(httpClient, uRI, this._ngcSolutionUser.getLoggedInToken(), this._ngcSolutionUser.getPrivateKey());
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n != 200) {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            throw new HttpException("HttpStatus is not SC_OK. statusCode = " + n);
        }
        File file = new File(string);
        InputStream inputStream = httpResponse.getEntity().getContent();
        try {
            FileUtil.writeFile((InputStream)inputStream, (File)file);
        }
        catch (Throwable throwable) {
            boolean bl = file.delete();
            if (!bl && file.exists()) {
                _logger.error((Object)("Failed to write file " + file.getAbsolutePath() + ". Failed to delete it either. " + "A file with corrupt contents is left behind."), throwable);
            }
            throw throwable;
        }
        EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        _logger.info((Object)("executeDownload: ResourceBundle " + uRI + " download succeeded with Status Code: " + n));
    }

    private void executeDownload(String string, URI uRI, String[] stringArray) throws Exception {
        SsoOverRestRequest ssoOverRestRequest = new SsoOverRestRequest(Request.Method.GET, uRI.toURL(), null);
        Map map = SsoOverRestHelper.calcAuthHeader((com.vmware.cis.common.sso.SsoOverRestRequest)ssoOverRestRequest, (PrivateKey)this._ngcSolutionUser.getPrivateKey(), (SamlToken)this._ngcSolutionUser.getLoggedInToken(), (int)1024);
        if (map == null) {
            throw new Exception("Error in determining authentication header for " + uRI);
        }
        String string2 = CertificateUtil.getThumbprint((String)stringArray[0]);
        com.vmware.vise.util.http.HttpClient httpClient = new SSLBuilder().sslConfigurationProvider(this._sslConfigurationProvider).thumbprint(string2).buildHttpClientIgnoreErrors();
        InputStream inputStream = httpClient.executeMethodResponseAsStream(uRI.toURL().toString(), null, map);
        FileUtil.writeFile((InputStream)inputStream, (File)new File(string));
        _logger.info((Object)("ResourceBundle " + uRI + " downloaded successfully"));
    }

    private boolean isTaskAlreadyExisting(URI uRI) throws InterruptedException {
        for (CatalogTask catalogTask : this._serviceProviderTaskById.values()) {
            if (!catalogTask.getUrl().equals(uRI)) continue;
            return !catalogTask.isFailed();
        }
        return false;
    }

    private URI getResourceBundleUrl(ServiceInfo serviceInfo) {
        ServiceEndPoint serviceEndPoint = CmCatalogManager.getResourceBundleEndpoint(serviceInfo);
        if (serviceEndPoint != null) {
            return serviceEndPoint.getUrl();
        }
        return null;
    }

    private static ServiceEndPoint getResourceBundleEndpoint(ServiceInfo serviceInfo) {
        ServiceEndPoint[] serviceEndPointArray;
        for (ServiceEndPoint serviceEndPoint : serviceEndPointArray = serviceInfo.getServiceEndPoints()) {
            if (serviceEndPoint == null || !RESOURCE_BUNDLE_ENDPOINT_TYPE.equals(serviceEndPoint.getEndPointType().getTypeId())) continue;
            return serviceEndPoint;
        }
        return null;
    }

    private static <R> R retryUntil(String string, Callable<R> callable, R r, long l) {
        long l2 = System.currentTimeMillis() + l;
        while (true) {
            try {
                R r2 = callable.call();
                return r2;
            }
            catch (Exception exception) {
                long l3 = l2 - System.currentTimeMillis();
                if (l3 <= 0L) {
                    _logger.warn((Object)String.format("Invoking '%s' unsuccessful, retry time left = None. Returning default result, reason = %s", string, exception.toString()));
                    return r;
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)String.format("Invoking '%s' unsuccessful, retry time left = %d, reason = %s", string, l3), (Throwable)exception);
                } else {
                    _logger.info((Object)String.format("Invoking '%s' unsuccessful, retry time left = %d, reason = %s", string, l3, exception.toString()));
                }
                BlockingUtil.sleep((long)Math.min(l3, Config.CM_CATALOG_MANAGER_BUNDLE_DOWNLOAD_RETRY_SLICE));
                continue;
            }
            break;
        }
    }

    private static class SyncWorkItems
    extends ArrayList<Future<?>> {
        private static final long serialVersionUID = -1L;

        private SyncWorkItems() {
        }
    }

    @ThreadSafe
    private class HttpClientManager {
        @GuardedBy(value="this")
        private volatile CloseableHttpClient _client = null;
        @GuardedBy(value="this")
        private boolean _canCloseClient = false;
        @GuardedBy(value="this")
        private int _countPermits = 0;

        HttpClientManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CloseableHttpClient getClient() {
            CloseableHttpClient closeableHttpClient = this._client;
            if (closeableHttpClient != null) {
                return closeableHttpClient;
            }
            HttpClientManager httpClientManager = this;
            synchronized (httpClientManager) {
                closeableHttpClient = this._client;
                if (closeableHttpClient != null) {
                    return closeableHttpClient;
                }
                String string = CmCatalogManager.this._ksService.getKeyStorePassword();
                char[] cArray = string != null ? string.toCharArray() : null;
                this._client = closeableHttpClient = CmLocalizationUtil.createHttpClient(CmCatalogManager.this._sslConfigurationProvider, CmCatalogManager.this._ksService.getKeyStore(), cArray, CmCatalogManager.this._ksService.getKeyStore());
                return closeableHttpClient;
            }
        }

        synchronized void acquirePermit() {
            ++this._countPermits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releasePermit() {
            int n;
            boolean bl = false;
            CloseableHttpClient closeableHttpClient = null;
            HttpClientManager httpClientManager = this;
            synchronized (httpClientManager) {
                n = --this._countPermits;
                if (this._canCloseClient && n <= 0) {
                    bl = true;
                    closeableHttpClient = this._client;
                    this._client = null;
                }
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("After releasing a permit, the number of acquired HttpClient permits is: " + n));
            }
            if (bl) {
                _logger.info((Object)"The HttpClient is no longer used. Will Close it.");
                StreamUtil.close((Closeable)closeableHttpClient);
            }
        }

        synchronized void canCloseClient() {
            this._canCloseClient = true;
        }
    }

    static class CatalogTask
    extends FutureTask<CatalogServiceProviderInfo> {
        private final URI _url;
        private final int _resourceBundleVersion;
        private final Version _serviceVersion;

        CatalogTask(URI uRI, int n, Version version, Callable<CatalogServiceProviderInfo> callable) {
            super(callable);
            this._url = uRI;
            this._resourceBundleVersion = n;
            this._serviceVersion = version;
        }

        public URI getUrl() {
            return this._url;
        }

        public int getResourceBundleVersion() {
            return this._resourceBundleVersion;
        }

        public Version getServiceInfoVersion() {
            return this._serviceVersion;
        }

        public boolean isFailed() throws InterruptedException {
            try {
                return super.isDone() && super.get() == null;
            }
            catch (ExecutionException executionException) {
                return false;
            }
        }
    }
}

