/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm.impl;

import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vise.vim.cm.ComponentManagerConnectionException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmUtil {
    private static final Log _logger = LogFactory.getLog(CmUtil.class);

    public static void handleException(Exception exception, URI uRI) throws ComponentManagerFault {
        Throwable throwable;
        if (exception instanceof ExecutionException || exception instanceof InterruptedException) {
            throwable = exception.getCause();
            exception = throwable == null || throwable instanceof Exception ? (Exception)throwable : new RuntimeException("System error thrown.", throwable);
        }
        if (exception instanceof ComponentManagerFault) {
            throw (ComponentManagerFault)((Object)exception);
        }
        if (exception instanceof UnexpectedStatusCodeException && (throwable = (UnexpectedStatusCodeException)exception).getStatusCode() == 503) {
            String string = String.format(ComponentManagerConnectionException.CONNECTION_ERROR, uRI.toString());
            throw new ComponentManagerConnectionException(string);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        _logger.error((Object)("CM exception detected. Will wrap in a " + ComponentManagerFault.class.getSimpleName() + " and will throw that"), (Throwable)exception);
        throwable = new ComponentManagerFault(0, exception.getMessage());
        throwable.setFaultCause(exception);
        throw throwable;
    }
}

