/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm.impl;

import com.google.common.annotations.VisibleForTesting;
import com.vmware.vim.binding.cis.cm.ComponentManager;
import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceInstanceContent;
import com.vmware.vim.binding.cis.cm.ServiceManager;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.cis.cm.site.Folder;
import com.vmware.vim.binding.cis.cm.version.version1;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vim.binding.impl.cis.cm.site.FolderImpl;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.RequestRetryCallback;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.vim.VimServicesUtil;
import com.vmware.vise.vim.cm.ComponentManagerConnectionException;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.cm.LoginCallback;
import com.vmware.vise.vim.cm.impl.CmUtil;
import com.vmware.vise.vim.cm.impl.ComponentManagerLocator;
import com.vmware.vise.vim.commons.vmomi.ClientWithSharedHttpConfig;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.commons.vmomi.OpIdAwareClientFactory;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import com.vmware.vise.vim.commons.vmomi.VmomiClientHelper;
import com.vmware.vise.vim.internal.Config;
import java.net.URI;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class ComponentManagerServiceImpl
implements ComponentManagerService {
    private final String NOT_AUTHENTICATED_ERROR = "cm.exception.securityError.notAuthenticated";
    private final int MAX_RETRY_COUNT = 2;
    private final ComponentManagerLocator _locator;
    private final VmodlContext _vmodlContext;
    private final LoginCallback _loginCallback;
    private final RequestRetryCallback _retryCallback = this.createNotAuthenticatedInterceptor();
    private final AtomicReference<Future<CMServiceHolder>> _cmAuthTaskReference = new AtomicReference();
    private static final Log _logger = LogFactory.getLog(ComponentManagerServiceImpl.class);
    private static final Class<version1> CM_VMODL_VERSION = version1.class;
    private static final String POOL_NAME = "cm-service-pool";
    private static final long LOCK_ACQUISITION_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(500L);
    private static final long TASK_COMPLETION_THRESHOLD_NANOS = TimeUnit.SECONDS.toNanos(2L);
    private static final ExecutorService EXECUTOR = ThreadPoolFactory.newQueingCachedThreadPool((int)10, (ThreadFactory)new WorkerThreadFactory("cm-service-pool"), (long)5L, (TimeUnit)TimeUnit.MINUTES, (long)1L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CALLER_RUNS);
    private static final AtomicReference<SharedHttpConfigPool> _legacyHttpConfigPoolRef = new AtomicReference();
    private static final long MAX_ACCEPTABLE_RETRY_TIME = TimeUnit.SECONDS.toNanos(5L);
    private final HttpConfigurationProvider _httpConfigProvider;
    private volatile CMServiceHolder _cmServiceHolder = null;

    @Deprecated
    public ComponentManagerServiceImpl(ComponentManagerLocator componentManagerLocator, LoginCallback loginCallback, VmodlContext vmodlContext) {
        this(componentManagerLocator, loginCallback, vmodlContext, (HttpConfigurationProvider)ComponentManagerServiceImpl.getLegacyHttpConfigPool());
    }

    public ComponentManagerServiceImpl(ComponentManagerLocator componentManagerLocator, LoginCallback loginCallback, VmodlContext vmodlContext, HttpConfigurationProvider httpConfigurationProvider) {
        this._locator = componentManagerLocator;
        this._loginCallback = loginCallback;
        this._vmodlContext = vmodlContext;
        this._httpConfigProvider = httpConfigurationProvider;
    }

    @VisibleForTesting
    static void setHttpConfigPool(@Nullable SharedHttpConfigPool sharedHttpConfigPool) {
        _legacyHttpConfigPoolRef.set(sharedHttpConfigPool);
    }

    public static SharedHttpConfigPool getLegacyHttpConfigPool() {
        SharedHttpConfigPool sharedHttpConfigPool;
        boolean bl;
        do {
            if ((sharedHttpConfigPool = _legacyHttpConfigPoolRef.get()) == null) continue;
            return sharedHttpConfigPool;
        } while (!(bl = _legacyHttpConfigPoolRef.compareAndSet(null, sharedHttpConfigPool = SharedHttpConfigPool.builder().maxConnections(Config.VMOMI_HTTP_CONNECTION_POOL_SIZE_CM).timeoutInMillis(Config.VMOMI_HTTP_SOCKET_TIMEOUT_CM).connectionTimeoutInMillis(Config.VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_CM).build())));
        return sharedHttpConfigPool;
    }

    @Override
    public String getServiceUrl() {
        URI uRI = this._locator.getServiceUri();
        if (uRI == null) {
            throw new NullPointerException(VimServicesUtil.getLocalizedString("cm.invalidServiceUrl", new String[0]));
        }
        return uRI.toString();
    }

    @Override
    public ServiceInfo[] searchSso() throws ComponentManagerFault {
        CMServiceHolder cMServiceHolder = this.getComponentManager(this._locator, this._retryCallback);
        SearchCriteriaImpl searchCriteriaImpl = new SearchCriteriaImpl();
        FolderImpl folderImpl = new FolderImpl();
        folderImpl.setId("");
        folderImpl.setParentId("");
        searchCriteriaImpl.setFolder((Folder)folderImpl);
        ServiceTypeImpl serviceTypeImpl = new ServiceTypeImpl("com.vmware.cis", "cs.identity");
        searchCriteriaImpl.setServiceType((ServiceType)serviceTypeImpl);
        return this.search(cMServiceHolder.getServiceManager(), (SearchCriteria)searchCriteriaImpl, false);
    }

    @Override
    public ServiceInfo[] search(SearchCriteria searchCriteria) throws ComponentManagerFault {
        ServiceManager serviceManager = this.getServiceManager();
        return this.search(serviceManager, searchCriteria, true);
    }

    @Override
    public ServiceInfo getService(String string) throws ComponentManagerFault {
        ServiceManager serviceManager = this.getServiceManager();
        return serviceManager.retrieveService(string);
    }

    @Override
    public String getHostId() {
        if (this._locator == null) {
            return null;
        }
        URI uRI = this._locator.getServiceUri();
        if (uRI == null) {
            return null;
        }
        List list = URLEncodedUtils.parse((URI)uRI, (String)"UTF-8");
        for (NameValuePair nameValuePair : list) {
            if (!nameValuePair.getName().equalsIgnoreCase("hostId")) continue;
            return nameValuePair.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceInfo[] search(ServiceManager serviceManager, SearchCriteria searchCriteria, boolean bl) throws ComponentManagerFault {
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)("Invoking serviceManager.search() on stub @" + Integer.toHexString(System.identityHashCode(serviceManager)) + " for criteria: " + ComponentManagerServiceImpl.buildSearchCriteriaDesc(searchCriteria) + "\n" + ExceptionUtil.getCurrentStackTrace()));
        } else if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Invoking serviceManager.search() on stub @" + Integer.toHexString(System.identityHashCode(serviceManager)) + " for criteria: " + ComponentManagerServiceImpl.buildSearchCriteriaDesc(searchCriteria)));
        }
        long l = System.nanoTime();
        long l2 = 0L;
        ServiceInfo[] serviceInfoArray = null;
        Exception exception = null;
        try {
            serviceInfoArray = serviceManager.search(searchCriteria);
            l2 = System.nanoTime() - l;
        }
        catch (Exception exception2) {
            l2 = System.nanoTime() - l;
            exception = exception2;
            CmUtil.handleException(exception2, this._locator.getServiceUri());
        }
        finally {
            if (l2 > TASK_COMPLETION_THRESHOLD_NANOS) {
                StringBuilder stringBuilder = new StringBuilder(1000);
                stringBuilder.append("CM search took too long: " + TimeUnit.NANOSECONDS.toMillis(l2) + " ms");
                if (exception != null) {
                    stringBuilder.append(", and failed with ").append(exception);
                }
                if (_logger.isDebugEnabled()) {
                    stringBuilder.append(". Search criteria: ").append(ComponentManagerServiceImpl.buildSearchCriteriaDesc(searchCriteria));
                }
                if (_logger.isTraceEnabled()) {
                    stringBuilder.append('\n').append(ExceptionUtil.getCurrentStackTrace());
                }
                _logger.warn((Object)stringBuilder.toString());
            } else if (_logger.isDebugEnabled()) {
                if (exception != null) {
                    _logger.debug((Object)("serviceManager.search() is failed: " + exception));
                } else {
                    _logger.debug((Object)"serviceManager.search() is complete");
                }
            }
        }
        return serviceInfoArray;
    }

    private static String buildSearchCriteriaDesc(SearchCriteria searchCriteria) {
        if (searchCriteria == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("serviceType=[");
        ServiceType serviceType = searchCriteria.getServiceType();
        if (serviceType != null) {
            stringBuilder.append("productId=").append(serviceType.getProductId()).append(", typeId=").append(serviceType.getTypeId());
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append("], folder=[");
        Folder folder = searchCriteria.getFolder();
        if (folder != null) {
            stringBuilder.append("id=").append(folder.getId()).append(", displayName=").append(folder.getDisplayName()).append(", parentId=").append(folder.getParentId());
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append("], endPointType=[");
        ServiceEndPointType serviceEndPointType = searchCriteria.getEndPointType();
        if (serviceEndPointType != null) {
            stringBuilder.append("protocol=").append(serviceEndPointType.getEndPointProtocol()).append(", typeId=").append(serviceEndPointType.getTypeId());
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append("], selectionMethod=").append(searchCriteria.getSelectionMethod()).append(", resultFieldList=").append(Arrays.toString(searchCriteria.getResultFieldList()));
        return stringBuilder.toString();
    }

    private ServiceManager getServiceManager() throws ComponentManagerFault {
        CMServiceHolder cMServiceHolder = this.getLoggedInCM(false);
        ServiceManager serviceManager = cMServiceHolder.getServiceManager();
        return serviceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMServiceHolder getLoggedInCM(boolean bl) throws ComponentManagerFault {
        CMServiceHolder cMServiceHolder = this.getComponentManager(this._locator, this._retryCallback);
        if (bl || !cMServiceHolder.isLoggedIn()) {
            boolean bl2;
            long l;
            Future<CMServiceHolder> future;
            block10: {
                FutureTask<CMServiceHolder> futureTask;
                boolean bl3;
                do {
                    if ((future = this._cmAuthTaskReference.get()) == null) continue;
                    _logger.info((Object)"A CM auth task already exists. Will wait for its result.");
                    l = System.nanoTime();
                    bl2 = false;
                    break block10;
                } while (!(bl3 = this._cmAuthTaskReference.compareAndSet(null, futureTask = this.createCmLoginTask(cMServiceHolder))));
                _logger.info((Object)"Will run a CM auth task in the current thread");
                bl2 = true;
                l = System.nanoTime();
                futureTask.run();
                future = futureTask;
                this._cmAuthTaskReference.compareAndSet(future, null);
            }
            try {
                cMServiceHolder = future.get();
                _logger.info((Object)"CM auth completed");
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                CmUtil.handleException(interruptedException, cMServiceHolder.getCMUri());
            }
            catch (Exception exception) {
                CmUtil.handleException(exception, cMServiceHolder.getCMUri());
            }
            finally {
                long l2 = System.nanoTime() - l;
                if (l2 > TASK_COMPLETION_THRESHOLD_NANOS) {
                    _logger.warn((Object)("CM login task took too long: " + TimeUnit.NANOSECONDS.toMillis(l2) + " ms;  ranTaskInThisThread=" + bl2 + ", task=" + future));
                }
            }
        }
        return cMServiceHolder;
    }

    private FutureTask<CMServiceHolder> createCmLoginTask(final CMServiceHolder cMServiceHolder) {
        Callable<CMServiceHolder> callable = new Callable<CMServiceHolder>(){

            @Override
            public CMServiceHolder call() throws Exception {
                cMServiceHolder.login(ComponentManagerServiceImpl.this._loginCallback);
                return cMServiceHolder;
            }
        };
        FutureTask<CMServiceHolder> futureTask = new FutureTask<CMServiceHolder>(callable);
        return futureTask;
    }

    void cleanup() {
        try {
            CMServiceHolder cMServiceHolder = this._cmServiceHolder;
            this._cmServiceHolder = null;
            _logger.info((Object)"Cleaning up CM");
            this.cleanup(cMServiceHolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cleanup(CMServiceHolder cMServiceHolder) {
        if (cMServiceHolder == null) {
            return;
        }
        _logger.info((Object)("Cleaning up CMServiceHolder@" + Integer.toHexString(System.identityHashCode(cMServiceHolder)) + " for CM@" + Integer.toHexString(System.identityHashCode(this))));
        URI uRI = cMServiceHolder.getCMUri();
        try {
            Client client;
            if (cMServiceHolder.isLoggedIn()) {
                try {
                    cMServiceHolder.logout();
                }
                catch (RuntimeException runtimeException) {
                    _logger.error((Object)"Failed to log out of CM", (Throwable)runtimeException);
                }
            }
            if ((client = cMServiceHolder.getClient()) != null) {
                client.shutdown();
            }
            cMServiceHolder = null;
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to shut down CM client", (Throwable)exception);
        }
        _logger.info((Object)("Cleaned up CMServiceHolder " + uRI));
    }

    private RequestRetryCallback createNotAuthenticatedInterceptor() {
        return new RequestRetryCallback(){

            public boolean retry(Exception exception, InvocationContext invocationContext, int n) {
                if (n >= 2) {
                    return false;
                }
                if (exception instanceof SecurityError) {
                    try {
                        SecurityError securityError = (SecurityError)exception;
                        if (securityError.getFaultMessage() != null && securityError.getFaultMessage().length > 0 && !"cm.exception.securityError.notAuthenticated".equals(securityError.getFaultMessage()[0].getKey())) {
                            StringBuilder stringBuilder = new StringBuilder(200);
                            stringBuilder.append("Retry won't be attempted for CM " + ComponentManagerServiceImpl.this.getServiceUrl() + ", ");
                            String string = exception.getMessage();
                            if (string != null) {
                                stringBuilder.append("fault message for SecurityError thrown by CM is: ").append(string);
                            } else {
                                stringBuilder.append("the actual error type is: ").append(exception.getClass().getName());
                            }
                            _logger.info((Object)stringBuilder.toString());
                            return false;
                        }
                        _logger.info((Object)("Must retry CM operation due to: " + exception.getClass().getName()));
                        long l = System.nanoTime();
                        CMServiceHolder cMServiceHolder = ComponentManagerServiceImpl.this.getLoggedInCM(true);
                        ComponentManagerServiceImpl.this._loginCallback.login(cMServiceHolder.getComponentManager());
                        long l2 = System.nanoTime() - l;
                        if (l2 > MAX_ACCEPTABLE_RETRY_TIME) {
                            _logger.warn((Object)("RetryCallback invocation was too slow: " + TimeUnit.NANOSECONDS.toMillis(l2) + " ms"));
                        } else {
                            _logger.debug((Object)"Returning 'true'");
                        }
                        return true;
                    }
                    catch (Exception exception2) {
                        _logger.error((Object)"Re-login attempt failed", (Throwable)exception2);
                    }
                } else {
                    _logger.info((Object)("Retry won't be attempted for CM " + ComponentManagerServiceImpl.this.getServiceUrl() + " for error: " + exception.getClass().getName() + " - " + exception.getMessage()));
                }
                return false;
            }
        };
    }

    private CMServiceHolder getComponentManager(ComponentManagerLocator componentManagerLocator, RequestRetryCallback requestRetryCallback) {
        return this.getComponentManager(componentManagerLocator.getServiceUri(), componentManagerLocator.getKeyStore(), componentManagerLocator.getThumbprint(), requestRetryCallback);
    }

    private CMServiceHolder getComponentManager(URI uRI, KeyStore keyStore, String string, RequestRetryCallback requestRetryCallback) {
        if (uRI == null) {
            throw new ComponentManagerConnectionException(VimServicesUtil.getLocalizedString("cm.notConfigured", new String[0]));
        }
        CMServiceHolder cMServiceHolder = this._cmServiceHolder;
        if (cMServiceHolder != null && uRI.equals(cMServiceHolder.getCMUri())) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Returning a pre-existing CMServiceHolder@" + Integer.toHexString(System.identityHashCode(cMServiceHolder)) + " for URI " + uRI + " for CM@" + Integer.toHexString(System.identityHashCode(this))));
            }
            return cMServiceHolder;
        }
        long l = System.nanoTime();
        ComponentManagerServiceImpl componentManagerServiceImpl = this;
        synchronized (componentManagerServiceImpl) {
            long l2 = System.nanoTime() - l;
            if (l2 > LOCK_ACQUISITION_THRESHOLD_NANOS) {
                _logger.warn((Object)("getComponentManager lock acquisition took too long: " + TimeUnit.NANOSECONDS.toMillis(l2) + " ms"));
            }
            if ((cMServiceHolder = this._cmServiceHolder) != null && uRI.equals(cMServiceHolder.getCMUri())) {
                _logger.debug((Object)"Returning a pre-existing CMServiceHolder (sync)");
                return cMServiceHolder;
            }
            this._cmServiceHolder = null;
            this.cleanup(cMServiceHolder);
            _logger.info((Object)("Creating a CMServiceHolder for URI " + uRI));
            cMServiceHolder = null;
            try {
                ManagedObjectReference managedObjectReference = this.createCMMoRef(ComponentManager.class, ComponentManager.class.getSimpleName());
                Client client = this.createClient(uRI, keyStore, string, requestRetryCallback);
                _logger.debug((Object)"Created a VMOMI Client");
                ComponentManager componentManager = (ComponentManager)VmomiClientHelper.createStub((Client)client, ComponentManager.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)ComponentManagerServiceImpl.class.getClassLoader());
                ServiceInstanceContent serviceInstanceContent = componentManager.retrieveServiceInstanceContent();
                _logger.debug((Object)"Done with cm.retrieveServiceInstanceContent()");
                ManagedObjectReference managedObjectReference2 = serviceInstanceContent.getServiceManager();
                ServiceManager serviceManager = (ServiceManager)VmomiClientHelper.createStub((Client)client, ServiceManager.class, (ManagedObjectReference)managedObjectReference2, (ClassLoader)ComponentManagerServiceImpl.class.getClassLoader());
                this._cmServiceHolder = cMServiceHolder = new CMServiceHolder(uRI, client, componentManager, serviceManager);
                _logger.info((Object)("Created a " + cMServiceHolder.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(cMServiceHolder)) + " for CM@" + Integer.toHexString(System.identityHashCode(this))));
                return cMServiceHolder;
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (exception instanceof SslException || exception instanceof InternalException) {
                    throwable = exception.getCause();
                }
                _logger.error((Object)("Error when creating component manager service: " + uRI), throwable);
                String string2 = String.format(ComponentManagerConnectionException.CONNECTION_ERROR, uRI.toString());
                if (throwable instanceof UnmarshallException) {
                    string2 = String.format(ComponentManagerConnectionException.VMODL_MISMATCH_ERROR, uRI.toString());
                } else if (throwable instanceof CertificateValidationException) {
                    string2 = String.format(ComponentManagerConnectionException.SSL_ERROR, uRI.toString());
                }
                throw new ComponentManagerConnectionException(string2, throwable);
            }
        }
    }

    private Client createClient(URI uRI, KeyStore keyStore, String string, RequestRetryCallback requestRetryCallback) {
        String string2 = uRI.toString();
        HttpConfiguration httpConfiguration = this._httpConfigProvider.getHttpConfig(string2, keyStore, string);
        HttpClientConfiguration httpClientConfiguration = HttpClientConfiguration.Factory.newInstance();
        httpClientConfiguration.setExecutor((Executor)EXECUTOR);
        httpClientConfiguration.setHttpConfiguration(httpConfiguration);
        if (requestRetryCallback != null) {
            httpClientConfiguration.setRequestRetryCallback(requestRetryCallback);
        }
        Client client = Config.CM_USE_OP_ID_AWARE_CLIENT ? OpIdAwareClientFactory.createClient((URI)uRI, CM_VMODL_VERSION, (VmodlContext)this._vmodlContext, (ClientConfiguration)httpClientConfiguration) : Client.Factory.createClient((URI)uRI, CM_VMODL_VERSION, (VmodlContext)this._vmodlContext, (ClientConfiguration)httpClientConfiguration);
        client = new ClientWithSharedHttpConfig(client, this._httpConfigProvider);
        return client;
    }

    private ManagedObjectReference createCMMoRef(Class<?> clazz, String string) {
        VmodlType vmodlType = this._vmodlContext.getVmodlTypeMap().getVmodlType(clazz);
        ManagedObjectReference managedObjectReference = new ManagedObjectReference(vmodlType.getWsdlName(), string);
        return managedObjectReference;
    }

    private static class CMServiceHolder {
        private final Client _client;
        private final URI _cmUri;
        private final ServiceManager _serviceManager;
        private final ComponentManager _cm;
        private volatile boolean _clientIsLoggedIn = false;

        public CMServiceHolder(URI uRI, Client client, ComponentManager componentManager, ServiceManager serviceManager) {
            this._client = client;
            this._cmUri = uRI;
            this._cm = componentManager;
            this._serviceManager = serviceManager;
        }

        public Client getClient() {
            return this._client;
        }

        public URI getCMUri() {
            return this._cmUri;
        }

        public ComponentManager getComponentManager() {
            return this._cm;
        }

        public ServiceManager getServiceManager() {
            return this._serviceManager;
        }

        public boolean isLoggedIn() {
            return this._clientIsLoggedIn;
        }

        public synchronized void login(LoginCallback loginCallback) throws ComponentManagerFault {
            this.logout();
            _logger.info((Object)("Logging into CM at " + this._cmUri));
            loginCallback.login(this._cm);
            this._clientIsLoggedIn = true;
        }

        public synchronized void logout() {
            if (this._clientIsLoggedIn) {
                try {
                    _logger.info((Object)("Logging out of CM at " + this._cmUri));
                    this._cm.logout();
                    this._clientIsLoggedIn = false;
                }
                catch (RuntimeException runtimeException) {
                    _logger.error((Object)"Failed to log out of CM", (Throwable)runtimeException);
                }
                this._clientIsLoggedIn = false;
            } else if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Not logging out of CM at " + this._cmUri + " because the client isn't logged in"));
            }
        }
    }
}

