/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.lookup.impl;

import com.google.common.annotations.VisibleForTesting;
import com.vmware.vim.binding.lookup.SearchCriteria;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vise.extensionfw.ExtensionFilter;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.ZipUtil;
import com.vmware.vise.util.common.Environment;
import com.vmware.vise.util.concurrent.BlockingUtil;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.internal.Config;
import com.vmware.vise.vim.lookup.LookupService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LookupServiceExtensionManager
implements UserSessionListener,
ExtensionFilter,
ExtensionListener {
    private static final Log _logger = LogFactory.getLog(LookupServiceExtensionManager.class);
    @Nonnull
    private final LookupService _lookupService;
    @Nullable
    private final SearchCriteria _criteria;
    @Nonnull
    private final ExtensionService _extensionService;
    @Nonnull
    private final String _extensionType;
    @Nullable
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private static final String SESSION_PACKAGES_REFS = "lsPackagesRefs";
    private Set<IdVersionPair> _registeredPackageRefs = new HashSet<IdVersionPair>();
    private ConcurrentMap<File, Object> _lockByPackageDir = new ConcurrentHashMap<File, Object>();
    private static final String POOL_NAME = "lookup-service-extension-mngr-pool";
    private static final ExecutorService EXECUTOR = ThreadPoolFactory.newQueingCachedThreadPool((int)10, (ThreadFactory)new WorkerThreadFactory("lookup-service-extension-mngr-pool"), (long)10L, (TimeUnit)TimeUnit.SECONDS, (long)1L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CALLER_RUNS);

    public LookupServiceExtensionManager(ExtensionService extensionService, LookupService lookupService, String string) {
        this(false, extensionService, lookupService, string, null);
    }

    public LookupServiceExtensionManager(@Nonnull ExtensionService extensionService, @Nonnull LookupService lookupService, @Nonnull String string, @Nonnull SSLConfigurationProvider sSLConfigurationProvider) {
        this(true, (ExtensionService)ValidationUtil.notNull((Object)extensionService, (String)"extensionService is null"), (LookupService)ValidationUtil.notNull((Object)lookupService, (String)"lookupService is null"), (String)ValidationUtil.notNull((Object)string, (String)"extensionType is null"), (SSLConfigurationProvider)ValidationUtil.notNull((Object)sSLConfigurationProvider, (String)"sslConfigurationProvider is null"));
    }

    private LookupServiceExtensionManager(boolean bl, ExtensionService extensionService, LookupService lookupService, String string, SSLConfigurationProvider sSLConfigurationProvider) {
        SearchCriteria searchCriteria;
        this._extensionService = extensionService;
        this._lookupService = lookupService;
        this._extensionType = string;
        this._sslConfigurationProvider = sSLConfigurationProvider;
        try {
            searchCriteria = new SearchCriteria();
            searchCriteria.serviceType = new URI(this._extensionType);
        }
        catch (Exception exception) {
            searchCriteria = null;
        }
        this._criteria = searchCriteria;
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        Object object;
        if (_logger.isDebugEnabled()) {
            object = SessionUtil.getHashedSessionId((HttpSession)httpSessionEvent.getSession());
            _logger.debug((Object)("LS Extensions session init start " + (String)object));
        }
        try {
            object = this._lookupService.find(this._criteria);
            List<LSPackageInfo> list = this.getLSPackages((Service[])object);
            Set<IdVersionPair> set = this.addPackages(list);
            if (!set.isEmpty()) {
                SessionUtil.setData((String)SESSION_PACKAGES_REFS, set, (HttpSession)httpSessionEvent.getSession());
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when fetching NGC plugins from LookupService (SSO may be disabled).", (Throwable)exception);
        }
        if (_logger.isDebugEnabled()) {
            object = SessionUtil.getHashedSessionId((HttpSession)httpSessionEvent.getSession());
            _logger.debug((Object)("LS Extensions session init complete " + (String)object));
        }
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) throws Exception {
        if (!pluginPackageEvent.getType().equals("pluginPackageUndeployed")) {
            return;
        }
        for (PluginPackageInfo pluginPackageInfo : pluginPackageEvent.getPluginPackageInfos()) {
            this.packageUndeployed(pluginPackageInfo.getPackageRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterPackages(Set<IdVersionPair> set) {
        Set set2 = (Set)SessionUtil.getData((String)SESSION_PACKAGES_REFS);
        Iterator<IdVersionPair> iterator = set.iterator();
        while (iterator.hasNext()) {
            IdVersionPair idVersionPair = iterator.next();
            Set<IdVersionPair> set3 = this._registeredPackageRefs;
            synchronized (set3) {
                if (!this._registeredPackageRefs.contains(idVersionPair)) {
                    continue;
                }
            }
            if (set2 != null && set2.contains(idVersionPair)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packageUndeployed(IdVersionPair idVersionPair) {
        Object object;
        Object object2 = this._registeredPackageRefs;
        synchronized (object2) {
            this._registeredPackageRefs.remove(idVersionPair);
        }
        object2 = this.getPackageDir(idVersionPair);
        Object object3 = object = this.getPackageDirLock((File)object2);
        synchronized (object3) {
            try {
                if (((File)object2).exists()) {
                    _logger.info((Object)("Delete lookup-service package directory '" + object2 + "' because the package is undeployed."));
                    FileUtil.deleteDir((File)object2);
                }
            }
            finally {
                this.removePackageDirLock((File)object2);
            }
        }
    }

    private List<LSPackageInfo> getLSPackages(Service[] serviceArray) {
        ArrayList<LSPackageInfo> arrayList = new ArrayList<LSPackageInfo>();
        if (serviceArray == null || serviceArray.length == 0) {
            return arrayList;
        }
        for (Service service : serviceArray) {
            if (service.endpoints == null || service.endpoints.length != 1) continue;
            if (StringUtil.isNullOrEmpty((String)service.productId)) {
                _logger.error((Object)("Lookup-service extension '" + service.serviceName + "' has empty productId, skip."));
                continue;
            }
            LSPackageInfo lSPackageInfo = new LSPackageInfo();
            lSPackageInfo.setId(service.productId);
            lSPackageInfo.setVersion(service.version);
            lSPackageInfo.setName(service.serviceName);
            lSPackageInfo.setDescription(service.description);
            ServiceEndpoint serviceEndpoint = service.endpoints[0];
            lSPackageInfo.url = serviceEndpoint.url.toString();
            lSPackageInfo.certificate = serviceEndpoint.sslTrustAnchor;
            arrayList.add(lSPackageInfo);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IdVersionPair> addPackages(Collection<LSPackageInfo> collection) {
        ArrayList<Future<IdVersionPair>> arrayList = new ArrayList<Future<IdVersionPair>>();
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
        for (final LSPackageInfo lSPackageInfo : collection) {
            IdVersionPair idVersionPair = lSPackageInfo.getPackageRef();
            try {
                boolean bl;
                final SessionUtil.ThreadContext threadContext = this._registeredPackageRefs;
                synchronized (threadContext) {
                    bl = this._registeredPackageRefs.contains(idVersionPair);
                    if (!bl) {
                        bl = this._extensionService.getPluginPackageInfo(idVersionPair) != null;
                    }
                }
                if (bl) {
                    hashSet.add(idVersionPair);
                    continue;
                }
                threadContext = SessionUtil.getThreadContext((boolean)true);
                Callable<IdVersionPair> callable = new Callable<IdVersionPair>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public IdVersionPair call() {
                        SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                        try {
                            IdVersionPair idVersionPair;
                            IdVersionPair idVersionPair2 = idVersionPair = LookupServiceExtensionManager.this.downloadAndAddPackage(lSPackageInfo);
                            return idVersionPair2;
                        }
                        finally {
                            SessionUtil.setThreadContext(null);
                        }
                    }
                };
                Future<IdVersionPair> future = EXECUTOR.submit(callable);
                arrayList.add(future);
            }
            catch (Exception exception) {
                _logger.error((Object)("Adding lookup-service extension " + idVersionPair + " failed"), (Throwable)exception);
            }
        }
        LookupServiceExtensionManager.getAddedPackageRefs(arrayList, hashSet);
        Set<IdVersionPair> set = this._registeredPackageRefs;
        synchronized (set) {
            this._registeredPackageRefs.addAll(hashSet);
        }
        return hashSet;
    }

    private static void getAddedPackageRefs(List<Future<IdVersionPair>> list, Set<IdVersionPair> set) {
        for (Future<IdVersionPair> future : list) {
            try {
                IdVersionPair idVersionPair = (IdVersionPair)BlockingUtil.getUninterruptibly(future);
                if (idVersionPair == null) continue;
                set.add(idVersionPair);
            }
            catch (Exception exception) {
                _logger.error((Object)"Adding lookup-service extension failed", (Throwable)exception);
            }
        }
    }

    private IdVersionPair downloadAndAddPackage(LSPackageInfo lSPackageInfo) {
        File file = this.downloadPackage(lSPackageInfo);
        if (file == null) {
            return null;
        }
        lSPackageInfo.setDirectory(file);
        IdVersionPair idVersionPair = null;
        try {
            Set set = this._extensionService.addPluginPackages(new PluginPackageInfo[]{lSPackageInfo});
            if (set != null && set.size() == 1) {
                idVersionPair = (IdVersionPair)set.iterator().next();
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Adding lookup-service extension " + lSPackageInfo.getPackageRef() + " failed"), (Throwable)exception);
        }
        return idVersionPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private File downloadPackage(LSPackageInfo lSPackageInfo) {
        Object object;
        File file = this.getPackageDir(lSPackageInfo.getPackageRef());
        Object object2 = object = this.getPackageDirLock(file);
        synchronized (object2) {
            boolean bl;
            boolean bl2 = bl = !file.mkdirs();
            if (bl) {
                return file;
            }
            File file2 = null;
            try {
                file2 = File.createTempFile("vmw-pckg", ".zip");
                try {
                    this.writePackageToFile(lSPackageInfo, file2);
                }
                catch (IOException | GeneralSecurityException exception) {
                    _logger.warn((Object)String.format("Could not download bundle from %s: %s", lSPackageInfo.url, exception.toString()));
                    FileUtil.deleteDir((File)file);
                    File file3 = null;
                    if (file2 != null) {
                        file2.delete();
                    }
                    return file3;
                }
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(file2);
                    ZipUtil.unzip((ZipFile)zipFile, (File)file);
                }
                catch (IOException iOException) {
                    File file4;
                    try {
                        _logger.warn((Object)String.format("Could not unzip bundle downloaded from %s: %s", lSPackageInfo.url, iOException.toString()));
                        FileUtil.deleteDir((File)file);
                        file4 = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            StreamUtil.close((ZipFile)zipFile);
                            throw throwable;
                        }
                        catch (Exception exception) {
                            _logger.error((Object)String.format("Error handling package %s. ", lSPackageInfo.url), (Throwable)exception);
                            FileUtil.deleteDir((File)file);
                            File file5 = null;
                            return file5;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                    StreamUtil.close((ZipFile)zipFile);
                    if (file2 != null) {
                        file2.delete();
                    }
                    return file4;
                }
                StreamUtil.close((ZipFile)zipFile);
            }
            finally {
                if (file2 != null) {
                    file2.delete();
                }
            }
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackageToFile(LSPackageInfo lSPackageInfo, File file) throws IOException, GeneralSecurityException {
        String string = lSPackageInfo.certificate;
        URL uRL = new URL(lSPackageInfo.url);
        String string2 = uRL.getProtocol();
        InputStream inputStream = null;
        if ("https".equals(string2) && !StringUtil.isNullOrEmpty((String)string)) {
            String string3 = CertificateUtil.getThumbprint((String)string);
            try {
                SSLBuilder sSLBuilder = new SSLBuilder();
                if (this._sslConfigurationProvider != null) {
                    sSLBuilder.sslConfigurationProvider(this._sslConfigurationProvider);
                }
                sSLBuilder.socketReadTimeout(Integer.valueOf(Config.LS_EXTENSION_MANAGER_SOCKET_READ_TIMEOUT.toIntMillis()));
                sSLBuilder.socketConnectionTimeout(Integer.valueOf(Config.LS_EXTENSION_MANAGER_SOCKET_CONNECTION_TIMEOUT.toIntMillis()));
                HttpClient httpClient = sSLBuilder.thumbprint(string3).buildHttpClientIgnoreErrors();
                inputStream = httpClient.executeMethodResponseAsStream(lSPackageInfo.url, null, null);
            }
            catch (SSLHandshakeException sSLHandshakeException) {
                if (!StringUtil.isNullOrEmpty((String)string3)) {
                    _logger.info((Object)("SSL handshake exception is detected {" + sSLHandshakeException.getMessage() + "}, " + "trying explicitly using TLSv1 protocol."));
                    String[] stringArray = new String[]{"TLSv1"};
                    HttpClient httpClient = new SSLBuilder().enabledProtocols(stringArray).thumbprint(string3).buildHttpClientIgnoreErrors();
                    inputStream = httpClient.executeMethodResponseAsStream(lSPackageInfo.url, null, null);
                }
            }
        } else {
            inputStream = uRL.openStream();
        }
        try {
            FileUtil.writeFile((InputStream)inputStream, (File)file);
        }
        finally {
            inputStream.close();
        }
    }

    private Object getPackageDirLock(File file) {
        Object object;
        Object object2 = this._lockByPackageDir.get(file);
        if (object2 == null && (object = this._lockByPackageDir.putIfAbsent(file, object2 = new Object())) != null) {
            object2 = object;
        }
        return object2;
    }

    private Object removePackageDirLock(File file) {
        return this._lockByPackageDir.remove(file);
    }

    private File getPackageDir(IdVersionPair idVersionPair) {
        String string = idVersionPair.getId() + "-" + idVersionPair.getVersion();
        File file = new File(Environment.clientAppDataFolder());
        File file2 = new File(new File(file, "lookup-service-packages"), this._extensionType);
        File file3 = new File(file2, string);
        return file3;
    }

    @VisibleForTesting
    static class LSPackageInfo
    extends PluginPackageInfo {
        public String url;
        public String certificate;

        LSPackageInfo() {
        }
    }
}

