/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.lookup.impl;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.lookup.impl.AfdLSSource;
import com.vmware.vise.vim.lookup.impl.LookupServiceSource;
import java.net.URI;
import java.security.KeyStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LookupServiceLocator {
    private static final Log _logger = LogFactory.getLog(LookupServiceLocator.class);
    private static final String LS_URL_KEY = "ls.url";
    private LookupServiceSource _source;

    public LookupServiceLocator(ConfigurationService configurationService, KeystoreService keystoreService) {
        this._source = this.initLookupServiceSource(configurationService, keystoreService);
    }

    public URI getServiceUri() {
        return this._source.getServiceUri();
    }

    public String getThumbprint() {
        return this._source.getThumbprint();
    }

    public KeyStore getKeyStore() {
        return this._source.getKeyStore();
    }

    private LookupServiceSource initLookupServiceSource(ConfigurationService configurationService, KeystoreService keystoreService) {
        LookupServiceSource lookupServiceSource = AfdLSSource.tryCreate(configurationService, keystoreService);
        if (lookupServiceSource != null) {
            return lookupServiceSource;
        }
        _logger.info((Object)"Loading lookup service url from a back up source.");
        lookupServiceSource = ConfigServiceSource.tryCreate(configurationService, keystoreService);
        if (lookupServiceSource != null) {
            return lookupServiceSource;
        }
        _logger.warn((Object)"Created a default LookupServiceSource.");
        return new LookupServiceSource(keystoreService);
    }

    private static class ConfigServiceSource
    extends LookupServiceSource {
        private final ConfigurationService _configService;

        public ConfigServiceSource(ConfigurationService configurationService, KeystoreService keystoreService) {
            super(keystoreService);
            this._configService = configurationService;
        }

        @Override
        public URI getServiceUri() {
            return ConfigServiceSource.toServiceUri(this._configService.getProperty(LookupServiceLocator.LS_URL_KEY));
        }

        public static LookupServiceSource tryCreate(ConfigurationService configurationService, KeystoreService keystoreService) {
            String string = configurationService.getProperty(LookupServiceLocator.LS_URL_KEY);
            if (StringUtil.isNullOrEmpty((String)string)) {
                return null;
            }
            return new ConfigServiceSource(configurationService, keystoreService);
        }
    }
}

