/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.sca.impl;

import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointTypeImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vim.binding.sca.ServiceInstance;
import com.vmware.vim.binding.sca.version.version1;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.exception.VmodlAlreadyLoadedException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.commons.vmomi.ClientWithSharedHttpConfig;
import com.vmware.vise.vim.commons.vmomi.OpIdAwareClientFactory;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceProvider;
import com.vmware.vise.vim.sca.impl.ScaServiceImpl;
import com.vmware.vise.vim.sca.impl.security.SessionTokenSignInfoImpl;
import com.vmware.vise.vim.sca.impl.security.SolutionUserSignInfoImpl;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.impl.NgcSolutionUser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;

public class ScaServiceProviderImpl
implements ScaServiceProvider,
UserSessionListener {
    private static final Log _logger = LogFactory.getLog(ScaServiceProviderImpl.class);
    private static final String SCA_SERVICE_SESSION_KEY = "scaServiceSessionKey";
    private static final String SCA_SERVICE_SCHEME = "https";
    private static final String SCA_SERVICE_PATH = "/sca/sdk";
    private static final String SCA_ENDPOINTS_BY_MACHINE_SESSION_KEY = "scaEndpointsByMachine";
    private static final Map<String, ScaService> _solutionScaService = new HashMap<String, ScaService>();
    private final SsoService _ssoService;
    private final NgcSolutionUser _solutionUser;
    private final SharedHttpConfigPool _httpConfigPool;
    private final ComponentManagerService _cmService;

    public ScaServiceProviderImpl(SsoService ssoService, NgcSolutionUser ngcSolutionUser, SharedHttpConfigPool sharedHttpConfigPool, ComponentManagerService componentManagerService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{ssoService, ngcSolutionUser, sharedHttpConfigPool});
        this._ssoService = ssoService;
        this._solutionUser = ngcSolutionUser;
        this._httpConfigPool = sharedHttpConfigPool;
        this._cmService = componentManagerService;
        _logger.info((Object)"instantiated");
    }

    public void init() {
        this.initializeVmodlContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeVmodlContext() {
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(ServiceInstance.class);
        if (vmodlType != null) {
            return;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader classLoader2 = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        String string = ServiceInstance.class.getPackage().getName();
        try {
            VmodlContext.initContext((String[])new String[]{string});
        }
        catch (VmodlAlreadyLoadedException vmodlAlreadyLoadedException) {
        }
        finally {
            thread.setContextClassLoader(classLoader2);
        }
    }

    public ScaService getService(String string) throws URISyntaxException {
        URI uRI = new URIBuilder().setHost(string).build();
        return this.getService(uRI);
    }

    public ScaService getService(URI uRI) {
        URI uRI2 = this.getScaServiceEndpoint(uRI);
        Map map = (Map)SessionUtil.getData((String)SCA_SERVICE_SESSION_KEY);
        if (map != null && map.containsKey(uRI2.getHost())) {
            return (ScaService)map.get(uRI2.getHost());
        }
        return this.getServiceSynchronized(uRI2);
    }

    private synchronized ScaService getServiceSynchronized(URI uRI) {
        HashMap<String, ScaServiceImpl> hashMap = (HashMap<String, ScaServiceImpl>)SessionUtil.getData((String)SCA_SERVICE_SESSION_KEY);
        if (hashMap != null && hashMap.containsKey(uRI.getHost())) {
            return (ScaService)hashMap.get(uRI.getHost());
        }
        if (hashMap == null) {
            hashMap = new HashMap<String, ScaServiceImpl>();
            SessionUtil.setData((String)SCA_SERVICE_SESSION_KEY, hashMap);
        }
        Client client = this.createVmomiClient(uRI);
        String string = SessionUtil.getClientId((HttpSession)SessionUtil.getHttpSession());
        ScaServiceImpl scaServiceImpl = new ScaServiceImpl(client, new SessionTokenSignInfoImpl(this._ssoService, string));
        hashMap.put(uRI.getHost(), scaServiceImpl);
        return scaServiceImpl;
    }

    public ScaService getSolutionService(String string) throws URISyntaxException {
        URI uRI = new URI(string);
        return this.getSolutionService(uRI);
    }

    public ScaService getSolutionService(URI uRI) {
        URI uRI2 = this.getScaServiceEndpoint(uRI);
        if (_solutionScaService.containsKey(uRI2.getHost())) {
            return _solutionScaService.get(uRI2.getHost());
        }
        return this.getSolutionServiceSynchronized(uRI2);
    }

    private synchronized ScaService getSolutionServiceSynchronized(URI uRI) {
        if (_solutionScaService.containsKey(uRI.getHost())) {
            return _solutionScaService.get(uRI.getHost());
        }
        Client client = this.createVmomiClient(uRI);
        ScaServiceImpl scaServiceImpl = new ScaServiceImpl(client, new SolutionUserSignInfoImpl(this._solutionUser));
        _solutionScaService.put(uRI.getHost(), scaServiceImpl);
        return scaServiceImpl;
    }

    private Client createVmomiClient(URI uRI) {
        String string = uRI.toString();
        HttpConfiguration httpConfiguration = this._httpConfigPool.getHttpConfig(string);
        HttpClientConfiguration httpClientConfiguration = HttpClientConfiguration.Factory.newInstance();
        httpClientConfiguration.setHttpConfiguration(httpConfiguration);
        Client client = OpIdAwareClientFactory.createClient((URI)uRI, version1.class, (ClientConfiguration)httpClientConfiguration);
        client = new ClientWithSharedHttpConfig(client, this._httpConfigPool);
        return client;
    }

    private URI getScaServiceEndpoint(URI uRI) {
        URI uRI2;
        String string = uRI.getHost();
        if (string == null) {
            string = uRI.getPath();
        }
        if ((uRI2 = this.getEndpointByHost(string)) == null) {
            try {
                uRI2 = new URI(SCA_SERVICE_SCHEME, string, SCA_SERVICE_PATH, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                _logger.error((Object)("Failed to construct SCA URI from " + uRI.toString()), (Throwable)uRISyntaxException);
            }
        }
        return uRI2;
    }

    private URI getEndpointByHost(String string) {
        HashMap hashMap = (HashMap)SessionUtil.getData((String)SCA_ENDPOINTS_BY_MACHINE_SESSION_KEY);
        if (hashMap == null) {
            return null;
        }
        return (URI)hashMap.get(string.toLowerCase());
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        Map map = (Map)SessionUtil.removeData((String)SCA_SERVICE_SESSION_KEY, (HttpSession)httpSessionEvent.getSession());
        if (map == null || map.isEmpty()) {
            return;
        }
        for (String string : map.keySet()) {
            ScaService scaService = (ScaService)map.get(string);
            scaService.getVmomiClient().shutdown();
        }
        map.clear();
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        ServiceTypeImpl serviceTypeImpl = new ServiceTypeImpl();
        serviceTypeImpl.setProductId("com.vmware.cis");
        serviceTypeImpl.setTypeId("sca");
        ServiceEndPointTypeImpl serviceEndPointTypeImpl = new ServiceEndPointTypeImpl("vmomi", "com.vmware.cis.sca");
        SearchCriteriaImpl searchCriteriaImpl = new SearchCriteriaImpl();
        searchCriteriaImpl.setServiceType((ServiceType)serviceTypeImpl);
        searchCriteriaImpl.setEndPointType((ServiceEndPointType)serviceEndPointTypeImpl);
        ServiceInfo[] serviceInfoArray = this._cmService.search((SearchCriteria)searchCriteriaImpl);
        HashMap<String, URI> hashMap = new HashMap<String, URI>();
        if (serviceInfoArray != null) {
            for (ServiceInfo serviceInfo : serviceInfoArray) {
                ServiceEndPoint serviceEndPoint = serviceInfo.getServiceEndPoints()[0];
                URI uRI = serviceEndPoint.getUrl();
                String string = uRI.getHost().toLowerCase();
                hashMap.put(string, uRI);
            }
        }
        SessionUtil.setData((String)SCA_ENDPOINTS_BY_MACHINE_SESSION_KEY, hashMap);
    }
}

