/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.certificates;

import com.vmware.vim.binding.impl.vmodl.DataObjectImpl;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vise.util.security.CertificateUtil;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@data
public class X509Spec
extends DataObjectImpl {
    private static final long serialVersionUID = 1L;
    private static final Log _logger = LogFactory.getLog(X509Spec.class);
    private static final int PENDING_EXPIRATION_OFFSET = 30;
    public String issuer;
    public String subject;
    public String serialNumber;
    public int version;
    public Date validFrom;
    public Date validTo;
    public String publicKey;
    public String algorithm;
    public String thumbprint;
    public boolean isExpired;
    public boolean isPendingExpiration;
    public String certificateAsString;

    public X509Spec() {
    }

    public X509Spec(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return;
        }
        this.version = x509Certificate.getVersion();
        this.subject = x509Certificate.getSubjectDN().getName();
        this.issuer = x509Certificate.getIssuerDN().getName();
        this.serialNumber = x509Certificate.getSerialNumber().toString();
        this.validFrom = x509Certificate.getNotBefore();
        this.validTo = x509Certificate.getNotAfter();
        this.publicKey = x509Certificate.getPublicKey().getAlgorithm();
        this.algorithm = x509Certificate.getSigAlgName();
        try {
            this.thumbprint = CertificateUtil.getThumbprint((Certificate)x509Certificate);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            _logger.warn((Object)certificateEncodingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            _logger.warn((Object)noSuchAlgorithmException.getMessage());
        }
        try {
            this.certificateAsString = CertificateUtil.encodeCertificate((X509Certificate)x509Certificate);
        }
        catch (Exception exception) {
            _logger.warn((Object)("Error converting certificate to a string. - " + exception.getMessage()));
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(5, 30);
        this.isExpired = this.verifyExpiration(x509Certificate, calendar.getTime());
        this.isPendingExpiration = this.verifyExpiration(x509Certificate, calendar2.getTime());
    }

    private boolean verifyExpiration(X509Certificate x509Certificate, Date date) {
        Date date2 = x509Certificate.getNotAfter();
        return date.after(date2);
    }
}

