/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso;

import com.google.common.collect.ImmutableSet;
import com.vmware.vim.binding.sso.version.version3_5;
import com.vmware.vise.vim.connections.SiteAffinityServerEndpointProvider;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public final class SsoServerInfo {
    private static final String WEBSSO_URL_PATTERN = "/websso/SAML2/SSOSSL?RelyingPartyEntityId=";
    private static final String SCHEME_END = "://";
    private static final String PORT_DELIMETER = ":";
    private final String _primaryAdminAppUrl;
    private final String _primaryStsUrl;
    private final KeyStore _keyStore;
    private final X509Certificate _stsSslCertificate;
    private final X509Certificate _adminAppSslCertificate;
    private final X509Certificate _metadataSslCertificate;
    private final String _primaryMetadataUrl;
    private final Class<?> _vmodlVersion;
    private final URI _primaryStsUri;
    private final Set<String> _allAdminAppUrls;
    private final Set<String> _allStsUrls;
    private final Set<String> _allMetadataUrls;

    private SsoServerInfo(Builder builder) {
        assert (builder != null);
        this._primaryAdminAppUrl = builder.adminAppUrl;
        this._primaryStsUrl = builder.stsUrl;
        this._primaryStsUri = this._primaryStsUrl != null ? URI.create(this._primaryStsUrl) : null;
        this._keyStore = builder.keyStore;
        this._stsSslCertificate = builder.sslCertificate;
        this._adminAppSslCertificate = builder.adminAppSslCertificate;
        this._metadataSslCertificate = builder.metadataSslCertificate;
        this._primaryMetadataUrl = builder.metadataUrl;
        this._vmodlVersion = builder.vmodlVersion != null ? builder.vmodlVersion : version3_5.class;
        this._allAdminAppUrls = builder.allAdminAppUrls != null && builder.allAdminAppUrls.size() > 0 ? ImmutableSet.copyOf(builder.allAdminAppUrls) : Collections.singleton(this._primaryAdminAppUrl);
        this._allStsUrls = builder.allStsUrls != null && builder.allStsUrls.size() > 0 ? ImmutableSet.copyOf(builder.allStsUrls) : Collections.singleton(this._primaryStsUrl);
        this._allMetadataUrls = builder.allMetadataUrls != null && builder.allMetadataUrls.size() > 0 ? ImmutableSet.copyOf(builder.allMetadataUrls) : Collections.singleton(this._primaryMetadataUrl);
    }

    public String getAdminAppUrl() {
        return this._primaryAdminAppUrl;
    }

    public Set<String> getAllAdminAppUrls() {
        return this._allAdminAppUrls;
    }

    public String getMetadataUrl() {
        return this._primaryMetadataUrl;
    }

    public Set<String> getAllMetadataUrls() {
        return this._allMetadataUrls;
    }

    public String getStsUrl() {
        return this._primaryStsUrl;
    }

    public Set<String> getAllStsUrls() {
        return this._allStsUrls;
    }

    public URI getStsUri() {
        return this._primaryStsUri;
    }

    public KeyStore getKeyStore() {
        return this._keyStore;
    }

    public X509Certificate getSslCertificate() {
        return this.getStsSslCertificate();
    }

    public X509Certificate getStsSslCertificate() {
        return this._stsSslCertificate;
    }

    public X509Certificate getAdminAppSslCertificate() {
        return this._adminAppSslCertificate;
    }

    public X509Certificate getMetadataSslCertificate() {
        return this._metadataSslCertificate;
    }

    public Class<?> getVmodlVersion() {
        return this._vmodlVersion;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SsoServerInfo)) {
            return false;
        }
        SsoServerInfo ssoServerInfo = (SsoServerInfo)object;
        return StringUtils.equals((String)this._primaryStsUrl, (String)ssoServerInfo.getStsUrl());
    }

    public String getWebSsoAddress(String string) throws MalformedURLException, URISyntaxException {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.getMetadataUrl();
        URL uRL = new URL(string2);
        SiteAffinityServerEndpointProvider siteAffinityServerEndpointProvider = new SiteAffinityServerEndpointProvider(uRL.toURI());
        String string3 = siteAffinityServerEndpointProvider.getServerEndpoint().getHost();
        stringBuilder.append(uRL.getProtocol()).append(SCHEME_END);
        stringBuilder.append(string3);
        if (uRL.getPort() != -1) {
            stringBuilder.append(PORT_DELIMETER).append(uRL.getPort());
        }
        stringBuilder.append(WEBSSO_URL_PATTERN).append(string);
        return stringBuilder.toString();
    }

    public String toString() {
        return "adminAppUrl: " + this._primaryAdminAppUrl + ", stsUrl: " + this._primaryStsUrl + ", metadataUrl: " + this._primaryMetadataUrl + ", vmodlVersion: " + this._vmodlVersion;
    }

    public String toExtendedString() {
        return this.toString() + ", allStsUrls: " + this._allStsUrls + ", allAdminAppUrls: " + this._allAdminAppUrls + ", allMetadataUrls: " + this._allMetadataUrls;
    }

    public static class Builder {
        public String adminAppUrl;
        public String stsUrl;
        public KeyStore keyStore;
        public X509Certificate adminAppSslCertificate;
        public X509Certificate sslCertificate;
        public X509Certificate metadataSslCertificate;
        public String metadataUrl;
        public Class<?> vmodlVersion;
        public Set<String> allAdminAppUrls;
        public Set<String> allStsUrls;
        public Set<String> allMetadataUrls;

        public SsoServerInfo getInstance() {
            SsoServerInfo ssoServerInfo = new SsoServerInfo(this);
            return ssoServerInfo;
        }
    }
}

