/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoLocator;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vise.vim.security.sso.impl.SsoUtilInternal;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NgcSolutionUser
implements SsoSolutionUser {
    private static final Log _logger = LogFactory.getLog(NgcSolutionUser.class);
    private static NgcSolutionUser _ngcSolutionUser;
    private static final String DEFAULT_CERT_ALIAS = "vsphere-webclient";
    private final SsoLocator _ssoLocator;
    private final KeystoreService _ksService;
    private final ConfigurationService _configService;
    @Nullable
    private final SsoConfigurationProvider _ssoConfigurationProvider;
    @Nullable
    private final HttpConfigurationProvider _httpConfigProvider;
    private X509Certificate _solutionUserCertificate;
    private PrivateKey _solutionUserPrivateKey;
    private SamlToken _token;

    @Deprecated
    public NgcSolutionUser(SsoLocator ssoLocator, KeystoreService keystoreService, ConfigurationService configurationService) {
        this(false, ssoLocator, keystoreService, configurationService, null, null);
    }

    public NgcSolutionUser(SsoLocator ssoLocator, KeystoreService keystoreService, ConfigurationService configurationService, @Nonnull SsoConfigurationProvider ssoConfigurationProvider, @Nonnull HttpConfigurationProvider httpConfigurationProvider) {
        this(true, ssoLocator, keystoreService, configurationService, (SsoConfigurationProvider)ValidationUtil.notNull((Object)ssoConfigurationProvider, (String)"ssoConfigProvider is null"), (HttpConfigurationProvider)ValidationUtil.notNull((Object)httpConfigurationProvider, (String)"httpConfigProvider is null"));
    }

    public NgcSolutionUser(boolean bl, SsoLocator ssoLocator, KeystoreService keystoreService, ConfigurationService configurationService, SsoConfigurationProvider ssoConfigurationProvider, HttpConfigurationProvider httpConfigurationProvider) {
        this._ssoLocator = ssoLocator;
        this._ksService = keystoreService;
        this._configService = configurationService;
        this._ssoConfigurationProvider = ssoConfigurationProvider;
        this._httpConfigProvider = httpConfigurationProvider;
        if (_ngcSolutionUser == null) {
            _ngcSolutionUser = this;
        }
        this.loadKeystore();
    }

    public static NgcSolutionUser instance() {
        return _ngcSolutionUser;
    }

    @Override
    public synchronized SamlToken getLoggedInToken() {
        if (this._token == null) {
            this.login();
        } else {
            boolean bl = false;
            try {
                if (SsoUtilInternal.checkTokenLifetime(this._token)) {
                    bl = true;
                }
            }
            catch (InvalidTokenException invalidTokenException) {
                bl = true;
            }
            if (bl) {
                this.login();
            }
        }
        return this._token;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this._solutionUserPrivateKey;
    }

    @Override
    public X509Certificate getCertificate() {
        return this._solutionUserCertificate;
    }

    private void login() {
        try {
            _logger.info((Object)"Solution user logging in");
            SecurityTokenServiceConfig.HolderOfKeyConfig holderOfKeyConfig = new SecurityTokenServiceConfig.HolderOfKeyConfig((Key)this._solutionUserPrivateKey, this._solutionUserCertificate, null);
            SecurityTokenServiceConfig securityTokenServiceConfig = this._ssoConfigurationProvider != null && this._httpConfigProvider != null ? SsoUtilInternal.createStsConfiguration(this._ssoLocator.getSsoServerInfo(), holderOfKeyConfig, this._ksService, this._ssoConfigurationProvider, this._httpConfigProvider) : SsoUtilInternal.createStsConfiguration(this._ssoLocator.getSsoServerInfo(), holderOfKeyConfig, this._ksService);
            SecurityTokenService securityTokenService = SsoUtilInternal.createSts(securityTokenServiceConfig);
            TokenSpec tokenSpec = SsoUtil.buildTokenSpec(28800000L, new TokenSpec.DelegationSpec(true), false);
            this._token = SsoUtilInternal.acquireTokenByCertificate(securityTokenServiceConfig, securityTokenService, tokenSpec);
            _logger.info((Object)"Solution user logged in");
        }
        catch (Exception exception) {
            _logger.error((Object)"Solution user login failed.", (Throwable)exception);
        }
    }

    private void loadKeystore() {
        if (!StringUtil.isNullOrEmpty((String)this._configService.getProperty("keystore.jks.path"))) {
            this.loadLocalKeystore();
            return;
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("VKS");
            Class<?> clazz = Class.forName("com.vmware.provider.VecsLoadStoreParameter");
            KeyStore.LoadStoreParameter loadStoreParameter = (KeyStore.LoadStoreParameter)clazz.getConstructor(String.class).newInstance(DEFAULT_CERT_ALIAS);
            keyStore.load(loadStoreParameter);
            _logger.info((Object)"VECS NGC solution user store is now loaded successfully.");
            this._solutionUserCertificate = (X509Certificate)keyStore.getCertificate(DEFAULT_CERT_ALIAS);
            this._solutionUserPrivateKey = (PrivateKey)keyStore.getKey(DEFAULT_CERT_ALIAS, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Error loading VECS NGC solution user store", (Throwable)exception);
        }
    }

    private void loadLocalKeystore() {
        try {
            _logger.info((Object)"Using local keystore to fetch NGC solution user info.");
            KeyStore keyStore = this._ksService.getKeyStore();
            char[] cArray = this._ksService.getKeyStorePassword() != null ? this._ksService.getKeyStorePassword().toCharArray() : null;
            String string = DEFAULT_CERT_ALIAS;
            this._solutionUserCertificate = (X509Certificate)keyStore.getCertificate(string);
            this._solutionUserPrivateKey = (PrivateKey)keyStore.getKey(string, cArray);
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to fetch solution user info from local key store.", (Throwable)exception);
        }
    }
}

