/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.vim.binding.lookup.SearchCriteria;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.security.sso.SsoLocator;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import java.io.Serializable;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoLocatorImpl
implements SsoLocator {
    private LookupService _lookupService;
    private LookupServiceUpdateTracker _updateTracker;
    private SsoServerInfo _ssoServerInfo;
    private Service _ssoAdminService;
    private Service _ssoStsService;
    private Class<?> _vmodlVersion;
    private static final Log _logger = LogFactory.getLog(SsoLocatorImpl.class);

    public SsoLocatorImpl(LookupService lookupService) {
        this._lookupService = lookupService;
        this._updateTracker = new LookupServiceUpdateTracker(this._lookupService);
    }

    public SsoLocatorImpl(LookupService lookupService, Class<?> clazz) {
        this(lookupService);
        this._vmodlVersion = clazz;
    }

    @Override
    public SsoServerInfo getSsoServerInfo() throws Exception {
        if (this._ssoServerInfo == null || this._updateTracker.isUpdateRequired()) {
            this._ssoServerInfo = this.getSsoServerInfoFromLS();
        }
        return this._ssoServerInfo;
    }

    private SsoServerInfo getSsoServerInfoFromLS() throws Exception {
        Object object;
        KeyStore keyStore;
        Serializable serializable;
        SsoServerInfo.Builder builder = new SsoServerInfo.Builder();
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.serviceType = new URI("urn:sso:admin");
        Service[] serviceArray = this._lookupService.find(searchCriteria);
        if (serviceArray != null && serviceArray.length == 1) {
            this._ssoAdminService = serviceArray[0];
            serializable = this._ssoAdminService.endpoints[0].url;
            builder.adminAppUrl = ((URI)serializable).toString();
        }
        serializable = SsoLocatorImpl.getSslCertificate(this._ssoAdminService);
        builder.sslCertificate = serializable;
        builder.keyStore = keyStore = SsoLocatorImpl.getKeyStore((X509Certificate)serializable);
        searchCriteria = new SearchCriteria();
        searchCriteria.serviceType = new URI("urn:sso:sts");
        serviceArray = this._lookupService.find(searchCriteria);
        if (serviceArray != null && serviceArray.length == 1) {
            this._ssoStsService = serviceArray[0];
            object = this._ssoStsService.endpoints[0].url;
            builder.stsUrl = ((URI)object).toString();
        }
        builder.vmodlVersion = this._vmodlVersion;
        object = builder.getInstance();
        return object;
    }

    private static X509Certificate getSslCertificate(Service service) {
        try {
            String string = service.endpoints[0].sslTrustAnchor;
            X509Certificate x509Certificate = (X509Certificate)CertificateUtil.generateCertificate((String)string);
            return x509Certificate;
        }
        catch (Exception exception) {
            _logger.error((Object)("Error getting the certificate for service: " + service.serviceName), (Throwable)exception);
            throw new IllegalStateException(exception);
        }
    }

    private static KeyStore getKeyStore(X509Certificate x509Certificate) {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null);
            keyStore.setEntry("SslTrustAnchor", new KeyStore.TrustedCertificateEntry(x509Certificate), null);
            return keyStore;
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when creating SSO certificate keystore.", (Throwable)exception);
            throw new IllegalStateException(exception);
        }
    }

    private static class LookupServiceUpdateTracker {
        private final LookupService _lookupService;
        private String _serviceUrl;

        public LookupServiceUpdateTracker(LookupService lookupService) {
            this._lookupService = lookupService;
            try {
                this._serviceUrl = this._lookupService.getServiceUrl();
            }
            catch (Exception exception) {
                _logger.info((Object)"No lookup service configured for the client.");
            }
        }

        public boolean isUpdateRequired() {
            String string = this._lookupService.getServiceUrl();
            if (!StringUtil.isNullOrEmpty((String)this._serviceUrl) && this._serviceUrl.equals(string)) {
                return false;
            }
            this._serviceUrl = string;
            return true;
        }
    }
}

