/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.ServiceContent;
import com.vmware.vim.binding.sso.admin.ServiceInstance;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.binding.sso.version.version1_5;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidRequest;
import com.vmware.vim.sso.client.DefaultSecurityTokenServiceFactory;
import com.vmware.vim.sso.client.DefaultTokenFactory;
import com.vmware.vim.sso.client.GssNegotiationClient;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.CertificateValidationException;
import com.vmware.vim.sso.client.exception.InternalError;
import com.vmware.vim.sso.client.exception.InvalidTimingException;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.RequestExpiredException;
import com.vmware.vim.sso.client.exception.ServerCommunicationException;
import com.vmware.vim.sso.client.exception.ServerSecurityException;
import com.vmware.vim.sso.client.exception.SsoException;
import com.vmware.vim.sso.client.exception.TimeSynchronizationException;
import com.vmware.vim.sso.client.exception.TokenRequestRejectedException;
import com.vmware.vim.sso.client.util.codec.Base64;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.ext.RequestRetryCallback;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.ThreadPoolManager;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vmomi.ClientWithSharedHttpConfig;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.commons.vmomi.OpIdAwareClientFactory;
import com.vmware.vise.vim.commons.vmomi.VmomiClientHelper;
import com.vmware.vise.vim.connections.SiteAffinityServerEndpointProvider;
import com.vmware.vise.vim.security.sso.SsoConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vise.vim.security.sso.exception.SsoSspiChallenge;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V1CertificateGenerator;

final class SsoUtilInternal {
    private static final Log _logger = LogFactory.getLog(SsoUtilInternal.class);
    private static final String SSO_VERSION_NOT_SUPPORTED = "Request version 'urn:sso/version[^']+' and namespace 'urn:sso' are not supported";
    private static final String SSO_ADMIN_CLIENT_HTTP_CONFIG_ID = "#ssoAdminClientHttpConfigId#";

    SsoUtilInternal() {
    }

    public static synchronized X509Certificate createHokCertificate(KeyPair keyPair) throws InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException, CertificateException, NoSuchProviderException {
        _logger.info((Object)"Generating a temporary client certificate to be used with HOK tokens");
        String string = "C=AU, O=VMware vSphere Client, OU=VMware vSphere Client Temporary Certificate";
        String string2 = "C=AU, O=VMware vSphere Client, OU=VMware vSphere Client Temporary Certificate";
        X509V1CertificateGenerator x509V1CertificateGenerator = new X509V1CertificateGenerator();
        x509V1CertificateGenerator.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        x509V1CertificateGenerator.setIssuerDN((X509Name)new X509Principal(string));
        x509V1CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 31536000000L));
        x509V1CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 31536000000L));
        x509V1CertificateGenerator.setSubjectDN((X509Name)new X509Principal(string2));
        x509V1CertificateGenerator.setPublicKey(keyPair.getPublic());
        x509V1CertificateGenerator.setSignatureAlgorithm("SHA1WithRSAEncryption");
        X509Certificate x509Certificate = x509V1CertificateGenerator.generate(keyPair.getPrivate());
        x509Certificate.checkValidity(new Date());
        x509Certificate.verify(keyPair.getPublic());
        return x509Certificate;
    }

    @Deprecated
    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo, RequestRetryCallback requestRetryCallback, Class<?> clazz) throws URISyntaxException {
        return SsoUtilInternal.createSsoAdminClient(ssoServerInfo, requestRetryCallback, clazz, (HttpConfigurationProvider)SsoUtil.getLegacyHttpConfigPool());
    }

    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo, RequestRetryCallback requestRetryCallback, Class<?> clazz, @Nonnull HttpConfigurationProvider httpConfigurationProvider) throws URISyntaxException {
        Validate.notNull((Object)httpConfigurationProvider, (String)"httpConfigProvider is null");
        String string = ssoServerInfo.getAdminAppUrl();
        URI uRI = new URI(string);
        KeyStore keyStore = ssoServerInfo.getKeyStore();
        HttpConfiguration httpConfiguration = httpConfigurationProvider.getHttpConfig(SSO_ADMIN_CLIENT_HTTP_CONFIG_ID, keyStore, null);
        HttpClientConfiguration httpClientConfiguration = HttpClientConfiguration.Factory.newInstance();
        SiteAffinityServerEndpointProvider siteAffinityServerEndpointProvider = new SiteAffinityServerEndpointProvider(uRI);
        httpClientConfiguration.setHttpConfiguration(httpConfiguration);
        httpClientConfiguration.setServerEndpointProvider((ServerEndpointProvider)siteAffinityServerEndpointProvider);
        if (requestRetryCallback != null) {
            httpClientConfiguration.setRequestRetryCallback(requestRetryCallback);
        }
        VmodlVersionMap vmodlVersionMap = VmodlVersionMap.Factory.getVmodlVersionMap();
        VmodlVersion vmodlVersion = vmodlVersionMap.getVersion(clazz);
        Client client = OpIdAwareClientFactory.createClient(null, (Class)vmodlVersion.getVersionClass(), (ClientConfiguration)httpClientConfiguration);
        ClientWithSharedHttpConfig clientWithSharedHttpConfig = new ClientWithSharedHttpConfig(client, httpConfigurationProvider, SSO_ADMIN_CLIENT_HTTP_CONFIG_ID);
        return clientWithSharedHttpConfig;
    }

    @Deprecated
    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo, RequestRetryCallback requestRetryCallback) throws URISyntaxException {
        return SsoUtilInternal.createSsoAdminClient(ssoServerInfo, requestRetryCallback, ssoServerInfo.getVmodlVersion());
    }

    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo, RequestRetryCallback requestRetryCallback, HttpConfigurationProvider httpConfigurationProvider) throws URISyntaxException {
        return SsoUtilInternal.createSsoAdminClient(ssoServerInfo, requestRetryCallback, ssoServerInfo.getVmodlVersion(), httpConfigurationProvider);
    }

    @Deprecated
    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo) throws URISyntaxException {
        return SsoUtilInternal.createSsoAdminClient(ssoServerInfo, (RequestRetryCallback)null);
    }

    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo, HttpConfigurationProvider httpConfigurationProvider) throws URISyntaxException {
        return SsoUtilInternal.createSsoAdminClient(ssoServerInfo, null, httpConfigurationProvider);
    }

    public static ServiceContent getSsoAdminServiceContent(Client client) throws InvalidCredentials, ServiceFault {
        if (client == null) {
            throw new IllegalArgumentException("ssoAdminClient");
        }
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(ServiceInstance.class);
        ManagedObjectReference managedObjectReference = new ManagedObjectReference(vmodlType.getWsdlName(), "SsoAdminServiceInstance");
        ServiceInstance serviceInstance = (ServiceInstance)VmomiClientHelper.createStub((Client)client, ServiceInstance.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoUtilInternal.class.getClassLoader());
        return serviceInstance.retrieveServiceContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate[] getStsRootCertificates(SsoServerInfo ssoServerInfo, @Nullable HttpConfigurationProvider httpConfigurationProvider) throws URISyntaxException, ServiceFault, CertificateException {
        Client client = null;
        try {
            String string;
            _logger.info((Object)("Requesting all STS trusted root certificates from " + ssoServerInfo.getAdminAppUrl()));
            if (httpConfigurationProvider == null) {
                httpConfigurationProvider = SsoUtil.getLegacyHttpConfigPool();
            }
            client = SsoUtilInternal.createSsoAdminClient(ssoServerInfo, httpConfigurationProvider);
            ServiceContent serviceContent = null;
            try {
                serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
            }
            catch (InvalidRequest invalidRequest) {
                string = invalidRequest.getMessage();
                if (string != null && string.matches(SSO_VERSION_NOT_SUPPORTED)) {
                    client = SsoUtilInternal.createSsoAdminClient(ssoServerInfo, null, version1_5.class, httpConfigurationProvider);
                    serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
                }
                throw new RuntimeException(invalidRequest);
            }
            ManagedObjectReference managedObjectReference = serviceContent.getConfigurationManagementService();
            string = (ConfigurationManagementService)VmomiClientHelper.createStub((Client)client, ConfigurationManagementService.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoUtilInternal.class.getClassLoader());
            String[] stringArray = string.getTrustedCertificates();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
            for (String string2 : stringArray) {
                byte[] byArray = Base64.decodeBase64((byte[])string2.getBytes());
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                linkedList.add(x509Certificate);
            }
            Object[] objectArray = linkedList.toArray(new X509Certificate[linkedList.size()]);
            return objectArray;
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void export(Certificate certificate, File file, boolean bl) {
        OutputStreamWriter outputStreamWriter;
        FileOutputStream fileOutputStream;
        block5: {
            fileOutputStream = null;
            outputStreamWriter = null;
            try {
                byte[] byArray = certificate.getEncoded();
                fileOutputStream = new FileOutputStream(file);
                if (bl) {
                    fileOutputStream.write(byArray);
                    break block5;
                }
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
                outputStreamWriter.write("-----BEGIN CERTIFICATE-----\n");
                outputStreamWriter.write(Base64.encodeBase64String((byte[])byArray));
                outputStreamWriter.write("\n-----END CERTIFICATE-----\n");
                ((Writer)outputStreamWriter).flush();
            }
            catch (Exception exception) {
                try {
                    _logger.error((Object)"Error when exporting the certificate", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    StreamUtil.close(outputStreamWriter);
                    StreamUtil.close(fileOutputStream);
                    throw throwable;
                }
                StreamUtil.close(outputStreamWriter);
                StreamUtil.close((Closeable)fileOutputStream);
            }
        }
        StreamUtil.close(outputStreamWriter);
        StreamUtil.close((Closeable)fileOutputStream);
    }

    public static synchronized KeyPair createHokKeyPair() {
        _logger.info((Object)"Generating a temporary RSA key pair to be used with HOK tokens");
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            return keyPair;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            _logger.error((Object)"Error when generating the private key", (Throwable)noSuchAlgorithmException);
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityTokenService createSts(SecurityTokenServiceConfig securityTokenServiceConfig) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(SsoUtilInternal.class.getClassLoader());
            SecurityTokenService securityTokenService = DefaultSecurityTokenServiceFactory.getSecurityTokenService((SecurityTokenServiceConfig)securityTokenServiceConfig);
            return securityTokenService;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @Deprecated
    public static SecurityTokenServiceConfig createStsConfiguration(SsoServerInfo ssoServerInfo, SecurityTokenServiceConfig.HolderOfKeyConfig holderOfKeyConfig, KeystoreService keystoreService) throws ServiceFault, CertificateException, URISyntaxException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, InvalidKeyException, IllegalStateException, SignatureException, MalformedURLException {
        return SsoUtilInternal.doCreateStsConfiguration(ssoServerInfo, holderOfKeyConfig, keystoreService, null, null);
    }

    public static SecurityTokenServiceConfig createStsConfiguration(@Nonnull SsoServerInfo ssoServerInfo, @Nullable SecurityTokenServiceConfig.HolderOfKeyConfig holderOfKeyConfig, @Nonnull KeystoreService keystoreService, @Nonnull SsoConfigurationProvider ssoConfigurationProvider, @Nonnull HttpConfigurationProvider httpConfigurationProvider) throws ServiceFault, CertificateException, URISyntaxException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, InvalidKeyException, IllegalStateException, SignatureException, MalformedURLException {
        return SsoUtilInternal.doCreateStsConfiguration((SsoServerInfo)ValidationUtil.notNull((Object)ssoServerInfo, (String)"info is null"), holderOfKeyConfig, (KeystoreService)ValidationUtil.notNull((Object)keystoreService, (String)"ksService is null"), (SsoConfigurationProvider)ValidationUtil.notNull((Object)ssoConfigurationProvider, (String)"ssoConfigProvider is null"), (HttpConfigurationProvider)ValidationUtil.notNull((Object)httpConfigurationProvider, (String)"httpConfigProvider is null"));
    }

    private static SecurityTokenServiceConfig doCreateStsConfiguration(SsoServerInfo ssoServerInfo, SecurityTokenServiceConfig.HolderOfKeyConfig holderOfKeyConfig, KeystoreService keystoreService, @Nullable SsoConfigurationProvider ssoConfigurationProvider, @Nullable HttpConfigurationProvider httpConfigurationProvider) throws ServiceFault, CertificateException, URISyntaxException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, InvalidKeyException, IllegalStateException, SignatureException, MalformedURLException {
        SecurityTokenServiceConfig securityTokenServiceConfig;
        _logger.info((Object)("Preparing the STS configuration for " + ssoServerInfo.getStsUrl()));
        X509Certificate[] x509CertificateArray = keystoreService.getSslTrustCertificates();
        SecurityTokenServiceConfig.ConnectionConfig connectionConfig = new SecurityTokenServiceConfig.ConnectionConfig(new URL(ssoServerInfo.getStsUrl()), x509CertificateArray, null);
        WorkerThreadFactory workerThreadFactory = new WorkerThreadFactory("security-token-service-config");
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 3L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)workerThreadFactory);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        ThreadPoolManager.getInstance().register((ExecutorService)threadPoolExecutor);
        if (ssoConfigurationProvider != null) {
            long l = ssoConfigurationProvider.getClockToleranceInSeconds();
            securityTokenServiceConfig = new SecurityTokenServiceConfig(connectionConfig, SsoUtilInternal.getStsRootCertificates(ssoServerInfo, httpConfigurationProvider), (ExecutorService)threadPoolExecutor, holderOfKeyConfig, l);
        } else {
            securityTokenServiceConfig = new SecurityTokenServiceConfig(connectionConfig, SsoUtilInternal.getStsRootCertificates(ssoServerInfo, httpConfigurationProvider), (ExecutorService)threadPoolExecutor, holderOfKeyConfig);
        }
        return securityTokenServiceConfig;
    }

    public static SamlToken acquireToken(SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenService securityTokenService, String string, String string2, TokenSpec tokenSpec) throws CertificateNotYetValidException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException, CertificateException, NoSuchProviderException, InvalidKeySpecException, InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, SsoException {
        if (securityTokenServiceConfig == null) {
            throw new IllegalArgumentException("config");
        }
        if (tokenSpec == null) {
            throw new IllegalArgumentException("tokenSpec");
        }
        _logger.info((Object)("Acquiring a SAML token for user " + string + " from " + securityTokenServiceConfig.getConnectionConfig().getUrl()));
        SamlToken samlToken = securityTokenService.acquireToken(string, string2, tokenSpec);
        return samlToken;
    }

    public static SamlToken acquireTokenByCertificate(SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenService securityTokenService, TokenSpec tokenSpec) throws InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, TimeSynchronizationException, InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        if (securityTokenServiceConfig == null) {
            throw new IllegalArgumentException("config");
        }
        if (tokenSpec == null) {
            throw new IllegalArgumentException("tokenSpec");
        }
        _logger.info((Object)("Acquiring a SAML token by certificate from " + securityTokenServiceConfig.getConnectionConfig().getUrl()));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(SsoUtilInternal.class.getClassLoader());
            SamlToken samlToken = securityTokenService.acquireTokenByCertificate(tokenSpec);
            return samlToken;
        }
        catch (TimeSynchronizationException timeSynchronizationException) {
            _logger.error((Object)"Time sync error: VC Server and local machine's clocks are out of sync by more than the accepted tolerance.");
            throw timeSynchronizationException;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public static SamlToken acquireTokenByToken(SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenService securityTokenService, SamlToken samlToken, TokenSpec tokenSpec) throws CertificateNotYetValidException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException, CertificateException, NoSuchProviderException, InvalidKeySpecException, InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, SsoException {
        if (securityTokenServiceConfig == null) {
            throw new IllegalArgumentException("config");
        }
        if (samlToken == null) {
            throw new IllegalArgumentException("token");
        }
        if (tokenSpec == null) {
            throw new IllegalArgumentException("tokenSpec");
        }
        _logger.info((Object)("Exchanging token " + samlToken.getId() + " for a new one using " + securityTokenServiceConfig.getConnectionConfig().getUrl()));
        SamlToken samlToken2 = securityTokenService.acquireTokenByToken(samlToken, tokenSpec);
        return samlToken2;
    }

    public static SamlToken buildToken(SecurityTokenServiceConfig securityTokenServiceConfig, String string) throws InvalidTokenException {
        _logger.info((Object)("Building a token from its XML representation - " + string));
        SamlToken samlToken = DefaultTokenFactory.createToken((String)string, (X509Certificate[])securityTokenServiceConfig.getTrustedRootCertificates());
        return samlToken;
    }

    public static GssNegotiationClient obtainGssNegotiationClient(SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenService securityTokenService, TokenSpec tokenSpec) throws CertificateNotYetValidException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException, CertificateException, NoSuchProviderException, InvalidKeySpecException {
        if (tokenSpec == null) {
            throw new IllegalArgumentException("tokenSpec");
        }
        return securityTokenService.obtainGssNegotiationClient(tokenSpec);
    }

    public static SamlToken negotiateToken(GssNegotiationClient gssNegotiationClient, String string) throws SsoSspiChallenge, IOException, InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, CertificateValidationException {
        byte[] byArray = Base64.decodeBase64((String)string);
        GssNegotiationClient.GssNegotiationResult gssNegotiationResult = gssNegotiationClient.negotiateToken(byArray);
        if (gssNegotiationResult.getToken() != null) {
            return gssNegotiationResult.getToken();
        }
        String string2 = Base64.encodeBase64String((byte[])gssNegotiationResult.getLeg());
        throw new SsoSspiChallenge(string2);
    }

    public static SamlToken renewToken(SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenService securityTokenService, SamlToken samlToken, long l) throws CertificateNotYetValidException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException, CertificateException, NoSuchProviderException, InvalidKeySpecException, InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, SsoException {
        if (securityTokenServiceConfig == null) {
            throw new IllegalArgumentException("config");
        }
        if (samlToken == null) {
            throw new IllegalArgumentException("token");
        }
        _logger.info((Object)("Renewing token " + samlToken.getId() + " using " + securityTokenServiceConfig.getConnectionConfig().getUrl()));
        SamlToken samlToken2 = securityTokenService.renewToken(samlToken, l);
        return samlToken2;
    }

    public static boolean validateToken(SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenService securityTokenService, SamlToken samlToken) throws CertificateNotYetValidException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException, CertificateException, NoSuchProviderException, InvalidKeySpecException, InvalidTokenException, InternalError, ServerCommunicationException, SsoException {
        if (securityTokenServiceConfig == null) {
            throw new IllegalArgumentException("config");
        }
        if (samlToken == null) {
            throw new IllegalArgumentException("token");
        }
        _logger.info((Object)("Validating token " + samlToken.getId() + " using " + securityTokenServiceConfig.getConnectionConfig().getUrl()));
        boolean bl = securityTokenService.validateToken(samlToken);
        return bl;
    }

    public static boolean checkTokenLifetime(SamlToken samlToken) throws InvalidTokenException {
        if (samlToken == null) {
            throw new IllegalArgumentException("token");
        }
        Date date = samlToken.getExpirationTime();
        Date date2 = Calendar.getInstance().getTime();
        long l = date.getTime() - date2.getTime();
        if (l <= 0L) {
            throw new InvalidTimingException("token expired");
        }
        return l <= 120000L;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

