/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vise.vim.security.sso.impl.SsoUtilInternal;
import java.lang.invoke.MethodHandles;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.BasePoolableObjectFactory;

public final class StsPoolableObjectFactory
extends BasePoolableObjectFactory {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final SecurityTokenServiceConfig _config;
    private final List<SecurityTokenService> _createdObjects;

    public StsPoolableObjectFactory(SecurityTokenServiceConfig securityTokenServiceConfig) {
        this._config = securityTokenServiceConfig;
        this._createdObjects = new LinkedList<SecurityTokenService>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object makeObject() throws Exception {
        _logger.debug((Object)"Making an STS object");
        SecurityTokenService securityTokenService = SsoUtilInternal.createSts(this._config);
        List<SecurityTokenService> list = this._createdObjects;
        synchronized (list) {
            this._createdObjects.add(securityTokenService);
        }
        _logger.debug((Object)"Done making an STS object");
        return securityTokenService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateObject(Object object) {
        List<SecurityTokenService> list = this._createdObjects;
        synchronized (list) {
            return this._createdObjects.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(Object object) throws Exception {
        List<SecurityTokenService> list = this._createdObjects;
        synchronized (list) {
            this._createdObjects.remove(object);
        }
    }
}

