/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vapi;

import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointTypeImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.vapi.DefaultVapiConnectionControl;
import com.vmware.vise.vim.vapi.EndpointInfo;
import com.vmware.vise.vim.vapi.SessionBasedVapiConnectionAuthenticator;
import com.vmware.vise.vim.vapi.StaticEndpointVapiConnectionManager;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vapi.VapiSessionProvider;
import java.net.URI;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmDiscoveryVapiConnectionManager
implements VapiConnectionManager {
    private static final Log _logger = LogFactory.getLog(CmDiscoveryVapiConnectionManager.class);
    private volatile StaticEndpointVapiConnectionManager _wrappedManager;
    private final ComponentManagerService _cmService;
    private final EndpointInfo _endpoint;
    private final ExecutorService _asyncCallExecutor;
    private final KeystoreService _ksService;
    private final Class<? extends Service> _sessionManagerType;
    private final String _sessionManagerLoginOperation;
    private final String _sessionManagerLogoutOperation;
    private final VapiSessionProvider _sessionProvider;

    public CmDiscoveryVapiConnectionManager(ComponentManagerService componentManagerService, EndpointInfo endpointInfo, KeystoreService keystoreService, ExecutorService executorService, Class<? extends Service> clazz, String string, String string2, VapiSessionProvider vapiSessionProvider) {
        Validate.notNull((Object)componentManagerService);
        Validate.notNull((Object)endpointInfo);
        Validate.notNull((Object)executorService);
        Validate.notNull((Object)keystoreService);
        Validate.notNull(clazz);
        Validate.notNull((Object)string);
        Validate.notNull((Object)string2);
        Validate.notNull((Object)vapiSessionProvider);
        this._cmService = componentManagerService;
        this._endpoint = endpointInfo;
        this._asyncCallExecutor = executorService;
        this._ksService = keystoreService;
        this._sessionManagerType = clazz;
        this._sessionManagerLoginOperation = string;
        this._sessionManagerLogoutOperation = string2;
        this._sessionProvider = vapiSessionProvider;
    }

    @Override
    public Service createServiceStub(Class<? extends Service> clazz) {
        return this.connectionManager().createServiceStub(clazz);
    }

    @Override
    public ApiProvider getApiProvider() {
        return this.connectionManager().getApiProvider();
    }

    @Override
    public StubConfiguration getStubConfig() {
        return this.connectionManager().getStubConfig();
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        this.connectionManager().sessionStarted(httpSessionEvent, locale);
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        this.connectionManager().sessionEnded(httpSessionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VapiConnectionManager connectionManager() {
        StaticEndpointVapiConnectionManager staticEndpointVapiConnectionManager = this._wrappedManager;
        if (staticEndpointVapiConnectionManager != null) {
            return staticEndpointVapiConnectionManager;
        }
        CmDiscoveryVapiConnectionManager cmDiscoveryVapiConnectionManager = this;
        synchronized (cmDiscoveryVapiConnectionManager) {
            staticEndpointVapiConnectionManager = this._wrappedManager;
            if (staticEndpointVapiConnectionManager != null) {
                return staticEndpointVapiConnectionManager;
            }
            ServiceEndPoint serviceEndPoint = this.findServiceEndpoint();
            if (serviceEndPoint == null) {
                throw new RuntimeException("Unable to find vAPI endpoint service.");
            }
            URI uRI = serviceEndPoint.getUrl();
            SessionBasedVapiConnectionAuthenticator sessionBasedVapiConnectionAuthenticator = new SessionBasedVapiConnectionAuthenticator(this._sessionManagerType, this._sessionManagerLoginOperation, this._sessionManagerLogoutOperation, this._sessionProvider, uRI);
            this._wrappedManager = staticEndpointVapiConnectionManager = new StaticEndpointVapiConnectionManager(serviceEndPoint.getUrl(), this._ksService, this._asyncCallExecutor, sessionBasedVapiConnectionAuthenticator, new DefaultVapiConnectionControl());
            return staticEndpointVapiConnectionManager;
        }
    }

    private ServiceEndPoint findServiceEndpoint() {
        try {
            ServiceInfo[] serviceInfoArray = this.retrieveServices();
            return this.findService(serviceInfoArray);
        }
        catch (ComponentManagerFault componentManagerFault) {
            throw new RuntimeException("Error obtaining endpoint corresponding to " + this._endpoint.toString(), componentManagerFault);
        }
    }

    private ServiceEndPoint findService(ServiceInfo[] serviceInfoArray) {
        if (serviceInfoArray == null) {
            return null;
        }
        String string = this._cmService.getHostId();
        ServiceEndPoint serviceEndPoint = null;
        for (ServiceInfo serviceInfo : serviceInfoArray) {
            String string2 = serviceInfo.getHostId();
            ServiceEndPoint[] serviceEndPointArray = serviceInfo.getServiceEndPoints();
            if (serviceEndPointArray.length > 1) {
                _logger.warn((Object)String.format("Found more than one endpoint of type '%s' on hostId '%s'. Getting the first and ignoring the rest.", this._endpoint.toString(), string2));
            }
            ServiceEndPoint serviceEndPoint2 = serviceEndPointArray[0];
            if (string2 != null && string2.equals(string)) {
                return serviceEndPoint2;
            }
            if (serviceEndPoint != null) continue;
            serviceEndPoint = serviceEndPoint2;
        }
        return serviceEndPoint;
    }

    private ServiceInfo[] retrieveServices() throws ComponentManagerFault {
        SearchCriteriaImpl searchCriteriaImpl = new SearchCriteriaImpl();
        searchCriteriaImpl.setServiceType((ServiceType)new ServiceTypeImpl(this._endpoint.getProductId(), this._endpoint.getServiceTypeId()));
        searchCriteriaImpl.setEndPointType((ServiceEndPointType)new ServiceEndPointTypeImpl(this._endpoint.getEndpointProtocolId(), this._endpoint.getEndpointTypeId()));
        return this._cmService.search((SearchCriteria)searchCriteriaImpl);
    }
}

