/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.impl;

import com.vmware.cis.cm.common.EndpointUtil;
import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcSource;
import com.vmware.vsphere.client.security.impl.LinkedGroupUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentManagerVcSource
implements VcSource {
    private static final Log _logger = LogFactory.getLog(ComponentManagerVcSource.class);
    private ComponentManagerService _cmService;

    public ComponentManagerVcSource(ComponentManagerService componentManagerService) {
        this._cmService = componentManagerService;
    }

    public List<ServerInfoEx> getVcs() {
        ArrayList<ServerInfoEx> arrayList = new ArrayList<ServerInfoEx>();
        ServiceInfo[] serviceInfoArray = this.getServiceInfos("com.vmware.cis", "vcenterserver");
        if (serviceInfoArray == null || serviceInfoArray.length == 0) {
            _logger.warn((Object)"No VC's retrieved from CM");
            return arrayList;
        }
        ServiceInfo[] serviceInfoArray2 = this.getServiceInfos("com.vmware.cis", "cs.inventory");
        if (serviceInfoArray2 == null) {
            _logger.warn((Object)"No INV's retrieved from CM");
            return arrayList;
        }
        this.applyLocalUrl(serviceInfoArray2);
        return this.getVcsInternal(serviceInfoArray, serviceInfoArray2);
    }

    private List<ServerInfoEx> getVcsInternal(ServiceInfo[] serviceInfoArray, ServiceInfo[] serviceInfoArray2) {
        ArrayList<ServiceEndpointEx> arrayList = new ArrayList<ServiceEndpointEx>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<ServerInfoEx> arrayList2 = new ArrayList<ServerInfoEx>(serviceInfoArray.length);
        for (ServiceInfo object2 : serviceInfoArray) {
            ServerInfoEx serverInfoEx = this.createServerInfoEx(object2, hashMap);
            if (serverInfoEx == null) continue;
            arrayList2.add(serverInfoEx);
            ServiceEndpointEx serviceEndpointEx = this.createServiceEndpoint(object2);
            if (serviceEndpointEx == null) continue;
            arrayList.add(serviceEndpointEx);
        }
        for (ServerInfoEx serverInfoEx : arrayList2) {
            if (!LinkedGroupUtils.is60VcOrLater(serverInfoEx.version)) continue;
            serverInfoEx.peers = LinkedGroupUtils.getServerInfosForVcPeers(serverInfoEx, arrayList2);
        }
        LinkedGroupUtils.addISEndpoints(serviceInfoArray2, hashMap, arrayList);
        ServiceEndpointEx[] serviceEndpointExArray = arrayList.toArray(new ServiceEndpointEx[0]);
        for (ServerInfoEx serverInfoEx : arrayList2) {
            if (!LinkedGroupUtils.is60VcOrLater(serverInfoEx.version)) continue;
            serverInfoEx.endpoints = serviceEndpointExArray;
        }
        LinkedList linkedList = new LinkedList();
        ServerInfoEx serviceEndpointEx = null;
        String string = this._cmService.getHostId();
        for (ServerInfoEx serverInfoEx : arrayList2) {
            boolean bl = LinkedGroupUtils.is60VcOrLater(serverInfoEx.version);
            if (bl) {
                if (string != null && string.equals(serverInfoEx.hostId)) {
                    serviceEndpointEx = serverInfoEx;
                    continue;
                }
                if (serviceEndpointEx != null) continue;
                serviceEndpointEx = serverInfoEx;
                continue;
            }
            linkedList.add(serverInfoEx);
        }
        if (serviceEndpointEx != null) {
            linkedList.addFirst(serviceEndpointEx);
        }
        return linkedList;
    }

    private ServerInfoEx createServerInfoEx(ServiceInfo serviceInfo, Map<String, String> map) {
        ServiceEndPoint serviceEndPoint = LinkedGroupUtils.extractEndpointFromServiceInfo(serviceInfo, "com.vmware.vim");
        if (serviceEndPoint == null) {
            _logger.warn((Object)("Found no endpoint in VC service:" + serviceInfo.getHostId()));
            return null;
        }
        ServerInfoEx serverInfoEx = new ServerInfoEx();
        serverInfoEx.hostId = serviceInfo.getHostId();
        serverInfoEx.version = serviceInfo.getServiceVersion();
        serverInfoEx.serviceUrl = serviceEndPoint.getUrl().toString();
        _logger.info((Object)String.format("Found vCenter Server %1s from Component Manager", serverInfoEx.serviceUrl));
        this.setThumprintAndCertificate(serviceEndPoint, serverInfoEx);
        String string = serviceInfo.getHostId();
        String string2 = serviceInfo.getServiceId();
        map.put(string, string2);
        return serverInfoEx;
    }

    private ServiceEndpointEx createServiceEndpoint(ServiceInfo serviceInfo) {
        ServiceEndpointEx serviceEndpointEx = LinkedGroupUtils.is60VcOrLater(serviceInfo.getServiceVersion()) ? LinkedGroupUtils.createVcServiceEndpoint(serviceInfo) : null;
        return serviceEndpointEx;
    }

    private void setThumprintAndCertificate(ServiceEndPoint serviceEndPoint, ServerInfoEx serverInfoEx) {
        String[] stringArray = serviceEndPoint.getSslTrust();
        if (stringArray != null && stringArray.length > 0 && !StringUtil.isNullOrEmpty((String)stringArray[0])) {
            String string = stringArray[0];
            try {
                String string2;
                serverInfoEx.thumbprint = string2 = CertificateUtil.getThumbprint((String)string);
                serverInfoEx.sslTrustAnchor = string;
            }
            catch (Exception exception) {
                _logger.error((Object)("Error when extracting thumbprint from certificate for vc:" + serverInfoEx.serviceUrl));
            }
        }
    }

    private ServiceInfo[] getServiceInfos(String string, String string2) {
        ServiceInfo[] serviceInfoArray = null;
        try {
            _logger.info((Object)String.format("Fetching services of type %s from CM...", string2));
            serviceInfoArray = this.fetchServicesFromCM(string, string2);
            _logger.info((Object)"Fetched services from CM.");
        }
        catch (ComponentManagerFault componentManagerFault) {
            _logger.error((Object)"Error when fetching vc's from Component Manager.", (Throwable)componentManagerFault);
            return null;
        }
        return serviceInfoArray;
    }

    private void applyLocalUrl(ServiceInfo[] serviceInfoArray) {
        String string = this._cmService.getHostId();
        EndpointUtil.applyLocalUrl((ServiceInfo[])serviceInfoArray, (String)string);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Applied local URLs to serverInfos: %s ", ArrayUtils.toString((Object)serviceInfoArray)));
        }
    }

    private ServiceInfo[] fetchServicesFromCM(String string, String string2) throws ComponentManagerFault {
        SearchCriteriaImpl searchCriteriaImpl = new SearchCriteriaImpl();
        searchCriteriaImpl.setServiceType((ServiceType)new ServiceTypeImpl(string, string2));
        ServiceInfo[] serviceInfoArray = this._cmService.search((SearchCriteria)searchCriteriaImpl);
        return serviceInfoArray;
    }
}

