/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.impl;

import com.vmware.vim.binding.cis.cm.ServiceAttribute;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.site.Folder;
import com.vmware.vise.util.Version;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LinkedGroupUtils {
    public static final String VC_ENDPOINT_TYPE = "com.vmware.vim";

    @Deprecated
    public static boolean is2014VcOrLater(String string) {
        return LinkedGroupUtils.is60VcOrLater(string);
    }

    public static boolean is60VcOrLater(String string) {
        return VcServiceUtil.is60VcOrLater((Version)new Version(string));
    }

    public static List<ServerInfoEx> getServerInfosForVcPeers(ServerInfoEx serverInfoEx, List<ServerInfoEx> list) {
        ArrayList<ServerInfoEx> arrayList = new ArrayList<ServerInfoEx>();
        for (ServerInfoEx serverInfoEx2 : list) {
            if (serverInfoEx2 == serverInfoEx || !LinkedGroupUtils.is60VcOrLater(serverInfoEx2.version)) continue;
            arrayList.add(serverInfoEx2);
        }
        return arrayList;
    }

    public static ServiceEndpointEx createVcServiceEndpoint(ServiceInfo serviceInfo) {
        ServiceEndPoint serviceEndPoint = LinkedGroupUtils.extractEndpointFromServiceInfo(serviceInfo, VC_ENDPOINT_TYPE);
        if (serviceEndPoint == null) {
            return null;
        }
        Folder folder = serviceInfo.getFolder();
        String string = folder != null ? folder.getId() : null;
        String string2 = serviceInfo.getHostId();
        String string3 = serviceInfo.getServiceId();
        String string4 = LinkedGroupUtils.getServiceAttr(serviceInfo, "com.vmware.vim.vcenter.instanceName");
        String string5 = serviceEndPoint.getUrl().toString();
        String string6 = serviceInfo.getServiceVersion();
        String string7 = serviceEndPoint.getSslTrust()[0];
        ServiceEndpointEx serviceEndpointEx = ServiceEndpointEx.buildVcServiceEndpoint((String)string, (String)string2, (String)string3, (String)string4, (String)string5, (String)string6, (String)string7);
        return serviceEndpointEx;
    }

    public static void addISEndpoints(ServiceInfo[] serviceInfoArray, Map<String, String> map, List<ServiceEndpointEx> list) {
        for (ServiceInfo serviceInfo : serviceInfoArray) {
            ServiceEndPoint serviceEndPoint = LinkedGroupUtils.extractEndpointFromServiceInfo(serviceInfo, "com.vmware.cis.inventory");
            if (serviceEndPoint == null) continue;
            Folder folder = serviceInfo.getFolder();
            String string = folder != null ? folder.getId() : null;
            String string2 = serviceInfo.getHostId();
            String string3 = serviceInfo.getServiceId();
            String string4 = map.get(string2);
            String string5 = serviceEndPoint.getUrl().toString();
            String string6 = serviceInfo.getServiceVersion();
            String string7 = serviceEndPoint.getSslTrust()[0];
            ServiceEndpointEx serviceEndpointEx = ServiceEndpointEx.buildInventoryServiceEndpoint((String)string, (String)string2, (String)string4, (String)string3, (String)string5, (String)string6, (String)string7);
            list.add(serviceEndpointEx);
        }
    }

    public static String getServiceAttr(ServiceInfo serviceInfo, String string) {
        if (serviceInfo != null && serviceInfo.getServiceAttributes() != null) {
            for (ServiceAttribute serviceAttribute : serviceInfo.getServiceAttributes()) {
                if (!string.equals(serviceAttribute.getKey()) || serviceAttribute.getValue() == null) continue;
                return serviceAttribute.getValue();
            }
        }
        return null;
    }

    public static ServiceEndPoint extractEndpointFromServiceInfo(ServiceInfo serviceInfo, String string) {
        if (serviceInfo.getServiceEndPoints() == null) {
            return null;
        }
        for (ServiceEndPoint serviceEndPoint : serviceInfo.getServiceEndPoints()) {
            if (!string.equals(serviceEndPoint.getEndPointType().getTypeId())) continue;
            return serviceEndPoint;
        }
        return null;
    }
}

