/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.http.impl;

import com.vmware.vim.vmomi.core.common.LifecycleListener;
import com.vmware.vim.vmomi.core.common.LifecycleManager;
import com.vmware.vim.vmomi.core.common.impl.BasicLifecycleManager;
import com.vmware.vim.vmomi.server.http.Endpoint;
import com.vmware.vim.vmomi.server.http.Filter;
import com.vmware.vim.vmomi.server.http.Server;
import com.vmware.vim.vmomi.server.http.ServerConfigurator;
import com.vmware.vim.vmomi.server.http.Service;
import com.vmware.vim.vmomi.server.http.StaticContentService;
import com.vmware.vim.vmomi.server.http.impl.HttpEndpoint;
import com.vmware.vim.vmomi.server.http.impl.ServiceImpl;
import com.vmware.vim.vmomi.server.http.impl.StaticContentServiceImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractServer
implements Server,
LifecycleManager {
    protected static Log _logger = LogFactory.getLog(AbstractServer.class);
    protected static final Service[] NO_SERVICES = new Service[0];
    protected static final Filter[] NO_FILTERS = new Filter[0];
    public static int DEFAULT_PORT = 8080;
    protected Endpoint[] _endpoints;
    protected Service[] _services;
    protected Filter[] _filters;
    protected final LifecycleManager _lifecycleManager;
    protected ServerConfigurator _serverConfig;
    private static final String[] ENABLED_SSL_CIPHERS = new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"};
    private String[] _enabledCiphers = ENABLED_SSL_CIPHERS;

    protected abstract Service prepareDefaultServlet(StaticContentService var1);

    public AbstractServer() {
        this._endpoints = new Endpoint[]{new HttpEndpoint(DEFAULT_PORT)};
        this._services = NO_SERVICES;
        this._filters = NO_FILTERS;
        this._lifecycleManager = new BasicLifecycleManager();
    }

    @Override
    public void setEndpoints(Endpoint[] endpoints) {
        AbstractServer.validateArray(endpoints);
        this._endpoints = endpoints;
    }

    @Override
    public void setServices(Service[] services) {
        AbstractServer.validateArray(services);
        this._services = services;
        this.prepareStaticContentServices();
    }

    @Override
    public void setFilters(Filter[] filters) {
        AbstractServer.validateArray(filters);
        this._filters = filters;
    }

    @Override
    public void setServerConfigurator(ServerConfigurator serverConfig) {
        this._serverConfig = serverConfig;
    }

    protected static void validateArray(Object[] array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            throw new IllegalArgumentException("Empty array element at index " + i);
        }
    }

    protected void prepareStaticContentServices() {
        for (int i = 0; i < this._services.length; ++i) {
            if (!(this._services[i] instanceof StaticContentServiceImpl)) continue;
            StaticContentService staticSrv = (StaticContentService)this._services[i];
            if (staticSrv.getContentBase() == null) {
                throw new IllegalArgumentException("contentBase must not be null for service " + staticSrv);
            }
            this._services[i] = this.prepareDefaultServlet(staticSrv);
        }
    }

    protected void applyServerConfigurator() {
        if (this._serverConfig != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Applying server configurator " + this._serverConfig + " to server " + this));
            }
            this._serverConfig.configure(this);
        }
    }

    @Override
    @Deprecated
    public void setServiceMap(Map<String, HttpServlet> serviceMap) {
        Service[] services = new Service[serviceMap.size()];
        int i = 0;
        for (Map.Entry<String, HttpServlet> e : serviceMap.entrySet()) {
            ServiceImpl serv = new ServiceImpl();
            serv.setPath(e.getKey());
            serv.setServlet((Servlet)e.getValue());
            services[i] = serv;
            ++i;
        }
        this.setServices(services);
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this._lifecycleManager.addLifecycleListener(lifecycleListener);
    }

    public void setLifecycleListeners(List<LifecycleListener> lifecycleListeners) {
        this._lifecycleManager.setLifecycleListeners(lifecycleListeners);
    }

    public void shutdown() {
        this._lifecycleManager.shutdown();
    }

    public void shutdownNow() {
        this._lifecycleManager.shutdownNow();
    }

    public void setEnabledSSLCiphers(String[] enabledCiphers) {
        if (enabledCiphers == null || enabledCiphers.length == 0) {
            throw new NullPointerException("Can not specify empty list");
        }
        this._enabledCiphers = enabledCiphers;
    }

    protected String[] getDisabledSSLCiphers() {
        SSLSocketFactory sslf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        HashSet<String> ciphers = new HashSet<String>(Arrays.asList(sslf.getSupportedCipherSuites()));
        ciphers.removeAll(Arrays.asList(this._enabledCiphers));
        return ciphers.toArray(new String[ciphers.size()]);
    }

    protected String[] getEnabledSSLCiphers() {
        SSLSocketFactory sslf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        HashSet<String> ciphers = new HashSet<String>(Arrays.asList(sslf.getSupportedCipherSuites()));
        ciphers.retainAll(Arrays.asList(this._enabledCiphers));
        return ciphers.toArray(new String[ciphers.size()]);
    }
}

