/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.http.impl;

import com.vmware.vim.vmomi.core.util.LoggingUtil;
import com.vmware.vim.vmomi.server.common.Response;
import com.vmware.vim.vmomi.server.http.Responder;
import com.vmware.vim.vmomi.server.http.impl.AsyncServlet30Template;
import com.vmware.vim.vmomi.server.impl.Correlator;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncCompleteResponder
implements Responder {
    private static final Log _logger = LogFactory.getLog(AsyncCompleteResponder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnResponse(Response response, Correlator<?> correlator) {
        AsyncContext asyncCtx = null;
        AsyncServlet30Template template = null;
        HttpServletRequest servletRequest = null;
        HttpServletResponse servletResponse = null;
        String correlatorId = response.getCorrelator();
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Continuing response: " + correlatorId));
            }
            if ((asyncCtx = (AsyncContext)correlator.remove(correlatorId)) == null) {
                if (_logger.isErrorEnabled()) {
                    _logger.error((Object)("Unable to find asyncContext for correlation ID " + correlatorId));
                }
            } else {
                servletRequest = (HttpServletRequest)asyncCtx.getRequest();
                servletResponse = (HttpServletResponse)asyncCtx.getResponse();
                template = (AsyncServlet30Template)servletRequest.getAttribute("AsyncServlet30Template");
                template.onCompleteRequest(servletRequest, servletResponse, response);
            }
        }
        catch (Exception ex) {
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)"Internal server error during asynchronous response completion", (Throwable)ex);
            }
            if (template != null) {
                template.asyncErrorResponse(servletResponse, ex);
            }
        }
        finally {
            if (asyncCtx != null) {
                try {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Completing async servlet request " + asyncCtx));
                    }
                    asyncCtx.complete();
                }
                catch (RuntimeException ex) {
                    _logger.error((Object)("Unable to complete async servlet request " + asyncCtx + " for correlation ID: " + correlatorId), (Throwable)ex);
                    LoggingUtil.generateThreadDump();
                }
            }
        }
    }
}

