/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.http.impl;

import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vim.vmomi.server.http.Endpoint;
import com.vmware.vim.vmomi.server.http.Filter;
import com.vmware.vim.vmomi.server.http.Service;
import com.vmware.vim.vmomi.server.http.StaticContentService;
import com.vmware.vim.vmomi.server.http.impl.AbstractServer;
import com.vmware.vim.vmomi.server.http.impl.HttpEndpoint;
import com.vmware.vim.vmomi.server.http.impl.HttpsEndpoint;
import com.vmware.vim.vmomi.server.http.impl.JettyErrorHandler;
import com.vmware.vim.vmomi.server.http.impl.JettyNoContextHandler;
import com.vmware.vim.vmomi.server.http.impl.ServiceImpl;
import com.vmware.vim.vmomi.server.http.impl.VlsiSslConnector;
import com.vmware.vim.vmomi.server.http.impl.VlsiSslSelectChannelConnector;
import com.vmware.vim.vmomi.server.http.impl.VlsiSslSocketConnector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.ThreadPool;

public class JettyServer
extends AbstractServer {
    private static final char PATH_SEPARATOR;
    private static final Log LOG;
    private final Server _server = new Server();
    private Context _context;
    private ThreadPool _threadPool;

    public void setThreadPool(ThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    @Override
    public void start() throws Exception {
        if (this._threadPool != null) {
            this._server.setThreadPool(this._threadPool);
        }
        this._server.setConnectors(this.createConnectors());
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{this.createHandler(), new JettyNoContextHandler()});
        this._server.setHandler((Handler)handlers);
        this._server.setSendServerVersion(false);
        this.applyServerConfigurator();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Starting server on " + Arrays.toString(this._endpoints)));
        }
        this._server.start();
    }

    private Connector[] createConnectors() {
        AbstractConnector[] connectors = new AbstractConnector[this._endpoints.length];
        for (int i = 0; i < this._endpoints.length; ++i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating connector for " + this._endpoints[i]));
            }
            connectors[i] = this._endpoints[i].getProtocol() == Endpoint.Protocol.HTTP ? this.createHttpConnector((HttpEndpoint)this._endpoints[i]) : this.createHttpsConnector((HttpsEndpoint)this._endpoints[i]);
            connectors[i].setHost(this._endpoints[i].getHost());
            connectors[i].setPort(this._endpoints[i].getPort());
            connectors[i].setAcceptors(this._endpoints[i].getNumAcceptors());
            connectors[i].setAcceptQueueSize(this._endpoints[i].getAcceptQueueSize());
            connectors[i].setMaxIdleTime(this._endpoints[i].getMaxIdleTime());
        }
        return connectors;
    }

    private AbstractConnector createHttpConnector(HttpEndpoint endpoint) {
        switch (endpoint.getEndpointType()) {
            case NON_BLOCKING_NIO: {
                return new SelectChannelConnector();
            }
            case BLOCKING: {
                return new SocketConnector();
            }
        }
        throw new IllegalArgumentException("Unknown Endpoint type: " + (Object)((Object)endpoint.getEndpointType()));
    }

    private AbstractConnector createHttpsConnector(HttpsEndpoint endpoint) {
        switch (endpoint.getEndpointType()) {
            case NON_BLOCKING_NIO: {
                VlsiSslSelectChannelConnector channelConn = new VlsiSslSelectChannelConnector();
                this.configureSslConnector(channelConn, endpoint);
                return channelConn;
            }
            case BLOCKING: {
                VlsiSslSocketConnector socketConn = new VlsiSslSocketConnector();
                this.configureSslConnector(socketConn, endpoint);
                return socketConn;
            }
        }
        throw new IllegalArgumentException("Unknown Endpoint type: " + (Object)((Object)endpoint.getEndpointType()));
    }

    private void configureSslConnector(VlsiSslConnector connector, HttpsEndpoint endpoint) {
        if (endpoint.getKeyStoreType() != null) {
            connector.setKeystoreType(endpoint.getKeyStoreType());
        }
        connector.setKeystore(endpoint.getKeyStorePath());
        connector.setPassword(endpoint.getKeyStorePassword());
        connector.setKeyPassword(endpoint.getKeyPassword());
        if (endpoint.getTrustStorePath() != null) {
            connector.setTruststore(endpoint.getTrustStorePath());
            connector.setTrustPassword(endpoint.getTrustStorePassword());
        }
        connector.setNeedClientAuth(endpoint.getNeedClientAuth());
        if (!endpoint.getNeedClientAuth()) {
            connector.setWantClientAuth(endpoint.getWantClientAuth());
        }
        connector.setExcludeCipherSuites(this.getDisabledSSLCiphers());
        if (endpoint.getEnabledProtocols() != null) {
            connector.setEnabledProtocols(endpoint.getEnabledProtocols().split(","));
        }
    }

    private Handler createHandler() {
        this._context = new Context((HandlerContainer)this._server, "/", 3);
        this._context.setErrorHandler((ErrorHandler)new JettyErrorHandler());
        this._context.setClassLoader(this.getClass().getClassLoader());
        if (this._services.length == 0) {
            throw new IllegalStateException("There are no services configured");
        }
        this.addServices();
        this.addFilters();
        return this._context;
    }

    private void addServices() {
        ArrayList<ConstraintMapping> security = new ArrayList<ConstraintMapping>();
        int servletNo = 0;
        for (Service srv : this._services) {
            ServletHolder holder = new ServletHolder(srv.getServlet());
            holder.setInitParameters(srv.getInitParameters());
            holder.setName("servlet " + servletNo++);
            String path = srv.getPath();
            if (path.indexOf(42) < 0 && !path.endsWith("/")) {
                String trailingSlashPath = path + "/";
                path = path + PATH_SEPARATOR + trailingSlashPath;
            }
            this._context.addServlet(holder, path);
            security.add(this.createDisableTraceConstraint(srv.getPath()));
            security.add(this.createDataConstraint(srv.getTransportGuarantee(), srv.getPath()));
            if (srv.getPath().indexOf(42) >= 0 || srv.getPath().endsWith("/")) continue;
            security.add(this.createDisableTraceConstraint(srv.getPath() + "/"));
            security.add(this.createDataConstraint(srv.getTransportGuarantee(), srv.getPath() + "/"));
        }
        this._context.getSecurityHandler().setConstraintMappings(security.toArray(new ConstraintMapping[security.size()]));
    }

    private ConstraintMapping createDataConstraint(Service.TransportGuarantee tg, String path) {
        Constraint dc = new Constraint();
        dc.setDataConstraint(JettyServer.resolveDataConstraint(tg));
        ConstraintMapping dcMapping = new ConstraintMapping();
        dcMapping.setConstraint(dc);
        dcMapping.setPathSpec(path);
        return dcMapping;
    }

    private ConstraintMapping createDisableTraceConstraint(String path) {
        Constraint disableTraceConstraint = new Constraint();
        disableTraceConstraint.setName("Disable TRACE");
        disableTraceConstraint.setRoles(new String[0]);
        disableTraceConstraint.setAuthenticate(true);
        ConstraintMapping disableTraceConstraintMapping = new ConstraintMapping();
        disableTraceConstraintMapping.setConstraint(disableTraceConstraint);
        disableTraceConstraintMapping.setPathSpec(path);
        disableTraceConstraintMapping.setMethod("TRACE");
        return disableTraceConstraintMapping;
    }

    private void addFilters() {
        int filterNo = 0;
        for (Filter flt : this._filters) {
            FilterHolder holder = new FilterHolder(flt.getFilter());
            holder.setInitParameters(flt.getInitParameters());
            holder.setName("filter " + filterNo++);
            int dispatchers = 0;
            for (Filter.Dispatcher t : flt.getDispatchers()) {
                dispatchers |= JettyServer.resolveFilterDispatcher(t);
            }
            this._context.addFilter(holder, flt.getPath(), dispatchers);
        }
    }

    private static int resolveDataConstraint(Service.TransportGuarantee tg) {
        switch (tg) {
            case NONE: {
                return 0;
            }
            case INTEGRAL: {
                return 1;
            }
            case CONFIDENTIAL: {
                return 2;
            }
        }
        throw new InternalException("Unknown transport guarantee " + (Object)((Object)tg));
    }

    private static int resolveFilterDispatcher(Filter.Dispatcher disp) {
        switch (disp) {
            case INCLUDE: {
                return 4;
            }
            case FORWARD: {
                return 2;
            }
            case REQUEST: {
                return 1;
            }
        }
        throw new InternalException("Unknown filter dispatcher " + (Object)((Object)disp));
    }

    @Override
    public void stop() throws Exception {
        this.shutdown();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Stopping server.");
        }
        this._server.stop();
    }

    @Override
    public void join() throws Exception {
        this._server.join();
    }

    public Server getServer() {
        return this._server;
    }

    public Context getContext() {
        return this._context;
    }

    @Override
    protected Service prepareDefaultServlet(StaticContentService staticSrv) {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("resourceBase", staticSrv.getContentBasePath());
        initParams.put("dirAllowed", String.valueOf(staticSrv.getDirListing()));
        initParams.put("gzip", String.valueOf(false));
        ServiceImpl converted = new ServiceImpl();
        converted.setServlet((Servlet)new DefaultServlet());
        converted.setInitParameters(initParams);
        converted.setPath(staticSrv.getPath());
        converted.setTransportGuarantee(staticSrv.getTransportGuarantee());
        return converted;
    }

    static {
        String prop = System.getProperty("org.mortbay.http.PathMap.separators");
        PATH_SEPARATOR = (char)(prop != null && prop.length() > 0 ? (int)prop.charAt(0) : 58);
        LOG = LogFactory.getLog(JettyServer.class);
    }
}

