/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.http.impl;

import com.vmware.vim.vmomi.core.util.ClassUtil;
import com.vmware.vim.vmomi.core.util.FileUtil;
import com.vmware.vim.vmomi.server.common.impl.ThumbprintTrustManager;
import com.vmware.vim.vmomi.server.http.impl.VlsiSslConnector;
import com.vmware.vim.vmomi.server.util.SslUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.security.Password;
import org.mortbay.jetty.security.SslSelectChannelConnector;

public class VlsiSslSelectChannelConnector
extends SslSelectChannelConnector
implements VlsiSslConnector {
    private SslConnectorHelper _sslConnectorHelper = new SslConnectorHelper();
    private String[] _enabledProtocols;

    @Override
    public void setPassword(String password) {
        super.setPassword(password);
        this._sslConnectorHelper._password = Password.getPassword((String)"jetty.ssl.password", (String)password, null);
    }

    @Override
    public void setKeyPassword(String password) {
        super.setKeyPassword(password);
        this._sslConnectorHelper._keyPassword = Password.getPassword((String)"jetty.ssl.keypassword", (String)password, null);
    }

    @Override
    public void setTrustPassword(String password) {
        super.setTrustPassword(password);
        this._sslConnectorHelper._trustPassword = Password.getPassword((String)"jetty.ssl.password", (String)password, null);
    }

    @Override
    public void setEnabledProtocols(String[] enabledProtocols) {
        this._enabledProtocols = enabledProtocols;
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        this._sslConnectorHelper.customize(endpoint, request);
    }

    protected SSLContext createSSLContext() throws Exception {
        return this._sslConnectorHelper.createSSLContext(this);
    }

    protected SSLEngine createSSLEngine() throws IOException {
        SSLEngine sslEngine = super.createSSLEngine();
        if (this._enabledProtocols != null) {
            sslEngine.setEnabledProtocols(this._enabledProtocols);
        }
        return sslEngine;
    }

    protected static class SslConnectorHelper {
        protected transient Password _password;
        protected transient Password _keyPassword;
        protected transient Password _trustPassword;
        private ThumbprintTrustManager _trustManager;

        protected SslConnectorHelper() {
        }

        protected void customize(EndPoint endpoint, Request request) throws IOException {
            if (null == this._trustManager) {
                throw new IllegalStateException("Invalid SSLContext");
            }
            SslUtil.addCertTrustedAttribute((HttpServletRequest)request, this._trustManager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SSLContext createSSLContext(VlsiSslConnector conn) throws Exception {
            if (conn.getTruststore() == null) {
                conn.setTruststore(conn.getKeystore());
                conn.setTruststoreType(conn.getKeystoreType());
            }
            InputStream keystoreInputStream = null;
            KeyManager[] keyManagers = null;
            KeyStore keyStore = null;
            try {
                if (conn.getKeystore() != null) {
                    ClassLoader loader = ClassUtil.getCurrentClassLoader();
                    keystoreInputStream = FileUtil.getInputStream((String)conn.getKeystore(), (ClassLoader)loader);
                    keyStore = KeyStore.getInstance(conn.getKeystoreType());
                    keyStore.load(keystoreInputStream, this._password == null ? null : this._password.toString().toCharArray());
                }
            }
            finally {
                if (keystoreInputStream != null) {
                    keystoreInputStream.close();
                }
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(conn.getSslKeyManagerFactoryAlgorithm());
            keyManagerFactory.init(keyStore, this._keyPassword == null ? (this._password == null ? null : this._password.toString().toCharArray()) : this._keyPassword.toString().toCharArray());
            keyManagers = keyManagerFactory.getKeyManagers();
            TrustManager[] trustManagers = null;
            InputStream truststoreInputStream = null;
            KeyStore trustStore = null;
            try {
                if (conn.getTruststore() != null) {
                    ClassLoader loader = ClassUtil.getCurrentClassLoader();
                    truststoreInputStream = FileUtil.getInputStream((String)conn.getTruststore(), (ClassLoader)loader);
                    trustStore = KeyStore.getInstance(conn.getTruststoreType());
                    trustStore.load(truststoreInputStream, this._trustPassword == null ? null : this._trustPassword.toString().toCharArray());
                }
            }
            finally {
                if (truststoreInputStream != null) {
                    truststoreInputStream.close();
                }
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(conn.getSslTrustManagerFactoryAlgorithm());
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
            SecureRandom secureRandom = conn.getSecureRandomAlgorithm() == null ? null : SecureRandom.getInstance(conn.getSecureRandomAlgorithm());
            SSLContext context = conn.getProvider() == null ? SSLContext.getInstance(conn.getProtocol()) : SSLContext.getInstance(conn.getProtocol(), conn.getProvider());
            this._trustManager = new ThumbprintTrustManager(trustManagers);
            context.init(keyManagers, new TrustManager[]{this._trustManager}, secureRandom);
            return context;
        }
    }
}

