/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.http.impl;

import com.vmware.vim.vmomi.server.common.ProcessingStep;
import com.vmware.vim.vmomi.server.common.Request;
import com.vmware.vim.vmomi.server.common.Response;
import com.vmware.vim.vmomi.server.http.VmomiRequestCustomizer;
import com.vmware.vim.vmomi.server.http.impl.RequestImpl;
import com.vmware.vim.vmomi.server.http.impl.VmomiServletUtils;
import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class VmomiServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String REQUEST_CUSTOMIZER_CLASS = "requestCustomizerClass";
    protected static final int DEFAULT_MAX_LENGTH = Integer.MAX_VALUE;
    protected static Log _logger = LogFactory.getLog(VmomiServlet.class);
    protected AtomicInteger _maxLength;
    protected ProcessingStep<Request> _firstStep;
    protected String _sessionCookiePath;
    protected VmomiRequestCustomizer _requestCustomizer;
    protected boolean runsInJetty;

    protected VmomiServlet() {
        this(null, null);
    }

    protected VmomiServlet(ProcessingStep<Request> firstStep) {
        this(firstStep, null);
    }

    protected VmomiServlet(ProcessingStep<Request> firstStep, String sessionCookiePath) {
        this._firstStep = firstStep;
        this._sessionCookiePath = sessionCookiePath;
        this._maxLength = new AtomicInteger(Integer.MAX_VALUE);
    }

    public void setMaxRequestLength(int maxLength) {
        this._maxLength.set(maxLength);
    }

    public void setRequestCustomizer(VmomiRequestCustomizer requestCustomizer) {
        this._requestCustomizer = requestCustomizer;
    }

    public void init() throws ServletException {
        super.init();
        this.runsInJetty = this.getServletContext().getServerInfo().toLowerCase().startsWith("jetty");
        if (this._firstStep != null) {
            return;
        }
        if (this.getServletConfig() != null) {
            String correlationStep = this.getServletConfig().getInitParameter("correlationStep");
            if (correlationStep == null) {
                correlationStep = "firstStep";
            }
            this._sessionCookiePath = this.getServletConfig().getInitParameter("sessionCookiePath");
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletConfig().getServletContext());
            this._firstStep = (ProcessingStep)ctx.getBean(correlationStep);
            String customizerClass = this.getServletConfig().getInitParameter(REQUEST_CUSTOMIZER_CLASS);
            try {
                if (customizerClass != null) {
                    Class<?> clazz = Class.forName(customizerClass);
                    this._requestCustomizer = (VmomiRequestCustomizer)clazz.newInstance();
                }
            }
            catch (Exception e) {
                throw new ServletException("Unable to instantiate request customizer class", (Throwable)e);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doOptions(request, response);
        VmomiServletUtils.doOptions(request, response);
    }

    protected boolean processNewRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object requestObject) throws IOException, ServletException {
        RequestImpl request = VmomiServletUtils.parseRequest(servletRequest, this._maxLength.get());
        request.setObject(requestObject);
        try {
            if (this._requestCustomizer != null) {
                this._requestCustomizer.customizeRequest(servletRequest, request);
            }
        }
        catch (Exception e) {
            _logger.warn((Object)"Exception in VmomiRequestCustomizer. Continue processing request", (Throwable)e);
        }
        if (_logger.isDebugEnabled() && Boolean.getBoolean("vlsi.debug.server.logRequests")) {
            _logger.debug((Object)("Received new HTTP request: " + request.getRequestBody()));
        }
        try {
            this._firstStep.process(request);
            return true;
        }
        catch (RejectedExecutionException ree) {
            _logger.warn((Object)"Executor can not handle request processing task", (Throwable)ree);
            VmomiServletUtils.handleRejectedExecution(ree, request, this._sessionCookiePath, servletRequest, servletResponse);
            return false;
        }
    }

    protected void completeRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object responseObject) throws IOException {
        Response response = (Response)responseObject;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Completing HTTP response: " + response.getCorrelator()));
        }
        if (!this.runsInJetty) {
            VmomiServletUtils.sendResponse(response, this._sessionCookiePath, servletRequest, servletResponse, this.is30Servlet());
        } else {
            VmomiServletUtils.sendResponseFromJetty(response, this._sessionCookiePath, servletRequest, servletResponse);
        }
    }

    protected boolean is30Servlet() {
        return true;
    }
}

