/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.ActivationResponseFilter;
import com.vmware.vim.vmomi.server.common.DiagnosticContextProvider;
import com.vmware.vim.vmomi.server.common.ProcessingStep;
import com.vmware.vim.vmomi.server.exception.ExceptionUtil;
import com.vmware.vim.vmomi.server.impl.FilterFutureImpl;
import com.vmware.vim.vmomi.server.util.DiagnosticContextUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterStartTask
implements Runnable,
DiagnosticContextProvider {
    private static final Log _logger = LogFactory.getLog(FilterStartTask.class);
    private Activation _activation;
    private List<ActivationResponseFilter> _filters;
    private ProcessingStep<Activation> _nextStep;

    public FilterStartTask(Activation activation, List<ActivationResponseFilter> filters, ProcessingStep<Activation> nextStep) {
        this._activation = activation;
        this._filters = filters;
        this._nextStep = nextStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AtomicInteger counter;
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)String.format("Starting activation response filtering for %1$s", this._activation.getRequest().getCorrelator()));
        }
        LinkedList<FilterFutureImpl> filterFutures = new LinkedList<FilterFutureImpl>();
        AtomicInteger atomicInteger = counter = new AtomicInteger();
        synchronized (atomicInteger) {
            try {
                for (ActivationResponseFilter filter : this._filters) {
                    FilterFutureImpl f = new FilterFutureImpl(this._activation, this._filters.size(), counter, this._nextStep);
                    filterFutures.add(f);
                    filter.filter(this._activation, f);
                }
            }
            catch (RuntimeException e) {
                if (_logger.isErrorEnabled()) {
                    _logger.error((Object)String.format("Failed to start activation response filtering %1$d of %2$d, faling request", filterFutures.size(), this._filters.size()), (Throwable)e);
                }
                for (FilterFutureImpl f : filterFutures) {
                    f.cancel();
                }
                this._activation.setFault((Exception)ExceptionUtil.buildFaultForInternalException(e));
                this._nextStep.process(this._activation);
            }
        }
    }

    @Override
    public Map<String, Object> getDiagnosticContext() {
        return DiagnosticContextUtils.getDiagnosticContext(this._activation.getRequest().getRequestContext());
    }
}

