/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.common.LifecycleListener;
import com.vmware.vim.vmomi.core.common.LifecycleManager;
import com.vmware.vim.vmomi.core.common.impl.BasicLifecycleManager;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.AdapterServer;
import com.vmware.vim.vmomi.server.LocalClient;
import com.vmware.vim.vmomi.server.common.ChainedProcessingStep;
import com.vmware.vim.vmomi.server.common.impl.RequestImpl;
import com.vmware.vim.vmomi.server.common.impl.ResponseImpl;
import com.vmware.vim.vmomi.server.impl.ActivationImpl;
import com.vmware.vim.vmomi.server.impl.Correlator;
import com.vmware.vim.vmomi.server.impl.MethodInvocationHandlerImpl;
import com.vmware.vim.vmomi.server.session.Session;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;

public class LocalClientImpl
implements LocalClient,
LifecycleManager {
    private final AdapterServer _adapterServer;
    private final Correlator _correlator;
    private final ChainedProcessingStep<Activation, Activation> _validationStep;
    private final ChainedProcessingStep<Activation, Activation> _filterStep;
    private final LifecycleManager _lifecycleManager = new BasicLifecycleManager();

    public LocalClientImpl(AdapterServer adapterServer, Correlator correlator, ChainedProcessingStep<Activation, Activation> validationStep, ChainedProcessingStep<Activation, Activation> filterStep) {
        this._adapterServer = adapterServer;
        this._correlator = correlator;
        this._validationStep = validationStep;
        this._filterStep = filterStep;
    }

    @Override
    public <T> T createStub(Class<T> type, ManagedObjectReference ref, VmodlVersion version, Session session) {
        ManagedObject mo = this._adapterServer.lookupManagedObject(ref.getValue());
        if (mo == null) {
            throw new IllegalArgumentException("Can't find a ManagedObject for reference " + ref);
        }
        ManagedObjectType moType = (ManagedObjectType)this._adapterServer.getVmodlContext().getVmodlTypeMap().getVmodlType(type);
        if (moType == null) {
            throw new IllegalArgumentException("Can't find ManagedObject type for class " + type.getName());
        }
        return type.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{type, Stub.class}, (InvocationHandler)new MethodInvocationHandlerImpl(mo, moType, version, session, this._adapterServer, this._correlator, this._validationStep, this._filterStep)));
    }

    @Override
    public void invoke(ManagedObject target, ManagedMethod method, Object[] args, VmodlVersion version, Session session, Future future) {
        RequestImpl request = new RequestImpl();
        ActivationImpl activation = new ActivationImpl(version, target, method, args, session, request, new ResponseImpl(request.getCorrelator()), null, null);
        this._correlator.put(activation.getRequest().getCorrelator(), future);
        this._adapterServer.invoke(activation, this._validationStep, this._filterStep);
    }

    public void shutdown() {
        this._lifecycleManager.shutdown();
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this._lifecycleManager.addLifecycleListener(lifecycleListener);
    }

    public void setLifecycleListeners(List<LifecycleListener> lifecycleListeners) {
        this._lifecycleManager.setLifecycleListeners(lifecycleListeners);
    }

    public void shutdownNow() {
        this._lifecycleManager.shutdownNow();
    }
}

