/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.common.DiagnosticContextProvider;
import com.vmware.vim.vmomi.server.impl.Correlator;
import com.vmware.vim.vmomi.server.util.DiagnosticContextUtils;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalCompletionTask
implements Runnable,
DiagnosticContextProvider {
    private static final Log _logger = LogFactory.getLog(LocalCompletionTask.class);
    private Correlator<Future> _correlator;
    private Activation _activation;

    public LocalCompletionTask(Activation activation, Correlator<Future> correlator) {
        this._activation = activation;
        this._correlator = correlator;
    }

    @Override
    public void run() {
        try {
            Future future = this._correlator.remove(this._activation.getResponse().getCorrelator());
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)String.format("Completing local task %s", this._activation.getResponse().getCorrelator()));
            }
            if (this._activation.getFault() != null) {
                if (_logger.isInfoEnabled()) {
                    _logger.info((Object)"Task finished with a fault");
                }
                future.setException(this._activation.getFault());
            } else {
                if (_logger.isInfoEnabled()) {
                    _logger.info((Object)"Task finished with a value");
                }
                future.set(this._activation.getReturnValue());
            }
        }
        catch (RuntimeException ex) {
            _logger.error((Object)"Internal server error during local conpletion", (Throwable)ex);
        }
    }

    @Override
    public Map<String, Object> getDiagnosticContext() {
        return DiagnosticContextUtils.getDiagnosticContext(this._activation.getRequest().getRequestContext());
    }
}

